from unidecode import unidecode

letra_morse = {
        "0" : "-----",
        "1" : ".----",
        "2" : "..---",
        "3" : "...--",
        "4" : "....-",
        "5" : ".....",
        "6" : "-....",
        "7" : "--...",
        "8" : "---..",
        "9" : "----.",
        "a" : ".-",
        "b" : "-...",
        "c" : "-.-.",
        "d" : "-..",
        "e" : ".",
        "f" : "..-.",
        "g" : "--.",
        "h" : "....",
        "i" : "..",
        "j" : ".---",
        "k" : "-.-",
        "l" : ".-..",
        "m" : "--",
        "n" : "-.",
        "o" : "---",
        "p" : ".--.",
        "q" : "--.-",
        "r" : ".-.",
        "s" : "...",
        "t" : "-",
        "u" : "..-",
        "v" : "...-",
        "w" : ".--",
        "x" : "-..-",
        "y" : "-.--",
        "z" : "--..",
        "." : ".-.-.-",
        "," : "--..--",
        "?" : "..--..",
        "!" : "-.-.--",
        "(" : "-.--.",
        ")" : "-.--.-",
        "&" : ".-...",
        ":" : "---...",
        ";" : "-.-.-.",
        "/" : "-..-.",
        "_" : "..--.-",
        "=" : "-...-",
        "+" : ".-.-.",
        "-" : "-....-",
        "$" : "...-..-",
        "@" : ".--.-.",
        " " : "/"
}

def text_to_morse(text : str):
    text = list(text)
    morse = ""
    for letter in text:
        if unidecode(letter).lower() in letra_morse.items():
            morse += letra_morse[unidecode(letter).lower()] + " "
        else:
            morse += letter + " "
    return morse


morse_letra = {
    "-----" : "0",
    ".----" : "1",
    "..---" : "2",
    "...--" : "3",
    "....-" : "4",
    "....." : "5",
    "-...." : "6",
    "--..." : "7",
    "---.." : "8",
    "----." : "9",
    ".-" : "a",
    "-..." : "b",
    "-.-." : "c",
    "-.." : "d",
    "." : "e",
    "..-." : "f",
    "--." : "g",
    "...." : "h",
    ".." : "i",
    ".---" : "j",
    "-.-" : "k",
    ".-.." : "l",
    "--" : "m",
    "-." : "n",
    "---" : "o",
    ".--." : "p",
    "--.-" : "q",
    ".-." : "r",
    "..." : "s",
    "-" : "t",
    "..-" : "u",
    "...-" : "v",
    ".--" : "w",
    "-..-" : "x",
    "-.--" : "y",
    "--.." : "z",
    ".-.-.-" : ".",
    "--..--" : ",",
    "..--.." : "?",
    "-.-.--" : "!",
    "-.--." : "(",
    "-.--.-" : ")",
    ".-..." : "&",
    "---..." : ":",
    "-.-.-." : ";",
    "-..-." : "/",
    "..--.-" : "_",
    "-...-" : "=",
    ".-.-." : "+",
    "-....-" : "-",
    "...-..-" : "$",
    ".--.-." : "@",
    "/" : " ",
    " " : ""
}

def morse_to_text(text : str):
    letters = text.split(' ')
    output = ""
    for letter in letters:
        if letter in morse_letra:
            output += morse_letra[letter.lower()]
        else:
            output += letter
    return output