
# DO NOT EDIT THIS FILE -- AUTOGENERATED BY PANTS
# Target: src/python/arcor2_scene:arcor2_scene_dist

from setuptools import setup

setup(**{
    'author': 'Robo@FIT',
    'author_email': 'imaterna@fit.vut.cz',
    'classifiers': [
        'Development Status :: 3 - Alpha',
        'Intended Audience :: Developers',
        'Topic :: Software Development :: Build Tools',
        'License :: OSI Approved :: GNU Lesser General Public License v3 (LGPLv3)',
        'Programming Language :: Python :: 3.10',
        'Natural Language :: English',
        'Topic :: Scientific/Engineering',
    ],
    'description': 'ARCOR2 Scene Service',
    'entry_points': {
        'console_scripts': [
            'arcor2_scene = arcor2_scene.scripts.scene:main',
        ],
    },
    'install_requires': (
        'Flask~=2.2.2',
        'arcor2~=1.0.0',
        'numpy-quaternion[numba,scipy]~=2022.4.2',
        'numpy~=1.23.5',
        'open3d==0.16.0',
        'pyhumps==3.8.0',
    ),
    'license': 'LGPL',
    'long_description': """# arcor2_scene

ARCOR2 Scene service has similar functionality to Kinali's Scene service (in version 0.8.0), but not all endpoints are implemented, and on the other hand, there are some additional, specific ones.

## Environment variables

- `ARCOR2_SCENE_SERVICE_PORT=5013` - by default, the Scene mock listens on port 5013.
- `ARCOR2_REST_API_DEBUG=1` - turns on Flask debugging (logs each endpoint call).

- `ARCOR2_SCENE_DEBUG=1` - turns on debug logging.
- `ARCOR2_SCENE_INFLATION=0.01` - controls how much in meters are collision models inflated (for simple collision checking).
- `ARCOR2_SCENE_DELAY_MEAN=0` and `ARCOR2_SCENE_DELAY_SIGMA=0` can be used to simulate long-lasting startup of the scene (with some randomness). May be useful for debugging.
# Changelog

The format is based on [Keep a Changelog](https://keepachangelog.com/en/1.0.0/),

## [1.0.0] - 2023-02-14

### Changed

- Marked as a stable version.
- Health check end-point changed to `/healthz/ready`.

## [0.2.0] - 2022-10-28

### Changed

- Switched to Python 3.10, updated dependencies.

## [0.1.1] - 2022-09-08

### Fixed

- `SceneGeneral` exception had wrong ancestor.

## [0.1.0] - 2022-09-02

### Added

- Scene service moved out of `arcor2_mocks` into a separate package.""",
    'long_description_content_type': 'text/markdown',
    'name': 'arcor2_scene',
    'namespace_packages': (
    ),
    'package_data': {
        'arcor2_scene': (
            'VERSION',
            'py.typed',
        ),
    },
    'packages': (
        'arcor2_scene',
        'arcor2_scene.scripts',
    ),
    'python_requires': '==3.10.*',
    'version': '1.0.0',
})
