"""
MAVLink protocol implementation (auto-generated by mavgen.py)

Generated from: ('minimal.xml',)

Note: this file has been auto-generated. DO NOT EDIT
"""
import hashlib
import json
import logging
import os
import struct
import sys
import time
from builtins import object, range


def cast(type_str, arg):
    """
    No-op for Python2 used instead of typing.cast()
    """
    return arg


WIRE_PROTOCOL_VERSION = "2.0"
DIALECT = "minimal"

PROTOCOL_MARKER_V1 = 0xFE
PROTOCOL_MARKER_V2 = 0xFD
HEADER_LEN_V1 = 6
HEADER_LEN_V2 = 10

MAVLINK_SIGNATURE_BLOCK_LEN = 13

MAVLINK_IFLAG_SIGNED = 0x01

logger = logging.getLogger(__name__)

# Will force use of native code regardless of what client app wants
native_force = "MAVNATIVE_FORCE" in os.environ
# Will force both native and legacy code to be used and their results compared
native_testing = "MAVNATIVE_TESTING" in os.environ

native_supported = False
if os.name == "posix" and float(WIRE_PROTOCOL_VERSION) <= 1:
    try:
        import mavnative

        native_supported = True
    except ImportError:
        logger.error("ERROR LOADING MAVNATIVE - falling back to python implementation")

# allow MAV_IGNORE_CRC=1 to ignore CRC, allowing some
# corrupted msgs to be seen
MAVLINK_IGNORE_CRC = os.environ.get("MAV_IGNORE_CRC", 0)

# some base types from mavlink_types.h
MAVLINK_TYPE_CHAR = 0
MAVLINK_TYPE_UINT8_T = 1
MAVLINK_TYPE_INT8_T = 2
MAVLINK_TYPE_UINT16_T = 3
MAVLINK_TYPE_INT16_T = 4
MAVLINK_TYPE_UINT32_T = 5
MAVLINK_TYPE_INT32_T = 6
MAVLINK_TYPE_UINT64_T = 7
MAVLINK_TYPE_INT64_T = 8
MAVLINK_TYPE_FLOAT = 9
MAVLINK_TYPE_DOUBLE = 10


class x25crc(object):
    """CRC-16/MCRF4XX - based on checksum.h from mavlink library"""

    def __init__(self, buf=None):
        self.crc = 0xFFFF
        if buf is not None:
            self.accumulate(buf)

    def accumulate(self, buf):
        """add in some more bytes (it also accepts python2 strings)"""
        if sys.version_info[0] == 2 and type(buf) is str:
            buf = bytearray(buf)

        accum = self.crc
        for b in buf:
            tmp = b ^ (accum & 0xFF)
            tmp = (tmp ^ (tmp << 4)) & 0xFF
            accum = (accum >> 8) ^ (tmp << 8) ^ (tmp << 3) ^ (tmp >> 4)
        self.crc = accum


class MAVLink_header(object):
    """MAVLink message header"""

    def __init__(self, msgId, incompat_flags=0, compat_flags=0, mlen=0, seq=0, srcSystem=0, srcComponent=0):
        self.mlen = mlen
        self.seq = seq
        self.srcSystem = srcSystem
        self.srcComponent = srcComponent
        self.msgId = msgId
        self.incompat_flags = incompat_flags
        self.compat_flags = compat_flags

    def pack(self, force_mavlink1=False):
        if float(WIRE_PROTOCOL_VERSION) == 2.0 and not force_mavlink1:
            return struct.pack(
                "<BBBBBBBHB",
                253,
                self.mlen,
                self.incompat_flags,
                self.compat_flags,
                self.seq,
                self.srcSystem,
                self.srcComponent,
                self.msgId & 0xFFFF,
                self.msgId >> 16,
            )
        return struct.pack(
            "<BBBBBB",
            PROTOCOL_MARKER_V1,
            self.mlen,
            self.seq,
            self.srcSystem,
            self.srcComponent,
            self.msgId,
        )


class MAVLink_message(object):
    """base MAVLink message class"""

    id = 0
    msgname = ""
    fieldnames = []
    ordered_fieldnames = []
    fieldtypes = []
    fielddisplays_by_name = {}
    fieldenums_by_name = {}
    fieldunits_by_name = {}
    native_format = bytearray(b"")
    orders = []
    lengths = []
    array_lengths = []
    crc_extra = 0
    unpacker = struct.Struct("")
    instance_field = None
    instance_offset = -1

    def __init__(self, msgId, name):
        self._header = MAVLink_header(msgId)
        self._payload = None
        self._msgbuf = bytearray(b"")
        self._crc = None
        self._fieldnames = []
        self._type = name
        self._signed = False
        self._link_id = None
        self._instances = None
        self._instance_field = None

    def format_attr(self, field):
        """override field getter"""
        raw_attr = cast("Union[bytes, float, int]", getattr(self, field))
        if isinstance(raw_attr, bytes):
            if sys.version_info[0] == 2:
                return raw_attr.rstrip(b"\x00")
            return raw_attr.decode(errors="ignore").rstrip("\x00")
        return raw_attr

    def get_msgbuf(self):
        return self._msgbuf

    def get_header(self):
        return self._header

    def get_payload(self):
        return self._payload

    def get_crc(self):
        return self._crc

    def get_fieldnames(self):
        return self._fieldnames

    def get_type(self):
        return self._type

    def get_msgId(self):
        return self._header.msgId

    def get_srcSystem(self):
        return self._header.srcSystem

    def get_srcComponent(self):
        return self._header.srcComponent

    def get_seq(self):
        return self._header.seq

    def get_signed(self):
        return self._signed

    def get_link_id(self):
        return self._link_id

    def __str__(self):
        ret = "%s {" % self._type
        for a in self._fieldnames:
            v = self.format_attr(a)
            ret += "%s : %s, " % (a, v)
        ret = ret[0:-2] + "}"
        return ret

    def __ne__(self, other):
        return not self.__eq__(other)

    def __eq__(self, other):
        if other is None:
            return False

        if not isinstance(other, MAVLink_message):
            return False

        if self.get_type() != other.get_type():
            return False

        # We do not compare CRC because native code doesn't provide it
        # if self.get_crc() != other.get_crc():
        #    return False

        if self.get_seq() != other.get_seq():
            return False

        if self.get_srcSystem() != other.get_srcSystem():
            return False

        if self.get_srcComponent() != other.get_srcComponent():
            return False

        for a in self._fieldnames:
            if self.format_attr(a) != other.format_attr(a):
                return False

        return True

    def to_dict(self):
        d = {}
        d["mavpackettype"] = self._type
        for a in self._fieldnames:
            d[a] = self.format_attr(a)
        return d

    def to_json(self):
        return json.dumps(self.to_dict())

    def sign_packet(self, mav):
        assert mav.signing.secret_key is not None

        h = hashlib.new("sha256")
        self._msgbuf += struct.pack("<BQ", mav.signing.link_id, mav.signing.timestamp)[:7]
        h.update(mav.signing.secret_key)
        h.update(self._msgbuf)
        sig = h.digest()[:6]
        self._msgbuf += sig
        mav.signing.timestamp += 1

    def _pack(self, mav, crc_extra, payload, force_mavlink1=False):
        plen = len(payload)
        if float(WIRE_PROTOCOL_VERSION) == 2.0 and not force_mavlink1:
            # in MAVLink2 we can strip trailing zeros off payloads. This allows for simple
            # variable length arrays and smaller packets
            if sys.version_info[0] == 2:
                nullbyte = chr(0)
            else:
                nullbyte = 0
            while plen > 1 and payload[plen - 1] == nullbyte:
                plen -= 1
        self._payload = payload[:plen]
        incompat_flags = 0
        if mav.signing.sign_outgoing:
            incompat_flags |= MAVLINK_IFLAG_SIGNED
        self._header = MAVLink_header(
            self._header.msgId,
            incompat_flags=incompat_flags,
            compat_flags=0,
            mlen=len(self._payload),
            seq=mav.seq,
            srcSystem=mav.srcSystem,
            srcComponent=mav.srcComponent,
        )
        self._msgbuf = bytearray(self._header.pack(force_mavlink1=force_mavlink1))
        self._msgbuf += self._payload
        crc = x25crc(self._msgbuf[1:])
        if True:
            # we are using CRC extra
            crc.accumulate(struct.pack("B", crc_extra))
        self._crc = crc.crc
        self._msgbuf += struct.pack("<H", self._crc)
        if mav.signing.sign_outgoing and not force_mavlink1:
            self.sign_packet(mav)
        return bytes(self._msgbuf)

    def pack(self, mav, force_mavlink1=False):
        raise NotImplementedError("MAVLink_message cannot be serialized directly")

    def __getitem__(self, key):
        """support indexing, allowing for multi-instance sensors in one message"""
        if self._instances is None:
            raise IndexError()
        if key not in self._instances:
            raise IndexError()
        return self._instances[key]


# enums


class EnumEntry(object):
    def __init__(self, name, description, param=None):
        self.name = name
        self.description = description
        self.param = param if param is not None else {}


MAV_AUTOPILOT_GENERIC = 0
MAV_AUTOPILOT_RESERVED = 1
MAV_AUTOPILOT_SLUGS = 2
MAV_AUTOPILOT_ARDUPILOTMEGA = 3
MAV_AUTOPILOT_OPENPILOT = 4
MAV_AUTOPILOT_GENERIC_WAYPOINTS_ONLY = 5
MAV_AUTOPILOT_GENERIC_WAYPOINTS_AND_SIMPLE_NAVIGATION_ONLY = 6
MAV_AUTOPILOT_GENERIC_MISSION_FULL = 7
MAV_AUTOPILOT_INVALID = 8
MAV_AUTOPILOT_PPZ = 9
MAV_AUTOPILOT_UDB = 10
MAV_AUTOPILOT_FP = 11
MAV_AUTOPILOT_PX4 = 12
MAV_AUTOPILOT_SMACCMPILOT = 13
MAV_AUTOPILOT_AUTOQUAD = 14
MAV_AUTOPILOT_ARMAZILA = 15
MAV_AUTOPILOT_AEROB = 16
MAV_AUTOPILOT_ASLUAV = 17
MAV_AUTOPILOT_SMARTAP = 18
MAV_AUTOPILOT_AIRRAILS = 19
MAV_AUTOPILOT_REFLEX = 20
MAV_AUTOPILOT_ENUM_END = 21
MAV_TYPE_GENERIC = 0
MAV_TYPE_FIXED_WING = 1
MAV_TYPE_QUADROTOR = 2
MAV_TYPE_COAXIAL = 3
MAV_TYPE_HELICOPTER = 4
MAV_TYPE_ANTENNA_TRACKER = 5
MAV_TYPE_GCS = 6
MAV_TYPE_AIRSHIP = 7
MAV_TYPE_FREE_BALLOON = 8
MAV_TYPE_ROCKET = 9
MAV_TYPE_GROUND_ROVER = 10
MAV_TYPE_SURFACE_BOAT = 11
MAV_TYPE_SUBMARINE = 12
MAV_TYPE_HEXAROTOR = 13
MAV_TYPE_OCTOROTOR = 14
MAV_TYPE_TRICOPTER = 15
MAV_TYPE_FLAPPING_WING = 16
MAV_TYPE_KITE = 17
MAV_TYPE_ONBOARD_CONTROLLER = 18
MAV_TYPE_VTOL_TAILSITTER_DUOROTOR = 19
MAV_TYPE_VTOL_TAILSITTER_QUADROTOR = 20
MAV_TYPE_VTOL_TILTROTOR = 21
MAV_TYPE_VTOL_FIXEDROTOR = 22
MAV_TYPE_VTOL_TAILSITTER = 23
MAV_TYPE_VTOL_RESERVED4 = 24
MAV_TYPE_VTOL_RESERVED5 = 25
MAV_TYPE_GIMBAL = 26
MAV_TYPE_ADSB = 27
MAV_TYPE_PARAFOIL = 28
MAV_TYPE_DODECAROTOR = 29
MAV_TYPE_CAMERA = 30
MAV_TYPE_CHARGING_STATION = 31
MAV_TYPE_FLARM = 32
MAV_TYPE_SERVO = 33
MAV_TYPE_ODID = 34
MAV_TYPE_DECAROTOR = 35
MAV_TYPE_BATTERY = 36
MAV_TYPE_PARACHUTE = 37
MAV_TYPE_LOG = 38
MAV_TYPE_OSD = 39
MAV_TYPE_IMU = 40
MAV_TYPE_GPS = 41
MAV_TYPE_WINCH = 42
MAV_TYPE_ENUM_END = 43
MAV_MODE_FLAG_CUSTOM_MODE_ENABLED = 1
MAV_MODE_FLAG_TEST_ENABLED = 2
MAV_MODE_FLAG_AUTO_ENABLED = 4
MAV_MODE_FLAG_GUIDED_ENABLED = 8
MAV_MODE_FLAG_STABILIZE_ENABLED = 16
MAV_MODE_FLAG_HIL_ENABLED = 32
MAV_MODE_FLAG_MANUAL_INPUT_ENABLED = 64
MAV_MODE_FLAG_SAFETY_ARMED = 128
MAV_MODE_FLAG_ENUM_END = 129
MAV_MODE_FLAG_DECODE_POSITION_CUSTOM_MODE = 1
MAV_MODE_FLAG_DECODE_POSITION_TEST = 2
MAV_MODE_FLAG_DECODE_POSITION_AUTO = 4
MAV_MODE_FLAG_DECODE_POSITION_GUIDED = 8
MAV_MODE_FLAG_DECODE_POSITION_STABILIZE = 16
MAV_MODE_FLAG_DECODE_POSITION_HIL = 32
MAV_MODE_FLAG_DECODE_POSITION_MANUAL = 64
MAV_MODE_FLAG_DECODE_POSITION_SAFETY = 128
MAV_MODE_FLAG_DECODE_POSITION_ENUM_END = 129
MAV_STATE_UNINIT = 0
MAV_STATE_BOOT = 1
MAV_STATE_CALIBRATING = 2
MAV_STATE_STANDBY = 3
MAV_STATE_ACTIVE = 4
MAV_STATE_CRITICAL = 5
MAV_STATE_EMERGENCY = 6
MAV_STATE_POWEROFF = 7
MAV_STATE_FLIGHT_TERMINATION = 8
MAV_STATE_ENUM_END = 9
MAV_COMP_ID_ALL = 0
MAV_COMP_ID_AUTOPILOT1 = 1
MAV_COMP_ID_USER1 = 25
MAV_COMP_ID_USER2 = 26
MAV_COMP_ID_USER3 = 27
MAV_COMP_ID_USER4 = 28
MAV_COMP_ID_USER5 = 29
MAV_COMP_ID_USER6 = 30
MAV_COMP_ID_USER7 = 31
MAV_COMP_ID_USER8 = 32
MAV_COMP_ID_USER9 = 33
MAV_COMP_ID_USER10 = 34
MAV_COMP_ID_USER11 = 35
MAV_COMP_ID_USER12 = 36
MAV_COMP_ID_USER13 = 37
MAV_COMP_ID_USER14 = 38
MAV_COMP_ID_USER15 = 39
MAV_COMP_ID_USER16 = 40
MAV_COMP_ID_USER17 = 41
MAV_COMP_ID_USER18 = 42
MAV_COMP_ID_USER19 = 43
MAV_COMP_ID_USER20 = 44
MAV_COMP_ID_USER21 = 45
MAV_COMP_ID_USER22 = 46
MAV_COMP_ID_USER23 = 47
MAV_COMP_ID_USER24 = 48
MAV_COMP_ID_USER25 = 49
MAV_COMP_ID_USER26 = 50
MAV_COMP_ID_USER27 = 51
MAV_COMP_ID_USER28 = 52
MAV_COMP_ID_USER29 = 53
MAV_COMP_ID_USER30 = 54
MAV_COMP_ID_USER31 = 55
MAV_COMP_ID_USER32 = 56
MAV_COMP_ID_USER33 = 57
MAV_COMP_ID_USER34 = 58
MAV_COMP_ID_USER35 = 59
MAV_COMP_ID_USER36 = 60
MAV_COMP_ID_USER37 = 61
MAV_COMP_ID_USER38 = 62
MAV_COMP_ID_USER39 = 63
MAV_COMP_ID_USER40 = 64
MAV_COMP_ID_USER41 = 65
MAV_COMP_ID_USER42 = 66
MAV_COMP_ID_USER43 = 67
MAV_COMP_ID_TELEMETRY_RADIO = 68
MAV_COMP_ID_USER45 = 69
MAV_COMP_ID_USER46 = 70
MAV_COMP_ID_USER47 = 71
MAV_COMP_ID_USER48 = 72
MAV_COMP_ID_USER49 = 73
MAV_COMP_ID_USER50 = 74
MAV_COMP_ID_USER51 = 75
MAV_COMP_ID_USER52 = 76
MAV_COMP_ID_USER53 = 77
MAV_COMP_ID_USER54 = 78
MAV_COMP_ID_USER55 = 79
MAV_COMP_ID_USER56 = 80
MAV_COMP_ID_USER57 = 81
MAV_COMP_ID_USER58 = 82
MAV_COMP_ID_USER59 = 83
MAV_COMP_ID_USER60 = 84
MAV_COMP_ID_USER61 = 85
MAV_COMP_ID_USER62 = 86
MAV_COMP_ID_USER63 = 87
MAV_COMP_ID_USER64 = 88
MAV_COMP_ID_USER65 = 89
MAV_COMP_ID_USER66 = 90
MAV_COMP_ID_USER67 = 91
MAV_COMP_ID_USER68 = 92
MAV_COMP_ID_USER69 = 93
MAV_COMP_ID_USER70 = 94
MAV_COMP_ID_USER71 = 95
MAV_COMP_ID_USER72 = 96
MAV_COMP_ID_USER73 = 97
MAV_COMP_ID_USER74 = 98
MAV_COMP_ID_USER75 = 99
MAV_COMP_ID_CAMERA = 100
MAV_COMP_ID_CAMERA2 = 101
MAV_COMP_ID_CAMERA3 = 102
MAV_COMP_ID_CAMERA4 = 103
MAV_COMP_ID_CAMERA5 = 104
MAV_COMP_ID_CAMERA6 = 105
MAV_COMP_ID_SERVO1 = 140
MAV_COMP_ID_SERVO2 = 141
MAV_COMP_ID_SERVO3 = 142
MAV_COMP_ID_SERVO4 = 143
MAV_COMP_ID_SERVO5 = 144
MAV_COMP_ID_SERVO6 = 145
MAV_COMP_ID_SERVO7 = 146
MAV_COMP_ID_SERVO8 = 147
MAV_COMP_ID_SERVO9 = 148
MAV_COMP_ID_SERVO10 = 149
MAV_COMP_ID_SERVO11 = 150
MAV_COMP_ID_SERVO12 = 151
MAV_COMP_ID_SERVO13 = 152
MAV_COMP_ID_SERVO14 = 153
MAV_COMP_ID_GIMBAL = 154
MAV_COMP_ID_LOG = 155
MAV_COMP_ID_ADSB = 156
MAV_COMP_ID_OSD = 157
MAV_COMP_ID_PERIPHERAL = 158
MAV_COMP_ID_QX1_GIMBAL = 159
MAV_COMP_ID_FLARM = 160
MAV_COMP_ID_PARACHUTE = 161
MAV_COMP_ID_GIMBAL2 = 171
MAV_COMP_ID_GIMBAL3 = 172
MAV_COMP_ID_GIMBAL4 = 173
MAV_COMP_ID_GIMBAL5 = 174
MAV_COMP_ID_GIMBAL6 = 175
MAV_COMP_ID_BATTERY = 180
MAV_COMP_ID_BATTERY2 = 181
MAV_COMP_ID_MAVCAN = 189
MAV_COMP_ID_MISSIONPLANNER = 190
MAV_COMP_ID_ONBOARD_COMPUTER = 191
MAV_COMP_ID_ONBOARD_COMPUTER2 = 192
MAV_COMP_ID_ONBOARD_COMPUTER3 = 193
MAV_COMP_ID_ONBOARD_COMPUTER4 = 194
MAV_COMP_ID_PATHPLANNER = 195
MAV_COMP_ID_OBSTACLE_AVOIDANCE = 196
MAV_COMP_ID_VISUAL_INERTIAL_ODOMETRY = 197
MAV_COMP_ID_PAIRING_MANAGER = 198
MAV_COMP_ID_IMU = 200
MAV_COMP_ID_IMU_2 = 201
MAV_COMP_ID_IMU_3 = 202
MAV_COMP_ID_GPS = 220
MAV_COMP_ID_GPS2 = 221
MAV_COMP_ID_ODID_TXRX_1 = 236
MAV_COMP_ID_ODID_TXRX_2 = 237
MAV_COMP_ID_ODID_TXRX_3 = 238
MAV_COMP_ID_UDP_BRIDGE = 240
MAV_COMP_ID_UART_BRIDGE = 241
MAV_COMP_ID_TUNNEL_NODE = 242
MAV_COMP_ID_SYSTEM_CONTROL = 250
MAV_COMPONENT_ENUM_END = 251


enums = {
    "MAV_AUTOPILOT": {
        MAV_AUTOPILOT_GENERIC: EnumEntry(
            "MAV_AUTOPILOT_GENERIC",
            """Generic autopilot, full support for everything""",
        ),
        MAV_AUTOPILOT_RESERVED: EnumEntry(
            "MAV_AUTOPILOT_RESERVED",
            """Reserved for future use.""",
        ),
        MAV_AUTOPILOT_SLUGS: EnumEntry(
            "MAV_AUTOPILOT_SLUGS",
            """SLUGS autopilot, http://slugsuav.soe.ucsc.edu""",
        ),
        MAV_AUTOPILOT_ARDUPILOTMEGA: EnumEntry(
            "MAV_AUTOPILOT_ARDUPILOTMEGA",
            """ArduPilot - Plane/Copter/Rover/Sub/Tracker, https://ardupilot.org""",
        ),
        MAV_AUTOPILOT_OPENPILOT: EnumEntry(
            "MAV_AUTOPILOT_OPENPILOT",
            """OpenPilot, http://openpilot.org""",
        ),
        MAV_AUTOPILOT_GENERIC_WAYPOINTS_ONLY: EnumEntry(
            "MAV_AUTOPILOT_GENERIC_WAYPOINTS_ONLY",
            """Generic autopilot only supporting simple waypoints""",
        ),
        MAV_AUTOPILOT_GENERIC_WAYPOINTS_AND_SIMPLE_NAVIGATION_ONLY: EnumEntry(
            "MAV_AUTOPILOT_GENERIC_WAYPOINTS_AND_SIMPLE_NAVIGATION_ONLY",
            """Generic autopilot supporting waypoints and other simple navigation commands""",
        ),
        MAV_AUTOPILOT_GENERIC_MISSION_FULL: EnumEntry(
            "MAV_AUTOPILOT_GENERIC_MISSION_FULL",
            """Generic autopilot supporting the full mission command set""",
        ),
        MAV_AUTOPILOT_INVALID: EnumEntry(
            "MAV_AUTOPILOT_INVALID",
            """No valid autopilot, e.g. a GCS or other MAVLink component""",
        ),
        MAV_AUTOPILOT_PPZ: EnumEntry(
            "MAV_AUTOPILOT_PPZ",
            """PPZ UAV - http://nongnu.org/paparazzi""",
        ),
        MAV_AUTOPILOT_UDB: EnumEntry(
            "MAV_AUTOPILOT_UDB",
            """UAV Dev Board""",
        ),
        MAV_AUTOPILOT_FP: EnumEntry(
            "MAV_AUTOPILOT_FP",
            """FlexiPilot""",
        ),
        MAV_AUTOPILOT_PX4: EnumEntry(
            "MAV_AUTOPILOT_PX4",
            """PX4 Autopilot - http://px4.io/""",
        ),
        MAV_AUTOPILOT_SMACCMPILOT: EnumEntry(
            "MAV_AUTOPILOT_SMACCMPILOT",
            """SMACCMPilot - http://smaccmpilot.org""",
        ),
        MAV_AUTOPILOT_AUTOQUAD: EnumEntry(
            "MAV_AUTOPILOT_AUTOQUAD",
            """AutoQuad -- http://autoquad.org""",
        ),
        MAV_AUTOPILOT_ARMAZILA: EnumEntry(
            "MAV_AUTOPILOT_ARMAZILA",
            """Armazila -- http://armazila.com""",
        ),
        MAV_AUTOPILOT_AEROB: EnumEntry(
            "MAV_AUTOPILOT_AEROB",
            """Aerob -- http://aerob.ru""",
        ),
        MAV_AUTOPILOT_ASLUAV: EnumEntry(
            "MAV_AUTOPILOT_ASLUAV",
            """ASLUAV autopilot -- http://www.asl.ethz.ch""",
        ),
        MAV_AUTOPILOT_SMARTAP: EnumEntry(
            "MAV_AUTOPILOT_SMARTAP",
            """SmartAP Autopilot - http://sky-drones.com""",
        ),
        MAV_AUTOPILOT_AIRRAILS: EnumEntry(
            "MAV_AUTOPILOT_AIRRAILS",
            """AirRails - http://uaventure.com""",
        ),
        MAV_AUTOPILOT_REFLEX: EnumEntry(
            "MAV_AUTOPILOT_REFLEX",
            """Fusion Reflex - https://fusion.engineering""",
        ),
        MAV_AUTOPILOT_ENUM_END: EnumEntry(
            "MAV_AUTOPILOT_ENUM_END",
            """""",
        ),
    },
    "MAV_TYPE": {
        MAV_TYPE_GENERIC: EnumEntry(
            "MAV_TYPE_GENERIC",
            """Generic micro air vehicle""",
        ),
        MAV_TYPE_FIXED_WING: EnumEntry(
            "MAV_TYPE_FIXED_WING",
            """Fixed wing aircraft.""",
        ),
        MAV_TYPE_QUADROTOR: EnumEntry(
            "MAV_TYPE_QUADROTOR",
            """Quadrotor""",
        ),
        MAV_TYPE_COAXIAL: EnumEntry(
            "MAV_TYPE_COAXIAL",
            """Coaxial helicopter""",
        ),
        MAV_TYPE_HELICOPTER: EnumEntry(
            "MAV_TYPE_HELICOPTER",
            """Normal helicopter with tail rotor.""",
        ),
        MAV_TYPE_ANTENNA_TRACKER: EnumEntry(
            "MAV_TYPE_ANTENNA_TRACKER",
            """Ground installation""",
        ),
        MAV_TYPE_GCS: EnumEntry(
            "MAV_TYPE_GCS",
            """Operator control unit / ground control station""",
        ),
        MAV_TYPE_AIRSHIP: EnumEntry(
            "MAV_TYPE_AIRSHIP",
            """Airship, controlled""",
        ),
        MAV_TYPE_FREE_BALLOON: EnumEntry(
            "MAV_TYPE_FREE_BALLOON",
            """Free balloon, uncontrolled""",
        ),
        MAV_TYPE_ROCKET: EnumEntry(
            "MAV_TYPE_ROCKET",
            """Rocket""",
        ),
        MAV_TYPE_GROUND_ROVER: EnumEntry(
            "MAV_TYPE_GROUND_ROVER",
            """Ground rover""",
        ),
        MAV_TYPE_SURFACE_BOAT: EnumEntry(
            "MAV_TYPE_SURFACE_BOAT",
            """Surface vessel, boat, ship""",
        ),
        MAV_TYPE_SUBMARINE: EnumEntry(
            "MAV_TYPE_SUBMARINE",
            """Submarine""",
        ),
        MAV_TYPE_HEXAROTOR: EnumEntry(
            "MAV_TYPE_HEXAROTOR",
            """Hexarotor""",
        ),
        MAV_TYPE_OCTOROTOR: EnumEntry(
            "MAV_TYPE_OCTOROTOR",
            """Octorotor""",
        ),
        MAV_TYPE_TRICOPTER: EnumEntry(
            "MAV_TYPE_TRICOPTER",
            """Tricopter""",
        ),
        MAV_TYPE_FLAPPING_WING: EnumEntry(
            "MAV_TYPE_FLAPPING_WING",
            """Flapping wing""",
        ),
        MAV_TYPE_KITE: EnumEntry(
            "MAV_TYPE_KITE",
            """Kite""",
        ),
        MAV_TYPE_ONBOARD_CONTROLLER: EnumEntry(
            "MAV_TYPE_ONBOARD_CONTROLLER",
            """Onboard companion controller""",
        ),
        MAV_TYPE_VTOL_TAILSITTER_DUOROTOR: EnumEntry(
            "MAV_TYPE_VTOL_TAILSITTER_DUOROTOR",
            """Two-rotor Tailsitter VTOL that additionally uses control surfaces in vertical operation. Note, value previously named MAV_TYPE_VTOL_DUOROTOR.""",
        ),
        MAV_TYPE_VTOL_TAILSITTER_QUADROTOR: EnumEntry(
            "MAV_TYPE_VTOL_TAILSITTER_QUADROTOR",
            """Quad-rotor Tailsitter VTOL using a V-shaped quad config in vertical operation. Note: value previously named MAV_TYPE_VTOL_QUADROTOR.""",
        ),
        MAV_TYPE_VTOL_TILTROTOR: EnumEntry(
            "MAV_TYPE_VTOL_TILTROTOR",
            """Tiltrotor VTOL. Fuselage and wings stay (nominally) horizontal in all flight phases. It able to tilt (some) rotors to provide thrust in cruise flight.""",
        ),
        MAV_TYPE_VTOL_FIXEDROTOR: EnumEntry(
            "MAV_TYPE_VTOL_FIXEDROTOR",
            """VTOL with separate fixed rotors for hover and cruise flight. Fuselage and wings stay (nominally) horizontal in all flight phases.""",
        ),
        MAV_TYPE_VTOL_TAILSITTER: EnumEntry(
            "MAV_TYPE_VTOL_TAILSITTER",
            """Tailsitter VTOL. Fuselage and wings orientation changes depending on flight phase: vertical for hover, horizontal for cruise. Use more specific VTOL MAV_TYPE_VTOL_DUOROTOR or MAV_TYPE_VTOL_QUADROTOR if appropriate.""",
        ),
        MAV_TYPE_VTOL_RESERVED4: EnumEntry(
            "MAV_TYPE_VTOL_RESERVED4",
            """VTOL reserved 4""",
        ),
        MAV_TYPE_VTOL_RESERVED5: EnumEntry(
            "MAV_TYPE_VTOL_RESERVED5",
            """VTOL reserved 5""",
        ),
        MAV_TYPE_GIMBAL: EnumEntry(
            "MAV_TYPE_GIMBAL",
            """Gimbal""",
        ),
        MAV_TYPE_ADSB: EnumEntry(
            "MAV_TYPE_ADSB",
            """ADSB system""",
        ),
        MAV_TYPE_PARAFOIL: EnumEntry(
            "MAV_TYPE_PARAFOIL",
            """Steerable, nonrigid airfoil""",
        ),
        MAV_TYPE_DODECAROTOR: EnumEntry(
            "MAV_TYPE_DODECAROTOR",
            """Dodecarotor""",
        ),
        MAV_TYPE_CAMERA: EnumEntry(
            "MAV_TYPE_CAMERA",
            """Camera""",
        ),
        MAV_TYPE_CHARGING_STATION: EnumEntry(
            "MAV_TYPE_CHARGING_STATION",
            """Charging station""",
        ),
        MAV_TYPE_FLARM: EnumEntry(
            "MAV_TYPE_FLARM",
            """FLARM collision avoidance system""",
        ),
        MAV_TYPE_SERVO: EnumEntry(
            "MAV_TYPE_SERVO",
            """Servo""",
        ),
        MAV_TYPE_ODID: EnumEntry(
            "MAV_TYPE_ODID",
            """Open Drone ID. See https://mavlink.io/en/services/opendroneid.html.""",
        ),
        MAV_TYPE_DECAROTOR: EnumEntry(
            "MAV_TYPE_DECAROTOR",
            """Decarotor""",
        ),
        MAV_TYPE_BATTERY: EnumEntry(
            "MAV_TYPE_BATTERY",
            """Battery""",
        ),
        MAV_TYPE_PARACHUTE: EnumEntry(
            "MAV_TYPE_PARACHUTE",
            """Parachute""",
        ),
        MAV_TYPE_LOG: EnumEntry(
            "MAV_TYPE_LOG",
            """Log""",
        ),
        MAV_TYPE_OSD: EnumEntry(
            "MAV_TYPE_OSD",
            """OSD""",
        ),
        MAV_TYPE_IMU: EnumEntry(
            "MAV_TYPE_IMU",
            """IMU""",
        ),
        MAV_TYPE_GPS: EnumEntry(
            "MAV_TYPE_GPS",
            """GPS""",
        ),
        MAV_TYPE_WINCH: EnumEntry(
            "MAV_TYPE_WINCH",
            """Winch""",
        ),
        MAV_TYPE_ENUM_END: EnumEntry(
            "MAV_TYPE_ENUM_END",
            """""",
        ),
    },
    "MAV_MODE_FLAG": {
        MAV_MODE_FLAG_CUSTOM_MODE_ENABLED: EnumEntry(
            "MAV_MODE_FLAG_CUSTOM_MODE_ENABLED",
            """0b00000001 Reserved for future use.""",
        ),
        MAV_MODE_FLAG_TEST_ENABLED: EnumEntry(
            "MAV_MODE_FLAG_TEST_ENABLED",
            """0b00000010 system has a test mode enabled. This flag is intended for temporary system tests and should not be used for stable implementations.""",
        ),
        MAV_MODE_FLAG_AUTO_ENABLED: EnumEntry(
            "MAV_MODE_FLAG_AUTO_ENABLED",
            """0b00000100 autonomous mode enabled, system finds its own goal positions. Guided flag can be set or not, depends on the actual implementation.""",
        ),
        MAV_MODE_FLAG_GUIDED_ENABLED: EnumEntry(
            "MAV_MODE_FLAG_GUIDED_ENABLED",
            """0b00001000 guided mode enabled, system flies waypoints / mission items.""",
        ),
        MAV_MODE_FLAG_STABILIZE_ENABLED: EnumEntry(
            "MAV_MODE_FLAG_STABILIZE_ENABLED",
            """0b00010000 system stabilizes electronically its attitude (and optionally position). It needs however further control inputs to move around.""",
        ),
        MAV_MODE_FLAG_HIL_ENABLED: EnumEntry(
            "MAV_MODE_FLAG_HIL_ENABLED",
            """0b00100000 hardware in the loop simulation. All motors / actuators are blocked, but internal software is full operational.""",
        ),
        MAV_MODE_FLAG_MANUAL_INPUT_ENABLED: EnumEntry(
            "MAV_MODE_FLAG_MANUAL_INPUT_ENABLED",
            """0b01000000 remote control input is enabled.""",
        ),
        MAV_MODE_FLAG_SAFETY_ARMED: EnumEntry(
            "MAV_MODE_FLAG_SAFETY_ARMED",
            """0b10000000 MAV safety set to armed. Motors are enabled / running / can start. Ready to fly. Additional note: this flag is to be ignore when sent in the command MAV_CMD_DO_SET_MODE and MAV_CMD_COMPONENT_ARM_DISARM shall be used instead. The flag can still be used to report the armed state.""",
        ),
        MAV_MODE_FLAG_ENUM_END: EnumEntry(
            "MAV_MODE_FLAG_ENUM_END",
            """""",
        ),
    },
    "MAV_MODE_FLAG_DECODE_POSITION": {
        MAV_MODE_FLAG_DECODE_POSITION_CUSTOM_MODE: EnumEntry(
            "MAV_MODE_FLAG_DECODE_POSITION_CUSTOM_MODE",
            """Eighth bit: 00000001""",
        ),
        MAV_MODE_FLAG_DECODE_POSITION_TEST: EnumEntry(
            "MAV_MODE_FLAG_DECODE_POSITION_TEST",
            """Seventh bit: 00000010""",
        ),
        MAV_MODE_FLAG_DECODE_POSITION_AUTO: EnumEntry(
            "MAV_MODE_FLAG_DECODE_POSITION_AUTO",
            """Sixth bit:   00000100""",
        ),
        MAV_MODE_FLAG_DECODE_POSITION_GUIDED: EnumEntry(
            "MAV_MODE_FLAG_DECODE_POSITION_GUIDED",
            """Fifth bit:  00001000""",
        ),
        MAV_MODE_FLAG_DECODE_POSITION_STABILIZE: EnumEntry(
            "MAV_MODE_FLAG_DECODE_POSITION_STABILIZE",
            """Fourth bit: 00010000""",
        ),
        MAV_MODE_FLAG_DECODE_POSITION_HIL: EnumEntry(
            "MAV_MODE_FLAG_DECODE_POSITION_HIL",
            """Third bit:  00100000""",
        ),
        MAV_MODE_FLAG_DECODE_POSITION_MANUAL: EnumEntry(
            "MAV_MODE_FLAG_DECODE_POSITION_MANUAL",
            """Second bit: 01000000""",
        ),
        MAV_MODE_FLAG_DECODE_POSITION_SAFETY: EnumEntry(
            "MAV_MODE_FLAG_DECODE_POSITION_SAFETY",
            """First bit:  10000000""",
        ),
        MAV_MODE_FLAG_DECODE_POSITION_ENUM_END: EnumEntry(
            "MAV_MODE_FLAG_DECODE_POSITION_ENUM_END",
            """""",
        ),
    },
    "MAV_STATE": {
        MAV_STATE_UNINIT: EnumEntry(
            "MAV_STATE_UNINIT",
            """Uninitialized system, state is unknown.""",
        ),
        MAV_STATE_BOOT: EnumEntry(
            "MAV_STATE_BOOT",
            """System is booting up.""",
        ),
        MAV_STATE_CALIBRATING: EnumEntry(
            "MAV_STATE_CALIBRATING",
            """System is calibrating and not flight-ready.""",
        ),
        MAV_STATE_STANDBY: EnumEntry(
            "MAV_STATE_STANDBY",
            """System is grounded and on standby. It can be launched any time.""",
        ),
        MAV_STATE_ACTIVE: EnumEntry(
            "MAV_STATE_ACTIVE",
            """System is active and might be already airborne. Motors are engaged.""",
        ),
        MAV_STATE_CRITICAL: EnumEntry(
            "MAV_STATE_CRITICAL",
            """System is in a non-normal flight mode. It can however still navigate.""",
        ),
        MAV_STATE_EMERGENCY: EnumEntry(
            "MAV_STATE_EMERGENCY",
            """System is in a non-normal flight mode. It lost control over parts or over the whole airframe. It is in mayday and going down.""",
        ),
        MAV_STATE_POWEROFF: EnumEntry(
            "MAV_STATE_POWEROFF",
            """System just initialized its power-down sequence, will shut down now.""",
        ),
        MAV_STATE_FLIGHT_TERMINATION: EnumEntry(
            "MAV_STATE_FLIGHT_TERMINATION",
            """System is terminating itself.""",
        ),
        MAV_STATE_ENUM_END: EnumEntry(
            "MAV_STATE_ENUM_END",
            """""",
        ),
    },
    "MAV_COMPONENT": {
        MAV_COMP_ID_ALL: EnumEntry(
            "MAV_COMP_ID_ALL",
            """Target id (target_component) used to broadcast messages to all components of the receiving system. Components should attempt to process messages with this component ID and forward to components on any other interfaces. Note: This is not a valid *source* component id for a message.""",
        ),
        MAV_COMP_ID_AUTOPILOT1: EnumEntry(
            "MAV_COMP_ID_AUTOPILOT1",
            """System flight controller component ("autopilot"). Only one autopilot is expected in a particular system.""",
        ),
        MAV_COMP_ID_USER1: EnumEntry(
            "MAV_COMP_ID_USER1",
            """Id for a component on privately managed MAVLink network. Can be used for any purpose but may not be published by components outside of the private network.""",
        ),
        MAV_COMP_ID_USER2: EnumEntry(
            "MAV_COMP_ID_USER2",
            """Id for a component on privately managed MAVLink network. Can be used for any purpose but may not be published by components outside of the private network.""",
        ),
        MAV_COMP_ID_USER3: EnumEntry(
            "MAV_COMP_ID_USER3",
            """Id for a component on privately managed MAVLink network. Can be used for any purpose but may not be published by components outside of the private network.""",
        ),
        MAV_COMP_ID_USER4: EnumEntry(
            "MAV_COMP_ID_USER4",
            """Id for a component on privately managed MAVLink network. Can be used for any purpose but may not be published by components outside of the private network.""",
        ),
        MAV_COMP_ID_USER5: EnumEntry(
            "MAV_COMP_ID_USER5",
            """Id for a component on privately managed MAVLink network. Can be used for any purpose but may not be published by components outside of the private network.""",
        ),
        MAV_COMP_ID_USER6: EnumEntry(
            "MAV_COMP_ID_USER6",
            """Id for a component on privately managed MAVLink network. Can be used for any purpose but may not be published by components outside of the private network.""",
        ),
        MAV_COMP_ID_USER7: EnumEntry(
            "MAV_COMP_ID_USER7",
            """Id for a component on privately managed MAVLink network. Can be used for any purpose but may not be published by components outside of the private network.""",
        ),
        MAV_COMP_ID_USER8: EnumEntry(
            "MAV_COMP_ID_USER8",
            """Id for a component on privately managed MAVLink network. Can be used for any purpose but may not be published by components outside of the private network.""",
        ),
        MAV_COMP_ID_USER9: EnumEntry(
            "MAV_COMP_ID_USER9",
            """Id for a component on privately managed MAVLink network. Can be used for any purpose but may not be published by components outside of the private network.""",
        ),
        MAV_COMP_ID_USER10: EnumEntry(
            "MAV_COMP_ID_USER10",
            """Id for a component on privately managed MAVLink network. Can be used for any purpose but may not be published by components outside of the private network.""",
        ),
        MAV_COMP_ID_USER11: EnumEntry(
            "MAV_COMP_ID_USER11",
            """Id for a component on privately managed MAVLink network. Can be used for any purpose but may not be published by components outside of the private network.""",
        ),
        MAV_COMP_ID_USER12: EnumEntry(
            "MAV_COMP_ID_USER12",
            """Id for a component on privately managed MAVLink network. Can be used for any purpose but may not be published by components outside of the private network.""",
        ),
        MAV_COMP_ID_USER13: EnumEntry(
            "MAV_COMP_ID_USER13",
            """Id for a component on privately managed MAVLink network. Can be used for any purpose but may not be published by components outside of the private network.""",
        ),
        MAV_COMP_ID_USER14: EnumEntry(
            "MAV_COMP_ID_USER14",
            """Id for a component on privately managed MAVLink network. Can be used for any purpose but may not be published by components outside of the private network.""",
        ),
        MAV_COMP_ID_USER15: EnumEntry(
            "MAV_COMP_ID_USER15",
            """Id for a component on privately managed MAVLink network. Can be used for any purpose but may not be published by components outside of the private network.""",
        ),
        MAV_COMP_ID_USER16: EnumEntry(
            "MAV_COMP_ID_USER16",
            """Id for a component on privately managed MAVLink network. Can be used for any purpose but may not be published by components outside of the private network.""",
        ),
        MAV_COMP_ID_USER17: EnumEntry(
            "MAV_COMP_ID_USER17",
            """Id for a component on privately managed MAVLink network. Can be used for any purpose but may not be published by components outside of the private network.""",
        ),
        MAV_COMP_ID_USER18: EnumEntry(
            "MAV_COMP_ID_USER18",
            """Id for a component on privately managed MAVLink network. Can be used for any purpose but may not be published by components outside of the private network.""",
        ),
        MAV_COMP_ID_USER19: EnumEntry(
            "MAV_COMP_ID_USER19",
            """Id for a component on privately managed MAVLink network. Can be used for any purpose but may not be published by components outside of the private network.""",
        ),
        MAV_COMP_ID_USER20: EnumEntry(
            "MAV_COMP_ID_USER20",
            """Id for a component on privately managed MAVLink network. Can be used for any purpose but may not be published by components outside of the private network.""",
        ),
        MAV_COMP_ID_USER21: EnumEntry(
            "MAV_COMP_ID_USER21",
            """Id for a component on privately managed MAVLink network. Can be used for any purpose but may not be published by components outside of the private network.""",
        ),
        MAV_COMP_ID_USER22: EnumEntry(
            "MAV_COMP_ID_USER22",
            """Id for a component on privately managed MAVLink network. Can be used for any purpose but may not be published by components outside of the private network.""",
        ),
        MAV_COMP_ID_USER23: EnumEntry(
            "MAV_COMP_ID_USER23",
            """Id for a component on privately managed MAVLink network. Can be used for any purpose but may not be published by components outside of the private network.""",
        ),
        MAV_COMP_ID_USER24: EnumEntry(
            "MAV_COMP_ID_USER24",
            """Id for a component on privately managed MAVLink network. Can be used for any purpose but may not be published by components outside of the private network.""",
        ),
        MAV_COMP_ID_USER25: EnumEntry(
            "MAV_COMP_ID_USER25",
            """Id for a component on privately managed MAVLink network. Can be used for any purpose but may not be published by components outside of the private network.""",
        ),
        MAV_COMP_ID_USER26: EnumEntry(
            "MAV_COMP_ID_USER26",
            """Id for a component on privately managed MAVLink network. Can be used for any purpose but may not be published by components outside of the private network.""",
        ),
        MAV_COMP_ID_USER27: EnumEntry(
            "MAV_COMP_ID_USER27",
            """Id for a component on privately managed MAVLink network. Can be used for any purpose but may not be published by components outside of the private network.""",
        ),
        MAV_COMP_ID_USER28: EnumEntry(
            "MAV_COMP_ID_USER28",
            """Id for a component on privately managed MAVLink network. Can be used for any purpose but may not be published by components outside of the private network.""",
        ),
        MAV_COMP_ID_USER29: EnumEntry(
            "MAV_COMP_ID_USER29",
            """Id for a component on privately managed MAVLink network. Can be used for any purpose but may not be published by components outside of the private network.""",
        ),
        MAV_COMP_ID_USER30: EnumEntry(
            "MAV_COMP_ID_USER30",
            """Id for a component on privately managed MAVLink network. Can be used for any purpose but may not be published by components outside of the private network.""",
        ),
        MAV_COMP_ID_USER31: EnumEntry(
            "MAV_COMP_ID_USER31",
            """Id for a component on privately managed MAVLink network. Can be used for any purpose but may not be published by components outside of the private network.""",
        ),
        MAV_COMP_ID_USER32: EnumEntry(
            "MAV_COMP_ID_USER32",
            """Id for a component on privately managed MAVLink network. Can be used for any purpose but may not be published by components outside of the private network.""",
        ),
        MAV_COMP_ID_USER33: EnumEntry(
            "MAV_COMP_ID_USER33",
            """Id for a component on privately managed MAVLink network. Can be used for any purpose but may not be published by components outside of the private network.""",
        ),
        MAV_COMP_ID_USER34: EnumEntry(
            "MAV_COMP_ID_USER34",
            """Id for a component on privately managed MAVLink network. Can be used for any purpose but may not be published by components outside of the private network.""",
        ),
        MAV_COMP_ID_USER35: EnumEntry(
            "MAV_COMP_ID_USER35",
            """Id for a component on privately managed MAVLink network. Can be used for any purpose but may not be published by components outside of the private network.""",
        ),
        MAV_COMP_ID_USER36: EnumEntry(
            "MAV_COMP_ID_USER36",
            """Id for a component on privately managed MAVLink network. Can be used for any purpose but may not be published by components outside of the private network.""",
        ),
        MAV_COMP_ID_USER37: EnumEntry(
            "MAV_COMP_ID_USER37",
            """Id for a component on privately managed MAVLink network. Can be used for any purpose but may not be published by components outside of the private network.""",
        ),
        MAV_COMP_ID_USER38: EnumEntry(
            "MAV_COMP_ID_USER38",
            """Id for a component on privately managed MAVLink network. Can be used for any purpose but may not be published by components outside of the private network.""",
        ),
        MAV_COMP_ID_USER39: EnumEntry(
            "MAV_COMP_ID_USER39",
            """Id for a component on privately managed MAVLink network. Can be used for any purpose but may not be published by components outside of the private network.""",
        ),
        MAV_COMP_ID_USER40: EnumEntry(
            "MAV_COMP_ID_USER40",
            """Id for a component on privately managed MAVLink network. Can be used for any purpose but may not be published by components outside of the private network.""",
        ),
        MAV_COMP_ID_USER41: EnumEntry(
            "MAV_COMP_ID_USER41",
            """Id for a component on privately managed MAVLink network. Can be used for any purpose but may not be published by components outside of the private network.""",
        ),
        MAV_COMP_ID_USER42: EnumEntry(
            "MAV_COMP_ID_USER42",
            """Id for a component on privately managed MAVLink network. Can be used for any purpose but may not be published by components outside of the private network.""",
        ),
        MAV_COMP_ID_USER43: EnumEntry(
            "MAV_COMP_ID_USER43",
            """Id for a component on privately managed MAVLink network. Can be used for any purpose but may not be published by components outside of the private network.""",
        ),
        MAV_COMP_ID_TELEMETRY_RADIO: EnumEntry(
            "MAV_COMP_ID_TELEMETRY_RADIO",
            """Telemetry radio (e.g. SiK radio, or other component that emits RADIO_STATUS messages).""",
        ),
        MAV_COMP_ID_USER45: EnumEntry(
            "MAV_COMP_ID_USER45",
            """Id for a component on privately managed MAVLink network. Can be used for any purpose but may not be published by components outside of the private network.""",
        ),
        MAV_COMP_ID_USER46: EnumEntry(
            "MAV_COMP_ID_USER46",
            """Id for a component on privately managed MAVLink network. Can be used for any purpose but may not be published by components outside of the private network.""",
        ),
        MAV_COMP_ID_USER47: EnumEntry(
            "MAV_COMP_ID_USER47",
            """Id for a component on privately managed MAVLink network. Can be used for any purpose but may not be published by components outside of the private network.""",
        ),
        MAV_COMP_ID_USER48: EnumEntry(
            "MAV_COMP_ID_USER48",
            """Id for a component on privately managed MAVLink network. Can be used for any purpose but may not be published by components outside of the private network.""",
        ),
        MAV_COMP_ID_USER49: EnumEntry(
            "MAV_COMP_ID_USER49",
            """Id for a component on privately managed MAVLink network. Can be used for any purpose but may not be published by components outside of the private network.""",
        ),
        MAV_COMP_ID_USER50: EnumEntry(
            "MAV_COMP_ID_USER50",
            """Id for a component on privately managed MAVLink network. Can be used for any purpose but may not be published by components outside of the private network.""",
        ),
        MAV_COMP_ID_USER51: EnumEntry(
            "MAV_COMP_ID_USER51",
            """Id for a component on privately managed MAVLink network. Can be used for any purpose but may not be published by components outside of the private network.""",
        ),
        MAV_COMP_ID_USER52: EnumEntry(
            "MAV_COMP_ID_USER52",
            """Id for a component on privately managed MAVLink network. Can be used for any purpose but may not be published by components outside of the private network.""",
        ),
        MAV_COMP_ID_USER53: EnumEntry(
            "MAV_COMP_ID_USER53",
            """Id for a component on privately managed MAVLink network. Can be used for any purpose but may not be published by components outside of the private network.""",
        ),
        MAV_COMP_ID_USER54: EnumEntry(
            "MAV_COMP_ID_USER54",
            """Id for a component on privately managed MAVLink network. Can be used for any purpose but may not be published by components outside of the private network.""",
        ),
        MAV_COMP_ID_USER55: EnumEntry(
            "MAV_COMP_ID_USER55",
            """Id for a component on privately managed MAVLink network. Can be used for any purpose but may not be published by components outside of the private network.""",
        ),
        MAV_COMP_ID_USER56: EnumEntry(
            "MAV_COMP_ID_USER56",
            """Id for a component on privately managed MAVLink network. Can be used for any purpose but may not be published by components outside of the private network.""",
        ),
        MAV_COMP_ID_USER57: EnumEntry(
            "MAV_COMP_ID_USER57",
            """Id for a component on privately managed MAVLink network. Can be used for any purpose but may not be published by components outside of the private network.""",
        ),
        MAV_COMP_ID_USER58: EnumEntry(
            "MAV_COMP_ID_USER58",
            """Id for a component on privately managed MAVLink network. Can be used for any purpose but may not be published by components outside of the private network.""",
        ),
        MAV_COMP_ID_USER59: EnumEntry(
            "MAV_COMP_ID_USER59",
            """Id for a component on privately managed MAVLink network. Can be used for any purpose but may not be published by components outside of the private network.""",
        ),
        MAV_COMP_ID_USER60: EnumEntry(
            "MAV_COMP_ID_USER60",
            """Id for a component on privately managed MAVLink network. Can be used for any purpose but may not be published by components outside of the private network.""",
        ),
        MAV_COMP_ID_USER61: EnumEntry(
            "MAV_COMP_ID_USER61",
            """Id for a component on privately managed MAVLink network. Can be used for any purpose but may not be published by components outside of the private network.""",
        ),
        MAV_COMP_ID_USER62: EnumEntry(
            "MAV_COMP_ID_USER62",
            """Id for a component on privately managed MAVLink network. Can be used for any purpose but may not be published by components outside of the private network.""",
        ),
        MAV_COMP_ID_USER63: EnumEntry(
            "MAV_COMP_ID_USER63",
            """Id for a component on privately managed MAVLink network. Can be used for any purpose but may not be published by components outside of the private network.""",
        ),
        MAV_COMP_ID_USER64: EnumEntry(
            "MAV_COMP_ID_USER64",
            """Id for a component on privately managed MAVLink network. Can be used for any purpose but may not be published by components outside of the private network.""",
        ),
        MAV_COMP_ID_USER65: EnumEntry(
            "MAV_COMP_ID_USER65",
            """Id for a component on privately managed MAVLink network. Can be used for any purpose but may not be published by components outside of the private network.""",
        ),
        MAV_COMP_ID_USER66: EnumEntry(
            "MAV_COMP_ID_USER66",
            """Id for a component on privately managed MAVLink network. Can be used for any purpose but may not be published by components outside of the private network.""",
        ),
        MAV_COMP_ID_USER67: EnumEntry(
            "MAV_COMP_ID_USER67",
            """Id for a component on privately managed MAVLink network. Can be used for any purpose but may not be published by components outside of the private network.""",
        ),
        MAV_COMP_ID_USER68: EnumEntry(
            "MAV_COMP_ID_USER68",
            """Id for a component on privately managed MAVLink network. Can be used for any purpose but may not be published by components outside of the private network.""",
        ),
        MAV_COMP_ID_USER69: EnumEntry(
            "MAV_COMP_ID_USER69",
            """Id for a component on privately managed MAVLink network. Can be used for any purpose but may not be published by components outside of the private network.""",
        ),
        MAV_COMP_ID_USER70: EnumEntry(
            "MAV_COMP_ID_USER70",
            """Id for a component on privately managed MAVLink network. Can be used for any purpose but may not be published by components outside of the private network.""",
        ),
        MAV_COMP_ID_USER71: EnumEntry(
            "MAV_COMP_ID_USER71",
            """Id for a component on privately managed MAVLink network. Can be used for any purpose but may not be published by components outside of the private network.""",
        ),
        MAV_COMP_ID_USER72: EnumEntry(
            "MAV_COMP_ID_USER72",
            """Id for a component on privately managed MAVLink network. Can be used for any purpose but may not be published by components outside of the private network.""",
        ),
        MAV_COMP_ID_USER73: EnumEntry(
            "MAV_COMP_ID_USER73",
            """Id for a component on privately managed MAVLink network. Can be used for any purpose but may not be published by components outside of the private network.""",
        ),
        MAV_COMP_ID_USER74: EnumEntry(
            "MAV_COMP_ID_USER74",
            """Id for a component on privately managed MAVLink network. Can be used for any purpose but may not be published by components outside of the private network.""",
        ),
        MAV_COMP_ID_USER75: EnumEntry(
            "MAV_COMP_ID_USER75",
            """Id for a component on privately managed MAVLink network. Can be used for any purpose but may not be published by components outside of the private network.""",
        ),
        MAV_COMP_ID_CAMERA: EnumEntry(
            "MAV_COMP_ID_CAMERA",
            """Camera #1.""",
        ),
        MAV_COMP_ID_CAMERA2: EnumEntry(
            "MAV_COMP_ID_CAMERA2",
            """Camera #2.""",
        ),
        MAV_COMP_ID_CAMERA3: EnumEntry(
            "MAV_COMP_ID_CAMERA3",
            """Camera #3.""",
        ),
        MAV_COMP_ID_CAMERA4: EnumEntry(
            "MAV_COMP_ID_CAMERA4",
            """Camera #4.""",
        ),
        MAV_COMP_ID_CAMERA5: EnumEntry(
            "MAV_COMP_ID_CAMERA5",
            """Camera #5.""",
        ),
        MAV_COMP_ID_CAMERA6: EnumEntry(
            "MAV_COMP_ID_CAMERA6",
            """Camera #6.""",
        ),
        MAV_COMP_ID_SERVO1: EnumEntry(
            "MAV_COMP_ID_SERVO1",
            """Servo #1.""",
        ),
        MAV_COMP_ID_SERVO2: EnumEntry(
            "MAV_COMP_ID_SERVO2",
            """Servo #2.""",
        ),
        MAV_COMP_ID_SERVO3: EnumEntry(
            "MAV_COMP_ID_SERVO3",
            """Servo #3.""",
        ),
        MAV_COMP_ID_SERVO4: EnumEntry(
            "MAV_COMP_ID_SERVO4",
            """Servo #4.""",
        ),
        MAV_COMP_ID_SERVO5: EnumEntry(
            "MAV_COMP_ID_SERVO5",
            """Servo #5.""",
        ),
        MAV_COMP_ID_SERVO6: EnumEntry(
            "MAV_COMP_ID_SERVO6",
            """Servo #6.""",
        ),
        MAV_COMP_ID_SERVO7: EnumEntry(
            "MAV_COMP_ID_SERVO7",
            """Servo #7.""",
        ),
        MAV_COMP_ID_SERVO8: EnumEntry(
            "MAV_COMP_ID_SERVO8",
            """Servo #8.""",
        ),
        MAV_COMP_ID_SERVO9: EnumEntry(
            "MAV_COMP_ID_SERVO9",
            """Servo #9.""",
        ),
        MAV_COMP_ID_SERVO10: EnumEntry(
            "MAV_COMP_ID_SERVO10",
            """Servo #10.""",
        ),
        MAV_COMP_ID_SERVO11: EnumEntry(
            "MAV_COMP_ID_SERVO11",
            """Servo #11.""",
        ),
        MAV_COMP_ID_SERVO12: EnumEntry(
            "MAV_COMP_ID_SERVO12",
            """Servo #12.""",
        ),
        MAV_COMP_ID_SERVO13: EnumEntry(
            "MAV_COMP_ID_SERVO13",
            """Servo #13.""",
        ),
        MAV_COMP_ID_SERVO14: EnumEntry(
            "MAV_COMP_ID_SERVO14",
            """Servo #14.""",
        ),
        MAV_COMP_ID_GIMBAL: EnumEntry(
            "MAV_COMP_ID_GIMBAL",
            """Gimbal #1.""",
        ),
        MAV_COMP_ID_LOG: EnumEntry(
            "MAV_COMP_ID_LOG",
            """Logging component.""",
        ),
        MAV_COMP_ID_ADSB: EnumEntry(
            "MAV_COMP_ID_ADSB",
            """Automatic Dependent Surveillance-Broadcast (ADS-B) component.""",
        ),
        MAV_COMP_ID_OSD: EnumEntry(
            "MAV_COMP_ID_OSD",
            """On Screen Display (OSD) devices for video links.""",
        ),
        MAV_COMP_ID_PERIPHERAL: EnumEntry(
            "MAV_COMP_ID_PERIPHERAL",
            """Generic autopilot peripheral component ID. Meant for devices that do not implement the parameter microservice.""",
        ),
        MAV_COMP_ID_QX1_GIMBAL: EnumEntry(
            "MAV_COMP_ID_QX1_GIMBAL",
            """Gimbal ID for QX1.""",
        ),
        MAV_COMP_ID_FLARM: EnumEntry(
            "MAV_COMP_ID_FLARM",
            """FLARM collision alert component.""",
        ),
        MAV_COMP_ID_PARACHUTE: EnumEntry(
            "MAV_COMP_ID_PARACHUTE",
            """Parachute component.""",
        ),
        MAV_COMP_ID_GIMBAL2: EnumEntry(
            "MAV_COMP_ID_GIMBAL2",
            """Gimbal #2.""",
        ),
        MAV_COMP_ID_GIMBAL3: EnumEntry(
            "MAV_COMP_ID_GIMBAL3",
            """Gimbal #3.""",
        ),
        MAV_COMP_ID_GIMBAL4: EnumEntry(
            "MAV_COMP_ID_GIMBAL4",
            """Gimbal #4""",
        ),
        MAV_COMP_ID_GIMBAL5: EnumEntry(
            "MAV_COMP_ID_GIMBAL5",
            """Gimbal #5.""",
        ),
        MAV_COMP_ID_GIMBAL6: EnumEntry(
            "MAV_COMP_ID_GIMBAL6",
            """Gimbal #6.""",
        ),
        MAV_COMP_ID_BATTERY: EnumEntry(
            "MAV_COMP_ID_BATTERY",
            """Battery #1.""",
        ),
        MAV_COMP_ID_BATTERY2: EnumEntry(
            "MAV_COMP_ID_BATTERY2",
            """Battery #2.""",
        ),
        MAV_COMP_ID_MAVCAN: EnumEntry(
            "MAV_COMP_ID_MAVCAN",
            """CAN over MAVLink client.""",
        ),
        MAV_COMP_ID_MISSIONPLANNER: EnumEntry(
            "MAV_COMP_ID_MISSIONPLANNER",
            """Component that can generate/supply a mission flight plan (e.g. GCS or developer API).""",
        ),
        MAV_COMP_ID_ONBOARD_COMPUTER: EnumEntry(
            "MAV_COMP_ID_ONBOARD_COMPUTER",
            """Component that lives on the onboard computer (companion computer) and has some generic functionalities, such as settings system parameters and monitoring the status of some processes that don't directly speak mavlink and so on.""",
        ),
        MAV_COMP_ID_ONBOARD_COMPUTER2: EnumEntry(
            "MAV_COMP_ID_ONBOARD_COMPUTER2",
            """Component that lives on the onboard computer (companion computer) and has some generic functionalities, such as settings system parameters and monitoring the status of some processes that don't directly speak mavlink and so on.""",
        ),
        MAV_COMP_ID_ONBOARD_COMPUTER3: EnumEntry(
            "MAV_COMP_ID_ONBOARD_COMPUTER3",
            """Component that lives on the onboard computer (companion computer) and has some generic functionalities, such as settings system parameters and monitoring the status of some processes that don't directly speak mavlink and so on.""",
        ),
        MAV_COMP_ID_ONBOARD_COMPUTER4: EnumEntry(
            "MAV_COMP_ID_ONBOARD_COMPUTER4",
            """Component that lives on the onboard computer (companion computer) and has some generic functionalities, such as settings system parameters and monitoring the status of some processes that don't directly speak mavlink and so on.""",
        ),
        MAV_COMP_ID_PATHPLANNER: EnumEntry(
            "MAV_COMP_ID_PATHPLANNER",
            """Component that finds an optimal path between points based on a certain constraint (e.g. minimum snap, shortest path, cost, etc.).""",
        ),
        MAV_COMP_ID_OBSTACLE_AVOIDANCE: EnumEntry(
            "MAV_COMP_ID_OBSTACLE_AVOIDANCE",
            """Component that plans a collision free path between two points.""",
        ),
        MAV_COMP_ID_VISUAL_INERTIAL_ODOMETRY: EnumEntry(
            "MAV_COMP_ID_VISUAL_INERTIAL_ODOMETRY",
            """Component that provides position estimates using VIO techniques.""",
        ),
        MAV_COMP_ID_PAIRING_MANAGER: EnumEntry(
            "MAV_COMP_ID_PAIRING_MANAGER",
            """Component that manages pairing of vehicle and GCS.""",
        ),
        MAV_COMP_ID_IMU: EnumEntry(
            "MAV_COMP_ID_IMU",
            """Inertial Measurement Unit (IMU) #1.""",
        ),
        MAV_COMP_ID_IMU_2: EnumEntry(
            "MAV_COMP_ID_IMU_2",
            """Inertial Measurement Unit (IMU) #2.""",
        ),
        MAV_COMP_ID_IMU_3: EnumEntry(
            "MAV_COMP_ID_IMU_3",
            """Inertial Measurement Unit (IMU) #3.""",
        ),
        MAV_COMP_ID_GPS: EnumEntry(
            "MAV_COMP_ID_GPS",
            """GPS #1.""",
        ),
        MAV_COMP_ID_GPS2: EnumEntry(
            "MAV_COMP_ID_GPS2",
            """GPS #2.""",
        ),
        MAV_COMP_ID_ODID_TXRX_1: EnumEntry(
            "MAV_COMP_ID_ODID_TXRX_1",
            """Open Drone ID transmitter/receiver (Bluetooth/WiFi/Internet).""",
        ),
        MAV_COMP_ID_ODID_TXRX_2: EnumEntry(
            "MAV_COMP_ID_ODID_TXRX_2",
            """Open Drone ID transmitter/receiver (Bluetooth/WiFi/Internet).""",
        ),
        MAV_COMP_ID_ODID_TXRX_3: EnumEntry(
            "MAV_COMP_ID_ODID_TXRX_3",
            """Open Drone ID transmitter/receiver (Bluetooth/WiFi/Internet).""",
        ),
        MAV_COMP_ID_UDP_BRIDGE: EnumEntry(
            "MAV_COMP_ID_UDP_BRIDGE",
            """Component to bridge MAVLink to UDP (i.e. from a UART).""",
        ),
        MAV_COMP_ID_UART_BRIDGE: EnumEntry(
            "MAV_COMP_ID_UART_BRIDGE",
            """Component to bridge to UART (i.e. from UDP).""",
        ),
        MAV_COMP_ID_TUNNEL_NODE: EnumEntry(
            "MAV_COMP_ID_TUNNEL_NODE",
            """Component handling TUNNEL messages (e.g. vendor specific GUI of a component).""",
        ),
        MAV_COMP_ID_SYSTEM_CONTROL: EnumEntry(
            "MAV_COMP_ID_SYSTEM_CONTROL",
            """Component for handling system messages (e.g. to ARM, takeoff, etc.).""",
        ),
        MAV_COMPONENT_ENUM_END: EnumEntry(
            "MAV_COMPONENT_ENUM_END",
            """""",
        ),
    },
}

# message IDs
MAVLINK_MSG_ID_BAD_DATA = -1
MAVLINK_MSG_ID_UNKNOWN = -2
MAVLINK_MSG_ID_HEARTBEAT = 0
MAVLINK_MSG_ID_PROTOCOL_VERSION = 300


class MAVLink_heartbeat_message(MAVLink_message):
    """
    The heartbeat message shows that a system or component is present
    and responding. The type and autopilot fields (along with the
    message component id), allow the receiving system to treat further
    messages from this system appropriately (e.g. by laying out the
    user interface based on the autopilot). This microservice is
    documented at https://mavlink.io/en/services/heartbeat.html
    """

    id = MAVLINK_MSG_ID_HEARTBEAT
    msgname = "HEARTBEAT"
    fieldnames = ["type", "autopilot", "base_mode", "custom_mode", "system_status", "mavlink_version"]
    ordered_fieldnames = ["custom_mode", "type", "autopilot", "base_mode", "system_status", "mavlink_version"]
    fieldtypes = ["uint8_t", "uint8_t", "uint8_t", "uint32_t", "uint8_t", "uint8_t"]
    fielddisplays_by_name = {"base_mode": "bitmask"}
    fieldenums_by_name = {"type": "MAV_TYPE", "autopilot": "MAV_AUTOPILOT", "base_mode": "MAV_MODE_FLAG", "system_status": "MAV_STATE"}
    fieldunits_by_name = {}
    native_format = bytearray(b"<IBBBBB")
    orders = [1, 2, 3, 0, 4, 5]
    lengths = [1, 1, 1, 1, 1, 1]
    array_lengths = [0, 0, 0, 0, 0, 0]
    crc_extra = 50
    unpacker = struct.Struct("<IBBBBB")
    instance_field = None
    instance_offset = -1

    def __init__(self, type, autopilot, base_mode, custom_mode, system_status, mavlink_version):
        MAVLink_message.__init__(self, MAVLink_heartbeat_message.id, MAVLink_heartbeat_message.msgname)
        self._fieldnames = MAVLink_heartbeat_message.fieldnames
        self._instance_field = MAVLink_heartbeat_message.instance_field
        self._instance_offset = MAVLink_heartbeat_message.instance_offset
        self.type = type
        self.autopilot = autopilot
        self.base_mode = base_mode
        self.custom_mode = custom_mode
        self.system_status = system_status
        self.mavlink_version = mavlink_version

    def pack(self, mav, force_mavlink1=False):
        return self._pack(mav, self.crc_extra, self.unpacker.pack(self.custom_mode, self.type, self.autopilot, self.base_mode, self.system_status, self.mavlink_version), force_mavlink1=force_mavlink1)


class MAVLink_protocol_version_message(MAVLink_message):
    """
    Version and capability of protocol version. This message can be
    requested with MAV_CMD_REQUEST_MESSAGE and is used as part of the
    handshaking to establish which MAVLink version should be used on
    the network. Every node should respond to a request for
    PROTOCOL_VERSION to enable the handshaking. Library implementers
    should consider adding this into the default decoding state
    machine to allow the protocol core to respond directly.
    """

    id = MAVLINK_MSG_ID_PROTOCOL_VERSION
    msgname = "PROTOCOL_VERSION"
    fieldnames = ["version", "min_version", "max_version", "spec_version_hash", "library_version_hash"]
    ordered_fieldnames = ["version", "min_version", "max_version", "spec_version_hash", "library_version_hash"]
    fieldtypes = ["uint16_t", "uint16_t", "uint16_t", "uint8_t", "uint8_t"]
    fielddisplays_by_name = {}
    fieldenums_by_name = {}
    fieldunits_by_name = {}
    native_format = bytearray(b"<HHHBB")
    orders = [0, 1, 2, 3, 4]
    lengths = [1, 1, 1, 8, 8]
    array_lengths = [0, 0, 0, 8, 8]
    crc_extra = 217
    unpacker = struct.Struct("<HHH8B8B")
    instance_field = None
    instance_offset = -1

    def __init__(self, version, min_version, max_version, spec_version_hash, library_version_hash):
        MAVLink_message.__init__(self, MAVLink_protocol_version_message.id, MAVLink_protocol_version_message.msgname)
        self._fieldnames = MAVLink_protocol_version_message.fieldnames
        self._instance_field = MAVLink_protocol_version_message.instance_field
        self._instance_offset = MAVLink_protocol_version_message.instance_offset
        self.version = version
        self.min_version = min_version
        self.max_version = max_version
        self.spec_version_hash = spec_version_hash
        self.library_version_hash = library_version_hash

    def pack(self, mav, force_mavlink1=False):
        return self._pack(mav, self.crc_extra, self.unpacker.pack(self.version, self.min_version, self.max_version, self.spec_version_hash[0], self.spec_version_hash[1], self.spec_version_hash[2], self.spec_version_hash[3], self.spec_version_hash[4], self.spec_version_hash[5], self.spec_version_hash[6], self.spec_version_hash[7], self.library_version_hash[0], self.library_version_hash[1], self.library_version_hash[2], self.library_version_hash[3], self.library_version_hash[4], self.library_version_hash[5], self.library_version_hash[6], self.library_version_hash[7]), force_mavlink1=force_mavlink1)


mavlink_map = {
    MAVLINK_MSG_ID_HEARTBEAT: MAVLink_heartbeat_message,
    MAVLINK_MSG_ID_PROTOCOL_VERSION: MAVLink_protocol_version_message,
}


class MAVError(Exception):
    """MAVLink error class"""

    def __init__(self, msg):
        Exception.__init__(self, msg)
        self.message = msg


class MAVLink_bad_data(MAVLink_message):
    """
    a piece of bad data in a mavlink stream
    """

    def __init__(self, data, reason):
        MAVLink_message.__init__(self, MAVLINK_MSG_ID_BAD_DATA, "BAD_DATA")
        self._fieldnames = ["data", "reason"]
        self.data = data
        self.reason = reason
        self._msgbuf = bytearray(data)
        self._instance_field = None

    def __str__(self):
        """Override the __str__ function from MAVLink_messages because non-printable characters are common in to be the reason for this message to exist."""
        if sys.version_info[0] == 2:
            hexstr = ["{:x}".format(ord(i)) for i in self.data]
        else:
            hexstr = ["{:x}".format(i) for i in self.data]
        return "%s {%s, data:%s}" % (self._type, self.reason, hexstr)


class MAVLink_unknown(MAVLink_message):
    """
    a message that we don't have in the XML used when built
    """

    def __init__(self, msgid, data):
        MAVLink_message.__init__(self, MAVLINK_MSG_ID_UNKNOWN, "UNKNOWN_%u" % msgid)
        self._fieldnames = ["data"]
        self.data = data
        self._msgbuf = bytearray(data)
        self._instance_field = None

    def __str__(self):
        """Override the __str__ function from MAVLink_messages because non-printable characters are common."""
        if sys.version_info[0] == 2:
            hexstr = ["{:x}".format(ord(i)) for i in self.data]
        else:
            hexstr = ["{:x}".format(i) for i in self.data]
        return "%s {data:%s}" % (self._type, hexstr)


class MAVLinkSigning(object):
    """MAVLink signing state class"""

    def __init__(self):
        self.secret_key = None
        self.timestamp = 0
        self.link_id = 0
        self.sign_outgoing = False
        self.allow_unsigned_callback = None
        self.stream_timestamps = {}
        self.sig_count = 0
        self.badsig_count = 0
        self.goodsig_count = 0
        self.unsigned_count = 0
        self.reject_count = 0


class MAVLink(object):
    """MAVLink protocol handling class"""

    def __init__(self, file, srcSystem=0, srcComponent=0, use_native=False):
        self.seq = 0
        self.file = file
        self.srcSystem = srcSystem
        self.srcComponent = srcComponent
        self.callback = None
        self.callback_args = None
        self.callback_kwargs = None
        self.send_callback = None
        self.send_callback_args = None
        self.send_callback_kwargs = None
        self.buf = bytearray()
        self.buf_index = 0
        self.expected_length = HEADER_LEN_V1 + 2
        self.have_prefix_error = False
        self.robust_parsing = False
        self.protocol_marker = 253
        self.little_endian = True
        self.crc_extra = True
        self.sort_fields = True
        self.total_packets_sent = 0
        self.total_bytes_sent = 0
        self.total_packets_received = 0
        self.total_bytes_received = 0
        self.total_receive_errors = 0
        self.startup_time = time.time()
        self.signing = MAVLinkSigning()
        if native_supported and (use_native or native_testing or native_force):
            logger.warning("NOTE: mavnative is currently beta-test code")
            self.native = mavnative.NativeConnection(MAVLink_message, mavlink_map)
        else:
            self.native = None
        if native_testing:
            self.test_buf = bytearray()
        self.mav20_unpacker = struct.Struct("<cBBBBBBHB")
        self.mav10_unpacker = struct.Struct("<cBBBBB")
        self.mav20_h3_unpacker = struct.Struct("BBB")
        self.mav_csum_unpacker = struct.Struct("<H")
        self.mav_sign_unpacker = struct.Struct("<IH")

    def set_callback(self, callback, *args, **kwargs):
        self.callback = callback
        self.callback_args = args
        self.callback_kwargs = kwargs

    def set_send_callback(self, callback, *args, **kwargs):
        self.send_callback = callback
        self.send_callback_args = args
        self.send_callback_kwargs = kwargs

    def send(self, mavmsg, force_mavlink1=False):
        """send a MAVLink message"""
        buf = mavmsg.pack(self, force_mavlink1=force_mavlink1)
        self.file.write(buf)
        self.seq = (self.seq + 1) % 256
        self.total_packets_sent += 1
        self.total_bytes_sent += len(buf)
        if self.send_callback is not None and self.send_callback_args is not None and self.send_callback_kwargs is not None:
            self.send_callback(mavmsg, *self.send_callback_args, **self.send_callback_kwargs)

    def buf_len(self):
        return len(self.buf) - self.buf_index

    def bytes_needed(self):
        """return number of bytes needed for next parsing stage"""
        if self.native is not None:
            ret = cast("int", self.native.expected_length) - self.buf_len()
        else:
            ret = self.expected_length - self.buf_len()

        if ret <= 0:
            return 1
        return ret

    def __parse_char_native(self, c):
        """this method exists only to see in profiling results"""
        m = cast("Optional[MAVLink_message]", self.native.parse_chars(c))
        return m

    def __callbacks(self, msg):
        """this method exists only to make profiling results easier to read"""
        if self.callback is not None and self.callback_args is not None and self.callback_kwargs is not None:
            self.callback(msg, *self.callback_args, **self.callback_kwargs)

    def parse_char(self, c):
        """input some data bytes, possibly returning a new message"""
        self.buf.extend(c)

        self.total_bytes_received += len(c)

        if self.native is not None:
            if native_testing:
                self.test_buf.extend(c)
                m = self.__parse_char_native(self.test_buf)
                m2 = self.__parse_char_legacy()
                if m2 != m:
                    logger.error("Native: %s\nLegacy: %s\n", m, m2)
                    raise Exception("Native vs. Legacy mismatch")
            else:
                m = self.__parse_char_native(self.buf)
        else:
            m = self.__parse_char_legacy()

        if m is not None:
            self.total_packets_received += 1
            self.__callbacks(m)
        else:
            # XXX The idea here is if we've read something and there's nothing left in
            # the buffer, reset it to 0 which frees the memory
            if self.buf_len() == 0 and self.buf_index != 0:
                self.buf = bytearray()
                self.buf_index = 0

        return m

    def __parse_char_legacy(self):
        """input some data bytes, possibly returning a new message (uses no native code)"""
        header_len = HEADER_LEN_V1
        if self.buf_len() >= 1 and self.buf[self.buf_index] == PROTOCOL_MARKER_V2:
            header_len = HEADER_LEN_V2

        m = None
        if self.buf_len() >= 1 and self.buf[self.buf_index] != PROTOCOL_MARKER_V1 and self.buf[self.buf_index] != PROTOCOL_MARKER_V2:
            magic = self.buf[self.buf_index]
            self.buf_index += 1
            if self.robust_parsing:
                m = MAVLink_bad_data(bytearray([magic]), "Bad prefix")
                self.expected_length = header_len + 2
                self.total_receive_errors += 1
                return m
            if self.have_prefix_error:
                return None
            self.have_prefix_error = True
            self.total_receive_errors += 1
            raise MAVError("invalid MAVLink prefix '%s'" % magic)
        self.have_prefix_error = False
        if self.buf_len() >= 3:
            sbuf = self.buf[self.buf_index : 3 + self.buf_index]
            (magic, self.expected_length, incompat_flags) = cast(
                "Tuple[int, int, int]",
                self.mav20_h3_unpacker.unpack(sbuf),
            )
            if magic == PROTOCOL_MARKER_V2 and (incompat_flags & MAVLINK_IFLAG_SIGNED):
                self.expected_length += MAVLINK_SIGNATURE_BLOCK_LEN
            self.expected_length += header_len + 2
        if self.expected_length >= (header_len + 2) and self.buf_len() >= self.expected_length:
            mbuf = self.buf[self.buf_index : self.buf_index + self.expected_length]
            self.buf_index += self.expected_length
            self.expected_length = header_len + 2
            if self.robust_parsing:
                try:
                    if magic == PROTOCOL_MARKER_V2 and (incompat_flags & ~MAVLINK_IFLAG_SIGNED) != 0:
                        raise MAVError("invalid incompat_flags 0x%x 0x%x %u" % (incompat_flags, magic, self.expected_length))
                    m = self.decode(mbuf)
                except MAVError as reason:
                    m = MAVLink_bad_data(mbuf, reason.message)
                    self.total_receive_errors += 1
            else:
                if magic == PROTOCOL_MARKER_V2 and (incompat_flags & ~MAVLINK_IFLAG_SIGNED) != 0:
                    raise MAVError("invalid incompat_flags 0x%x 0x%x %u" % (incompat_flags, magic, self.expected_length))
                m = self.decode(mbuf)
            return m
        return None

    def parse_buffer(self, s):
        """input some data bytes, possibly returning a list of new messages"""
        m = self.parse_char(s)
        if m is None:
            return None
        ret = [m]
        while True:
            m = self.parse_char(b"")
            if m is None:
                return ret
            ret.append(m)

    def check_signature(self, msgbuf, srcSystem, srcComponent):
        """check signature on incoming message"""
        assert self.signing.secret_key is not None

        timestamp_buf = msgbuf[-12:-6]
        link_id = msgbuf[-13]
        (tlow, thigh) = cast(
            "Tuple[int, int]",
            self.mav_sign_unpacker.unpack(timestamp_buf),
        )
        timestamp = tlow + (thigh << 32)

        # see if the timestamp is acceptable
        stream_key = (link_id, srcSystem, srcComponent)
        if stream_key in self.signing.stream_timestamps:
            if timestamp <= self.signing.stream_timestamps[stream_key]:
                # reject old timestamp
                logger.info("old timestamp")
                return False
        else:
            # a new stream has appeared. Accept the timestamp if it is at most
            # one minute behind our current timestamp
            if timestamp + 6000 * 1000 < self.signing.timestamp:
                logger.info("bad new stream %s %s", timestamp / (100.0 * 1000 * 60 * 60 * 24 * 365), self.signing.timestamp / (100.0 * 1000 * 60 * 60 * 24 * 365))
                return False
            self.signing.stream_timestamps[stream_key] = timestamp
            logger.info("new stream")

        h = hashlib.new("sha256")
        h.update(self.signing.secret_key)
        h.update(msgbuf[:-6])
        sig1 = h.digest()[:6]
        sig2 = msgbuf[-6:]
        if sig1 != sig2:
            logger.info("sig mismatch")
            return False

        # the timestamp we next send with is the max of the received timestamp and
        # our current timestamp
        self.signing.timestamp = max(self.signing.timestamp, timestamp)
        return True

    def decode(self, msgbuf):
        """decode a buffer as a MAVLink message"""
        # decode the header
        if msgbuf[0] != PROTOCOL_MARKER_V1:
            headerlen = 10
            try:
                magic, mlen, incompat_flags, compat_flags, seq, srcSystem, srcComponent, msgIdlow, msgIdhigh = cast(
                    "Tuple[bytes, int, int, int, int, int, int, int, int]",
                    self.mav20_unpacker.unpack(msgbuf[:headerlen]),
                )
            except struct.error as emsg:
                raise MAVError("Unable to unpack MAVLink header: %s" % emsg)
            msgId = msgIdlow | (msgIdhigh << 16)
            mapkey = msgId
        else:
            headerlen = 6
            try:
                magic, mlen, seq, srcSystem, srcComponent, msgId = cast(
                    "Tuple[bytes, int, int, int, int, int]",
                    self.mav10_unpacker.unpack(msgbuf[:headerlen]),
                )
                incompat_flags = 0
                compat_flags = 0
            except struct.error as emsg:
                raise MAVError("Unable to unpack MAVLink header: %s" % emsg)
            mapkey = msgId
        if (incompat_flags & MAVLINK_IFLAG_SIGNED) != 0:
            signature_len = MAVLINK_SIGNATURE_BLOCK_LEN
        else:
            signature_len = 0

        if ord(magic) != PROTOCOL_MARKER_V1 and ord(magic) != PROTOCOL_MARKER_V2:
            raise MAVError("invalid MAVLink prefix '{}'".format(hex(ord(magic))))
        if mlen != len(msgbuf) - (headerlen + 2 + signature_len):
            raise MAVError("invalid MAVLink message length. Got %u expected %u, msgId=%u headerlen=%u" % (len(msgbuf) - (headerlen + 2 + signature_len), mlen, msgId, headerlen))

        if mapkey not in mavlink_map:
            return MAVLink_unknown(msgId, msgbuf)

        # decode the payload
        msgtype = mavlink_map[mapkey]
        order_map = msgtype.orders
        len_map = msgtype.lengths
        crc_extra = msgtype.crc_extra

        # decode the checksum
        try:
            (crc,) = cast(
                "Tuple[int]",
                self.mav_csum_unpacker.unpack(msgbuf[-(2 + signature_len) :][:2]),
            )
        except struct.error as emsg:
            raise MAVError("Unable to unpack MAVLink CRC: %s" % emsg)
        crcbuf = msgbuf[1 : -(2 + signature_len)]
        if True:
            # using CRC extra
            crcbuf.append(crc_extra)
        crc2 = x25crc(crcbuf)
        if crc != crc2.crc and not MAVLINK_IGNORE_CRC:
            raise MAVError("invalid MAVLink CRC in msgID %u 0x%04x should be 0x%04x" % (msgId, crc, crc2.crc))

        sig_ok = False
        if signature_len == MAVLINK_SIGNATURE_BLOCK_LEN:
            self.signing.sig_count += 1
        if self.signing.secret_key is not None:
            accept_signature = False
            if signature_len == MAVLINK_SIGNATURE_BLOCK_LEN:
                sig_ok = self.check_signature(msgbuf, srcSystem, srcComponent)
                accept_signature = sig_ok
                if sig_ok:
                    self.signing.goodsig_count += 1
                else:
                    self.signing.badsig_count += 1
                if not accept_signature and self.signing.allow_unsigned_callback is not None:
                    accept_signature = self.signing.allow_unsigned_callback(self, msgId)
                    if accept_signature:
                        self.signing.unsigned_count += 1
                    else:
                        self.signing.reject_count += 1
            elif self.signing.allow_unsigned_callback is not None:
                accept_signature = self.signing.allow_unsigned_callback(self, msgId)
                if accept_signature:
                    self.signing.unsigned_count += 1
                else:
                    self.signing.reject_count += 1
            if not accept_signature:
                raise MAVError("Invalid signature")

        csize = msgtype.unpacker.size
        mbuf = msgbuf[headerlen : -(2 + signature_len)]
        if len(mbuf) < csize:
            # zero pad to give right size
            mbuf.extend([0] * (csize - len(mbuf)))
        if len(mbuf) < csize:
            raise MAVError("Bad message of type %s length %u needs %s" % (msgtype, len(mbuf), csize))
        mbuf = mbuf[:csize]
        try:
            t = cast(
                "Tuple[Union[bytes, int, float], ...]",
                msgtype.unpacker.unpack(mbuf),
            )
        except struct.error as emsg:
            raise MAVError("Unable to unpack MAVLink payload type=%s payloadLength=%u: %s" % (msgtype, len(mbuf), emsg))

        tlist = list(t)
        # handle sorted fields
        if True:
            if sum(len_map) == len(len_map):
                # message has no arrays in it
                for i in range(0, len(tlist)):
                    tlist[i] = t[order_map[i]]
            else:
                # message has some arrays
                tlist = []
                for i in range(0, len(order_map)):
                    order = order_map[i]
                    L = len_map[order]
                    tip = sum(len_map[:order])
                    field = t[tip]
                    if L == 1 or isinstance(field, bytes):
                        tlist.append(field)
                    else:
                        tlist.append(cast("Union[Sequence[int], Sequence[float]]", list(t[tip : (tip + L)])))

        # terminate any strings
        for i, elem in enumerate(tlist):
            if isinstance(elem, bytes):
                tlist[i] = elem.rstrip(b"\x00")

        # construct the message object
        try:
            # Note that initializers don't follow the Liskov Substitution Principle
            # therefore it can't be typechecked
            m = msgtype(*tlist)  # type: ignore
        except Exception as emsg:
            raise MAVError("Unable to instantiate MAVLink message of type %s : %s" % (msgtype, emsg))
        m._signed = sig_ok
        if m._signed:
            m._link_id = msgbuf[-13]
        m._msgbuf = msgbuf
        m._payload = msgbuf[6 : -(2 + signature_len)]
        m._crc = crc
        m._header = MAVLink_header(msgId, incompat_flags, compat_flags, mlen, seq, srcSystem, srcComponent)
        return m

    def heartbeat_encode(self, type, autopilot, base_mode, custom_mode, system_status, mavlink_version=3):
        """
        The heartbeat message shows that a system or component is present and
        responding. The type and autopilot fields (along with the
        message component id), allow the receiving system to treat
        further messages from this system appropriately (e.g. by
        laying out the user interface based on the autopilot). This
        microservice is documented at
        https://mavlink.io/en/services/heartbeat.html

        type                      : Vehicle or component type. For a flight controller component the vehicle type (quadrotor, helicopter, etc.). For other components the component type (e.g. camera, gimbal, etc.). This should be used in preference to component id for identifying the component type. (type:uint8_t, values:MAV_TYPE)
        autopilot                 : Autopilot type / class. Use MAV_AUTOPILOT_INVALID for components that are not flight controllers. (type:uint8_t, values:MAV_AUTOPILOT)
        base_mode                 : System mode bitmap. (type:uint8_t, values:MAV_MODE_FLAG)
        custom_mode               : A bitfield for use for autopilot-specific flags (type:uint32_t)
        system_status             : System status flag. (type:uint8_t, values:MAV_STATE)
        mavlink_version           : MAVLink version, not writable by user, gets added by protocol because of magic data type: uint8_t_mavlink_version (type:uint8_t)

        """
        return MAVLink_heartbeat_message(type, autopilot, base_mode, custom_mode, system_status, mavlink_version)

    def heartbeat_send(self, type, autopilot, base_mode, custom_mode, system_status, mavlink_version=3, force_mavlink1=False):
        """
        The heartbeat message shows that a system or component is present and
        responding. The type and autopilot fields (along with the
        message component id), allow the receiving system to treat
        further messages from this system appropriately (e.g. by
        laying out the user interface based on the autopilot). This
        microservice is documented at
        https://mavlink.io/en/services/heartbeat.html

        type                      : Vehicle or component type. For a flight controller component the vehicle type (quadrotor, helicopter, etc.). For other components the component type (e.g. camera, gimbal, etc.). This should be used in preference to component id for identifying the component type. (type:uint8_t, values:MAV_TYPE)
        autopilot                 : Autopilot type / class. Use MAV_AUTOPILOT_INVALID for components that are not flight controllers. (type:uint8_t, values:MAV_AUTOPILOT)
        base_mode                 : System mode bitmap. (type:uint8_t, values:MAV_MODE_FLAG)
        custom_mode               : A bitfield for use for autopilot-specific flags (type:uint32_t)
        system_status             : System status flag. (type:uint8_t, values:MAV_STATE)
        mavlink_version           : MAVLink version, not writable by user, gets added by protocol because of magic data type: uint8_t_mavlink_version (type:uint8_t)

        """
        self.send(self.heartbeat_encode(type, autopilot, base_mode, custom_mode, system_status, mavlink_version), force_mavlink1=force_mavlink1)

    def protocol_version_encode(self, version, min_version, max_version, spec_version_hash, library_version_hash):
        """
        Version and capability of protocol version. This message can be
        requested with MAV_CMD_REQUEST_MESSAGE and is used as part of
        the handshaking to establish which MAVLink version should be
        used on the network. Every node should respond to a request
        for PROTOCOL_VERSION to enable the handshaking. Library
        implementers should consider adding this into the default
        decoding state machine to allow the protocol core to respond
        directly.

        version                   : Currently active MAVLink version number * 100: v1.0 is 100, v2.0 is 200, etc. (type:uint16_t)
        min_version               : Minimum MAVLink version supported (type:uint16_t)
        max_version               : Maximum MAVLink version supported (set to the same value as version by default) (type:uint16_t)
        spec_version_hash         : The first 8 bytes (not characters printed in hex!) of the git hash. (type:uint8_t)
        library_version_hash        : The first 8 bytes (not characters printed in hex!) of the git hash. (type:uint8_t)

        """
        return MAVLink_protocol_version_message(version, min_version, max_version, spec_version_hash, library_version_hash)

    def protocol_version_send(self, version, min_version, max_version, spec_version_hash, library_version_hash, force_mavlink1=False):
        """
        Version and capability of protocol version. This message can be
        requested with MAV_CMD_REQUEST_MESSAGE and is used as part of
        the handshaking to establish which MAVLink version should be
        used on the network. Every node should respond to a request
        for PROTOCOL_VERSION to enable the handshaking. Library
        implementers should consider adding this into the default
        decoding state machine to allow the protocol core to respond
        directly.

        version                   : Currently active MAVLink version number * 100: v1.0 is 100, v2.0 is 200, etc. (type:uint16_t)
        min_version               : Minimum MAVLink version supported (type:uint16_t)
        max_version               : Maximum MAVLink version supported (set to the same value as version by default) (type:uint16_t)
        spec_version_hash         : The first 8 bytes (not characters printed in hex!) of the git hash. (type:uint8_t)
        library_version_hash        : The first 8 bytes (not characters printed in hex!) of the git hash. (type:uint8_t)

        """
        self.send(self.protocol_version_encode(version, min_version, max_version, spec_version_hash, library_version_hash), force_mavlink1=force_mavlink1)
