from paradoxdjango.forms.widgets import NumberInput
from paradoxdjango.test import override_settings

from .base import WidgetTest


class NumberInputTests(WidgetTest):
    @override_settings(USE_THOUSAND_SEPARATOR=True)
    def test_attrs_not_localized(self):
        widget = NumberInput(attrs={"max": 12345, "min": 1234, "step": 9999})
        self.check_html(
            widget,
            "name",
            "value",
            '<input type="number" name="name" value="value" max="12345" min="1234" '
            'step="9999">',
        )
