import gemmi
from rdkit import Chem

import pdbinf

ala_ala = """\
REMARK   1 PDBFIXER FROM: NTerminal_ALA_ALA.pdb
REMARK   1 CREATED WITH OPENMM 7.7, 2023-01-03
CRYST1   48.000   48.000   48.000  90.00  90.00  90.00 P 1           1 
ATOM      1  N   ALA     1      27.352  25.519  24.270  1.00  0.00           N  
ATOM      2  H   ALA     1      27.682  24.857  23.580  1.00  0.00           H  
ATOM      3  H2  ALA     1      26.346  25.594  24.227  1.00  0.00           H  
ATOM      4  H3  ALA     1      27.635  25.175  25.179  1.00  0.00           H  
ATOM      5  CA  ALA     1      27.988  26.835  24.037  1.00  0.00           C  
ATOM      6  HA  ALA     1      27.733  27.179  23.034  1.00  0.00           H  
ATOM      7  CB  ALA     1      27.480  27.872  25.050  1.00  0.00           C  
ATOM      8  HB1 ALA     1      27.750  27.571  26.064  1.00  0.00           H  
ATOM      9  HB2 ALA     1      27.924  28.846  24.840  1.00  0.00           H  
ATOM     10  HB3 ALA     1      26.396  27.963  24.978  1.00  0.00           H  
ATOM     11  C   ALA     1      29.507  26.678  24.103  1.00  0.00           C  
ATOM     12  O   ALA     1      29.961  25.613  24.504  1.00  0.00           O  
ATOM     13  N   ALA     2      30.269  27.698  23.708  1.00  0.00           N  
ATOM     14  H   ALA     2      29.842  28.573  23.431  1.00  0.00           H  
ATOM     15  CA  ALA     2      31.734  27.734  23.756  1.00  0.00           C  
ATOM     16  HA  ALA     2      32.086  27.184  24.631  1.00  0.00           H  
ATOM     17  CB  ALA     2      32.290  27.061  22.492  1.00  0.00           C  
ATOM     18  HB1 ALA     2      31.957  27.600  21.603  1.00  0.00           H  
ATOM     19  HB2 ALA     2      33.380  27.063  22.518  1.00  0.00           H  
ATOM     20  HB3 ALA     2      31.947  26.027  22.437  1.00  0.00           H  
ATOM     21  C   ALA     2      32.210  29.196  23.885  1.00  0.00           C  
ATOM     22  O   ALA     2      31.403  30.109  23.706  1.00  0.00           O  
HETATM   23  N   NME     3      33.495  29.410  24.192  1.00  0.00           N  
HETATM   24  H   NME     3      34.098  28.612  24.315  1.00  0.00           H  
HETATM   25  C   NME     3      34.087  30.739  24.339  1.00  0.00           C  
HETATM   26  H1  NME     3      33.505  31.332  25.048  1.00  0.00           H  
HETATM   27  H2  NME     3      35.114  30.659  24.701  1.00  0.00           H  
HETATM   28  H3  NME     3      34.088  31.254  23.376  1.00  0.00           H  
TER      29      NME     3
END
"""

cterm_ala_ala = """\
REMARK   1 PDBFIXER FROM: CTerminal_ALA_ALA.pdb
REMARK   1 CREATED WITH OPENMM 7.7, 2023-02-01
CRYST1   48.000   48.000   48.000  90.00  90.00  90.00 P 1           1 
HETATM    1  H1  ACE     1      25.966  25.121  24.502  1.00  0.00           H  
HETATM    2  CH3 ACE     1      25.997  26.139  24.116  1.00  0.00           C  
HETATM    3  H2  ACE     1      25.359  26.781  24.719  1.00  0.00           H  
HETATM    4  H3  ACE     1      25.664  26.150  23.080  1.00  0.00           H  
HETATM    5  C   ACE     1      27.419  26.645  24.185  1.00  0.00           C  
HETATM    6  O   ACE     1      28.303  25.921  24.624  1.00  0.00           O  
ATOM      7  N   ALA     2      27.622  27.886  23.752  1.00  0.00           N  
ATOM      8  H   ALA     2      26.829  28.428  23.444  1.00  0.00           H  
ATOM      9  CA  ALA     2      28.899  28.601  23.773  1.00  0.00           C  
ATOM     10  HA  ALA     2      29.453  28.323  24.671  1.00  0.00           H  
ATOM     11  CB  ALA     2      29.721  28.191  22.541  1.00  0.00           C  
ATOM     12  HB1 ALA     2      29.188  28.466  21.630  1.00  0.00           H  
ATOM     13  HB2 ALA     2      30.686  28.700  22.556  1.00  0.00           H  
ATOM     14  HB3 ALA     2      29.893  27.114  22.552  1.00  0.00           H  
ATOM     15  C   ALA     2      28.661  30.124  23.811  1.00  0.00           C  
ATOM     16  O   ALA     2      27.545  30.578  23.537  1.00  0.00           O  
ATOM     17  N   ALA     3      29.708  30.883  24.139  1.00  0.00           N  
ATOM     18  H   ALA     3      30.608  30.446  24.295  1.00  0.00           H  
ATOM     19  CA  ALA     3      29.780  32.346  24.156  1.00  0.00           C  
ATOM     20  HA  ALA     3      29.219  32.755  23.317  1.00  0.00           H  
ATOM     21  CB  ALA     3      29.180  32.867  25.471  1.00  0.00           C  
ATOM     22  HB1 ALA     3      29.746  32.471  26.315  1.00  0.00           H  
ATOM     23  HB2 ALA     3      29.241  33.956  25.483  1.00  0.00           H  
ATOM     24  HB3 ALA     3      28.136  32.565  25.550  1.00  0.00           H  
ATOM     25  C   ALA     3      31.243  32.793  23.975  1.00  0.00           C  
ATOM     26  O   ALA     3      32.128  31.938  24.215  1.00  0.00           O  
ATOM     27  OXT ALA     3      31.438  33.965  23.590  1.00  0.00           O  
TER      28      ALA     3
END
"""

arg = """\
REMARK   1 PDBFIXER FROM: MainChain_ARG.pdb                                                                                                 
REMARK   1 CREATED WITH OPENMM 7.7, 2023-01-13                                                                                              
CRYST1   48.000   48.000   48.000  90.00  90.00  90.00 P 1           1                                                                      
HETATM    1  H1  ACE     1      26.138  25.214  24.583  1.00  0.00           H                                                              
HETATM    2  CH3 ACE     1      26.124  26.209  24.139  1.00  0.00           C                                                              
HETATM    3  H2  ACE     1      25.413  26.835  24.676  1.00  0.00           H                                                              
HETATM    4  H3  ACE     1      25.837  26.135  23.092  1.00  0.00           H                                                              
HETATM    5  C   ACE     1      27.506  26.811  24.243  1.00  0.00           C                                                              
HETATM    6  O   ACE     1      28.418  26.182  24.765  1.00  0.00           O                                                              
ATOM      7  N   ARG     2      27.671  28.039  23.742  1.00  0.00           N                                                              
ATOM      8  H   ARG     2      26.871  28.490  23.320  1.00  0.00           H                                                              
ATOM      9  CA  ARG     2      28.942  28.780  23.768  1.00  0.00           C                                                              
ATOM     10  HA  ARG     2      29.476  28.515  24.682  1.00  0.00           H                                                              
ATOM     11  CB  ARG     2      29.787  28.342  22.555  1.00  0.00           C                                                              
ATOM     12  HB2 ARG     2      29.888  27.255  22.575  1.00  0.00           H                                                              
ATOM     13  HB3 ARG     2      29.263  28.617  21.637  1.00  0.00           H                                                              
ATOM     14  CG  ARG     2      31.194  28.957  22.536  1.00  0.00           C                                                              
ATOM     15  HG2 ARG     2      31.121  30.043  22.463  1.00  0.00           H                                                              
ATOM     16  HG3 ARG     2      31.716  28.692  23.456  1.00  0.00           H                                                              
ATOM     17  CD  ARG     2      31.981  28.424  21.331  1.00  0.00           C                                                              
ATOM     18  HD2 ARG     2      32.042  27.336  21.408  1.00  0.00           H                                                              
ATOM     19  HD3 ARG     2      31.438  28.683  20.419  1.00  0.00           H                                                              
ATOM     20  NE  ARG     2      33.344  28.991  21.272  1.00  0.00           N                                                              
ATOM     21  HE  ARG     2      33.600  29.629  22.006  1.00  0.00           H                                                              
ATOM     22  CZ  ARG     2      34.256  28.739  20.348  1.00  0.00           C                                                              
ATOM     23  NH1 ARG     2      34.029  27.928  19.353  1.00  0.00           N                                                              
ATOM     24 HH11 ARG     2      33.132  27.480  19.289  1.00  0.00           H                                                              
ATOM     25 HH12 ARG     2      34.732  27.748  18.660  1.00  0.00           H                                                              
ATOM     26  NH2 ARG     2      35.428  29.305  20.406  1.00  0.00           N                                                              
ATOM     27 HH21 ARG     2      35.650  29.938  21.155  1.00  0.00           H                                                              
ATOM     28 HH22 ARG     2      36.117  29.111  19.703  1.00  0.00           H                                                              
ATOM     29  C   ARG     2      28.683  30.288  23.768  1.00  0.00           C                                                              
ATOM     30  O   ARG     2      28.008  30.786  22.875  1.00  0.00           O                                                              
HETATM   31  N   NME     3      29.250  31.004  24.744  1.00  0.00           N                                                              
HETATM   32  H   NME     3      29.758  30.508  25.458  1.00  0.00           H                                                              
HETATM   33  C   NME     3      29.101  32.453  24.889  1.00  0.00           C                                                              
HETATM   34  H1  NME     3      28.055  32.699  25.084  1.00  0.00           H                                                              
HETATM   35  H2  NME     3      29.712  32.817  25.716  1.00  0.00           H                                                              
HETATM   36  H3  NME     3      29.407  32.954  23.968  1.00  0.00           H                                                              
TER      37      NME     3                                                                                                                                                                                                                                            
END 
"""


trp = """\
REMARK   1 PDBFIXER FROM: MainChain_TRP.pdb                                                                                                 
REMARK   1 CREATED WITH OPENMM 7.7, 2023-01-13                                                                                              
CRYST1   48.000   48.000   48.000  90.00  90.00  90.00 P 1           1                                                                      
HETATM    1  H1  ACE     1      25.987  25.343  25.068  1.00  0.00           H                                                              
HETATM    2  CH3 ACE     1      26.037  26.135  24.322  1.00  0.00           C                                                              
HETATM    3  H2  ACE     1      25.187  26.804  24.443  1.00  0.00           H                                                              
HETATM    4  H3  ACE     1      26.028  25.698  23.325  1.00  0.00           H                                                              
HETATM    5  C   ACE     1      27.318  26.912  24.518  1.00  0.00           C                                                              
HETATM    6  O   ACE     1      28.091  26.607  25.417  1.00  0.00           O                                                              
ATOM      7  N   TRP     2      27.538  27.920  23.677  1.00  0.00           N                                                              
ATOM      8  H   TRP     2      26.840  28.135  22.980  1.00  0.00           H                                                              
ATOM      9  CA  TRP     2      28.712  28.797  23.720  1.00  0.00           C                                                              
ATOM     10  HA  TRP     2      29.022  28.915  24.759  1.00  0.00           H                                                              
ATOM     11  CB  TRP     2      29.868  28.144  22.946  1.00  0.00           C                                                              
ATOM     12  HB2 TRP     2      30.130  27.203  23.433  1.00  0.00           H                                                              
ATOM     13  HB3 TRP     2      29.522  27.909  21.938  1.00  0.00           H                                                              
ATOM     14  CG  TRP     2      31.112  28.973  22.840  1.00  0.00           C                                                              
ATOM     15  CD1 TRP     2      31.621  29.485  21.697  1.00  0.00           C                                                              
ATOM     16  HD1 TRP     2      31.194  29.338  20.711  1.00  0.00           H                                                              
ATOM     17  NE1 TRP     2      32.746  30.233  21.984  1.00  0.00           N                                                              
ATOM     18  HE1 TRP     2      33.294  30.707  21.281  1.00  0.00           H                                                              
ATOM     19  CE2 TRP     2      33.010  30.254  23.337  1.00  0.00           C                                                              
ATOM     20  CZ2 TRP     2      33.997  30.881  24.111  1.00  0.00           C                                                              
ATOM     21  HZ2 TRP     2      34.755  31.491  23.642  1.00  0.00           H                                                              
ATOM     22  CH2 TRP     2      33.987  30.703  25.505  1.00  0.00           C                                                              
ATOM     23  HH2 TRP     2      34.741  31.178  26.118  1.00  0.00           H                                                              
ATOM     24  CZ3 TRP     2      32.998  29.900  26.102  1.00  0.00           C                                                              
ATOM     25  HZ3 TRP     2      32.999  29.759  27.174  1.00  0.00           H                                                              
ATOM     26  CE3 TRP     2      32.012  29.273  25.314  1.00  0.00           C                                                              
ATOM     27  HE3 TRP     2      31.266  28.648  25.784  1.00  0.00           H                                                              
ATOM     28  CD2 TRP     2      31.991  29.437  23.912  1.00  0.00           C                                                              
ATOM     29  C   TRP     2      28.381  30.195  23.175  1.00  0.00           C                                                              
ATOM     30  O   TRP     2      27.456  30.346  22.378  1.00  0.00           O                                                              
HETATM   31  N   NME     3      29.137  31.215  23.603  1.00  0.00           N                                                              
HETATM   32  H   NME     3      29.911  30.999  24.215  1.00  0.00           H                                                              
HETATM   33  C   NME     3      28.956  32.603  23.187  1.00  0.00           C                                                              
HETATM   34  H1  NME     3      27.915  32.898  23.332  1.00  0.00           H                                                              
HETATM   35  H2  NME     3      29.602  33.258  23.773  1.00  0.00           H                                                              
HETATM   36  H3  NME     3      29.204  32.703  22.129  1.00  0.00           H                                                              
TER      37      NME     3                                                                                                                                                                                                                                             
END                                                                                                                                         
"""


pro = """\
       REMARK   1 PDBFIXER FROM: MainChain_PRO.pdb                                                                                                 
REMARK   1 CREATED WITH OPENMM 7.7, 2023-01-14                                                                                              
CRYST1   48.000   48.000   48.000  90.00  90.00  90.00 P 1           1                                                                      
HETATM    1  H1  ACE     1      26.508  24.897  24.198  1.00  0.00           H                                                              
HETATM    2  CH3 ACE     1      26.278  25.954  24.075  1.00  0.00           C                                                              
HETATM    3  H2  ACE     1      25.662  26.287  24.908  1.00  0.00           H                                                              
HETATM    4  H3  ACE     1      25.754  26.105  23.134  1.00  0.00           H                                                              
HETATM    5  C   ACE     1      27.577  26.740  24.064  1.00  0.00           C                                                              
HETATM    6  O   ACE     1      28.637  26.123  24.044  1.00  0.00           O                                                              
ATOM      7  N   PRO     2      27.528  28.085  24.064  1.00  0.00           N                                                              
ATOM      8  CD  PRO     2      26.342  28.911  23.908  1.00  0.00           C                                                              
ATOM      9  HD2 PRO     2      25.907  29.109  24.889  1.00  0.00           H                                                              
ATOM     10  HD3 PRO     2      25.604  28.452  23.251  1.00  0.00           H                                                              
ATOM     11  CG  PRO     2      26.851  30.212  23.291  1.00  0.00           C                                                              
ATOM     12  HG2 PRO     2      26.195  31.053  23.521  1.00  0.00           H                                                              
ATOM     13  HG3 PRO     2      26.960  30.089  22.213  1.00  0.00           H                                                              
ATOM     14  CB  PRO     2      28.228  30.369  23.936  1.00  0.00           C                                                              
ATOM     15  HB2 PRO     2      28.110  30.844  24.912  1.00  0.00           H                                                              
ATOM     16  HB3 PRO     2      28.899  30.957  23.310  1.00  0.00           H                                                              
ATOM     17  CA  PRO     2      28.725  28.923  24.097  1.00  0.00           C                                                              
ATOM     18  HA  PRO     2      29.348  28.666  23.240  1.00  0.00           H                                                              
ATOM     19  C   PRO     2      29.531  28.734  25.393  1.00  0.00           C                                                              
ATOM     20  O   PRO     2      29.011  28.944  26.487  1.00  0.00           O                                                              
HETATM   21  N   NME     3      30.814  28.375  25.264  1.00  0.00           N                                                              
HETATM   22  H   NME     3      31.150  28.164  24.338  1.00  0.00           H                                                              
HETATM   23  C   NME     3      31.719  28.162  26.391  1.00  0.00           C                                                              
HETATM   24  H1  NME     3      31.372  27.311  26.981  1.00  0.00           H                                                              
HETATM   25  H2  NME     3      32.730  27.965  26.033  1.00  0.00           H                                                              
HETATM   26  H3  NME     3      31.727  29.047  27.031  1.00  0.00           H                                                              
TER      27      NME     3                                                                                                                                                                                                                                           
END                                                                                                                                                                                                                                                         
"""


cys = """\
REMARK   1 PDBFIXER FROM: MainChain_CYS.pdb                                                                                                 
REMARK   1 CREATED WITH OPENMM 7.7, 2023-01-14                                                                                              
CRYST1   48.000   48.000   48.000  90.00  90.00  90.00 P 1           1                                                                      
HETATM    1  H1  ACE     1      25.973  25.174  24.544  1.00  0.00           H                                                              
HETATM    2  CH3 ACE     1      25.997  26.195  24.165  1.00  0.00           C                                                              
HETATM    3  H2  ACE     1      25.393  26.837  24.805  1.00  0.00           H                                                              
HETATM    4  H3  ACE     1      25.611  26.217  23.148  1.00  0.00           H                                                              
HETATM    5  C   ACE     1      27.425  26.686  24.169  1.00  0.00           C                                                              
HETATM    6  O   ACE     1      28.326  25.956  24.559  1.00  0.00           O                                                              
ATOM      7  N   CYS     2      27.631  27.926  23.732  1.00  0.00           N                                                              
ATOM      8  H   CYS     2      26.835  28.482  23.454  1.00  0.00           H                                                              
ATOM      9  CA  CYS     2      28.930  28.601  23.716  1.00  0.00           C                                                              
ATOM     10  HA  CYS     2      29.492  28.302  24.603  1.00  0.00           H                                                              
ATOM     11  CB  CYS     2      29.705  28.139  22.471  1.00  0.00           C                                                              
ATOM     12  HB2 CYS     2      29.719  27.047  22.449  1.00  0.00           H                                                              
ATOM     13  HB3 CYS     2      29.201  28.502  21.573  1.00  0.00           H                                                              
ATOM     14  SG  CYS     2      31.419  28.741  22.503  1.00  0.00           S                                                              
ATOM     15  HG  CYS     2      31.840  28.100  21.406  1.00  0.00           H                                                              
ATOM     16  C   CYS     2      28.734  30.130  23.768  1.00  0.00           C                                                              
ATOM     17  O   CYS     2      27.658  30.623  23.428  1.00  0.00           O                                                              
HETATM   18  N   NME     3      29.759  30.876  24.196  1.00  0.00           N                                                              
HETATM   19  H   NME     3      30.627  30.400  24.395  1.00  0.00           H                                                              
HETATM   20  C   NME     3      29.728  32.333  24.310  1.00  0.00           C                                                              
HETATM   21  H1  NME     3      28.835  32.642  24.858  1.00  0.00           H                                                              
HETATM   22  H2  NME     3      30.614  32.689  24.837  1.00  0.00           H                                                              
HETATM   23  H3  NME     3      29.697  32.778  23.314  1.00  0.00           H                                                              
TER      24      NME     3                                                                                                                                                                                                                                        
END                
"""


cyx = """\
REMARK   1 PDBFIXER FROM: MainChain_CYX.pdb                                                                                                 
REMARK   1 CREATED WITH OPENMM 7.7, 2023-01-14                                                                                              
CRYST1   48.000   48.000   48.000  90.00  90.00  90.00 P 1           1                                                                      
HETATM    1  H1  ACE     1      28.573  24.032  26.099  1.00  0.00           H                                                              
HETATM    2  CH3 ACE     1      28.403  25.075  26.364  1.00  0.00           C                                                              
HETATM    3  H2  ACE     1      29.047  25.351  27.196  1.00  0.00           H                                                              
HETATM    4  H3  ACE     1      27.360  25.215  26.643  1.00  0.00           H                                                              
HETATM    5  C   ACE     1      28.726  25.945  25.173  1.00  0.00           C                                                              
HETATM    6  O   ACE     1      29.129  25.442  24.132  1.00  0.00           O                                                              
ATOM      7  N   CYS     2      28.533  27.252  25.319  1.00  0.00           N                                                              
ATOM      8  H   CYS     2      28.195  27.601  26.205  1.00  0.00           H                                                              
ATOM      9  CA  CYS     2      28.788  28.255  24.284  1.00  0.00           C                                                              
ATOM     10  HA  CYS     2      29.726  28.000  23.788  1.00  0.00           H                                                              
ATOM     11  CB  CYS     2      27.665  28.212  23.233  1.00  0.00           C                                                              
ATOM     12  HB2 CYS     2      27.542  27.183  22.893  1.00  0.00           H                                                              
ATOM     13  HB3 CYS     2      27.997  28.784  22.367  1.00  0.00           H                                                              
ATOM     14  SG  CYS     2      26.035  28.864  23.703  1.00  0.00           S                                                              
ATOM     15  C   CYS     2      28.948  29.658  24.899  1.00  0.00           C                                                              
ATOM     16  O   CYS     2      28.616  29.871  26.065  1.00  0.00           O                                                              
HETATM   17  N   NME     3      29.464  30.614  24.115  1.00  0.00           N                                                              
HETATM   18  H   NME     3      29.717  30.370  23.171  1.00  0.00           H                                                              
HETATM   19  C   NME     3      29.676  31.993  24.550  1.00  0.00           C                                                              
HETATM   20  H1  NME     3      28.717  32.449  24.805  1.00  0.00           H                                                              
HETATM   21  H2  NME     3      30.312  32.007  25.437  1.00  0.00           H                                                              
HETATM   22  H3  NME     3      30.151  32.572  23.757  1.00  0.00           H                                                              
TER      23      NME     3                                                                                                                  
HETATM   24  H1  ACE     4      23.123  21.295  23.934  1.00  0.00           H                                                              
HETATM   25  CH3 ACE     4      23.375  22.084  23.227  1.00  0.00           C                                                              
HETATM   26  H2  ACE     4      22.641  22.105  22.423  1.00  0.00           H                                                              
HETATM   27  H3  ACE     4      24.367  21.904  22.817  1.00  0.00           H                                                              
HETATM   28  C   ACE     4      23.365  23.411  23.949  1.00  0.00           C                                                              
HETATM   29  O   ACE     4      23.112  23.462  25.145  1.00  0.00           O                                                              
ATOM     30  N   CYS     5      23.650  24.486  23.219  1.00  0.00           N                                                              
ATOM     31  H   CYS     5      23.839  24.370  22.234  1.00  0.00           H                                                              
ATOM     32  CA  CYS     5      23.696  25.853  23.738  1.00  0.00           C                                                              
ATOM     33  HA  CYS     5      22.909  25.977  24.484  1.00  0.00           H                                                              
ATOM     34  CB  CYS     5      25.052  26.054  24.429  1.00  0.00           C                                                              
ATOM     35  HB2 CYS     5      25.136  25.300  25.213  1.00  0.00           H                                                              
ATOM     36  HB3 CYS     5      25.847  25.859  23.709  1.00  0.00           H                                                              
ATOM     37  SG  CYS     5      25.362  27.661  25.209  1.00  0.00           S                                                              
ATOM     38  C   CYS     5      23.449  26.867  22.607  1.00  0.00           C                                                              
ATOM     39  O   CYS     5      23.798  26.601  21.456  1.00  0.00           O                                                              
HETATM   40  N   NME     6      22.844  28.017  22.931  1.00  0.00           N                                                              
HETATM   41  H   NME     6      22.620  28.173  23.901  1.00  0.00           H                                                              
HETATM   42  C   NME     6      22.545  29.086  21.979  1.00  0.00           C                                                              
HETATM   43  H1  NME     6      23.464  29.613  21.717  1.00  0.00           H                                                              
HETATM   44  H2  NME     6      22.113  28.665  21.068  1.00  0.00           H                                                              
HETATM   45  H3  NME     6      21.838  29.792  22.415  1.00  0.00           H                                                              
TER      46      NME     6  
END
"""


lys = """\
REMARK   1 PDBFIXER FROM: lys.pdb                                                                                                           
REMARK   1 CREATED WITH OPENMM 7.7, 2023-01-15                                                                                              
HETATM    1  H1  ACE     1       3.851  -3.562   0.131  1.00  0.00           H                                                              
HETATM    2  CH3 ACE     1       3.389  -3.037  -0.713  1.00  0.00           C                                                              
HETATM    3  H2  ACE     1       3.132  -3.704  -1.541  1.00  0.00           H                                                              
HETATM    4  H3  ACE     1       4.006  -2.170  -1.057  1.00  0.00           H                                                              
HETATM    5  C   ACE     1       2.115  -2.449  -0.125  1.00  0.00           C                                                              
HETATM    6  O   ACE     1       1.100  -3.195  -0.165  1.00  0.00           O                                                              
ATOM      7  N   LYS     2       2.145  -1.000   0.467  1.00  0.00           N                                                              
ATOM      8  CA  LYS     2       0.684  -0.172   0.107  1.00  0.00           C                                                              
ATOM      9  C   LYS     2       1.161   1.161  -0.224  1.00  0.00           C                                                              
ATOM     10  O   LYS     2       0.958   1.659  -1.347  1.00  0.00           O                                                              
ATOM     11  CB  LYS     2      -0.253  -0.408   1.195  1.00  0.00           C                                                              
ATOM     12  CG  LYS     2      -1.599   0.233   1.121  1.00  0.00           C                                                              
ATOM     13  CD  LYS     2      -2.466  -0.159  -0.054  1.00  0.00           C                                                              
ATOM     14  CE  LYS     2      -3.754   0.617   0.150  1.00  0.00           C                                                              
ATOM     15  NZ  LYS     2      -4.785   0.362  -0.787  1.00  0.00           N                                                              
ATOM     16  H   LYS     2       2.562  -0.670   1.540  1.00  0.00           H                                                              
ATOM     17  HA  LYS     2       0.300  -0.689  -0.853  1.00  0.00           H                                                              
ATOM     18  HB2 LYS     2      -0.509  -1.551   1.129  1.00  0.00           H                                                              
ATOM     19  HB3 LYS     2       0.163  -0.267   2.211  1.00  0.00           H                                                              
ATOM     20  HG2 LYS     2      -1.613   1.336   1.159  1.00  0.00           H                                                              
ATOM     21  HG3 LYS     2      -2.164  -0.139   2.024  1.00  0.00           H                                                              
ATOM     22  HD2 LYS     2      -1.955   0.239  -0.949  1.00  0.00           H                                                              
ATOM     23  HD3 LYS     2      -2.615  -1.226  -0.207  1.00  0.00           H                                                              
ATOM     24  HE2 LYS     2      -4.119   0.453   1.180  1.00  0.00           H                                                              
ATOM     25  HE3 LYS     2      -3.466   1.712   0.126  1.00  0.00           H                                                              
ATOM     26  HZ1 LYS     2      -4.575   0.480  -1.785  1.00  0.00           H                                                              
ATOM     27  HZ2 LYS     2      -5.564   1.061  -0.557  1.00  0.00           H                                                              
ATOM     28  HZ3 LYS     2      -5.249  -0.563  -0.540  1.00  0.00           H                                                              
HETATM   29  N   NME     3       2.024   2.091   0.877  1.00  0.00           N                                                              
HETATM   30  H   NME     3       1.295   3.264   1.380  1.00  0.00           H                                                              
HETATM   31  C   NME     3       3.556   2.525   0.096  1.00  0.00           C                                                              
HETATM   32  H1  NME     3       4.519   3.117   1.252  1.00  0.00           H                                                              
HETATM   33  H2  NME     3       4.264   1.218  -0.292  1.00  0.00           H                                                              
HETATM   34  H3  NME     3       3.463   3.431  -1.036  1.00  0.00           H                                                              
TER      35      NME     3                                                                                                                                                                                                                                        
END                                                                                                                                         
"""


asp = """\
REMARK   1 PDBFIXER FROM: asp.pdb
REMARK   1 CREATED WITH OPENMM 7.7, 2023-01-16
HETATM    1  H1  ACE     1      -2.705  -3.217   0.456  1.00  0.00           H  
HETATM    2  CH3 ACE     1      -3.024  -2.157   0.693  1.00  0.00           C  
HETATM    3  H2  ACE     1      -3.650  -2.037   1.542  1.00  0.00           H  
HETATM    4  H3  ACE     1      -3.578  -1.864  -0.271  1.00  0.00           H  
HETATM    5  C   ACE     1      -1.784  -1.307   0.763  1.00  0.00           C  
HETATM    6  O   ACE     1      -1.321  -1.088   1.857  1.00  0.00           O  
ATOM      7  N   ASP     2      -1.103  -0.732  -0.532  1.00  0.00           N  
ATOM      8  CA  ASP     2      -0.051   0.501  -0.003  1.00  0.00           C  
ATOM      9  C   ASP     2       1.187   0.212  -0.739  1.00  0.00           C  
ATOM     10  O   ASP     2       1.613   0.828  -1.748  1.00  0.00           O  
ATOM     11  CB  ASP     2      -0.799   1.698  -0.478  1.00  0.00           C  
ATOM     12  CG  ASP     2      -0.320   3.035  -0.340  1.00  0.00           C  
ATOM     13  OD1 ASP     2       0.193   3.550  -1.430  1.00  0.00           O  
ATOM     14  OD2 ASP     2      -0.296   3.907   0.710  1.00  0.00           O  
ATOM     15  H   ASP     2      -0.664  -1.422  -1.301  1.00  0.00           H  
ATOM     16  HA  ASP     2       0.091   0.492   1.050  1.00  0.00           H  
ATOM     17  HB2 ASP     2      -1.138   1.514  -1.584  1.00  0.00           H  
ATOM     18  HB3 ASP     2      -1.827   1.550   0.014  1.00  0.00           H  
ATOM     19  HD2 ASP     2      -0.651   4.887   0.567  1.00  0.00           H  
HETATM   20  N   NME     3       2.060  -1.094  -0.134  1.00  0.00           N  
HETATM   21  H   NME     3       1.505  -2.428  -0.518  1.00  0.00           H  
HETATM   22  C   NME     3       3.545  -1.013   0.401  1.00  0.00           C  
HETATM   23  H1  NME     3       3.903  -2.282   1.333  1.00  0.00           H  
HETATM   24  H2  NME     3       4.537  -1.650  -1.016  1.00  0.00           H  
HETATM   25  H3  NME     3       4.277   0.116   0.704  1.00  0.00           H  
TER      26      NME     3
CONECT    1    2
CONECT    2    5    1    3    4
CONECT    3    2
CONECT    4    2
CONECT    5    2    6    7
CONECT    6    5
CONECT    7    5
CONECT    9   20
CONECT   20    9   22   21
CONECT   21   20
CONECT   22   23   24   25   20
CONECT   23   22
CONECT   24   22
CONECT   25   22
END
"""


asn = """\
REMARK   1 PDBFIXER FROM: asn.pdb                                                                                                           
REMARK   1 CREATED WITH OPENMM 7.7, 2023-01-16                                                                                              
HETATM    1  H1  ACE     1      -1.652   3.100  -0.767  1.00  0.00           H                                                              
HETATM    2  CH3 ACE     1      -0.654   2.957  -0.309  1.00  0.00           C                                                              
HETATM    3  H2  ACE     1      -0.004   2.466  -1.071  1.00  0.00           H                                                              
HETATM    4  H3  ACE     1      -0.214   3.950  -0.113  1.00  0.00           H                                                              
HETATM    5  C   ACE     1      -0.760   2.150   0.929  1.00  0.00           C                                                              
HETATM    6  O   ACE     1      -0.348   2.660   2.003  1.00  0.00           O                                                              
ATOM      7  N   ASN     2      -1.376   0.672   0.925  1.00  0.00           N                                                              
ATOM      8  CA  ASN     2      -0.280  -0.443   0.644  1.00  0.00           C                                                              
ATOM      9  C   ASN     2       1.109   0.016   0.637  1.00  0.00           C                                                              
ATOM     10  O   ASN     2       1.509   1.154   0.829  1.00  0.00           O                                                              
ATOM     11  CB  ASN     2      -0.628  -1.189  -0.626  1.00  0.00           C                                                              
ATOM     12  CG  ASN     2      -1.940  -1.829  -0.496  1.00  0.00           C                                                              
ATOM     13  OD1 ASN     2      -2.368  -2.527  -1.449  1.00  0.00           O                                                              
ATOM     14  ND2 ASN     2      -2.703  -1.659   0.683  1.00  0.00           N                                                              
ATOM     15  H   ASN     2      -2.430   0.629   0.107  1.00  0.00           H                                                              
ATOM     16  HA  ASN     2      -0.337  -1.226   1.463  1.00  0.00           H                                                              
ATOM     17  HB2 ASN     2       0.151  -1.991  -0.782  1.00  0.00           H                                                              
ATOM     18  HB3 ASN     2      -0.547  -0.528  -1.513  1.00  0.00           H                                                              
ATOM     19 HD21 ASN     2      -3.742  -1.817   0.645  1.00  0.00           H                                                              
ATOM     20 HD22 ASN     2      -2.335  -1.388   1.607  1.00  0.00           H                                                              
HETATM   21  N   NME     3       2.364  -1.160   0.325  1.00  0.00           N                                                              
HETATM   22  H   NME     3       2.025  -2.485   0.427  1.00  0.00           H                                                              
HETATM   23  C   NME     3       3.706  -0.599  -0.492  1.00  0.00           C                                                              
HETATM   24  H1  NME     3       2.723   0.001  -2.114  1.00  0.00           H                                                              
HETATM   25  H2  NME     3       4.283   0.679  -0.256  1.00  0.00           H                                                              
HETATM   26  H3  NME     3       4.450  -1.594  -1.237  1.00  0.00           H                                                              
TER      27      NME     3                                                                                                                                                                                                                                             
END      
"""


glu = """\
REMARK   1 PDBFIXER FROM: glu.pdb                                                                                                           
REMARK   1 CREATED WITH OPENMM 7.7, 2023-01-16                                                                                              
HETATM    1  H1  ACE     1      -0.311   3.925   1.334  1.00  0.00           H                                                              
HETATM    2  CH3 ACE     1       0.440   3.107   1.123  1.00  0.00           C                                                              
HETATM    3  H2  ACE     1       0.386   2.364   1.930  1.00  0.00           H                                                              
HETATM    4  H3  ACE     1       1.436   3.616   1.301  1.00  0.00           H                                                              
HETATM    5  C   ACE     1       0.359   2.610  -0.255  1.00  0.00           C                                                              
HETATM    6  O   ACE     1      -0.306   3.417  -1.046  1.00  0.00           O                                                              
ATOM      7  N   GLU     2       0.925   1.296  -0.862  1.00  0.00           N                                                              
ATOM      8  CA  GLU     2      -0.025  -0.067  -0.630  1.00  0.00           C                                                              
ATOM      9  C   GLU     2       0.690  -0.905   0.384  1.00  0.00           C                                                              
ATOM     10  O   GLU     2       0.062  -1.499   1.344  1.00  0.00           O                                                              
ATOM     11  CB  GLU     2      -1.291   0.510  -0.002  1.00  0.00           C                                                              
ATOM     12  CG  GLU     2      -2.356  -0.363   0.440  1.00  0.00           C                                                              
ATOM     13  CD  GLU     2      -2.953  -1.213  -0.589  1.00  0.00           C                                                              
ATOM     14  OE1 GLU     2      -3.820  -0.851  -1.419  1.00  0.00           O                                                              
ATOM     15  OE2 GLU     2      -2.561  -2.577  -0.691  1.00  0.00           O                                                              
ATOM     16  H   GLU     2       1.988   1.207  -1.308  1.00  0.00           H                                                              
ATOM     17  HA  GLU     2      -0.155  -0.586  -1.553  1.00  0.00           H                                                              
ATOM     18  HB2 GLU     2      -1.115   1.302   0.726  1.00  0.00           H                                                              
ATOM     19  HB3 GLU     2      -1.722   1.113  -0.885  1.00  0.00           H                                                              
ATOM     20  HG2 GLU     2      -3.228   0.327   0.758  1.00  0.00           H                                                              
ATOM     21  HG3 GLU     2      -2.170  -0.874   1.423  1.00  0.00           H                                                              
ATOM     22  HE2 GLU     2      -3.368  -3.206  -0.916  1.00  0.00           H                                                              
HETATM   23  N   NME     3       2.372  -1.105   0.356  1.00  0.00           N                                                              
HETATM   24  H   NME     3       3.186   0.083   0.545  1.00  0.00           H                                                              
HETATM   25  C   NME     3       3.211  -2.445   0.075  1.00  0.00           C                                                              
HETATM   26  H1  NME     3       3.275  -2.809   2.199  1.00  0.00           H                                                              
HETATM   27  H2  NME     3       4.588  -2.582   0.117  1.00  0.00           H                                                              
HETATM   28  H3  NME     3       2.467  -3.794   0.078  1.00  0.00           H                                                              
TER      29      NME     3                                                                                                                                                                                                                                            
END                                                                                                                                         
"""


gln = """\
REMARK   1 PDBFIXER FROM: gln.pdb
REMARK   1 CREATED WITH OPENMM 7.7, 2023-01-16
HETATM    1  H1  ACE     1      -2.083   4.228  -0.223  1.00  0.00           H  
HETATM    2  CH3 ACE     1      -1.717   3.161  -0.067  1.00  0.00           C  
HETATM    3  H2  ACE     1      -1.919   2.693  -1.064  1.00  0.00           H  
HETATM    4  H3  ACE     1      -2.298   2.783   0.774  1.00  0.00           H  
HETATM    5  C   ACE     1      -0.305   3.151   0.283  1.00  0.00           C  
HETATM    6  O   ACE     1       0.128   4.082   1.074  1.00  0.00           O  
ATOM      7  N   GLN     2       0.874   2.112  -0.189  1.00  0.00           N  
ATOM      8  CA  GLN     2       0.549   0.614   0.634  1.00  0.00           C  
ATOM      9  C   GLN     2       1.810  -0.049   0.813  1.00  0.00           C  
ATOM     10  O   GLN     2       2.397  -0.089   1.920  1.00  0.00           O  
ATOM     11  CB  GLN     2      -0.635   0.032   0.029  1.00  0.00           C  
ATOM     12  CG  GLN     2      -1.103  -1.293   0.640  1.00  0.00           C  
ATOM     13  CD  GLN     2      -2.480  -1.567   0.064  1.00  0.00           C  
ATOM     14  OE1 GLN     2      -3.160  -0.518  -0.242  1.00  0.00           O  
ATOM     15  NE2 GLN     2      -2.994  -2.870  -0.146  1.00  0.00           N  
ATOM     16  H   GLN     2       1.069   1.903  -1.275  1.00  0.00           H  
ATOM     17  HA  GLN     2       0.226   1.012   1.712  1.00  0.00           H  
ATOM     18  HB2 GLN     2      -1.510   0.699   0.128  1.00  0.00           H  
ATOM     19  HB3 GLN     2      -0.487  -0.148  -1.080  1.00  0.00           H  
ATOM     20  HG2 GLN     2      -1.121  -1.242   1.750  1.00  0.00           H  
ATOM     21  HG3 GLN     2      -0.432  -2.085   0.318  1.00  0.00           H  
ATOM     22 HE21 GLN     2      -2.387  -3.667  -0.457  1.00  0.00           H  
ATOM     23 HE22 GLN     2      -3.997  -3.040  -0.004  1.00  0.00           H  
HETATM   24  N   NME     3       2.598  -0.794  -0.507  1.00  0.00           N  
HETATM   25  H   NME     3       3.446   0.335  -1.145  1.00  0.00           H  
HETATM   26  C   NME     3       3.356  -2.175  -0.335  1.00  0.00           C  
HETATM   27  H1  NME     3       4.512  -1.636   1.283  1.00  0.00           H  
HETATM   28  H2  NME     3       4.701  -2.338  -1.099  1.00  0.00           H  
HETATM   29  H3  NME     3       2.962  -3.296   0.325  1.00  0.00           H  
TER      30      NME     3
END
"""


gly = """\
REMARK   1 PDBFIXER FROM: gly.pdb
REMARK   1 CREATED WITH OPENMM 7.7, 2023-01-16
HETATM    1  H1  ACE     1       2.971   1.581   0.462  1.00  0.00           H  
HETATM    2  CH3 ACE     1       3.062   0.464   0.495  1.00  0.00           C  
HETATM    3  H2  ACE     1       4.087   0.151   0.777  1.00  0.00           H  
HETATM    4  H3  ACE     1       2.338   0.107   1.252  1.00  0.00           H  
HETATM    5  C   ACE     1       2.759  -0.044  -0.861  1.00  0.00           C  
HETATM    6  O   ACE     1       3.606   0.138  -1.763  1.00  0.00           O  
ATOM      7  N   GLY     2       1.381  -0.817  -1.199  1.00  0.00           N  
ATOM      8  CA  GLY     2       0.352  -0.517   0.111  1.00  0.00           C  
ATOM      9  C   GLY     2      -1.002  -0.781  -0.355  1.00  0.00           C  
ATOM     10  O   GLY     2      -1.229  -1.154  -1.523  1.00  0.00           O  
ATOM     11  H   GLY     2       0.690   0.274  -2.113  1.00  0.00           H  
ATOM     12  HA2 GLY     2       0.605  -1.231   0.913  1.00  0.00           H  
ATOM     13  HA3 GLY     2       0.506   0.529   0.454  1.00  0.00           H  
HETATM   14  N   NME     3      -2.338  -0.596   0.668  1.00  0.00           N  
HETATM   15  H   NME     3      -3.005  -2.097   0.686  1.00  0.00           H  
HETATM   16  C   NME     3      -3.556   0.411   0.255  1.00  0.00           C  
HETATM   17  H1  NME     3      -4.888   0.334   0.511  1.00  0.00           H  
HETATM   18  H2  NME     3      -3.117   1.609  -0.648  1.00  0.00           H  
HETATM   19  H3  NME     3      -3.224   1.639   1.880  1.00  0.00           H  
TER      20      NME     3
END
"""


ile = """\
REMARK   1 PDBFIXER FROM: ile.pdb
REMARK   1 CREATED WITH OPENMM 7.7, 2023-01-16
HETATM    1  H1  ACE     1      -4.349  -1.055   0.401  1.00  0.00           H  
HETATM    2  CH3 ACE     1      -3.682  -1.952   0.500  1.00  0.00           C  
HETATM    3  H2  ACE     1      -3.685  -2.590  -0.394  1.00  0.00           H  
HETATM    4  H3  ACE     1      -4.074  -2.492   1.405  1.00  0.00           H  
HETATM    5  C   ACE     1      -2.270  -1.564   0.757  1.00  0.00           C  
HETATM    6  O   ACE     1      -1.554  -2.348   1.446  1.00  0.00           O  
ATOM      7  N   ILE     2      -1.665  -0.206   0.189  1.00  0.00           N  
ATOM      8  CA  ILE     2      -0.087  -0.319  -0.106  1.00  0.00           C  
ATOM      9  C   ILE     2       0.767  -0.479   1.096  1.00  0.00           C  
ATOM     10  O   ILE     2       0.160  -0.500   2.219  1.00  0.00           O  
ATOM     11  CB  ILE     2       0.333   0.797  -1.016  1.00  0.00           C  
ATOM     12  CG1 ILE     2       0.082   2.174  -0.482  1.00  0.00           C  
ATOM     13  CG2 ILE     2      -0.454   0.676  -2.321  1.00  0.00           C  
ATOM     14  CD1 ILE     2       0.783   2.487   0.797  1.00  0.00           C  
ATOM     15  H   ILE     2      -1.505   0.496   1.685  1.00  0.00           H  
ATOM     16  HA  ILE     2       0.069  -1.289  -0.680  1.00  0.00           H  
ATOM     17  HB  ILE     2       1.434   0.727  -1.264  1.00  0.00           H  
ATOM     18 HG12 ILE     2      -1.012   2.312  -0.341  1.00  0.00           H  
ATOM     19 HG13 ILE     2       0.365   2.970  -1.219  1.00  0.00           H  
ATOM     20 HG21 ILE     2       0.111   1.192  -3.129  1.00  0.00           H  
ATOM     21 HG22 ILE     2      -0.650  -0.379  -2.576  1.00  0.00           H  
ATOM     22 HG23 ILE     2      -1.443   1.165  -2.203  1.00  0.00           H  
ATOM     23 HD11 ILE     2       1.809   2.087   0.855  1.00  0.00           H  
ATOM     24 HD12 ILE     2       0.904   3.602   0.919  1.00  0.00           H  
ATOM     25 HD13 ILE     2       0.203   2.184   1.711  1.00  0.00           H  
HETATM   26  N   NME     3       2.391  -0.622   1.012  1.00  0.00           N  
HETATM   27  H   NME     3       3.135   0.071   2.049  1.00  0.00           H  
HETATM   28  C   NME     3       3.157  -1.744   0.173  1.00  0.00           C  
HETATM   29  H1  NME     3       4.449  -2.265   0.542  1.00  0.00           H  
HETATM   30  H2  NME     3       3.895  -0.581  -1.231  1.00  0.00           H  
HETATM   31  H3  NME     3       2.385  -2.556  -0.795  1.00  0.00           H  
TER      32      NME     3
END
"""


leu = """\
REMARK   1 PDBFIXER FROM: leu.pdb                                                                                                           
REMARK   1 CREATED WITH OPENMM 7.7, 2023-01-16                                                                                              
HETATM    1  H1  ACE     1      -2.672   3.937   0.979  1.00  0.00           H                                                              
HETATM    2  CH3 ACE     1      -2.085   3.063   1.380  1.00  0.00           C                                                              
HETATM    3  H2  ACE     1      -1.582   3.390   2.331  1.00  0.00           H                                                              
HETATM    4  H3  ACE     1      -2.738   2.196   1.517  1.00  0.00           H                                                              
HETATM    5  C   ACE     1      -0.987   2.828   0.403  1.00  0.00           C                                                              
HETATM    6  O   ACE     1      -0.068   3.688   0.379  1.00  0.00           O                                                              
ATOM      7  N   LEU     2      -0.999   1.544  -0.555  1.00  0.00           N                                                              
ATOM      8  CA  LEU     2       0.102   0.491  -0.193  1.00  0.00           C                                                              
ATOM      9  C   LEU     2       1.496   1.013  -0.349  1.00  0.00           C                                                              
ATOM     10  O   LEU     2       1.771   2.158  -0.726  1.00  0.00           O                                                              
ATOM     11  CB  LEU     2      -0.003  -0.754  -1.010  1.00  0.00           C                                                              
ATOM     12  CG  LEU     2      -1.306  -1.479  -0.862  1.00  0.00           C                                                              
ATOM     13  CD1 LEU     2      -1.575  -1.915   0.559  1.00  0.00           C                                                              
ATOM     14  CD2 LEU     2      -1.189  -2.771  -1.680  1.00  0.00           C                                                              
ATOM     15  H   LEU     2      -0.572   2.072  -1.849  1.00  0.00           H                                                              
ATOM     16  HA  LEU     2       0.028   0.180   0.888  1.00  0.00           H                                                              
ATOM     17  HB2 LEU     2       0.115  -0.489  -2.075  1.00  0.00           H                                                              
ATOM     18  HB3 LEU     2       0.815  -1.440  -0.732  1.00  0.00           H                                                              
ATOM     19  HG  LEU     2      -2.171  -0.931  -1.230  1.00  0.00           H                                                              
ATOM     20 HD11 LEU     2      -2.026  -1.128   1.159  1.00  0.00           H                                                              
ATOM     21 HD12 LEU     2      -0.691  -2.395   1.027  1.00  0.00           H                                                              
ATOM     22 HD13 LEU     2      -2.346  -2.738   0.493  1.00  0.00           H                                                              
ATOM     23 HD21 LEU     2      -0.239  -3.243  -1.352  1.00  0.00           H                                                              
ATOM     24 HD22 LEU     2      -2.013  -3.461  -1.440  1.00  0.00           H                                                              
ATOM     25 HD23 LEU     2      -1.093  -2.560  -2.757  1.00  0.00           H                                                              
HETATM   26  N   NME     3       2.801   0.011  -0.001  1.00  0.00           N                                                              
HETATM   27  H   NME     3       3.500  -0.407  -1.232  1.00  0.00           H                                                              
HETATM   28  C   NME     3       3.676   0.206   1.358  1.00  0.00           C                                                              
HETATM   29  H1  NME     3       5.186   0.250   1.280  1.00  0.00           H                                                              
HETATM   30  H2  NME     3       3.772  -1.805   1.704  1.00  0.00           H                                                              
HETATM   31  H3  NME     3       3.096   0.490   2.586  1.00  0.00           H                                                              
TER      32      NME     3                                                                                                                                                                                                                                           
END   
"""


met = """\
REMARK   1 PDBFIXER FROM: met.pdb                                                                                                           
REMARK   1 CREATED WITH OPENMM 7.7, 2023-01-16                                                                                              
HETATM    1  H1  ACE     1      -0.521   4.167  -1.348  1.00  0.00           H                                                              
HETATM    2  CH3 ACE     1      -0.301   4.239  -0.272  1.00  0.00           C                                                              
HETATM    3  H2  ACE     1       0.429   5.024  -0.022  1.00  0.00           H                                                              
HETATM    4  H3  ACE     1      -1.289   4.426   0.240  1.00  0.00           H                                                              
HETATM    5  C   ACE     1       0.122   2.883   0.187  1.00  0.00           C                                                              
HETATM    6  O   ACE     1       1.058   2.888   1.063  1.00  0.00           O                                                              
ATOM      7  N   MET     2      -0.529   1.652  -0.363  1.00  0.00           N                                                              
ATOM      8  CA  MET     2      -0.594   0.310   0.345  1.00  0.00           C                                                              
ATOM      9  C   MET     2      -1.615  -0.567  -0.298  1.00  0.00           C                                                              
ATOM     10  O   MET     2      -2.268  -0.138  -1.282  1.00  0.00           O                                                              
ATOM     11  CB  MET     2       0.652  -0.518   0.488  1.00  0.00           C                                                              
ATOM     12  CG  MET     2       1.256  -0.888  -0.853  1.00  0.00           C                                                              
ATOM     13  SD  MET     2       2.756  -1.879  -0.595  1.00  0.00           S                                                              
ATOM     14  CE  MET     2       4.062  -0.924   0.189  1.00  0.00           C                                                              
ATOM     15  H   MET     2      -2.061   2.114  -0.404  1.00  0.00           H                                                              
ATOM     16  HA  MET     2      -0.976   0.430   1.410  1.00  0.00           H                                                              
ATOM     17  HB2 MET     2       0.484  -1.478   1.021  1.00  0.00           H                                                              
ATOM     18  HB3 MET     2       1.457   0.000   1.048  1.00  0.00           H                                                              
ATOM     19  HG2 MET     2       0.580  -1.513  -1.459  1.00  0.00           H                                                              
ATOM     20  HG3 MET     2       1.518   0.033  -1.431  1.00  0.00           H                                                              
ATOM     21  HE1 MET     2       4.993  -0.915  -0.430  1.00  0.00           H                                                              
ATOM     22  HE2 MET     2       4.333  -1.454   1.146  1.00  0.00           H                                                              
ATOM     23  HE3 MET     2       3.747   0.124   0.388  1.00  0.00           H                                                              
HETATM   24  N   NME     3      -1.950  -2.089   0.204  1.00  0.00           N                                                              
HETATM   25  H   NME     3      -0.694  -2.951   0.245  1.00  0.00           H                                                              
HETATM   26  C   NME     3      -3.365  -2.643   0.397  1.00  0.00           C                                                              
HETATM   27  H1  NME     3      -3.291  -4.297  -0.697  1.00  0.00           H                                                              
HETATM   28  H2  NME     3      -3.413  -3.718   1.791  1.00  0.00           H                                                              
HETATM   29  H3  NME     3      -4.580  -2.316   0.037  1.00  0.00           H                                                              
TER      30      NME     3                                                                                                                                                                                                                                            
END                                                                                                                                         
"""


phe = """\
REMARK   1 PDBFIXER FROM: phe.pdb                                                                                                           
REMARK   1 CREATED WITH OPENMM 7.7, 2023-01-16                                                                                              
HETATM    1  H1  ACE     1      -2.498   4.406   1.269  1.00  0.00           H                                                              
HETATM    2  CH3 ACE     1      -1.816   3.901   0.548  1.00  0.00           C                                                              
HETATM    3  H2  ACE     1      -0.908   4.550   0.490  1.00  0.00           H                                                              
HETATM    4  H3  ACE     1      -2.277   3.861  -0.449  1.00  0.00           H                                                              
HETATM    5  C   ACE     1      -1.477   2.523   0.971  1.00  0.00           C                                                              
HETATM    6  O   ACE     1      -2.194   1.971   1.839  1.00  0.00           O                                                              
ATOM      7  N   PHE     2      -0.220   1.748   0.336  1.00  0.00           N                                                              
ATOM      8  CA  PHE     2      -0.725   0.524  -0.599  1.00  0.00           C                                                              
ATOM      9  C   PHE     2      -1.266  -0.604   0.182  1.00  0.00           C                                                              
ATOM     10  O   PHE     2      -1.258  -0.549   1.460  1.00  0.00           O                                                              
ATOM     11  CB  PHE     2       0.396   0.089  -1.504  1.00  0.00           C                                                              
ATOM     12  CG  PHE     2       1.594  -0.372  -0.775  1.00  0.00           C                                                              
ATOM     13  CD1 PHE     2       2.619   0.506  -0.412  1.00  0.00           C                                                              
ATOM     14  CD2 PHE     2       1.779  -1.685  -0.408  1.00  0.00           C                                                              
ATOM     15  CE1 PHE     2       3.739   0.074   0.270  1.00  0.00           C                                                              
ATOM     16  CE2 PHE     2       2.897  -2.128   0.274  1.00  0.00           C                                                              
ATOM     17  CZ  PHE     2       3.898  -1.240   0.623  1.00  0.00           C                                                              
ATOM     18  H   PHE     2       0.287   2.674  -0.687  1.00  0.00           H                                                              
ATOM     19  HA  PHE     2      -1.541   0.898  -1.252  1.00  0.00           H                                                              
ATOM     20  HB2 PHE     2       0.026  -0.747  -2.127  1.00  0.00           H                                                              
ATOM     21  HB3 PHE     2       0.634   0.906  -2.216  1.00  0.00           H                                                              
ATOM     22  HD1 PHE     2       2.551   1.535  -0.659  1.00  0.00           H                                                              
ATOM     23  HD2 PHE     2       1.028  -2.411  -0.658  1.00  0.00           H                                                              
ATOM     24  HE1 PHE     2       4.525   0.771   0.544  1.00  0.00           H                                                              
ATOM     25  HE2 PHE     2       3.047  -3.160   0.565  1.00  0.00           H                                                              
ATOM     26  HZ  PHE     2       4.787  -1.538   1.154  1.00  0.00           H                                                              
HETATM   27  N   NME     3      -1.895  -1.963  -0.510  1.00  0.00           N                                                              
HETATM   28  H   NME     3      -1.098  -2.369  -1.739  1.00  0.00           H                                                              
HETATM   29  C   NME     3      -3.447  -2.368  -0.469  1.00  0.00           C                                                              
HETATM   30  H1  NME     3      -4.206  -2.483   0.678  1.00  0.00           H                                                              
HETATM   31  H2  NME     3      -2.855  -4.405  -0.117  1.00  0.00           H                                                              
HETATM   32  H3  NME     3      -4.125  -2.918  -1.756  1.00  0.00           H                                                              
TER      33      NME     3                                                                                                                                                                                                                                      
END 
"""


ser = """\
REMARK   1 PDBFIXER FROM: ser.pdb
REMARK   1 CREATED WITH OPENMM 7.7, 2023-01-16
HETATM    1  H1  ACE     1      -3.915   1.290   0.582  1.00  0.00           H  
HETATM    2  CH3 ACE     1      -3.332   0.434   0.185  1.00  0.00           C  
HETATM    3  H2  ACE     1      -2.724   0.036   1.019  1.00  0.00           H  
HETATM    4  H3  ACE     1      -4.074  -0.318  -0.182  1.00  0.00           H  
HETATM    5  C   ACE     1      -2.513   0.824  -0.993  1.00  0.00           C  
HETATM    6  O   ACE     1      -2.973   1.787  -1.664  1.00  0.00           O  
ATOM      7  N   SER     2      -1.144   0.138  -1.455  1.00  0.00           N  
ATOM      8  CA  SER     2      -0.187  -0.229  -0.242  1.00  0.00           C  
ATOM      9  C   SER     2       1.216   0.167  -0.536  1.00  0.00           C  
ATOM     10  O   SER     2       1.454   0.710  -1.642  1.00  0.00           O  
ATOM     11  CB  SER     2      -0.172  -1.690  -0.018  1.00  0.00           C  
ATOM     12  OG  SER     2      -1.393  -2.255   0.281  1.00  0.00           O  
ATOM     13  H   SER     2      -0.448   2.008  -0.860  1.00  0.00           H  
ATOM     14  HA  SER     2      -0.473   0.237   0.750  1.00  0.00           H  
ATOM     15  HB2 SER     2       0.270  -2.198  -0.922  1.00  0.00           H  
ATOM     16  HB3 SER     2       0.537  -1.925   0.813  1.00  0.00           H  
ATOM     17  HG  SER     2      -1.295  -3.247   0.161  1.00  0.00           H  
HETATM   18  N   NME     3       2.422  -0.081   0.519  1.00  0.00           N  
HETATM   19  H   NME     3       3.124  -1.415   0.371  1.00  0.00           H  
HETATM   20  C   NME     3       3.644   1.156   0.539  1.00  0.00           C  
HETATM   21  H1  NME     3       2.929   2.491   0.872  1.00  0.00           H  
HETATM   22  H2  NME     3       4.446   1.186  -0.695  1.00  0.00           H  
HETATM   23  H3  NME     3       4.599   0.896   1.799  1.00  0.00           H  
TER      24      NME     3
END
"""


thr = """\
REMARK   1 PDBFIXER FROM: thr.pdb
REMARK   1 CREATED WITH OPENMM 7.7, 2023-01-16
HETATM    1  H1  ACE     1      -2.470   1.924   1.525  1.00  0.00           H  
HETATM    2  CH3 ACE     1      -1.661   2.471   1.007  1.00  0.00           C  
HETATM    3  H2  ACE     1      -1.785   3.556   1.204  1.00  0.00           H  
HETATM    4  H3  ACE     1      -0.680   2.172   1.425  1.00  0.00           H  
HETATM    5  C   ACE     1      -1.781   2.134  -0.438  1.00  0.00           C  
HETATM    6  O   ACE     1      -2.326   3.014  -1.160  1.00  0.00           O  
ATOM      7  N   THR     2      -1.282   0.786  -1.091  1.00  0.00           N  
ATOM      8  CA  THR     2      -0.224  -0.024  -0.385  1.00  0.00           C  
ATOM      9  C   THR     2       1.151   0.236  -0.822  1.00  0.00           C  
ATOM     10  O   THR     2       1.411   1.056  -1.699  1.00  0.00           O  
ATOM     11  CB  THR     2      -0.453  -1.536  -0.572  1.00  0.00           C  
ATOM     12  OG1 THR     2       0.494  -2.288   0.060  1.00  0.00           O  
ATOM     13  CG2 THR     2      -1.864  -1.819  -0.126  1.00  0.00           C  
ATOM     14  H   THR     2      -1.946   0.360  -2.035  1.00  0.00           H  
ATOM     15  HA  THR     2      -0.219   0.097   0.740  1.00  0.00           H  
ATOM     16  HB  THR     2      -0.421  -1.679  -1.690  1.00  0.00           H  
ATOM     17  HG1 THR     2       0.624  -3.134  -0.463  1.00  0.00           H  
ATOM     18 HG21 THR     2      -2.058  -1.496   0.906  1.00  0.00           H  
ATOM     19 HG22 THR     2      -2.110  -2.884  -0.319  1.00  0.00           H  
ATOM     20 HG23 THR     2      -2.538  -1.217  -0.791  1.00  0.00           H  
HETATM   21  N   NME     3       2.469  -0.596  -0.125  1.00  0.00           N  
HETATM   22  H   NME     3       2.719  -1.889  -0.537  1.00  0.00           H  
HETATM   23  C   NME     3       3.525   0.293   0.767  1.00  0.00           C  
HETATM   24  H1  NME     3       3.130  -0.788   2.467  1.00  0.00           H  
HETATM   25  H2  NME     3       3.327   1.507   1.371  1.00  0.00           H  
HETATM   26  H3  NME     3       4.970  -0.256   0.782  1.00  0.00           H  
TER      27      NME     3
END
"""


tyr = """\
REMARK   1 PDBFIXER FROM: tyr.pdb
REMARK   1 CREATED WITH OPENMM 7.7, 2023-01-16
HETATM    1  H1  ACE     1      -2.669   3.302  -1.939  1.00  0.00           H  
HETATM    2  CH3 ACE     1      -2.615   3.477  -0.852  1.00  0.00           C  
HETATM    3  H2  ACE     1      -1.931   4.311  -0.628  1.00  0.00           H  
HETATM    4  H3  ACE     1      -3.608   3.692  -0.436  1.00  0.00           H  
HETATM    5  C   ACE     1      -2.162   2.216  -0.176  1.00  0.00           C  
HETATM    6  O   ACE     1      -1.919   2.280   1.056  1.00  0.00           O  
ATOM      7  N   TYR     2      -2.011   0.901  -0.990  1.00  0.00           N  
ATOM      8  CA  TYR     2      -0.858  -0.113  -0.028  1.00  0.00           C  
ATOM      9  C   TYR     2      -1.344  -1.390  -0.543  1.00  0.00           C  
ATOM     10  O   TYR     2      -0.772  -1.986  -1.450  1.00  0.00           O  
ATOM     11  CB  TYR     2       0.377   0.325  -0.811  1.00  0.00           C  
ATOM     12  CG  TYR     2       1.691  -0.088  -0.411  1.00  0.00           C  
ATOM     13  CD1 TYR     2       2.724   0.892  -0.380  1.00  0.00           C  
ATOM     14  CD2 TYR     2       2.095  -1.296   0.015  1.00  0.00           C  
ATOM     15  CE1 TYR     2       3.984   0.660   0.035  1.00  0.00           C  
ATOM     16  CE2 TYR     2       3.391  -1.582   0.455  1.00  0.00           C  
ATOM     17  CZ  TYR     2       4.324  -0.598   0.458  1.00  0.00           C  
ATOM     18  OH  TYR     2       5.603  -0.897   0.904  1.00  0.00           O  
ATOM     19  H   TYR     2      -1.679   0.715  -2.132  1.00  0.00           H  
ATOM     20  HA  TYR     2      -0.949   0.180   0.958  1.00  0.00           H  
ATOM     21  HB2 TYR     2       0.319   1.477  -0.726  1.00  0.00           H  
ATOM     22  HB3 TYR     2       0.174   0.108  -1.870  1.00  0.00           H  
ATOM     23  HD1 TYR     2       2.492   1.933  -0.745  1.00  0.00           H  
ATOM     24  HD2 TYR     2       1.402  -2.152   0.070  1.00  0.00           H  
ATOM     25  HE1 TYR     2       4.762   1.413   0.050  1.00  0.00           H  
ATOM     26  HE2 TYR     2       3.636  -2.600   0.823  1.00  0.00           H  
ATOM     27  HH  TYR     2       5.881  -0.800   1.864  1.00  0.00           H  
HETATM   28  N   NME     3      -2.738  -2.032   0.122  1.00  0.00           N  
HETATM   29  H   NME     3      -3.879  -2.027  -0.765  1.00  0.00           H  
HETATM   30  C   NME     3      -2.935  -2.576   1.614  1.00  0.00           C  
HETATM   31  H1  NME     3      -3.976  -3.886   1.635  1.00  0.00           H  
HETATM   32  H2  NME     3      -2.307  -2.372   2.758  1.00  0.00           H  
HETATM   33  H3  NME     3      -4.501  -1.488   2.065  1.00  0.00           H  
TER      34      NME     3
END
"""


val = """\
REMARK   1 PDBFIXER FROM: val.pdb
REMARK   1 CREATED WITH OPENMM 7.7, 2023-01-16
HETATM    1  H1  ACE     1      -3.184  -2.429   1.330  1.00  0.00           H  
HETATM    2  CH3 ACE     1      -2.232  -2.219   0.784  1.00  0.00           C  
HETATM    3  H2  ACE     1      -2.107  -3.057   0.040  1.00  0.00           H  
HETATM    4  H3  ACE     1      -1.411  -2.338   1.578  1.00  0.00           H  
HETATM    5  C   ACE     1      -2.207  -0.898   0.120  1.00  0.00           C  
HETATM    6  O   ACE     1      -3.172  -0.161   0.461  1.00  0.00           O  
ATOM      7  N   VAL     2      -1.193  -0.424  -0.908  1.00  0.00           N  
ATOM      8  CA  VAL     2       0.169   0.258  -0.537  1.00  0.00           C  
ATOM      9  C   VAL     2       1.031  -0.384   0.459  1.00  0.00           C  
ATOM     10  O   VAL     2       1.038  -0.208   1.681  1.00  0.00           O  
ATOM     11  CB  VAL     2      -0.075   1.698   0.011  1.00  0.00           C  
ATOM     12  CG1 VAL     2      -0.974   1.718   1.206  1.00  0.00           C  
ATOM     13  CG2 VAL     2      -0.648   2.533  -1.166  1.00  0.00           C  
ATOM     14  H   VAL     2      -1.450  -0.469  -2.135  1.00  0.00           H  
ATOM     15  HA  VAL     2       0.800   0.452  -1.445  1.00  0.00           H  
ATOM     16  HB  VAL     2       0.906   2.104   0.248  1.00  0.00           H  
ATOM     17 HG11 VAL     2      -0.549   2.434   1.965  1.00  0.00           H  
ATOM     18 HG12 VAL     2      -1.042   0.765   1.764  1.00  0.00           H  
ATOM     19 HG13 VAL     2      -1.960   2.182   0.974  1.00  0.00           H  
ATOM     20 HG21 VAL     2      -1.697   2.249  -1.423  1.00  0.00           H  
ATOM     21 HG22 VAL     2      -0.553   3.593  -0.902  1.00  0.00           H  
ATOM     22 HG23 VAL     2       0.044   2.296  -2.036  1.00  0.00           H  
HETATM   23  N   NME     3       2.174  -1.574  -0.135  1.00  0.00           N  
HETATM   24  H   NME     3       1.632  -2.905   0.465  1.00  0.00           H  
HETATM   25  C   NME     3       3.749  -1.363  -0.068  1.00  0.00           C  
HETATM   26  H1  NME     3       3.860  -1.180   1.921  1.00  0.00           H  
HETATM   27  H2  NME     3       4.628  -2.565  -0.008  1.00  0.00           H  
HETATM   28  H3  NME     3       4.420  -0.106  -0.268  1.00  0.00           H  
TER      29      NME     3
END
"""


hid = """\
REMARK   1 PDBFIXER FROM: MainChain_HID.pdb                                                                                                 
REMARK   1 CREATED WITH OPENMM 7.7, 2023-01-19                                                                                              
CRYST1   48.000   48.000   48.000  90.00  90.00  90.00 P 1           1                                                                      
HETATM    1  H1  ACE     1      25.833  25.385  24.879  1.00  0.00           H                                                              
HETATM    2  CH3 ACE     1      25.917  26.309  24.308  1.00  0.00           C                                                              
HETATM    3  H2  ACE     1      25.232  27.053  24.711  1.00  0.00           H                                                              
HETATM    4  H3  ACE     1      25.682  26.115  23.263  1.00  0.00           H                                                              
HETATM    5  C   ACE     1      27.332  26.822  24.416  1.00  0.00           C                                                              
HETATM    6  O   ACE     1      28.152  26.229  25.104  1.00  0.00           O                                                              
ATOM      7  N   HIS     2      27.617  27.929  23.736  1.00  0.00           N                                                              
ATOM      8  H   HIS     2      26.883  28.379  23.211  1.00  0.00           H                                                              
ATOM      9  CA  HIS     2      28.927  28.585  23.730  1.00  0.00           C                                                              
ATOM     10  HA  HIS     2      29.384  28.462  24.713  1.00  0.00           H                                                              
ATOM     11  CB  HIS     2      29.832  27.896  22.692  1.00  0.00           C                                                              
ATOM     12  HB2 HIS     2      29.935  26.841  22.952  1.00  0.00           H                                                              
ATOM     13  HB3 HIS     2      29.357  27.955  21.711  1.00  0.00           H                                                              
ATOM     14  CG  HIS     2      31.208  28.502  22.594  1.00  0.00           C                                                              
ATOM     15  ND1 HIS     2      31.580  29.555  21.786  1.00  0.00           N                                                              
ATOM     16  HD1 HIS     2      31.000  30.010  21.097  1.00  0.00           H                                                              
ATOM     17  CE1 HIS     2      32.855  29.868  22.072  1.00  0.00           C                                                              
ATOM     18  HE1 HIS     2      33.429  30.653  21.595  1.00  0.00           H                                                              
ATOM     19  NE2 HIS     2      33.323  29.069  23.042  1.00  0.00           N                                                              
ATOM     20  CD2 HIS     2      32.287  28.194  23.379  1.00  0.00           C                                                              
ATOM     21  HD2 HIS     2      32.318  27.433  24.148  1.00  0.00           H                                                              
ATOM     22  C   HIS     2      28.782  30.093  23.464  1.00  0.00           C                                                              
ATOM     23  O   HIS     2      27.862  30.512  22.762  1.00  0.00           O                                                              
HETATM   24  N   NME     3      29.697  30.905  24.008  1.00  0.00           N                                                              
HETATM   25  H   NME     3      30.452  30.480  24.526  1.00  0.00           H                                                              
HETATM   26  C   NME     3      29.703  32.358  23.860  1.00  0.00           C                                                              
HETATM   27  H1  NME     3      28.776  32.774  24.261  1.00  0.00           H                                                              
HETATM   28  H2  NME     3      30.550  32.786  24.397  1.00  0.00           H                                                              
HETATM   29  H3  NME     3      29.775  32.623  22.804  1.00  0.00           H                                                              
TER      30      NME     3                                                                                                                                                                                                                                             
END
"""


hie = """\
REMARK   1 PDBFIXER FROM: MainChain_HIE.pdb                                                                                                 
REMARK   1 CREATED WITH OPENMM 7.7, 2023-01-19                                                                                              
CRYST1   48.000   48.000   48.000  90.00  90.00  90.00 P 1           1                                                                      
HETATM    1  H1  ACE     1      26.547  25.127  24.896  1.00  0.00           H                                                              
HETATM    2  CH3 ACE     1      26.384  26.111  24.459  1.00  0.00           C                                                              
HETATM    3  H2  ACE     1      25.722  26.691  25.099  1.00  0.00           H                                                              
HETATM    4  H3  ACE     1      25.944  26.005  23.469  1.00  0.00           H                                                              
HETATM    5  C   ACE     1      27.711  26.823  24.340  1.00  0.00           C                                                              
HETATM    6  O   ACE     1      28.742  26.269  24.700  1.00  0.00           O                                                              
ATOM      7  N   HIS     2      27.683  28.053  23.832  1.00  0.00           N                                                              
ATOM      8  H   HIS     2      26.789  28.464  23.600  1.00  0.00           H                                                              
ATOM      9  CA  HIS     2      28.855  28.930  23.709  1.00  0.00           C                                                              
ATOM     10  HA  HIS     2      29.478  28.792  24.595  1.00  0.00           H                                                              
ATOM     11  CB  HIS     2      29.680  28.525  22.472  1.00  0.00           C                                                              
ATOM     12  HB2 HIS     2      29.554  27.459  22.277  1.00  0.00           H                                                              
ATOM     13  HB3 HIS     2      29.319  29.064  21.595  1.00  0.00           H                                                              
ATOM     14  CG  HIS     2      31.158  28.778  22.644  1.00  0.00           C                                                              
ATOM     15  ND1 HIS     2      31.795  30.014  22.526  1.00  0.00           N                                                              
ATOM     16  CE1 HIS     2      33.088  29.791  22.803  1.00  0.00           C                                                              
ATOM     17  HE1 HIS     2      33.858  30.552  22.787  1.00  0.00           H                                                              
ATOM     18  NE2 HIS     2      33.286  28.498  23.110  1.00  0.00           N                                                              
ATOM     19  HE2 HIS     2      34.171  28.087  23.374  1.00  0.00           H                                                              
ATOM     20  CD2 HIS     2      32.078  27.843  23.019  1.00  0.00           C                                                              
ATOM     21  HD2 HIS     2      31.875  26.799  23.222  1.00  0.00           H                                                              
ATOM     22  C   HIS     2      28.427  30.408  23.673  1.00  0.00           C                                                              
ATOM     23  O   HIS     2      27.232  30.703  23.654  1.00  0.00           O                                                              
HETATM   24  N   NME     3      29.392  31.333  23.673  1.00  0.00           N                                                              
HETATM   25  H   NME     3      30.346  31.002  23.582  1.00  0.00           H                                                              
HETATM   26  C   NME     3      29.164  32.776  23.655  1.00  0.00           C                                                              
HETATM   27  H1  NME     3      28.275  33.023  24.241  1.00  0.00           H                                                              
HETATM   28  H2  NME     3      30.026  33.293  24.079  1.00  0.00           H                                                              
HETATM   29  H3  NME     3      29.012  33.109  22.627  1.00  0.00           H                                                              
TER      30      NME     3                                                                                                                                                                                                                                          
END   
"""


hip = """\
REMARK   1 PDBFIXER FROM: MainChain_HIP.pdb
REMARK   1 CREATED WITH OPENMM 7.7, 2023-01-19
CRYST1   48.000   48.000   48.000  90.00  90.00  90.00 P 1           1 
HETATM    1  H1  ACE     1      26.025  25.793  25.230  1.00  0.00           H  
HETATM    2  CH3 ACE     1      26.116  26.620  24.526  1.00  0.00           C  
HETATM    3  H2  ACE     1      25.418  27.407  24.805  1.00  0.00           H  
HETATM    4  H3  ACE     1      25.895  26.259  23.522  1.00  0.00           H  
HETATM    5  C   ACE     1      27.528  27.157  24.573  1.00  0.00           C  
HETATM    6  O   ACE     1      28.353  26.667  25.333  1.00  0.00           O  
ATOM      7  N   HIS     2      27.824  28.163  23.745  1.00  0.00           N  
ATOM      8  H   HIS     2      27.091  28.499  23.138  1.00  0.00           H  
ATOM      9  CA  HIS     2      29.164  28.765  23.637  1.00  0.00           C  
ATOM     10  HA  HIS     2      29.647  28.698  24.615  1.00  0.00           H  
ATOM     11  CB  HIS     2      30.006  27.920  22.653  1.00  0.00           C  
ATOM     12  HB2 HIS     2      30.017  26.885  23.004  1.00  0.00           H  
ATOM     13  HB3 HIS     2      29.518  27.922  21.676  1.00  0.00           H  
ATOM     14  CG  HIS     2      31.435  28.384  22.466  1.00  0.00           C  
ATOM     15  ND1 HIS     2      31.821  29.534  21.805  1.00  0.00           N  
ATOM     16  HD1 HIS     2      31.159  30.220  21.431  1.00  0.00           H  
ATOM     17  CE1 HIS     2      33.166  29.614  21.840  1.00  0.00           C  
ATOM     18  HE1 HIS     2      33.760  30.419  21.412  1.00  0.00           H  
ATOM     19  NE2 HIS     2      33.642  28.539  22.508  1.00  0.00           N  
ATOM     20  HE2 HIS     2      34.621  28.336  22.692  1.00  0.00           H  
ATOM     21  CD2 HIS     2      32.568  27.756  22.908  1.00  0.00           C  
ATOM     22  HD2 HIS     2      32.608  26.824  23.465  1.00  0.00           H  
ATOM     23  C   HIS     2      29.080  30.263  23.294  1.00  0.00           C  
ATOM     24  O   HIS     2      29.363  30.664  22.164  1.00  0.00           O  
HETATM   25  N   NME     3      28.702  31.081  24.284  1.00  0.00           N  
HETATM   26  H   NME     3      28.479  30.662  25.174  1.00  0.00           H  
HETATM   27  C   NME     3      28.589  32.539  24.180  1.00  0.00           C  
HETATM   28  H1  NME     3      27.543  32.826  24.055  1.00  0.00           H  
HETATM   29  H2  NME     3      28.972  33.008  25.088  1.00  0.00           H  
HETATM   30  H3  NME     3      29.160  32.914  23.328  1.00  0.00           H  
TER      31      NME     3
END
"""


def test_ala_ala():
    m = Chem.MolFromPDBBlock(ala_ala, proximityBonding=False, removeHs=False)

    m = pdbinf.assign_pdb_bonds(m, templates=[pdbinf.STANDARD_AA_DOC])

    assert m.GetNumAtoms() == 28
    assert m.GetNumBonds() == 27
    assert m.GetAtomWithIdx(0).GetFormalCharge() == 1


def test_cterm_ala_ala():
    m = Chem.MolFromPDBBlock(cterm_ala_ala, proximityBonding=False, removeHs=False)

    m = pdbinf.assign_pdb_bonds(m, templates=[pdbinf.STANDARD_AA_DOC])

    assert m.GetNumAtoms() == 27
    assert m.GetNumBonds() == 26
    assert m.GetAtomWithIdx(6).GetFormalCharge() == 0


def test_arg():
    m = Chem.MolFromPDBBlock(arg, proximityBonding=False, removeHs=False)

    m = pdbinf.assign_pdb_bonds(m, templates=[pdbinf.STANDARD_AA_DOC])

    assert m.GetNumAtoms() == 36
    assert m.GetNumBonds() == 35
    # atom 25 is assigned the double bond, so should have FC +1
    atom = m.GetAtomWithIdx(25)
    assert atom.GetFormalCharge() == 1
    assert any(b.GetBondType() == Chem.BondType.DOUBLE
               for b in atom.GetBonds())


def test_trp():
    m = Chem.MolFromPDBBlock(trp, proximityBonding=False, removeHs=False)

    m = pdbinf.assign_pdb_bonds(m, templates=[pdbinf.STANDARD_AA_DOC])

    assert m.GetNumAtoms() == 36
    assert m.GetNumBonds() == 37
    for at in m.GetAtoms():
        assert at.GetFormalCharge() == 0


def test_pro():
    m = Chem.MolFromPDBBlock(pro, proximityBonding=False, removeHs=False)

    m = pdbinf.assign_pdb_bonds(m, templates=[pdbinf.STANDARD_AA_DOC])

    assert m.GetNumAtoms() == 26
    assert m.GetNumBonds() == 26
    for at in m.GetAtoms():
        assert at.GetFormalCharge() == 0


def test_cys():
    m = Chem.MolFromPDBBlock(cys, proximityBonding=False, removeHs=False)

    m = pdbinf.assign_pdb_bonds(m, templates=[pdbinf.STANDARD_AA_DOC])

    assert m.GetNumAtoms() == 23
    assert m.GetNumBonds() == 22
    for at in m.GetAtoms():
        assert at.GetFormalCharge() == 0


def test_cyx():
    # has sulphur-sulphur bond
    m = Chem.MolFromPDBBlock(cyx, proximityBonding=False, removeHs=False)

    m = pdbinf.assign_pdb_bonds(m, templates=[pdbinf.STANDARD_AA_DOC])

    assert m.GetNumAtoms() == 44
    assert m.GetNumBonds() == 43
    # S-S bond, will return None if this bond does not exist
    assert m.GetBondBetweenAtoms(13, 35) is not None


def test_lys():
    m = Chem.MolFromPDBBlock(lys, proximityBonding=False, removeHs=False)

    m = pdbinf.assign_pdb_bonds(m, templates=[pdbinf.STANDARD_AA_DOC])

    assert m.GetNumAtoms() == 34
    assert m.GetNumBonds() == 33
    assert m.GetAtomWithIdx(14).GetFormalCharge() == 1


def test_asp():
    m = Chem.MolFromPDBBlock(asp, proximityBonding=False, removeHs=False)
    m = pdbinf.assign_pdb_bonds(m, templates=[pdbinf.STANDARD_AA_DOC])

    assert m.GetNumAtoms() == 25
    assert m.GetNumBonds() == 24


def test_asn():
    m = Chem.MolFromPDBBlock(asn, proximityBonding=False, removeHs=False)
    m = pdbinf.assign_pdb_bonds(m, templates=[pdbinf.STANDARD_AA_DOC])

    assert m.GetNumAtoms() == 26
    assert m.GetNumBonds() == 25


def test_glu():
    m = Chem.MolFromPDBBlock(glu, proximityBonding=False, removeHs=False)
    m = pdbinf.assign_pdb_bonds(m, templates=[pdbinf.STANDARD_AA_DOC])

    assert m.GetNumAtoms() == 28
    assert m.GetNumBonds() == 27


def test_gln():
    m = Chem.MolFromPDBBlock(gln, proximityBonding=False, removeHs=False)
    m = pdbinf.assign_pdb_bonds(m, templates=[pdbinf.STANDARD_AA_DOC])

    assert m.GetNumAtoms() == 29
    assert m.GetNumBonds() == 28


def test_gly():
    m = Chem.MolFromPDBBlock(gly, proximityBonding=False, removeHs=False)
    m = pdbinf.assign_pdb_bonds(m, templates=[pdbinf.STANDARD_AA_DOC])

    assert m.GetNumAtoms() == 19
    assert m.GetNumBonds() == 18


def test_ile():
    m = Chem.MolFromPDBBlock(ile, proximityBonding=False, removeHs=False)
    m = pdbinf.assign_pdb_bonds(m, templates=[pdbinf.STANDARD_AA_DOC])

    assert m.GetNumAtoms() == 31
    assert m.GetNumBonds() == 30


def test_leu():
    m = Chem.MolFromPDBBlock(ile, proximityBonding=False, removeHs=False)
    m = pdbinf.assign_pdb_bonds(m, templates=[pdbinf.STANDARD_AA_DOC])

    assert m.GetNumAtoms() == 31
    assert m.GetNumBonds() == 30


def test_met():
    m = Chem.MolFromPDBBlock(met, proximityBonding=False, removeHs=False)
    m = pdbinf.assign_pdb_bonds(m, templates=[pdbinf.STANDARD_AA_DOC])

    assert m.GetNumAtoms() == 29
    assert m.GetNumBonds() == 28


def test_phe():
    m = Chem.MolFromPDBBlock(phe, proximityBonding=False, removeHs=False)
    m = pdbinf.assign_pdb_bonds(m, templates=[pdbinf.STANDARD_AA_DOC])

    assert m.GetNumAtoms() == 32
    assert m.GetNumBonds() == 32


def test_ser():
    m = Chem.MolFromPDBBlock(ser, proximityBonding=False, removeHs=False)
    m = pdbinf.assign_pdb_bonds(m, templates=[pdbinf.STANDARD_AA_DOC])

    assert m.GetNumAtoms() == 23
    assert m.GetNumBonds() == 22


def test_thr():
    m = Chem.MolFromPDBBlock(thr, proximityBonding=False, removeHs=False)
    m = pdbinf.assign_pdb_bonds(m, templates=[pdbinf.STANDARD_AA_DOC])

    assert m.GetNumAtoms() == 26
    assert m.GetNumBonds() == 25


def test_tyr():
    m = Chem.MolFromPDBBlock(tyr, proximityBonding=False, removeHs=False)
    m = pdbinf.assign_pdb_bonds(m, templates=[pdbinf.STANDARD_AA_DOC])

    assert m.GetNumAtoms() == 33
    assert m.GetNumBonds() == 33


def test_val():
    m = Chem.MolFromPDBBlock(val, proximityBonding=False, removeHs=False)
    m = pdbinf.assign_pdb_bonds(m, templates=[pdbinf.STANDARD_AA_DOC])

    assert m.GetNumAtoms() == 28
    assert m.GetNumBonds() == 27


def test_hie():
    m = Chem.MolFromPDBBlock(hie, proximityBonding=False, removeHs=False)
    m = pdbinf.assign_pdb_bonds(m, templates=[pdbinf.STANDARD_AA_DOC])

    assert m.GetNumAtoms() == 29
    assert m.GetNumBonds() == 29
    for at in m.GetAtoms():
        assert at.GetFormalCharge() == 0


def test_hid():
    m = Chem.MolFromPDBBlock(hid, proximityBonding=False, removeHs=False)
    m = pdbinf.assign_pdb_bonds(m, templates=[pdbinf.STANDARD_AA_DOC])

    assert m.GetNumAtoms() == 29
    assert m.GetNumBonds() == 29
    for at in m.GetAtoms():
        assert at.GetFormalCharge() == 0


def test_hip():
    m = Chem.MolFromPDBBlock(hip, proximityBonding=False, removeHs=False)
    m = pdbinf.assign_pdb_bonds(m, templates=[pdbinf.STANDARD_AA_DOC])

    assert m.GetNumAtoms() == 30
    assert m.GetNumBonds() == 30
    for i, at in enumerate(m.GetAtoms()):
        if i == 14:
            assert at.GetMonomerInfo().GetName().strip() == 'ND1'
            assert at.GetFormalCharge() == 1
        else:
            assert at.GetFormalCharge() == 0


def test_file_entrypoint(tmpdir):
    # all above tests aren't using files, so write a file to check that works
    f = str(tmpdir / 'foo.pdb')

    with open(f, 'w') as out:
        out.write(hip)

    m = pdbinf.load_pdb_file(f, templates=[pdbinf.STANDARD_AA_DOC])

    assert m.GetNumAtoms() == 30
    assert m.GetNumBonds() == 30
