import os

def getTorPathFile():
    if os.sys.platform == 'win32':
        if os.path.isdir(os.path.join(os.environ['USERPROFILE'], 'Desktop', r'Tor Browser')):
            return os.path.join(os.environ['USERPROFILE'], 'Desktop', r'Tor Browser\Browser\TorBrowser\Tor\tor.exe')
    else:
        for x in os.environ['PATH'].split(':'):
            if os.path.isfile(os.path.join(x, 'tor')):
                return 'tor'
    return ''

def getProfilePath():
    if os.sys.platform == 'win32':
        if os.path.isdir(os.path.join(os.environ['USERPROFILE'], 'Desktop', r'Tor Browser')):
            return os.path.join(os.environ['USERPROFILE'], 'Desktop', r'Tor Browser\Browser\TorBrowser\Data\Browser\profile.default')
    else:
        return ''

Settings = {
    'USER_AGENTS' : ["Mozilla/5.0 (iPhone; CPU iPhone OS 13_3 like Mac O…3; en_US; en-US; scale=2.00; 828x1792; 190542906)", "Mozilla/5.0 (iPhone; CPU iPhone OS 13_3 like Mac O…3; en_US; en-US; scale=2.00; 828x1792; 188362626)", "Mozilla/5.0 (iPhone; CPU iPhone OS 13_3 like Mac O…3; en_US; en-US; scale=2.00; 828x1792; 190542906)", "Mozilla/5.0 (iPhone; CPU iPhone OS 13_3 like Mac O…; en_US; en-US; scale=3.00; 1242x2688; 190542906)", "Mozilla/5.0 (iPhone; CPU iPhone OS 13_3 like Mac O…3; en_US; en-US; scale=2.00; 828x1792; 192646147)", "Mozilla/5.0 (iPhone; CPU iPhone OS 13_3 like Mac O…; en_US; en-US; scale=2.61; 1080x1920; 190542906)", "Mozilla/5.0 (iPhone; CPU iPhone OS 13_3 like Mac O…3; en_US; en-US; scale=2.00; 750x1334; 190542906)", "Mozilla/5.0 (Linux; Android 8.1.0; motorola one Bu…otorola one; deen_sprout; qcom; pt_BR; 132081645)", "Mozilla/5.0 (Linux; Android 7.0; Lenovo K33b36 Bui…o; Lenovo K33b36; K33b36; qcom; pt_BR; 103516666)", "Mozilla/5.0 (iPhone; CPU iPhone OS 13_3 like Mac O…; en_US; en-US; scale=2.61; 1080x1920; 190542906)", "Mozilla/5.0 (iPhone; CPU iPhone OS 13_3 like Mac O…3; en_US; en-US; scale=2.00; 750x1334; 190542906)", "Mozilla/5.0 (iPhone; CPU iPhone OS 13_3 like Mac O…; en_US; en-US; scale=3.00; 1125x2436; 193828684)", "Mozilla/5.0 (iPhone; CPU iPhone OS 13_3 like Mac O…; en_US; en-US; scale=3.00; 1125x2436; 190542906)", "Mozilla/5.0 (iPhone; CPU iPhone OS 13_3 like Mac O…3; en_US; en-US; scale=2.00; 828x1792; 188362626)", "Mozilla/5.0 (Linux; Android 5.0.1; LG-H342 Build/L…LGE/lge; LG-H342; c50ds; c50ds; pt_BR; 102221277)", "Mozilla/5.0 (Linux; Android 6.0.1; SM-G610M Build/…M; on7xelte; samsungexynos7870; pt_BR; 103516666)", "Mozilla/5.0 (iPhone; CPU iPhone OS 13_3 like Mac O…3; en_US; en-US; scale=2.00; 750x1334; 190542906)", "Mozilla/5.0 (iPhone; CPU iPhone OS 13_3 like Mac O…; en_US; en-US; scale=2.61; 1080x1920; 194985111)", "Mozilla/5.0 (Linux; Android 8.0.0; SM-A520F Build/…F; a5y17lte; samsungexynos7880; pt_BR; 109556226)", "Mozilla/5.0 (iPhone; CPU iPhone OS 13_3 like Mac O…; en_US; en-US; scale=3.00; 1242x2688; 190542906)", "Mozilla/5.0 (iPhone; CPU iPhone OS 13_3 like Mac O…3; en_US; en-US; scale=2.00; 828x1792; 192646147)", "Mozilla/5.0 (Linux; Android 6.0.1; SM-J700M Build/…00M; j7elte; samsungexynos7580; pt_BR; 133633069)", "Mozilla/5.0 (iPhone; CPU iPhone OS 13_3 like Mac O…3; en_US; en-US; scale=2.00; 828x1792; 193828684)", "Mozilla/5.0 (Linux; Android 6.0.1; ZUK Z2131 Build… ZUK; ZUK Z2131; z2_plus; qcom; pt_BR; 123790722)", "Mozilla/5.0 (Linux; Android 7.0; SM-G610M Build/NR…M; on7xelte; samsungexynos7870; es_US; 126223536)", "Mozilla/5.0 (Linux; Android 8.1.0; SM-J530G Build/…G; j5y17lte; samsungexynos7870; pt_BR; 127049016)", "Mozilla/5.0 (Linux; Android 7.0; SM-G610M Build/NR…M; on7xelte; samsungexynos7870; pt_BR; 123790722)", "Mozilla/5.0 (Linux; Android 7.0; SM-G610M Build/NR…M; on7xelte; samsungexynos7870; pt_BR; 115211364)", "Mozilla/5.0 (Linux; Android 5.1.1; Lenovo A6020l36…enovo A6020l36; A6020l36; qcom; pt_BR; 108357722)", "Mozilla/5.0 (iPhone; CPU iPhone OS 13_3 like Mac O…; en_US; en-US; scale=3.00; 1242x2688; 188362626)", "Mozilla/5.0 (Linux; Android 7.0; SM-G935F Build/NR…F; hero2lte; samsungexynos8890; pt_BR; 119875229)", "Mozilla/5.0 (Linux; Android 7.0; SM-A910F Build/NR…; SM-A910F; a9xproltesea; qcom; pt_BR; 118342010)", "Mozilla/5.0 (Linux; Android 7.0; SM-G610M Build/NR…M; on7xelte; samsungexynos7870; pt_BR; 119104802)", "Mozilla/5.0 (Linux; Android 7.0; SM-J730G Build/NR…G; j7y17lte; samsungexynos7870; pt_BR; 109556226)", "Mozilla/5.0 (iPhone; CPU iPhone OS 13_3 like Mac O…; en_US; en-US; scale=2.61; 1080x1920; 190542906)", "Mozilla/5.0 (Linux; Android 7.1.1; Moto G (5S) Plu… G (5S) Plus; sanders_nt; qcom; pt_PT; 119104802)", "Mozilla/5.0 (Linux; Android 7.0; SM-G570M Build/NR…M; on5xelte; samsungexynos7570; es_US; 126223520)", "Mozilla/5.0 (iPhone; CPU iPhone OS 12_0_1 like Mac…R; scale=2.00; gamut=normal; 750x1334; 124976489)", "Mozilla/5.0 (iPhone; CPU iPhone OS 13_3 like Mac O…; en_US; en-US; scale=3.00; 1125x2436; 190542906)", "Mozilla/5.0 (Linux; Android 7.0; Lenovo K33b36 Bui…o; Lenovo K33b36; K33b36; qcom; pt_BR; 103516666)", "Mozilla/5.0 (iPhone; CPU iPhone OS 13_3 like Mac O…3; en_US; en-US; scale=2.00; 750x1334; 190542906)", "Mozilla/5.0 (Linux; Android 6.0.1; ASUS_Z00UD Buil… ASUS_Z00UD; ASUS_Z00U_1; qcom; pt_BR; 115211364)", "Mozilla/5.0 (Linux; Android 7.0; Moto G (5) Build/…rola; Moto G (5); cedric; qcom; pt_BR; 103516666)", "Mozilla/5.0 (Linux; Android 7.0; SM-G935F Build/NR…F; hero2lte; samsungexynos8890; pt_BR; 118342010)", "Mozilla/5.0 (iPhone; CPU iPhone OS 13_3 like Mac O…3; en_US; en-US; scale=2.00; 828x1792; 194985111)", "Mozilla/5.0 (Linux; Android 8.1.0; ASUS_X00LD Buil…ASUS_X00LD; ASUS_X00LD_1; qcom; pt_BR; 132081645)", "Mozilla/5.0 (Linux; Android 7.0; Moto G (5) Build/…orola; Moto G (5); cedric; qcom; pt_BR; 98288242)", "Mozilla/5.0 (iPhone; CPU iPhone OS 13_3 like Mac O…; en_US; en-US; scale=2.61; 1080x1920; 188362626)", "Mozilla/5.0 (iPhone; CPU iPhone OS 13_1_3 like Mac…3; en_US; en-US; scale=2.00; 828x1792; 185888820)", "Mozilla/5.0 (Linux; Android 8.1.0; Moto G (5) Buil…rola; Moto G (5); cedric; qcom; pt_BR; 128676156)"],
    'PROFILE_PATH' : getProfilePath(),
    'TOR' : getTorPathFile(),
    'GECKO_DRIVER' : 'geckodriver',
}