from collections.abc import Callable, Iterable, Iterator
from io import BytesIO
from re import Pattern
from typing import TypeVar, overload

from django.db.models.base import Model
from django.utils.functional import SimpleLazyObject, _StrOrPromise
from django.utils.safestring import SafeString

_StrOrPromiseT = TypeVar("_StrOrPromiseT", bound=_StrOrPromise)

def capfirst(x: _StrOrPromiseT | None) -> _StrOrPromiseT | None: ...

re_words: Pattern[str]
re_chars: Pattern[str]
re_tag: Pattern[str]
re_newlines: Pattern[str]
re_camel_case: Pattern[str]

def wrap(text: _StrOrPromiseT, width: int) -> _StrOrPromiseT: ...

class Truncator(SimpleLazyObject):
    def __init__(self, text: Model | str) -> None: ...
    def add_truncation_text(self, text: str, truncate: str | None = ...) -> str: ...
    def chars(self, num: int, truncate: str | None = ..., html: bool = ...) -> str: ...
    def words(self, num: int, truncate: str | None = ..., html: bool = ...) -> str: ...

def get_valid_filename(name: _StrOrPromiseT) -> _StrOrPromiseT: ...
@overload
def get_text_list(list_: list[str], last_word: str = ...) -> str: ...
@overload
def get_text_list(list_: list[_StrOrPromise], last_word: _StrOrPromise = ...) -> _StrOrPromise: ...
def normalize_newlines(text: _StrOrPromiseT) -> _StrOrPromiseT: ...
def phone2numeric(phone: _StrOrPromiseT) -> _StrOrPromiseT: ...
def compress_string(s: bytes) -> bytes: ...

class StreamingBuffer(BytesIO):
    vals: list[bytes]
    def read(self) -> bytes: ...  # type: ignore

def compress_sequence(sequence: Iterable[bytes]) -> Iterator[bytes]: ...

smart_split_re: Pattern[str]

def smart_split(text: str) -> Iterator[str]: ...
def unescape_entities(text: _StrOrPromiseT) -> _StrOrPromiseT: ...
def unescape_string_literal(s: _StrOrPromiseT) -> _StrOrPromiseT: ...
def slugify(value: _StrOrPromiseT, allow_unicode: bool = ...) -> _StrOrPromiseT: ...
def camel_case_to_spaces(value: str) -> str: ...

format_lazy: Callable[..., str]
