from collections.abc import Iterable, Iterator, Mapping, Sequence
from typing import Any, ClassVar

from django.core.exceptions import ValidationError as ValidationError
from django.forms.boundfield import BoundField
from django.forms.fields import Field
from django.forms.renderers import BaseRenderer
from django.forms.utils import ErrorDict, ErrorList, _DataT, _FilesT
from django.forms.widgets import Media, MediaDefiningClass
from django.utils.functional import _StrOrPromise
from django.utils.safestring import SafeString

class DeclarativeFieldsMetaclass(MediaDefiningClass): ...

class BaseForm:
    class Meta:
        fields: Sequence[str]
    default_renderer: BaseRenderer | type[BaseRenderer] | None
    field_order: Iterable[str] | None
    use_required_attribute: bool
    is_bound: bool
    data: _DataT
    files: _FilesT
    auto_id: bool | str
    initial: Mapping[str, Any]
    error_class: type[ErrorList]
    prefix: str | None
    label_suffix: str
    empty_permitted: bool
    fields: dict[str, Field]
    renderer: BaseRenderer
    cleaned_data: dict[str, Any]
    def __init__(
        self,
        data: _DataT | None = ...,
        files: _FilesT | None = ...,
        auto_id: bool | str = ...,
        prefix: str | None = ...,
        initial: Mapping[str, Any] | None = ...,
        error_class: type[ErrorList] = ...,
        label_suffix: str | None = ...,
        empty_permitted: bool = ...,
        field_order: Iterable[str] | None = ...,
        use_required_attribute: bool | None = ...,
        renderer: BaseRenderer | None = ...,
    ) -> None: ...
    def order_fields(self, field_order: Iterable[str] | None) -> None: ...
    def __iter__(self) -> Iterator[BoundField]: ...
    def __getitem__(self, name: str) -> BoundField: ...
    @property
    def errors(self) -> ErrorDict: ...
    def is_valid(self) -> bool: ...
    def add_prefix(self, field_name: str) -> str: ...
    def add_initial_prefix(self, field_name: str) -> str: ...
    def as_table(self) -> SafeString: ...
    def as_ul(self) -> SafeString: ...
    def as_p(self) -> SafeString: ...
    def non_field_errors(self) -> ErrorList: ...
    def add_error(self, field: str | None, error: ValidationError | _StrOrPromise) -> None: ...
    def has_error(self, field: str | None, code: str | None = ...) -> bool: ...
    def full_clean(self) -> None: ...
    def clean(self) -> dict[str, Any] | None: ...
    def has_changed(self) -> bool: ...
    @property
    def changed_data(self) -> list[str]: ...
    @property
    def media(self) -> Media: ...
    def is_multipart(self) -> bool: ...
    def hidden_fields(self) -> list[BoundField]: ...
    def visible_fields(self) -> list[BoundField]: ...
    def get_initial_for_field(self, field: Field, field_name: str) -> Any: ...
    def _html_output(
        self,
        normal_row: str,
        error_row: str,
        row_ender: str,
        help_text_html: str,
        errors_on_separate_row: bool,
    ) -> SafeString: ...

class Form(BaseForm):
    base_fields: ClassVar[dict[str, Field]]
    declared_fields: ClassVar[dict[str, Field]]
