from collections.abc import Sequence
from typing import Any

from django.contrib.gis.gdal.driver import Driver
from django.contrib.gis.gdal.raster.band import BandList
from django.contrib.gis.gdal.raster.base import GDALRasterBase
from django.contrib.gis.gdal.srs import SpatialReference

class TransformPoint(list[Sequence[float]]):
    indices: dict[str, tuple[int, int]]
    def __init__(self, raster: GDALRaster, prop: str) -> None: ...
    @property
    def x(self) -> float: ...
    @x.setter
    def x(self, value: float) -> None: ...
    @property
    def y(self) -> float: ...
    @y.setter
    def y(self, value: float) -> None: ...

class GDALRaster(GDALRasterBase):
    destructor: Any
    def __init__(self, ds_input: Any, write: bool = ...) -> None: ...
    def __del__(self) -> None: ...
    @property
    def vsi_buffer(self) -> bytes | None: ...
    @property
    def is_vsi_based(self) -> bool: ...
    @property
    def name(self) -> str: ...
    @property
    def driver(self) -> Driver: ...
    @property
    def width(self) -> int: ...
    @property
    def height(self) -> int: ...
    @property
    def srs(self) -> SpatialReference | None: ...
    @srs.setter
    def srs(self, value: SpatialReference | int | str) -> None: ...
    @property
    def srid(self) -> int: ...
    @srid.setter
    def srid(self, value: int) -> None: ...
    @property
    def geotransform(self) -> list[float]: ...
    @geotransform.setter
    def geotransform(self, values: list[float]) -> None: ...
    @property
    def origin(self) -> TransformPoint: ...
    @property
    def scale(self) -> TransformPoint: ...
    @property
    def skew(self) -> TransformPoint: ...
    @property
    def extent(self) -> tuple[float, float, float, float]: ...
    @property
    def bands(self) -> BandList: ...
    def warp(self, ds_input: Any, resampling: str = ..., max_error: float = ...) -> GDALRaster: ...
    def transform(
        self,
        srs: SpatialReference | int | str,
        driver: Any | None = ...,
        name: str | None = ...,
        resampling: str = ...,
        max_error: float = ...,
    ) -> GDALRaster: ...
    @property
    def info(self) -> str: ...
