# Generated by Django 5.2.7 on 2025-10-25 02:36

import django.db.models.deletion
import mojo.models.rest
from django.conf import settings
from django.db import migrations, models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('account', '0023_rename_account_geo_is_mobi_8a7c2e_idx_account_geo_is_mobi_06bfa8_idx_and_more'),
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name='PhoneConfig',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('mojo_secrets', models.TextField(blank=True, default=None, null=True)),
                ('created', models.DateTimeField(auto_now_add=True, db_index=True)),
                ('modified', models.DateTimeField(auto_now=True, db_index=True)),
                ('name', models.CharField(help_text='Configuration name', max_length=100)),
                ('is_active', models.BooleanField(db_index=True, default=True)),
                ('provider', models.CharField(choices=[('twilio', 'Twilio'), ('aws', 'AWS SNS')], db_index=True, default='twilio', max_length=20)),
                ('twilio_from_number', models.CharField(blank=True, help_text='Twilio phone number for sending SMS', max_length=20, null=True)),
                ('aws_region', models.CharField(default='us-east-1', help_text='AWS region for SNS', max_length=20)),
                ('aws_sender_id', models.CharField(blank=True, help_text='AWS SNS sender ID (optional)', max_length=11, null=True)),
                ('lookup_enabled', models.BooleanField(db_index=True, default=True, help_text='Enable phone number lookups')),
                ('lookup_cache_days', models.IntegerField(default=90, help_text='Days to cache lookup results before re-lookup')),
                ('test_mode', models.BooleanField(db_index=True, default=False, help_text="Enable test mode - don't send real SMS")),
                ('group', models.OneToOneField(blank=True, help_text='Organization for this config. Null = system default', null=True, on_delete=django.db.models.deletion.CASCADE, related_name='phone_config', to='account.group')),
            ],
            options={
                'ordering': ['group__name', 'name'],
            },
            bases=(models.Model, mojo.models.rest.MojoModel),
        ),
        migrations.CreateModel(
            name='PhoneNumber',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', models.DateTimeField(auto_now_add=True, db_index=True)),
                ('modified', models.DateTimeField(auto_now=True, db_index=True)),
                ('phone_number', models.CharField(db_index=True, help_text='E.164 formatted phone number (+1234567890)', max_length=20, unique=True)),
                ('country_code', models.CharField(db_index=True, help_text='Country code (e.g., US, CA, GB)', max_length=5)),
                ('carrier', models.CharField(blank=True, help_text='Carrier/operator name', max_length=100, null=True)),
                ('line_type', models.CharField(blank=True, db_index=True, help_text='mobile, landline, voip, etc.', max_length=20, null=True)),
                ('is_mobile', models.BooleanField(db_index=True, default=False)),
                ('is_voip', models.BooleanField(db_index=True, default=False)),
                ('is_valid', models.BooleanField(db_index=True, default=True, help_text='Whether phone number is valid/reachable')),
                ('registered_owner', models.CharField(blank=True, db_index=True, help_text='Registered owner/caller name from carrier', max_length=200, null=True)),
                ('owner_type', models.CharField(blank=True, help_text='BUSINESS or CONSUMER', max_length=50, null=True)),
                ('address_line1', models.CharField(blank=True, max_length=200, null=True)),
                ('address_city', models.CharField(blank=True, max_length=100, null=True)),
                ('address_state', models.CharField(blank=True, max_length=50, null=True)),
                ('address_zip', models.CharField(blank=True, max_length=20, null=True)),
                ('address_country', models.CharField(blank=True, max_length=5, null=True)),
                ('lookup_provider', models.CharField(blank=True, help_text='twilio or aws', max_length=20, null=True)),
                ('lookup_data', models.JSONField(blank=True, default=dict, help_text='Raw lookup response data')),
                ('lookup_expires_at', models.DateTimeField(db_index=True, help_text='When to re-lookup this number')),
                ('lookup_count', models.IntegerField(default=0, help_text='Number of times this number has been looked up')),
                ('last_lookup_at', models.DateTimeField(blank=True, help_text='Last successful lookup timestamp', null=True)),
            ],
            options={
                'ordering': ['-created'],
                'indexes': [models.Index(fields=['phone_number'], name='phonehub_ph_phone_n_812166_idx'), models.Index(fields=['lookup_expires_at', 'is_valid'], name='phonehub_ph_lookup__73427e_idx'), models.Index(fields=['registered_owner'], name='phonehub_ph_registe_188d2b_idx')],
            },
            bases=(models.Model, mojo.models.rest.MojoModel),
        ),
        migrations.CreateModel(
            name='SMS',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', models.DateTimeField(auto_now_add=True, db_index=True)),
                ('modified', models.DateTimeField(auto_now=True, db_index=True)),
                ('direction', models.CharField(choices=[('outbound', 'Outbound'), ('inbound', 'Inbound')], db_index=True, help_text='Message direction', max_length=10)),
                ('from_number', models.CharField(db_index=True, help_text='Sender phone number (E.164 format)', max_length=20)),
                ('to_number', models.CharField(db_index=True, help_text='Recipient phone number (E.164 format)', max_length=20)),
                ('body', models.TextField(help_text='SMS message body')),
                ('status', models.CharField(choices=[('queued', 'Queued'), ('sending', 'Sending'), ('sent', 'Sent'), ('delivered', 'Delivered'), ('failed', 'Failed'), ('undelivered', 'Undelivered'), ('received', 'Received')], db_index=True, default='queued', max_length=20)),
                ('provider', models.CharField(blank=True, help_text='twilio or aws', max_length=20, null=True)),
                ('provider_message_id', models.CharField(blank=True, db_index=True, help_text="Provider's message ID", max_length=100, null=True)),
                ('error_code', models.CharField(blank=True, max_length=50, null=True)),
                ('error_message', models.TextField(blank=True, null=True)),
                ('metadata', models.JSONField(blank=True, default=dict, help_text='Additional metadata (webhooks, callbacks, etc.)')),
                ('is_test', models.BooleanField(db_index=True, default=False, help_text='Whether this was sent in test mode')),
                ('sent_at', models.DateTimeField(blank=True, db_index=True, help_text='When message was sent to provider', null=True)),
                ('delivered_at', models.DateTimeField(blank=True, help_text='When message was delivered to recipient', null=True)),
                ('group', models.ForeignKey(blank=True, help_text='Organization for this SMS', null=True, on_delete=django.db.models.deletion.CASCADE, related_name='sms_messages', to='account.group')),
                ('user', models.ForeignKey(blank=True, help_text='User associated with this SMS', null=True, on_delete=django.db.models.deletion.CASCADE, related_name='sms_messages', to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'verbose_name': 'SMS',
                'verbose_name_plural': 'SMS Messages',
                'ordering': ['-created'],
                'indexes': [models.Index(fields=['-created', 'direction'], name='phonehub_sm_created_a86926_idx'), models.Index(fields=['to_number', '-created'], name='phonehub_sm_to_numb_931375_idx'), models.Index(fields=['from_number', '-created'], name='phonehub_sm_from_nu_4a16f9_idx'), models.Index(fields=['status', '-created'], name='phonehub_sm_status_397277_idx'), models.Index(fields=['provider_message_id'], name='phonehub_sm_provide_df1158_idx')],
            },
            bases=(models.Model, mojo.models.rest.MojoModel),
        ),
    ]
