# Generated by Django 4.2.21 on 2025-06-07 13:32

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion
import mojo.models.rest


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('account', '0003_group_mojo_secrets_user_mojo_secrets'),
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name='FileManager',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('mojo_secrets', models.TextField(blank=True, default=None, null=True)),
                ('created', models.DateTimeField(auto_now_add=True, db_index=True)),
                ('modified', models.DateTimeField(auto_now=True)),
                ('name', models.CharField(db_index=True, help_text='Descriptive name for this file manager configuration', max_length=255)),
                ('description', models.TextField(blank=True, default='', help_text="Optional description of this file manager's purpose")),
                ('backend_type', models.CharField(choices=[('file', 'File System'), ('s3', 'AWS S3'), ('azure', 'Azure Blob Storage'), ('gcs', 'Google Cloud Storage'), ('custom', 'Custom Backend')], db_index=True, help_text='Type of storage backend (file, s3, azure, gcs, custom)', max_length=32)),
                ('backend_url', models.CharField(help_text='Base URL or connection string for the storage backend', max_length=500)),
                ('supports_direct_upload', models.BooleanField(default=False, help_text='Whether this backend supports direct upload (pre-signed URLs)')),
                ('max_file_size', models.BigIntegerField(default=104857600, help_text='Maximum file size in bytes (0 for unlimited)')),
                ('allowed_extensions', models.JSONField(blank=True, default=list, help_text='List of allowed file extensions (empty for all)')),
                ('allowed_mime_types', models.JSONField(blank=True, default=list, help_text='List of allowed MIME types (empty for all)')),
                ('is_active', models.BooleanField(default=True, help_text='Whether this file manager is active and can be used')),
                ('is_default', models.BooleanField(default=False, help_text='Whether this is the default file manager for the group or user')),
                ('group', models.ForeignKey(blank=True, default=None, help_text='Group that owns this file manager configuration', null=True, on_delete=django.db.models.deletion.CASCADE, related_name='file_managers', to='account.group')),
                ('user', models.ForeignKey(blank=True, default=None, help_text='User that owns this file manager configuration', null=True, on_delete=django.db.models.deletion.CASCADE, related_name='file_managers', to=settings.AUTH_USER_MODEL)),
            ],
            bases=(models.Model, mojo.models.rest.MojoModel),
        ),
        migrations.CreateModel(
            name='File',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', models.DateTimeField(auto_now_add=True, db_index=True)),
                ('modified', models.DateTimeField(auto_now=True)),
                ('filename', models.CharField(db_index=True, help_text='Final filename used for storage', max_length=255)),
                ('original_filename', models.CharField(help_text='Original filename as uploaded by user', max_length=255)),
                ('file_path', models.TextField(help_text='Full path to file in storage backend')),
                ('file_size', models.BigIntegerField(blank=True, help_text='File size in bytes', null=True)),
                ('content_type', models.CharField(db_index=True, help_text='MIME type of the file', max_length=255)),
                ('checksum', models.CharField(blank=True, default='', help_text='File checksum (MD5, SHA256, etc.)', max_length=128)),
                ('upload_token', models.CharField(db_index=True, help_text='Unique token for tracking direct uploads', max_length=64, unique=True)),
                ('upload_status', models.CharField(choices=[('pending', 'Pending Upload'), ('uploading', 'Uploading'), ('completed', 'Upload Completed'), ('failed', 'Upload Failed'), ('expired', 'Upload Expired')], db_index=True, default='pending', help_text='Current status of the file upload', max_length=32)),
                ('upload_url', models.TextField(blank=True, default='', help_text='Pre-signed URL for direct upload (temporary)')),
                ('upload_expires_at', models.DateTimeField(blank=True, help_text='When the upload URL expires', null=True)),
                ('metadata', models.JSONField(blank=True, default=dict, help_text='Additional file metadata and custom properties')),
                ('is_active', models.BooleanField(default=True, help_text='Whether this file is active and accessible')),
                ('is_public', models.BooleanField(default=False, help_text='Whether this file can be accessed without authentication')),
                ('file_manager', models.ForeignKey(help_text='File manager configuration used for this file', on_delete=django.db.models.deletion.CASCADE, related_name='files', to='fileman.filemanager')),
                ('group', models.ForeignKey(blank=True, default=None, help_text='Group that owns this file', null=True, on_delete=django.db.models.deletion.CASCADE, related_name='files', to='account.group')),
                ('uploaded_by', models.ForeignKey(blank=True, default=None, help_text='User who uploaded this file', null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='uploaded_files', to=settings.AUTH_USER_MODEL)),
            ],
            bases=(models.Model, mojo.models.rest.MojoModel),
        ),
        migrations.AddIndex(
            model_name='filemanager',
            index=models.Index(fields=['backend_type', 'is_active'], name='fileman_fil_backend_d27c68_idx'),
        ),
        migrations.AddIndex(
            model_name='filemanager',
            index=models.Index(fields=['group', 'is_default'], name='fileman_fil_group_i_c1c47d_idx'),
        ),
        migrations.AddIndex(
            model_name='filemanager',
            index=models.Index(fields=['user', 'is_default'], name='fileman_fil_user_id_525e54_idx'),
        ),
        migrations.AddIndex(
            model_name='filemanager',
            index=models.Index(fields=['group', 'backend_type'], name='fileman_fil_group_i_3f1fc6_idx'),
        ),
        migrations.AlterUniqueTogether(
            name='filemanager',
            unique_together={('group', 'name')},
        ),
        migrations.AddIndex(
            model_name='file',
            index=models.Index(fields=['upload_status', 'created'], name='fileman_fil_upload__64e176_idx'),
        ),
        migrations.AddIndex(
            model_name='file',
            index=models.Index(fields=['file_manager', 'upload_status'], name='fileman_fil_file_ma_765f1a_idx'),
        ),
        migrations.AddIndex(
            model_name='file',
            index=models.Index(fields=['group', 'is_active'], name='fileman_fil_group_i_4d4a8a_idx'),
        ),
        migrations.AddIndex(
            model_name='file',
            index=models.Index(fields=['content_type', 'is_active'], name='fileman_fil_content_c5b4a6_idx'),
        ),
        migrations.AddIndex(
            model_name='file',
            index=models.Index(fields=['upload_expires_at'], name='fileman_fil_upload__c4bc35_idx'),
        ),
    ]
