# Generated by Django 4.2.21 on 2025-08-27 18:23

from django.db import migrations, models
import django.db.models.deletion
import mojo.models.rest


class Migration(migrations.Migration):

    initial = True

    dependencies = [
    ]

    operations = [
        migrations.CreateModel(
            name='EmailAttachment',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', models.DateTimeField(auto_now_add=True)),
                ('modified', models.DateTimeField(auto_now=True, db_index=True)),
                ('filename', models.CharField(blank=True, help_text='Original filename (if provided by the sender)', max_length=512, null=True)),
                ('content_type', models.CharField(blank=True, help_text='MIME content type (e.g., application/pdf)', max_length=255, null=True)),
                ('size_bytes', models.IntegerField(default=0, help_text='Size of the stored attachment in bytes (approximate)')),
                ('stored_as', models.CharField(help_text='Storage reference (e.g., s3://bucket/key)', max_length=512)),
                ('metadata', models.JSONField(blank=True, default=dict, help_text='Arbitrary metadata (e.g., content-id, part headers)')),
            ],
            options={
                'db_table': 'aws_email_attachment',
                'ordering': ['-created', 'id'],
            },
            bases=(models.Model, mojo.models.rest.MojoModel),
        ),
        migrations.CreateModel(
            name='EmailDomain',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('mojo_secrets', models.TextField(blank=True, default=None, null=True)),
                ('created', models.DateTimeField(auto_now_add=True)),
                ('modified', models.DateTimeField(auto_now=True, db_index=True)),
                ('name', models.CharField(db_index=True, max_length=255, unique=True)),
                ('region', models.CharField(default='us-west-2', help_text='AWS region for SES operations', max_length=64)),
                ('status', models.CharField(db_index=True, default='pending', help_text='High-level status: pending, verified, error (free-form)', max_length=32)),
                ('receiving_enabled', models.BooleanField(default=False, help_text='When true, domain-level catch-all receiving is enabled via SES receipt rules')),
                ('s3_inbound_bucket', models.CharField(blank=True, help_text='S3 bucket for inbound emails (required if receiving_enabled)', max_length=255, null=True)),
                ('s3_inbound_prefix', models.CharField(blank=True, default='', help_text='S3 prefix for inbound emails (e.g., inbound/example.com/)', max_length=255)),
                ('dns_mode', models.CharField(default='manual', help_text='DNS automation mode: manual | route53 | godaddy', max_length=32)),
                ('sns_topic_bounce_arn', models.CharField(blank=True, help_text='SNS topic ARN for SES bounce notifications', max_length=512, null=True)),
                ('sns_topic_complaint_arn', models.CharField(blank=True, help_text='SNS topic ARN for SES complaint notifications', max_length=512, null=True)),
                ('sns_topic_delivery_arn', models.CharField(blank=True, help_text='SNS topic ARN for SES delivery notifications', max_length=512, null=True)),
                ('sns_topic_inbound_arn', models.CharField(blank=True, help_text='SNS topic ARN for SES inbound notifications', max_length=512, null=True)),
                ('metadata', models.JSONField(blank=True, default=dict)),
            ],
            options={
                'db_table': 'aws_email_domain',
                'ordering': ['name'],
            },
            bases=(models.Model, mojo.models.rest.MojoModel),
        ),
        migrations.CreateModel(
            name='Mailbox',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', models.DateTimeField(auto_now_add=True)),
                ('modified', models.DateTimeField(auto_now=True, db_index=True)),
                ('email', models.EmailField(db_index=True, help_text='Full email address for this mailbox (e.g., support@example.com)', max_length=254, unique=True)),
                ('allow_inbound', models.BooleanField(default=True, help_text='If true, inbound messages addressed to this mailbox will be processed')),
                ('allow_outbound', models.BooleanField(default=True, help_text='If true, outbound messages can be sent from this mailbox')),
                ('async_handler', models.CharField(blank=True, help_text="Dotted path to async handler: 'package.module:function'", max_length=255, null=True)),
                ('metadata', models.JSONField(blank=True, default=dict)),
                ('domain', models.ForeignKey(help_text='Owning email domain (SES identity)', on_delete=django.db.models.deletion.CASCADE, related_name='mailboxes', to='aws.emaildomain')),
            ],
            options={
                'db_table': 'aws_mailbox',
                'ordering': ['email'],
            },
            bases=(models.Model, mojo.models.rest.MojoModel),
        ),
        migrations.CreateModel(
            name='SentMessage',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', models.DateTimeField(auto_now_add=True)),
                ('modified', models.DateTimeField(auto_now=True, db_index=True)),
                ('ses_message_id', models.CharField(blank=True, db_index=True, help_text='AWS SES MessageId returned after a successful send', max_length=255, null=True)),
                ('to_addresses', models.JSONField(blank=True, default=list, help_text='List of recipient addresses (To)')),
                ('cc_addresses', models.JSONField(blank=True, default=list, help_text='List of recipient addresses (Cc)')),
                ('bcc_addresses', models.JSONField(blank=True, default=list, help_text='List of recipient addresses (Bcc)')),
                ('subject', models.CharField(blank=True, help_text='Email subject', max_length=512, null=True)),
                ('body_text', models.TextField(blank=True, help_text='Plain text body', null=True)),
                ('body_html', models.TextField(blank=True, help_text='HTML body', null=True)),
                ('template_name', models.CharField(blank=True, help_text='Optional EmailTemplate name used to render this message', max_length=255, null=True)),
                ('template_context', models.JSONField(blank=True, default=dict, help_text='Context used when rendering a template')),
                ('status', models.CharField(choices=[('queued', 'Queued'), ('sending', 'Sending'), ('delivered', 'Delivered'), ('bounced', 'Bounced'), ('complained', 'Complained'), ('failed', 'Failed'), ('unknown', 'Unknown')], db_index=True, default='queued', help_text='Current delivery status', max_length=32)),
                ('status_reason', models.TextField(blank=True, help_text='Details or raw payload for bounces/complaints/errors', null=True)),
                ('metadata', models.JSONField(blank=True, default=dict, help_text='Arbitrary metadata for downstream processing/auditing')),
                ('mailbox', models.ForeignKey(help_text='Mailbox used as the sender (envelope MAIL FROM = mailbox.email)', on_delete=django.db.models.deletion.CASCADE, related_name='sent_messages', to='aws.mailbox')),
            ],
            options={
                'db_table': 'aws_sent_message',
                'ordering': ['-created', 'id'],
            },
            bases=(models.Model, mojo.models.rest.MojoModel),
        ),
        migrations.CreateModel(
            name='IncomingEmail',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', models.DateTimeField(auto_now_add=True)),
                ('modified', models.DateTimeField(auto_now=True, db_index=True)),
                ('s3_object_url', models.CharField(help_text='S3 URL for the raw MIME message (e.g., s3://bucket/key)', max_length=512)),
                ('message_id', models.CharField(blank=True, db_index=True, help_text='SMTP Message-ID header (if present)', max_length=255, null=True)),
                ('from_address', models.CharField(blank=True, help_text='Raw From header address (may include name)', max_length=512, null=True)),
                ('to_addresses', models.JSONField(blank=True, default=list, help_text='List of recipient addresses from To header')),
                ('cc_addresses', models.JSONField(blank=True, default=list, help_text='List of recipient addresses from Cc header')),
                ('subject', models.CharField(blank=True, help_text='Email subject', max_length=512, null=True)),
                ('date_header', models.DateTimeField(blank=True, help_text='Parsed Date header from the message', null=True)),
                ('headers', models.JSONField(blank=True, default=dict, help_text='All headers as a JSON object (flattened)')),
                ('text_body', models.TextField(blank=True, help_text='Extracted plain text body (if available)', null=True)),
                ('html_body', models.TextField(blank=True, help_text='Extracted HTML body (if available)', null=True)),
                ('size_bytes', models.IntegerField(default=0, help_text='Approximate size of the raw message in bytes')),
                ('received_at', models.DateTimeField(blank=True, db_index=True, help_text='Time message was received (from SNS/S3 event or set by parser)', null=True)),
                ('processed', models.BooleanField(default=False, help_text='True if post-receive processing completed')),
                ('process_status', models.CharField(db_index=True, default='pending', help_text='Processing status: pending | success | error', max_length=32)),
                ('process_error', models.TextField(blank=True, help_text='Error details if processing failed', null=True)),
                ('mailbox', models.ForeignKey(blank=True, help_text='Associated mailbox if any recipient matches', null=True, on_delete=django.db.models.deletion.CASCADE, related_name='incoming_emails', to='aws.mailbox')),
            ],
            options={
                'db_table': 'aws_incoming_email',
                'ordering': ['-received_at', '-created'],
            },
            bases=(models.Model, mojo.models.rest.MojoModel),
        ),
        migrations.CreateModel(
            name='EmailTemplate',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', models.DateTimeField(auto_now_add=True)),
                ('modified', models.DateTimeField(auto_now=True, db_index=True)),
                ('name', models.CharField(db_index=True, help_text='Unique template name (used by callers to reference this template)', max_length=255, unique=True)),
                ('subject_template', models.TextField(blank=True, default='', help_text='Django template string for the email subject')),
                ('html_template', models.TextField(blank=True, default='', help_text='Django template string for the HTML body')),
                ('text_template', models.TextField(blank=True, default='', help_text='Django template string for the plain text body')),
                ('metadata', models.JSONField(blank=True, default=dict, help_text='Arbitrary metadata for this template (e.g., description, tags)')),
            ],
            options={
                'db_table': 'aws_email_template',
                'ordering': ['name'],
                'indexes': [models.Index(fields=['modified'], name='aws_email_t_modifie_cf76d6_idx'), models.Index(fields=['name'], name='aws_email_t_name_d1662a_idx')],
            },
            bases=(models.Model, mojo.models.rest.MojoModel),
        ),
        migrations.AddIndex(
            model_name='emaildomain',
            index=models.Index(fields=['status'], name='aws_email_d_status_398945_idx'),
        ),
        migrations.AddIndex(
            model_name='emaildomain',
            index=models.Index(fields=['modified'], name='aws_email_d_modifie_66ca75_idx'),
        ),
        migrations.AddField(
            model_name='emailattachment',
            name='incoming_email',
            field=models.ForeignKey(help_text='The inbound email this attachment belongs to', on_delete=django.db.models.deletion.CASCADE, related_name='attachments', to='aws.incomingemail'),
        ),
        migrations.AddIndex(
            model_name='sentmessage',
            index=models.Index(fields=['modified'], name='aws_sent_me_modifie_a26352_idx'),
        ),
        migrations.AddIndex(
            model_name='sentmessage',
            index=models.Index(fields=['status'], name='aws_sent_me_status_63e619_idx'),
        ),
        migrations.AddIndex(
            model_name='sentmessage',
            index=models.Index(fields=['ses_message_id'], name='aws_sent_me_ses_mes_b72855_idx'),
        ),
        migrations.AddIndex(
            model_name='mailbox',
            index=models.Index(fields=['modified'], name='aws_mailbox_modifie_597f5d_idx'),
        ),
        migrations.AddIndex(
            model_name='mailbox',
            index=models.Index(fields=['email'], name='aws_mailbox_email_e2c6d1_idx'),
        ),
        migrations.AddIndex(
            model_name='incomingemail',
            index=models.Index(fields=['modified'], name='aws_incomin_modifie_8e68a9_idx'),
        ),
        migrations.AddIndex(
            model_name='incomingemail',
            index=models.Index(fields=['received_at'], name='aws_incomin_receive_7b6d93_idx'),
        ),
        migrations.AddIndex(
            model_name='incomingemail',
            index=models.Index(fields=['message_id'], name='aws_incomin_message_d8ca7f_idx'),
        ),
        migrations.AddIndex(
            model_name='emailattachment',
            index=models.Index(fields=['modified'], name='aws_email_a_modifie_b283df_idx'),
        ),
        migrations.AddIndex(
            model_name='emailattachment',
            index=models.Index(fields=['filename'], name='aws_email_a_filenam_da3c89_idx'),
        ),
    ]
