# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['awscli_plugin_yubikeytotp']

package_data = \
{'': ['*']}

install_requires = \
['botocore>=1.14.14,<2.0.0', 'yubikey-manager>4,<=5']

setup_kwargs = {
    'name': 'awscli-plugin-yubikeytotp',
    'version': '1.2.0b1',
    'description': '',
    'long_description': "[![PyPI version fury.io](https://badge.fury.io/py/awscli-plugin-yubikeytotp.svg)](https://pypi.python.org/pypi/awscli-plugin-yubikeytotp/) [![Code style: black](https://img.shields.io/badge/code%20style-black-000000.svg)](https://github.com/psf/black)\n\n\n# Yubikey authentication for AWS CLI (and boto) made easy\n\nThis plugin enables aws-cli to directly talk to your [YubiKey](https://www.yubico.com/)\nto acquire an OATH-TOTP code using the YubiKey's CCID application.\n\nCurrently, FIDO-U2F is unsupported on both, [botocore](https://github.com/aws/aws-cli/issues/3607)\nand [aws-cli](https://github.com/aws/aws-cli/issues/3607).\nUsing aws-cli with roles and a regular OATH-TOTP token at least prompts you for\nthe TOTP code but this is quite cumbersome to use with a YubiKey.\n\n\n## Installation\n\n`awscli-plugin-yubikeytotp` can be installed from PyPI:\n```\n$ pip install awscli-plugin-yubikeytotp\n```\nIt's also possible to install it just for your user in case you don't have\npermission to install packages system-wide:\n```\n$ pip install --user awscli-plugin-yubikeytotp\n```\n\n\n### Configure AWS CLI\nTo enable the plugin, add this to your `~/.aws/config`:\n```\n[plugins]\nyubikeytotp = awscli_plugin_yubikeytotp\n```\nAlso make sure to have your MFA ARN configured for your profile:\n```\n[profile myprofile]\nrole_arn = arn:aws:iam::...\nmfa_serial = arn:aws:iam::...\nsource_profile = default\n```\n\n\n## Usage\n\nJust use the `aws` command with a custom role and the plugin will do the rest:\n```\n$ aws s3 ls --profile myprofile\nGenerating OATH code on YubiKey. You may have to touch your YubiKey to proceed...\nSuccessfully created OATH code.\n2013-07-11 17:08:50 mybucket\n2013-07-24 14:55:44 mybucket2\n```\n\n---\n**NOTE**\n\nTo AWS, the M in MFA [still stands for the number 2](https://forums.aws.amazon.com/thread.jspa?threadID=137055). Hence, if you want to log in to the AWS console with OATH-TOTP\nenabled, you will have to use `ykman oath code` to generate a key and enter it\nmanually to log in, just like with Google Authenticator or Yubikey Authenticator\nsmartphone apps.\n\nIf you want to use U2F MFA authentication for login while still being able to\nuse your YubiKey for command line, you should create multiple IAM users. Use\none user with U2F MFA to log in to the AWS console and disable access keys.\nUse the other use with Virtual MFA device and disable console login.\nOnly ever use one user in the console and the other on your command line.\n\n---\n\n\n## Tutorial\n\n### Prerequisites\n\nYou obviously have to have a YubiKey. A Yubico Security Key (the blue ones)\nare not supported as they lack the OATH application.\n\nTo setup your YubiKey, you also have to have [yubikey-manager](https://developers.yubico.com/yubikey-manager/) (or `ykman`) installed.\nYou can use it to verify that OATH is enabled for your YubiKey:\n```\n$ ykman info\nDevice type: YubiKey 5 NFC\nSerial number: 00000000\nFirmware version: 5.2.4\nForm factor: Keychain (USB-A)\nEnabled USB interfaces: OTP+FIDO+CCID\nNFC interface is enabled.\n\nApplications    USB     NFC    \nOTP             Enabled Enabled\nFIDO U2F        Enabled Enabled\nOpenPGP         Enabled Enabled\nPIV             Enabled Enabled\nOATH            Enabled Enabled\nFIDO2           Enabled Enabled\n```\n\n### Setup MFA in AWS\n\n1. Log-in to your AWS account/user and navigate to your *My Security Credentials*\npage.\n2. Take not of your *AWS account ID* at the top.\n2. Under *Multi-factor authentivation (MFA)*, click `Manage MFA device` and add\na *Virtual MFA device*.\n3. Instead of showing the QR code, click on `Show secret key` and copy the key.\n4. On a command line, run\n   ```\n   $ ykman oath add -t arn:aws:iam::${ACCOUNT_ID}:mfa/${IAM_USERNAME} ${MFA_SECRET}\n   ```\n   The strange string `arn:aws:iam::${ACCOUNT_ID}:mfa/${IAM_USERNAME}` will\n   be your user's MFA serial after you have set up everything. The AWS console\n   will not tell you the MFA serial in advance, but by replacing the account id\n   and IAM username, you can build it on your own, e.g.:\n   ```\n   $ ykman oath add -t arn:aws:iam::123456789012:mfa/tommie-lie ABCD1234...\n   ```\n   \n   The above command requires you to touch your YubiKey to generate\n   authentication codes. You can ommit `-t` if you don't want to touch your key\n   every time you authenticate.\n5. Now you have to enter two **consecutive** MFA codes into the AWS website\n   to assign your key to your AWS login. Just run\n   `ykman oath code arn:aws:iam::${ACCOUNT_ID}:mfa/${IAM_USERNAME}`\n   to get an authentication code.\n   The codes are re-generated every 30 seconds, so you have to run this command\n   twice with about 30 seconds in between to get two distinct codes.\n   \n   Enter the two codes in the AWS form and click `Assign MFA`\n6. You're done!\n\n\n### Setup AWS CLI\n\n1. AWS CLI only asks for MFA if you change roles, but role-based access\n   management is a good practice for AWS security anyway, so we'll assume you\n   already have a role and a profile configured in your AWS CLI config file.\n2. Install `awscli-plugin-yubikeytotp`, see [installation section](#installation).\n3. Edit your AWS CLI config file (`~/.aws/config`) and add the MFA serial to\n   the profile you want to use MFA authentication with:\n   <pre><code>\n   [profile yubikey]\n   role_arn = arn:aws:iam::123456789012:role/yubikey-role\n   <b>mfa_serial = arn:aws:iam::123456789012:mfa/tommie-lie</b>\n   source_profile = default\n   </code></pre>\n4. Enable the plugin by appending the following section to your AWS CLI config file:\n   ```\n   [plugins]\n   yubikeytotp = awscli_plugin_yubikeytotp\n   ```\n5. That's it, you're ready to use AWS CLI with your YubiKey now!\n\n\n### Test your setup\n\nIf you need authentication by switching to another IAM role to access certain\nresources, you will normally get a permission denied error:\n```\n$ aws s3 ls\n\nAn error occurred (AccessDenied) when calling the ListBuckets operation: Access Denied\n```\nIf you switch profiles, however, AWS CLI will automatically ask for an MFA code:\n```\n$ aws s3 ls --profile yubikey\nGenerating OATH code on YubiKey. You may have to touch your YubiKey to proceed...\nSuccessfully created OATH code.\n2013-07-11 17:08:50 mybucket\n2013-07-24 14:55:44 mybucket2\n```\n\n\n## Acknowledgements\n* Thanks to [@woowa-hsw0](https://github.com/woowa-hsw0) for this\n  [inspiration for this plugin](https://gist.github.com/woowa-hsw0/caa3340e2a7b390dbde81894f73e379d)\n",
    'author': 'Thomas Liebetraut',
    'author_email': 'thomas@tommie-lie.de',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/tommie-lie/awscli-plugin-yubikeytotp',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.7,<4.0',
}


setup(**setup_kwargs)
