#  Copyright (c) 2021. Davi Pereira dos Santos
#  This file is part of the ldict project.
#  Please respect the license - more about this in the section (*) below.
#
#  ldict is free software: you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation, either version 3 of the License, or
#  (at your option) any later version.
#
#  ldict is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with ldict.  If not, see <http://www.gnu.org/licenses/>.
#
#  (*) Removing authorship by any means, e.g. by distribution of derived
#  works or verbatim, obfuscated, compiled or rewritten versions of any
#  part of this work is illegal and unethical regarding the effort and
#  time spent here.
from json import JSONEncoder
from types import FunctionType


class CustomJSONEncoder(JSONEncoder):
    def default(self, obj):
        if obj is not None:
            from garoupa import Hosh
            if isinstance(obj, Hosh):
                return obj.id
            elif isinstance(obj, FunctionType):
                return obj.__name__
            elif not isinstance(obj, (list, set, str, int, float, bytearray, bool)):
                try:
                    from pandas.core.frame import DataFrame, Series
                    if isinstance(obj, (DataFrame, Series)):
                        return str(obj.to_numpy())
                    from numpy import ndarray
                    if isinstance(obj, ndarray):
                        return str(obj)
                except ImportError:
                    print("Pandas or numpy may be missing.")
                return obj.asdict if hasattr(obj, "asdict") else obj.aslist
        return JSONEncoder.default(self, obj)

# class CustomJSONDecoder(JSONDecoder):
#     def __init__(self, *args, **kwargs):
#         JSONDecoder.__init__(self, object_hook=self.object_hook, *args, **kwargs)
#
#     def object_hook(self, obj):
#         if obj is not None:
#             if isinstance(obj, str) and len(obj) == digits:
#                 return
#         return obj
