from pydantic import BaseModel
from pydantic.color import Color

from moontour_common.models.rooms.health_room import HealthRoom, START_HEALTH
from moontour_common.models.rooms.room import RoomMode
from moontour_common.models.user import User


class Team(BaseModel):
    color: Color
    health: int = START_HEALTH
    players: list[User] = []


class TeamsRoom(HealthRoom):
    mode = RoomMode.teams
    team_size: int = 2
    teams: dict[str, Team] = {
        'red': Team(color=Color('red')),
        'blue': Team(color=Color('blue')),
    }
