# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['uvm', 'uvm.commands']

package_data = \
{'': ['*']}

install_requires = \
['typer>=0.3.2,<0.4.0']

entry_points = \
{'console_scripts': ['uvm = uvm.main:app']}

setup_kwargs = {
    'name': 'uvm',
    'version': '1.0.1',
    'description': 'Unity Version Manager CLI implemented with Python and Typer',
    'long_description': '# Unity Version Manager\n\n[![License: MIT](https://img.shields.io/badge/License-MIT-green.svg)](https://opensource.org/licenses/MIT)\n[![Test](https://github.com/educup/uvm/workflows/CI/badge.svg)](https://github.com/educup/uvm/actions?query=workflow%3ACI)\n[![codecov](https://codecov.io/gh/educup/uvm/branch/main/graph/badge.svg?token=Z1MEEL3EAB)](https://codecov.io/gh/educup/uvm)\n[![Version](https://img.shields.io/pypi/v/uvm?color=%2334D058&label=Version)](https://pypi.org/project/uvm)\n[![Last commit](https://img.shields.io/github/last-commit/educup/uvm.svg?style=flat)](https://github.com/educup/uvm/commits)\n[![GitHub commit activity](https://img.shields.io/github/commit-activity/m/educup/uvm)](https://github.com/educup/uvm/commits)\n[![Github Stars](https://img.shields.io/github/stars/educup/uvm?style=flat&logo=github)](https://github.com/educup/uvm/stargazers)\n[![Github Forks](https://img.shields.io/github/forks/educup/uvm?style=flat&logo=github)](https://github.com/educup/uvm/network/members)\n[![Github Watchers](https://img.shields.io/github/watchers/educup/uvm?style=flat&logo=github)](https://github.com/educup/uvm)\n[![Website](https://img.shields.io/website?up_message=online&url=https%3A%2F%2Feducup.github.io/uvm)](https://educup.github.io/uvm)\n[![GitHub contributors](https://img.shields.io/github/contributors/educup/uvm)](https://github.com/educup/uvm/graphs/contributors)\n\n[Unity](https://unity.com) Version Manager CLI implemented with [Python](https://www.python.org) and [Typer](https://typer.tiangolo.com).\n\n**Usage**:\n\n```console\n$ uvm [OPTIONS] COMMAND [ARGS]...\n```\n\n**Options**:\n\n* `--install-completion`: Install completion for the current shell.\n* `--show-completion`: Show completion for the current shell, to copy it or customize the installation.\n* `--help`: Show this message and exit.\n\n**Commands**:\n\n* `build`: Command to manage the version build\n* `code`: Command to manage the version code\n* `get`: Get the version\n* `major`: Command to manage the version major\n* `minor`: Command to manage the version minor\n* `patch`: Command to manage the version patch\n* `set`: Set the version\n\n## `uvm build`\n\nCommand to manage the version build\n\n**Usage**:\n\n```console\n$ uvm build [OPTIONS] COMMAND [ARGS]...\n```\n\n**Options**:\n\n* `--help`: Show this message and exit.\n\n**Commands**:\n\n* `get`: Get the version build\n* `set`: Set the version build\n* `setup`: Increase the version build to the next\n\n### `uvm build get`\n\nGet the version build\n\n**Usage**:\n\n```console\n$ uvm build get [OPTIONS] [FILENAME]\n```\n\n**Arguments**:\n\n* `[FILENAME]`: Path of ProjectSettings.asset file of the Unity project  [envvar: UVM_FILENAME;default: ./ProjectSettings/ProjectSettings.asset]\n\n**Options**:\n\n* `--help`: Show this message and exit.\n\n### `uvm build set`\n\nSet the version build\n\n**Usage**:\n\n```console\n$ uvm build set [OPTIONS] NUMBER [FILENAME]\n```\n\n**Arguments**:\n\n* `NUMBER`: Version build  [required]\n* `[FILENAME]`: Path of ProjectSettings.asset file of the Unity project  [envvar: UVM_FILENAME;default: ./ProjectSettings/ProjectSettings.asset]\n\n**Options**:\n\n* `--help`: Show this message and exit.\n\n### `uvm build setup`\n\nIncrease the version build to the next\n\n**Usage**:\n\n```console\n$ uvm build setup [OPTIONS] [FILENAME]\n```\n\n**Arguments**:\n\n* `[FILENAME]`: Path of ProjectSettings.asset file of the Unity project  [envvar: UVM_FILENAME;default: ./ProjectSettings/ProjectSettings.asset]\n\n**Options**:\n\n* `--help`: Show this message and exit.\n\n## `uvm code`\n\nCommand to manage the version code\n\n**Usage**:\n\n```console\n$ uvm code [OPTIONS] COMMAND [ARGS]...\n```\n\n**Options**:\n\n* `--help`: Show this message and exit.\n\n**Commands**:\n\n* `get`: Get the version code\n* `set`: Set the version code\n* `setup`: Increase the version code to the next\n\n### `uvm code get`\n\nGet the version code\n\n**Usage**:\n\n```console\n$ uvm code get [OPTIONS] [FILENAME]\n```\n\n**Arguments**:\n\n* `[FILENAME]`: Path of ProjectSettings.asset file of the Unity project  [envvar: UVM_FILENAME;default: ./ProjectSettings/ProjectSettings.asset]\n\n**Options**:\n\n* `--help`: Show this message and exit.\n\n### `uvm code set`\n\nSet the version code\n\n**Usage**:\n\n```console\n$ uvm code set [OPTIONS] NUMBER [FILENAME]\n```\n\n**Arguments**:\n\n* `NUMBER`: Version code  [required]\n* `[FILENAME]`: Path of ProjectSettings.asset file of the Unity project  [envvar: UVM_FILENAME;default: ./ProjectSettings/ProjectSettings.asset]\n\n**Options**:\n\n* `--help`: Show this message and exit.\n\n### `uvm code setup`\n\nIncrease the version code to the next\n\n**Usage**:\n\n```console\n$ uvm code setup [OPTIONS] [FILENAME]\n```\n\n**Arguments**:\n\n* `[FILENAME]`: Path of ProjectSettings.asset file of the Unity project  [envvar: UVM_FILENAME;default: ./ProjectSettings/ProjectSettings.asset]\n\n**Options**:\n\n* `--help`: Show this message and exit.\n\n## `uvm get`\n\nGet the version\n\n**Usage**:\n\n```console\n$ uvm get [OPTIONS] [FILENAME]\n```\n\n**Arguments**:\n\n* `[FILENAME]`: Path of ProjectSettings.asset file of the Unity project  [envvar: UVM_FILENAME;default: ./ProjectSettings/ProjectSettings.asset]\n\n**Options**:\n\n* `--help`: Show this message and exit.\n\n## `uvm major`\n\nCommand to manage the version major\n\n**Usage**:\n\n```console\n$ uvm major [OPTIONS] COMMAND [ARGS]...\n```\n\n**Options**:\n\n* `--help`: Show this message and exit.\n\n**Commands**:\n\n* `get`: Get the version major\n* `set`: Set the version major\n* `setup`: Increase the version major to the next\n\n### `uvm major get`\n\nGet the version major\n\n**Usage**:\n\n```console\n$ uvm major get [OPTIONS] [FILENAME]\n```\n\n**Arguments**:\n\n* `[FILENAME]`: Path of ProjectSettings.asset file of the Unity project  [envvar: UVM_FILENAME;default: ./ProjectSettings/ProjectSettings.asset]\n\n**Options**:\n\n* `--help`: Show this message and exit.\n\n### `uvm major set`\n\nSet the version major\n\n**Usage**:\n\n```console\n$ uvm major set [OPTIONS] NUMBER [FILENAME]\n```\n\n**Arguments**:\n\n* `NUMBER`: Version major  [required]\n* `[FILENAME]`: Path of ProjectSettings.asset file of the Unity project  [envvar: UVM_FILENAME;default: ./ProjectSettings/ProjectSettings.asset]\n\n**Options**:\n\n* `--help`: Show this message and exit.\n\n### `uvm major setup`\n\nIncrease the version major to the next\n\n**Usage**:\n\n```console\n$ uvm major setup [OPTIONS] [FILENAME]\n```\n\n**Arguments**:\n\n* `[FILENAME]`: Path of ProjectSettings.asset file of the Unity project  [envvar: UVM_FILENAME;default: ./ProjectSettings/ProjectSettings.asset]\n\n**Options**:\n\n* `--help`: Show this message and exit.\n\n## `uvm minor`\n\nCommand to manage the version minor\n\n**Usage**:\n\n```console\n$ uvm minor [OPTIONS] COMMAND [ARGS]...\n```\n\n**Options**:\n\n* `--help`: Show this message and exit.\n\n**Commands**:\n\n* `get`: Get the version minor\n* `set`: Set the version minor\n* `setup`: Increase the version minor to the next\n\n### `uvm minor get`\n\nGet the version minor\n\n**Usage**:\n\n```console\n$ uvm minor get [OPTIONS] [FILENAME]\n```\n\n**Arguments**:\n\n* `[FILENAME]`: Path of ProjectSettings.asset file of the Unity project  [envvar: UVM_FILENAME;default: ./ProjectSettings/ProjectSettings.asset]\n\n**Options**:\n\n* `--help`: Show this message and exit.\n\n### `uvm minor set`\n\nSet the version minor\n\n**Usage**:\n\n```console\n$ uvm minor set [OPTIONS] NUMBER [FILENAME]\n```\n\n**Arguments**:\n\n* `NUMBER`: Version minor  [required]\n* `[FILENAME]`: Path of ProjectSettings.asset file of the Unity project  [envvar: UVM_FILENAME;default: ./ProjectSettings/ProjectSettings.asset]\n\n**Options**:\n\n* `--help`: Show this message and exit.\n\n### `uvm minor setup`\n\nIncrease the version minor to the next\n\n**Usage**:\n\n```console\n$ uvm minor setup [OPTIONS] [FILENAME]\n```\n\n**Arguments**:\n\n* `[FILENAME]`: Path of ProjectSettings.asset file of the Unity project  [envvar: UVM_FILENAME;default: ./ProjectSettings/ProjectSettings.asset]\n\n**Options**:\n\n* `--help`: Show this message and exit.\n\n## `uvm patch`\n\nCommand to manage the version patch\n\n**Usage**:\n\n```console\n$ uvm patch [OPTIONS] COMMAND [ARGS]...\n```\n\n**Options**:\n\n* `--help`: Show this message and exit.\n\n**Commands**:\n\n* `get`: Get the version patch\n* `set`: Set the version patch\n* `setup`: Increase the version patch to the next\n\n### `uvm patch get`\n\nGet the version patch\n\n**Usage**:\n\n```console\n$ uvm patch get [OPTIONS] [FILENAME]\n```\n\n**Arguments**:\n\n* `[FILENAME]`: Path of ProjectSettings.asset file of the Unity project  [envvar: UVM_FILENAME;default: ./ProjectSettings/ProjectSettings.asset]\n\n**Options**:\n\n* `--help`: Show this message and exit.\n\n### `uvm patch set`\n\nSet the version patch\n\n**Usage**:\n\n```console\n$ uvm patch set [OPTIONS] NUMBER [FILENAME]\n```\n\n**Arguments**:\n\n* `NUMBER`: Version patch  [required]\n* `[FILENAME]`: Path of ProjectSettings.asset file of the Unity project  [envvar: UVM_FILENAME;default: ./ProjectSettings/ProjectSettings.asset]\n\n**Options**:\n\n* `--help`: Show this message and exit.\n\n### `uvm patch setup`\n\nIncrease the version patch to the next\n\n**Usage**:\n\n```console\n$ uvm patch setup [OPTIONS] [FILENAME]\n```\n\n**Arguments**:\n\n* `[FILENAME]`: Path of ProjectSettings.asset file of the Unity project  [envvar: UVM_FILENAME;default: ./ProjectSettings/ProjectSettings.asset]\n\n**Options**:\n\n* `--help`: Show this message and exit.\n\n## `uvm set`\n\nSet the version\n\n**Usage**:\n\n```console\n$ uvm set [OPTIONS] ARG [FILENAME]\n```\n\n**Arguments**:\n\n* `ARG`: The format must be `"*.*.*b*(*)"` where * is the major, minor, patch, build and code respectively and all integers.  [required]\n* `[FILENAME]`: Path of ProjectSettings.asset file of the Unity project  [envvar: UVM_FILENAME;default: ./ProjectSettings/ProjectSettings.asset]\n\n**Options**:\n\n* `--help`: Show this message and exit.\n',
    'author': 'educup',
    'author_email': 'hello@educup.io',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/educup/uvm',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.8,<4.0',
}


setup(**setup_kwargs)
