# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['homepage']

package_data = \
{'': ['*'], 'homepage': ['static/*', 'templates/*']}

install_requires = \
['Flask', 'easyparse', 'gevent', 'youtube_dl']

entry_points = \
{'console_scripts': ['homepage = homepage:main']}

setup_kwargs = {
    'name': 'homepage',
    'version': '0.4.5',
    'description': 'A simple flask webapp to download the audio track from almost any internet video.',
    'long_description': '# HomePage\n\nHomePage is a trivial flask web app that allows downloading the audio track from almost any internet video.\nIt is intended to be deployed inside a private network for personal use, so that hosts within the network can access\nand download the tracks they want.\n\nHomePage is very basic, but it has a simple and easy to use front-end.\nHomePage uses `youtube_dl` to download the videos, so quite a few sites are supported. Playlists are also supported.\n[`youtube_dl`](https://github.com/ytdl-org/youtube-dl/) has been taken down due to a copyright strike from GitHub, but this does not impact the PyPi version, so this will work as normal.\n\n![HomePage](homepage/static/HomePage.png)\n\n## Prerequsites\n\n- `python 3.6` or above with `pip`\n- `sudo` access (for port 80)\n- `pyenv` and `poetry` installed (optional)\n- `apt` package manager & package lists\n\n## Install\n\nThe basic installation is very simple.\n\n```bash\n$ python3 -m pip install --user homepage\n\n# Normal desktop\n$ homepage -i\n\n# Server without x11\n$ homepage -ic\n```\n\nThen, you can deploy with:\n\n```bash\n$ homepage -dfp\n```\n\nAlternatively, if your system is running an older version of python or you wish to run this project inside\na virtual environment, you can do that too.\n\nFirst, go ahead and install [pyenv](https://github.com/pyenv/pyenv#basic-github-checkout). Then install [poetry](https://github.com/sdispater/poetry).\nOnce you\'ve installed those, we just to install a few more things.\n\n```bash\n$ git clone https://github.com/Sh3llcod3/HomePage.git\n$ cd HomePage/\n$ pyenv install 3.9.0\n$ pyenv local 3.9.0\n$ poetry poetry self update --preview\n$ poetry update\n$ poetry install # Add --no-dev if you don\'t want dev deps\n$ poetry shell\n$ homepage -ip\n$ homepage -df\n```\n\nAfter installing `pyenv`, the lines you add to your `~/.bashrc` may need to be different, please see the [FAQ](#faq--troubleshooting).\n\n## Uninstall\n\nIf you installed using `pip`:\n\n```shell\npython3 -m pip uninstall -y homepage easyparse Flask youtube_dl gevent\n```\n\nand it will remove this completely from your system. You can vary this command based on what you want to keep.\n\nOtherwise, if you\'ve installed using poetry and assuming you\'re inside the current directory:\n\n```shell\n$ exit # Exit virtualenv or press Ctrl-d\n$ poetry env remove 3.9\n$ poetry cache clear --all pypi\n$ cd .. && rm -rf HomePage/\n```\n\n## Usage\n\nOnce deployed, if you\'re using this on the device which is hosting it, fire up your\nfavourite web browser and head to `http://localhost:5000/`. If you\'re on another device,\nsimply head to the IP address of the host node.\n\nIf you have `sudo` access, use the `-f` switch. If you don\'t, port 80 will not be used.\n\n> Playlists are supported and all sites that will with ytdl will also work here.\n\n## FAQ & Troubleshooting\n\n#### I\'m having trouble with the env\n\nYou may have inserted the wrong lines in your `~/.bashrc`.\nThe initialization lines shown on the pyenv repo don\'t work\nwell with poetry. Instead, add these lines to the end of the file\nand remove any previous lines you may have added before\n(taking care to ensure you don\'t remove anything else).\n\n```bash\n# Pyenv installation\n\nif [[ -z "$VIRTUAL_ENV" ]]; then\n    export PATH="$HOME/.pyenv/bin:$PATH"\n    eval "$(pyenv init -)"\nfi\n```\n\n#### Can I change the background?\n\nYou absolutely can. To change the background, change out `homepage/static/Background.jpg` with any image you like,\nbut it has to be called `Background.jpg` and in the `JPEG` format. I will make this process easier in the future.\n\n#### Pyenv fails to install 3.9.0\n\nYou may have forgotten to install some crucial `pyenv` dependencies.\nIf you\'re using other package managers, check [here](https://github.com/pyenv/pyenv/wiki#suggested-build-environment)\nfor their wiki page. If you\'re using `apt`, you can simply run:\n\n```bash\n$ sudo apt update\n$ sudo apt-get install -y --no-install-recommends make build-essential libssl-dev zlib1g-dev libbz2-dev libreadline-dev libsqlite3-dev wget curl llvm libncurses5-dev xz-utils tk-dev libxml2-dev libxmlsec1-dev libffi-dev liblzma-dev\n```\n\nThen retry the `pyenv` installation.\n\n#### Why does HomePage exist?\n\nThat is a really good question.\nI wanted a simple web app where I could download music from various videos on any\ndevice, without having access to a command line version of `youtube_dl` or resorting\nto using questionable sites and apps.\n\nThe code is bad at best, but it works and you have the freedom of choice.\nWhether you want to use it, is up to you.\n\n#### Why is it not working?\n\nYour version of `youtube_dl` may be out of date. Having a version of `youtube_dl`\nthat is even one version old can mean your tracks may fail to download. Fortunately,\nthe library is updated frequently and you can pull in the updates very easily.\n\nIf you\'re using it from PyPi, then:\n```shell\n$ python3 -m pip install --upgrade youtube_dl gevent Flask --user\n$ youtube-dl --rm-cache-dir\n```\n\nIf you\'re using it from the `env`, then simply `cd` to the directory you installed it\nand run:\n```shell\n$ poetry update\n$ poetry shell\n```\n\n> You may want to write some sort of `cron` job to do this every few days or so.\n\n#### Does HomePage scale to multiple users asynchronously?\n\nNo. It was never intended to scale in the first place. Neither is it secure in any way.\nTherefore, I should stress that you should __NOT__ deploy this to anywhere except your\nRFC1918 private/internal network with caution.\n\n#### Does it have Windows support?\n\nYes. If you can get the latest executables for `lame`, `atomicparsley`, `faac`, `ffmpeg` and\nplace them inside the project\'s directory, it should work.\n\n#### Why does it take long?\n\nThis depends on:\n\n- Speed of computer and version of ffmpeg\n- Size of download, network speed\n- Single track or playlist?\n\n## To-do\n\n- [ ] Add auth\n- [ ] Replace xhr with websocket\n- [ ] Save user preferences using cookies\n- [ ] Display past tracks only for that user\n- [ ] Add management card\n- [ ] Make it work on windows and generate executables\n',
    'author': 'Sh3llcod3',
    'author_email': '28938427+Sh3llcod3@users.noreply.github.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/Sh3llcod3/HomePage',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.6,<4.0',
}


setup(**setup_kwargs)
