# coding: utf-8

"""
    NCBI Datasets API

    NCBI service to query and download biological sequence data across all domains of life from NCBI databases.  # noqa: E501

    The version of the OpenAPI document: v1
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from ncbi.datasets.openapi.configuration import Configuration


class V1ProkaryoteGeneRequest(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'accessions': 'list[str]',
        'gene_flank_config': 'ProkaryoteGeneRequestGeneFlankConfig',
        'include_annotation_type': 'list[V1Fasta]',
        'taxon': 'str'
    }

    attribute_map = {
        'accessions': 'accessions',
        'gene_flank_config': 'gene_flank_config',
        'include_annotation_type': 'include_annotation_type',
        'taxon': 'taxon'
    }

    def __init__(self, accessions=None, gene_flank_config=None, include_annotation_type=None, taxon=None, local_vars_configuration=None):  # noqa: E501
        """V1ProkaryoteGeneRequest - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._accessions = None
        self._gene_flank_config = None
        self._include_annotation_type = None
        self._taxon = None
        self.discriminator = None

        if accessions is not None:
            self.accessions = accessions
        if gene_flank_config is not None:
            self.gene_flank_config = gene_flank_config
        if include_annotation_type is not None:
            self.include_annotation_type = include_annotation_type
        if taxon is not None:
            self.taxon = taxon

    @property
    def accessions(self):
        """Gets the accessions of this V1ProkaryoteGeneRequest.  # noqa: E501


        :return: The accessions of this V1ProkaryoteGeneRequest.  # noqa: E501
        :rtype: list[str]
        """
        return self._accessions

    @accessions.setter
    def accessions(self, accessions):
        """Sets the accessions of this V1ProkaryoteGeneRequest.


        :param accessions: The accessions of this V1ProkaryoteGeneRequest.  # noqa: E501
        :type: list[str]
        """

        self._accessions = accessions

    @property
    def gene_flank_config(self):
        """Gets the gene_flank_config of this V1ProkaryoteGeneRequest.  # noqa: E501


        :return: The gene_flank_config of this V1ProkaryoteGeneRequest.  # noqa: E501
        :rtype: ProkaryoteGeneRequestGeneFlankConfig
        """
        return self._gene_flank_config

    @gene_flank_config.setter
    def gene_flank_config(self, gene_flank_config):
        """Sets the gene_flank_config of this V1ProkaryoteGeneRequest.


        :param gene_flank_config: The gene_flank_config of this V1ProkaryoteGeneRequest.  # noqa: E501
        :type: ProkaryoteGeneRequestGeneFlankConfig
        """

        self._gene_flank_config = gene_flank_config

    @property
    def include_annotation_type(self):
        """Gets the include_annotation_type of this V1ProkaryoteGeneRequest.  # noqa: E501

        Select additional types of annotation to include in the data package.  If unset, no annotation is provided.  # noqa: E501

        :return: The include_annotation_type of this V1ProkaryoteGeneRequest.  # noqa: E501
        :rtype: list[V1Fasta]
        """
        return self._include_annotation_type

    @include_annotation_type.setter
    def include_annotation_type(self, include_annotation_type):
        """Sets the include_annotation_type of this V1ProkaryoteGeneRequest.

        Select additional types of annotation to include in the data package.  If unset, no annotation is provided.  # noqa: E501

        :param include_annotation_type: The include_annotation_type of this V1ProkaryoteGeneRequest.  # noqa: E501
        :type: list[V1Fasta]
        """

        self._include_annotation_type = include_annotation_type

    @property
    def taxon(self):
        """Gets the taxon of this V1ProkaryoteGeneRequest.  # noqa: E501


        :return: The taxon of this V1ProkaryoteGeneRequest.  # noqa: E501
        :rtype: str
        """
        return self._taxon

    @taxon.setter
    def taxon(self, taxon):
        """Sets the taxon of this V1ProkaryoteGeneRequest.


        :param taxon: The taxon of this V1ProkaryoteGeneRequest.  # noqa: E501
        :type: str
        """

        self._taxon = taxon

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, V1ProkaryoteGeneRequest):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, V1ProkaryoteGeneRequest):
            return True

        return self.to_dict() != other.to_dict()
