# coding: utf-8

"""
    NCBI Datasets API

    NCBI service to query and download biological sequence data across all domains of life from NCBI databases.  # noqa: E501

    The version of the OpenAPI document: v1
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from ncbi.datasets.openapi.configuration import Configuration


class V1AssemblyMetadataRequest(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'accessions': 'V1Accessions',
        'bioprojects': 'AssemblyMetadataRequestBioprojects',
        'filters': 'V1AssemblyDatasetDescriptorsFilter',
        'limit': 'str',
        'page_size': 'int',
        'page_token': 'str',
        'returned_content': 'V1AssemblyMetadataRequestContentType',
        'tax_exact_match': 'bool',
        'taxon': 'str'
    }

    attribute_map = {
        'accessions': 'accessions',
        'bioprojects': 'bioprojects',
        'filters': 'filters',
        'limit': 'limit',
        'page_size': 'page_size',
        'page_token': 'page_token',
        'returned_content': 'returned_content',
        'tax_exact_match': 'tax_exact_match',
        'taxon': 'taxon'
    }

    def __init__(self, accessions=None, bioprojects=None, filters=None, limit=None, page_size=None, page_token=None, returned_content=None, tax_exact_match=None, taxon=None, local_vars_configuration=None):  # noqa: E501
        """V1AssemblyMetadataRequest - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._accessions = None
        self._bioprojects = None
        self._filters = None
        self._limit = None
        self._page_size = None
        self._page_token = None
        self._returned_content = None
        self._tax_exact_match = None
        self._taxon = None
        self.discriminator = None

        if accessions is not None:
            self.accessions = accessions
        if bioprojects is not None:
            self.bioprojects = bioprojects
        if filters is not None:
            self.filters = filters
        if limit is not None:
            self.limit = limit
        if page_size is not None:
            self.page_size = page_size
        if page_token is not None:
            self.page_token = page_token
        if returned_content is not None:
            self.returned_content = returned_content
        if tax_exact_match is not None:
            self.tax_exact_match = tax_exact_match
        if taxon is not None:
            self.taxon = taxon

    @property
    def accessions(self):
        """Gets the accessions of this V1AssemblyMetadataRequest.  # noqa: E501


        :return: The accessions of this V1AssemblyMetadataRequest.  # noqa: E501
        :rtype: V1Accessions
        """
        return self._accessions

    @accessions.setter
    def accessions(self, accessions):
        """Sets the accessions of this V1AssemblyMetadataRequest.


        :param accessions: The accessions of this V1AssemblyMetadataRequest.  # noqa: E501
        :type: V1Accessions
        """

        self._accessions = accessions

    @property
    def bioprojects(self):
        """Gets the bioprojects of this V1AssemblyMetadataRequest.  # noqa: E501


        :return: The bioprojects of this V1AssemblyMetadataRequest.  # noqa: E501
        :rtype: AssemblyMetadataRequestBioprojects
        """
        return self._bioprojects

    @bioprojects.setter
    def bioprojects(self, bioprojects):
        """Sets the bioprojects of this V1AssemblyMetadataRequest.


        :param bioprojects: The bioprojects of this V1AssemblyMetadataRequest.  # noqa: E501
        :type: AssemblyMetadataRequestBioprojects
        """

        self._bioprojects = bioprojects

    @property
    def filters(self):
        """Gets the filters of this V1AssemblyMetadataRequest.  # noqa: E501


        :return: The filters of this V1AssemblyMetadataRequest.  # noqa: E501
        :rtype: V1AssemblyDatasetDescriptorsFilter
        """
        return self._filters

    @filters.setter
    def filters(self, filters):
        """Sets the filters of this V1AssemblyMetadataRequest.


        :param filters: The filters of this V1AssemblyMetadataRequest.  # noqa: E501
        :type: V1AssemblyDatasetDescriptorsFilter
        """

        self._filters = filters

    @property
    def limit(self):
        """Gets the limit of this V1AssemblyMetadataRequest.  # noqa: E501


        :return: The limit of this V1AssemblyMetadataRequest.  # noqa: E501
        :rtype: str
        """
        return self._limit

    @limit.setter
    def limit(self, limit):
        """Sets the limit of this V1AssemblyMetadataRequest.


        :param limit: The limit of this V1AssemblyMetadataRequest.  # noqa: E501
        :type: str
        """

        self._limit = limit

    @property
    def page_size(self):
        """Gets the page_size of this V1AssemblyMetadataRequest.  # noqa: E501

        The maximum number of genome assemblies to return. Default is 20 and maximum is 1000. If the number of results exceeds the page size,  `page_token` can be used to retrieve the remaining results.  # noqa: E501

        :return: The page_size of this V1AssemblyMetadataRequest.  # noqa: E501
        :rtype: int
        """
        return self._page_size

    @page_size.setter
    def page_size(self, page_size):
        """Sets the page_size of this V1AssemblyMetadataRequest.

        The maximum number of genome assemblies to return. Default is 20 and maximum is 1000. If the number of results exceeds the page size,  `page_token` can be used to retrieve the remaining results.  # noqa: E501

        :param page_size: The page_size of this V1AssemblyMetadataRequest.  # noqa: E501
        :type: int
        """

        self._page_size = page_size

    @property
    def page_token(self):
        """Gets the page_token of this V1AssemblyMetadataRequest.  # noqa: E501

        A page token is returned from an `AssemblyMetadataRequest` call with more than `page_size` results. Use this token, along with the previous  `AssemblyMetadataRequest` parameters, to retrieve the next page of results. When `page_token` is empty, all results have been retrieved.  # noqa: E501

        :return: The page_token of this V1AssemblyMetadataRequest.  # noqa: E501
        :rtype: str
        """
        return self._page_token

    @page_token.setter
    def page_token(self, page_token):
        """Sets the page_token of this V1AssemblyMetadataRequest.

        A page token is returned from an `AssemblyMetadataRequest` call with more than `page_size` results. Use this token, along with the previous  `AssemblyMetadataRequest` parameters, to retrieve the next page of results. When `page_token` is empty, all results have been retrieved.  # noqa: E501

        :param page_token: The page_token of this V1AssemblyMetadataRequest.  # noqa: E501
        :type: str
        """

        self._page_token = page_token

    @property
    def returned_content(self):
        """Gets the returned_content of this V1AssemblyMetadataRequest.  # noqa: E501


        :return: The returned_content of this V1AssemblyMetadataRequest.  # noqa: E501
        :rtype: V1AssemblyMetadataRequestContentType
        """
        return self._returned_content

    @returned_content.setter
    def returned_content(self, returned_content):
        """Sets the returned_content of this V1AssemblyMetadataRequest.


        :param returned_content: The returned_content of this V1AssemblyMetadataRequest.  # noqa: E501
        :type: V1AssemblyMetadataRequestContentType
        """

        self._returned_content = returned_content

    @property
    def tax_exact_match(self):
        """Gets the tax_exact_match of this V1AssemblyMetadataRequest.  # noqa: E501

        If true, only return assemblies with the given NCBI Taxonomy ID, or name. Otherwise, assemblies from taxonomy subtree are included, too. Ignored for assembly_accession request.  # noqa: E501

        :return: The tax_exact_match of this V1AssemblyMetadataRequest.  # noqa: E501
        :rtype: bool
        """
        return self._tax_exact_match

    @tax_exact_match.setter
    def tax_exact_match(self, tax_exact_match):
        """Sets the tax_exact_match of this V1AssemblyMetadataRequest.

        If true, only return assemblies with the given NCBI Taxonomy ID, or name. Otherwise, assemblies from taxonomy subtree are included, too. Ignored for assembly_accession request.  # noqa: E501

        :param tax_exact_match: The tax_exact_match of this V1AssemblyMetadataRequest.  # noqa: E501
        :type: bool
        """

        self._tax_exact_match = tax_exact_match

    @property
    def taxon(self):
        """Gets the taxon of this V1AssemblyMetadataRequest.  # noqa: E501


        :return: The taxon of this V1AssemblyMetadataRequest.  # noqa: E501
        :rtype: str
        """
        return self._taxon

    @taxon.setter
    def taxon(self, taxon):
        """Sets the taxon of this V1AssemblyMetadataRequest.


        :param taxon: The taxon of this V1AssemblyMetadataRequest.  # noqa: E501
        :type: str
        """

        self._taxon = taxon

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, V1AssemblyMetadataRequest):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, V1AssemblyMetadataRequest):
            return True

        return self.to_dict() != other.to_dict()
