# coding: utf-8

"""
    NCBI Datasets API

    NCBI service to query and download biological sequence data across all domains of life from NCBI databases.  # noqa: E501

    The version of the OpenAPI document: v1
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from ncbi.datasets.openapi.configuration import Configuration


class V1AssemblyMetadata(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'assemblies': 'list[V1AssemblyMatch]',
        'messages': 'list[V1Message]',
        'next_page_token': 'str',
        'total_count': 'int'
    }

    attribute_map = {
        'assemblies': 'assemblies',
        'messages': 'messages',
        'next_page_token': 'next_page_token',
        'total_count': 'total_count'
    }

    def __init__(self, assemblies=None, messages=None, next_page_token=None, total_count=None, local_vars_configuration=None):  # noqa: E501
        """V1AssemblyMetadata - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._assemblies = None
        self._messages = None
        self._next_page_token = None
        self._total_count = None
        self.discriminator = None

        if assemblies is not None:
            self.assemblies = assemblies
        if messages is not None:
            self.messages = messages
        if next_page_token is not None:
            self.next_page_token = next_page_token
        if total_count is not None:
            self.total_count = total_count

    @property
    def assemblies(self):
        """Gets the assemblies of this V1AssemblyMetadata.  # noqa: E501


        :return: The assemblies of this V1AssemblyMetadata.  # noqa: E501
        :rtype: list[V1AssemblyMatch]
        """
        return self._assemblies

    @assemblies.setter
    def assemblies(self, assemblies):
        """Sets the assemblies of this V1AssemblyMetadata.


        :param assemblies: The assemblies of this V1AssemblyMetadata.  # noqa: E501
        :type: list[V1AssemblyMatch]
        """

        self._assemblies = assemblies

    @property
    def messages(self):
        """Gets the messages of this V1AssemblyMetadata.  # noqa: E501


        :return: The messages of this V1AssemblyMetadata.  # noqa: E501
        :rtype: list[V1Message]
        """
        return self._messages

    @messages.setter
    def messages(self, messages):
        """Sets the messages of this V1AssemblyMetadata.


        :param messages: The messages of this V1AssemblyMetadata.  # noqa: E501
        :type: list[V1Message]
        """

        self._messages = messages

    @property
    def next_page_token(self):
        """Gets the next_page_token of this V1AssemblyMetadata.  # noqa: E501

        A token that can be sent as `page_token` to retrieve the next page. If this field is omitted, there are no subsequent pages.  # noqa: E501

        :return: The next_page_token of this V1AssemblyMetadata.  # noqa: E501
        :rtype: str
        """
        return self._next_page_token

    @next_page_token.setter
    def next_page_token(self, next_page_token):
        """Sets the next_page_token of this V1AssemblyMetadata.

        A token that can be sent as `page_token` to retrieve the next page. If this field is omitted, there are no subsequent pages.  # noqa: E501

        :param next_page_token: The next_page_token of this V1AssemblyMetadata.  # noqa: E501
        :type: str
        """

        self._next_page_token = next_page_token

    @property
    def total_count(self):
        """Gets the total_count of this V1AssemblyMetadata.  # noqa: E501

        The total count of available datasets (ignoring the cutoff parameter). Only provided for the first page of results (when `page_token` is empty in the request).  # noqa: E501

        :return: The total_count of this V1AssemblyMetadata.  # noqa: E501
        :rtype: int
        """
        return self._total_count

    @total_count.setter
    def total_count(self, total_count):
        """Sets the total_count of this V1AssemblyMetadata.

        The total count of available datasets (ignoring the cutoff parameter). Only provided for the first page of results (when `page_token` is empty in the request).  # noqa: E501

        :param total_count: The total_count of this V1AssemblyMetadata.  # noqa: E501
        :type: int
        """

        self._total_count = total_count

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, V1AssemblyMetadata):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, V1AssemblyMetadata):
            return True

        return self.to_dict() != other.to_dict()
