
Thanks for contributing to DASCore, community contributions are most welcomed!

Before contributing, please read through the [contributors doc](https://dascore.org/contributing/contributing.html)

Before making big changes to the code or adding large complex features, it is a good idea to
[open a discussion](https://github.com/DASDAE/dascore/discussions). Don't hesitate to ask a question or for
help if something isn't clear.

## Description

Please describe your PR here. What problem are you trying to solve, or what feature are you adding?

Also link any relevant issues/discussions (this can be done using the issue/discussion number preceded by a
pound sign, e.g. `#12` without the backticks)

## Checklist

I have (if applicable):

- [ ] referenced the GitHub issue this PR closes.
- [ ] [run pre-commit](https://dascore.org/contributing/style_and_linting.html) to ensure new code conform to DASCore's style guide.
- [ ] documented the new feature in docstrings or appropriate doc page.
- [ ] updated the changelog file (docs/changelog.md).
- [ ] included a test. See [testing guidelines](https://dascore.org/contributing/testing.html).
- [ ] first time contributors have been added to the contributors page (docs/contributors.md).
