<img src="./images/alphafold2.png" width="600px"></img>

## Alphafold2 - Pytorch (wip)

To eventually become an unofficial working Pytorch implementation of Alphafold2. Will be gradually implemented as more details of the architecture is released.

## Install

```bash
$ pip install alphafold2-pytorch
```

## Usage

```python
import torch
from alphafold2_pytorch import Alphafold2

model = Alphafold2(
    dim = 256,
    depth = 2,
    heads = 8,
    dim_head = 64
).cuda()

seq = torch.randint(0, 21, (1, 128)).cuda()
msa = torch.randint(0, 21, (1, 5, 64)).cuda()
mask = torch.ones_like(seq).bool().cuda()
msa_mask = torch.ones_like(msa).bool().cuda()

distogram = model(
    seq,
    msa,
    mask = mask,
    msa_mask = msa_mask
) # (1, 128, 128, 37)
```

## Speculation

https://fabianfuchsml.github.io/alphafold2/

https://moalquraishi.wordpress.com/2020/12/08/alphafold2-casp14-it-feels-like-ones-child-has-left-home/

<img src="./images/science.png"></img>

<img src="./images/reddit.png"></img>

Developments from competing labs

https://www.biorxiv.org/content/10.1101/2020.12.10.419994v1.full.pdf

Final step - <a href="https://graylab.jhu.edu/PyRosetta.documentation/pyrosetta.rosetta.protocols.relax.html#pyrosetta.rosetta.protocols.relax.FastRelax">Fast Relax</a>

## Citations

```bibtex
@misc{unpublished2021alphafold2,
    title={Alphafold2},
    author={John Jumper},
    year={2020},
    archivePrefix={arXiv},
    primaryClass={q-bio.BM}
}
```

```bibtex
@misc{king2020sidechainnet,
    title={SidechainNet: An All-Atom Protein Structure Dataset for Machine Learning}, 
    author={Jonathan E. King and David Ryan Koes},
    year={2020},
    eprint={2010.08162},
    archivePrefix={arXiv},
    primaryClass={q-bio.BM}
}
```

```bibtex
@misc{alquraishi2019proteinnet,
    title={ProteinNet: a standardized data set for machine learning of protein structure}, 
    author={Mohammed AlQuraishi},
    year={2019},
    eprint={1902.00249},
    archivePrefix={arXiv},
    primaryClass={q-bio.BM}
}
```
