"""
Copyright 2021 Patrick Schwab, Arash Mehrjou, GlaxoSmithKline plc; Andrew Jesson, University of Oxford; Ashkan Soleymani, MIT

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
"""
from abc import abstractmethod


class EmbeddingRetrievalModel:
    """An abstract model allowing retrieval of embedding layer and its gradient"""
    def __init__(self):
        super(EmbeddingRetrievalModel, self).__init__()

    @abstractmethod
    def get_gradient_embedding(self, dataset, eps: float = 0.001):
        raise NotImplementedError()

    @abstractmethod
    def get_embedding(self, dataset):
        raise NotImplementedError()

