# Generated by Django 4.0.5 on 2022-08-22 03:43

from typing import Any, List

import django.db.models.deletion
from django.db import connection, migrations, models


class Migration(migrations.Migration):
    def copy_existing(apps, _):
        if not apps.is_installed("basxconnect.core"):
            return
        with connection.cursor() as cursor:
            cursor.execute(
                "INSERT INTO taxonomy_vocabulary SELECT * FROM core_vocabulary;"
            )
            cursor.execute("INSERT INTO taxonomy_term SELECT * FROM core_term;")

    initial = True

    dependencies: List[Any] = []

    operations = [
        migrations.CreateModel(
            name="Vocabulary",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "name",
                    models.CharField(max_length=255, unique=True, verbose_name="Name"),
                ),
                (
                    "slug",
                    models.SlugField(
                        help_text="slug is human-readable, to make referencing easier",
                        unique=True,
                        verbose_name="Slug",
                    ),
                ),
            ],
            options={
                "verbose_name": "Vocabulary",
                "verbose_name_plural": "Vocabularies",
                "ordering": ["name"],
            },
        ),
        migrations.CreateModel(
            name="Term",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("term", models.CharField(max_length=255, verbose_name="Term")),
                (
                    "slug",
                    models.CharField(
                        blank=True, max_length=255, unique=True, verbose_name="Slug"
                    ),
                ),
                (
                    "vocabulary",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to="taxonomy.vocabulary",
                    ),
                ),
            ],
            options={
                "verbose_name": "Term",
                "verbose_name_plural": "Terms",
                "order_with_respect_to": "vocabulary",
            },
        ),
    ]
