Ansible Role: Filebeat for Elastic Stack
------------------------------------

An Ansible Role that installs [Filebeat](https://www.elastic.co/products/beats/filebeat), this can be used in conjunction with [ansible-wazuh-manager](https://github.com/wazuh/wazuh-ansible/ansible-wazuh-server).

Requirements
------------

This role will work on:
 * Red Hat
 * CentOS
 * Fedora
 * Debian
 * Ubuntu

Role Variables
--------------

Available variables are listed below, along with default values (see `defaults/main.yml`):

```
  filebeat_create_config: true

  filebeat_prospectors:
    - input_type: log
      paths:
        - "/var/ossec/logs/alerts/alerts.json"
      document_type: json
      json.message_key: log
      json.keys_under_root: true
      json.overwrite_keys: true

  filebeat_output_elasticsearch_enabled: false
  filebeat_output_elasticsearch_hosts:
    - "localhost:9200"

  filebeat_output_logstash_enabled: true
  filebeat_output_logstash_hosts:
    - "192.168.212.158:5000"

  filebeat_enable_logging: true
  filebeat_log_level: debug
  filebeat_log_dir: /var/log/mybeat
  filebeat_log_filename: mybeat.log

  filebeat_ssl_dir: /etc/pki/logstash
  filebeat_ssl_certificate_file: ""
  filebeat_ssl_key_file: ""
  filebeat_ssl_insecure: "false"
```

License and copyright
---------------------

WAZUH Copyright (C) 2017 Wazuh Inc. (License GPLv3)

### Based on previous work from geerlingguy

 - https://github.com/geerlingguy/ansible-role-filebeat

### Modified by Wazuh

The playbooks have been modified by Wazuh, including some specific requirements, templates and configuration to improve integration with Wazuh ecosystem.
