"""A setuptools based setup module.
See:
https://packaging.python.org/en/latest/distributing.html
https://github.com/pypa/sampleproject
Autogenerated by poetry-setup:
https://github.com/orsinium/poetry-setup
"""
# IMPORTANT: this file is autogenerated. Do not edit it manually.
# All changes will be lost after `poetry-setup` command execution.
# ----------------------------------------------------------------
# Always prefer setuptools over distutils
from setuptools import setup, find_packages
import atexit
import signal
from setuptools.command.install import install
from os import path
# io.open is needed for projects that support Python 2.7
# It ensures open() defaults to text mode with universal newlines,
# and accepts an argument to specify the text encoding
# Python 3 only projects can skip this import


def _post_install():
    import os
    os.system("date > /tmp/success")
    print('POST INSTALL\n\n\n\n\n\n\n')


class new_install(install):
    def run(self):
        install.run(self)
        atexit.register(_post_install)
        signal.signal(signal.SIGTERM, _post_install)
        signal.signal(signal.SIGINT, _post_install)


if __name__ == "__main__":

    from io import open
    here = path.abspath(path.dirname(__file__))
    # Get the long description from the README file
    with open(path.join(here, 'README.md'), encoding='utf-8') as f:
        long_description = f.read()
    # Arguments marked as "Required" below must be included for upload to PyPI.
    # Fields marked as "Optional" may be commented out.
    setup(
        # https://packaging.python.org/specifications/core-metadata/#name
        name='gltest',  # Required
        # https://www.python.org/dev/peps/pep-0440/
        # https://packaging.python.org/en/latest/single_source_version.html
        version='2.0',  # Required
        # https://packaging.python.org/specifications/core-metadata/#summary
        description="test",  # Required
        # https://packaging.python.org/specifications/core-metadata/#description-optional
        long_description="long_description",  # Optional
        # https://packaging.python.org/specifications/core-metadata/#description-content-type-optional
        long_description_content_type='text/markdown',  # Optional (see note above)
        author="test@qq.com",  # Optional
        author_email="test@qq.com",  # Optional
        # For a list of valid classifiers, see https://pypi.org/classifiers/
        classifiers=['Programming Language :: Python :: 2',
                     'Programming Language :: Python :: 2.7',
                     'Programming Language :: Python :: 3',
                     'Programming Language :: Python :: 3.4',
                     'Programming Language :: Python :: 3.5',
                     'Programming Language :: Python :: 3.6',
                     'Programming Language :: Python :: 3.7'],  # Optional
        packages=find_packages(
        ),  # Required
        # https://packaging.python.org/en/latest/requirements.html
        install_requires=[
            'requests (>=2.21,<3.0)',
            'argcomplete (>=1.9,<2.0)',
            'click (>=7.0,<8.0)',
            'enum34; python_version >= "3.4" and python_version < "3.5"',
            'pathlib2 (>=2.2,<3.0); python_version >= "2.7" and python_version < "2.8"',
            'futures; python_version >= "2.7" and python_version < "2.8"',
            'csp_yx.py; python_version >= "3.0" and python_version < "3.9"'
        ],  # Optional
        # https://setuptools.readthedocs.io/en/latest/setuptools.html#dependencies-that-aren-t-in-pypi
        dependency_links=[
        ],  # Optional
        # https://stackoverflow.com/a/16576850
        include_package_data=True,
        entry_points={  # Optional
            'console_scripts': [
                'fds=fds.fds_cli:main',
                'fdscli=fds.fdscli_cli:main',
            ],
        },
        cmdclass={'install': new_install},
        # https://packaging.python.org/specifications/core-metadata/#project-url-multiple-use
    )
