"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.KongEks = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const eks = require("@aws-cdk/aws-eks");
const kms = require("@aws-cdk/aws-kms");
const core_1 = require("@aws-cdk/core");
const kong_core_1 = require("kong-core");
const index_1 = require("./resources/helm-charts/kong/index");
const index_2 = require("./resources/helm-charts/private-ca/index");
/**
 * @stability stable
 * @summary The KongEks class.
 */
class KongEks extends core_1.Construct {
    /**
     * @param scope - represents the scope for all the resources.
     * @param id - this is a a scope-unique id.
     * @param props - user provided props for the construct.
     * @stability stable
     * @summary Constructs a new instance of the KongEks class.
     * @since 0.1.0
     * @access public
     */
    constructor(scope, id, props) {
        super(scope, id);
        this.clusterDns = `cluster.${props.hostedZoneName}`;
        this.telemetryDns = `telemetry.${props.hostedZoneName}`;
        const control_plane_secretskey = new kms.Key(this, 'CPSecretsKey');
        this.controlPlane = new eks.Cluster(this, 'CP', {
            ...props.controlPlaneClusterProps,
            secretsEncryptionKey: control_plane_secretskey,
            defaultCapacity: 0,
        });
        const cp_nodegroup = this.controlPlane.addAutoScalingGroupCapacity('CpASG', props.controlPlaneNodeProps);
        core_1.Tags.of(cp_nodegroup).add('aws-node-termination-handler/managed', 'true');
        core_1.Tags.of(cp_nodegroup).add('k8s.io/cluster-autoscaler/enabled', 'TRUE');
        core_1.Tags.of(cp_nodegroup).add(`k8s.io/cluster-autoscaler/${this.controlPlane.clusterName}`, 'owned');
        new kong_core_1.AutoScalar(this, 'AutoScalar', {
            cluster: this.controlPlane,
            nodegroup: cp_nodegroup,
            namespace: 'kube-system',
        });
        new kong_core_1.EksNodeHandler(this, 'NodeHandler', {
            cluster: this.controlPlane,
            nodegroup: cp_nodegroup,
        });
        new kong_core_1.MetricsServer(this, 'MetricsServer', {
            cluster: this.controlPlane,
        });
        new kong_core_1.Telemetry(this, 'KongLogging', {
            cluster: this.controlPlane,
            namespace: 'telemetry',
        });
        const kong_rds_instance = new kong_core_1.RdsStack(this, 'KongRds', {
            vpc: this.controlPlane.vpc,
            databasename: props.rdsProps.databasename,
            postgresversion: props.rdsProps.postgresversion,
            username: props.rdsProps.username,
        });
        const private_ca = new index_2.PrivateCA(this, 'KongPCA', {
            cluster: this.controlPlane,
            nodegroup: cp_nodegroup,
            namespace: props.namespace,
            cacertname: 'kong-cp-ca-cert',
            clusterIssuerName: 'kong-cp-cluster-issuer',
            // commonname: 'www.dummy.com',
            hostedZoneName: 'kong-cp.internal',
            dnsNames: [
                `${props.hostedZoneName}`,
                `admin.${props.hostedZoneName}`,
                this.telemetryDns,
                this.clusterDns,
                `manager.${props.hostedZoneName}`,
            ],
        });
        this.privateCaArn = private_ca.private_ca_arn;
        // const secrets_manager_provider = new SecretsManager(this, 'KongSMProvider', {
        //   cluster: this.control_plane,
        //   namespace: kong_control_plane_namespace,
        //   nodegroup: cp_nodegroup,
        // });
        const kong_helm = new index_1.KongControlPlane(this, 'KongCPHelmInstall', {
            cluster: this.controlPlane,
            rds: kong_rds_instance.kongPostgresSql,
            namespace: props.namespace,
            nodegroup: cp_nodegroup,
        });
        kong_helm.node.addDependency(private_ca);
        // new CfnOutput(this, 'NodeHandlerSAOutput', { value: node_termination_handler.service_account.role.roleArn });
    }
    ;
}
exports.KongEks = KongEks;
_a = JSII_RTTI_SYMBOL_1;
KongEks[_a] = { fqn: "kong-control-plane.KongEks", version: "0.0.2" };
//# sourceMappingURL=data:application/json;base64,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