from pathlib import Path

PROJECT_DIR = Path(__file__).parent.parent

TESTS_DIR = Path(__file__).parent
INPUT_FILES_DIR = TESTS_DIR / "input_files"
GENERATED_FILES_DIR = TESTS_DIR / "generated"
GENERATED_REPO_DIR = GENERATED_FILES_DIR / "project"
USING_TEMP_DIR_AS_GENERATED_DIR = False

TEMPLATES_DIR = INPUT_FILES_DIR / "templates"

COOKIECUTTERS_DIR = TEMPLATES_DIR / "cookiecutters"
COOKIECUTTER_ONE_NAME = "one"
COOKIECUTTER_ONE_DIR = COOKIECUTTERS_DIR / COOKIECUTTER_ONE_NAME
COOKIECUTTER_ONE_VERSION = "1c154af24ff30bc4cab8cf9d543304d9"
COOKIECUTTER_ONE_MODIFIED_VERSION = "2dc435b3d7e256fbdcc78e62faaabff4"
COOKIECUTTER_TWO_NAME = "two"
COOKIECUTTER_TWO_DIR = COOKIECUTTERS_DIR / COOKIECUTTER_TWO_NAME
COOKIECUTTER_WITH_HOOKS_NAME = "with-hooks"
COOKIECUTTER_WITH_HOOKS_DIR = COOKIECUTTERS_DIR / COOKIECUTTER_WITH_HOOKS_NAME
COOKIECUTTER_WITH_HOOKS_VERSION = "f54b5faa0a6318d5a21434235eb9e1a9"
COOKIECUTTER_WITH_HOOKS_MODIFIED_VERSION = "534cfcb2dce2a8d94e15e872e6ff08ba"
COOKIECUTTER_REMOTE_URL = (
    "https://github.com/nickderobertis/cookiecutter-simple-example"
)
COOKIECUTTER_REMOTE_NAME = "cookiecutter-simple-example"
COOKIECUTTER_REMOTE_VERSION_1 = "c390901c4fd599473bdb95fa4dd3d2a6eb2b34f0"
COOKIECUTTER_REMOTE_VERSION_2 = "ee8da996b5d74dfcbba5727d7c950c88173dc9ca"

COPIERS_DIR = TEMPLATES_DIR / "copiers"
COPIER_ONE_NAME = "one"
COPIER_ONE_DIR = COPIERS_DIR / COPIER_ONE_NAME
COPIER_ONE_VERSION = "a6e386b97e1d7de2670e4fc4fee5b655"
COPIER_ONE_MODIFIED_VERSION = "c5d65a8f94813d33ef031b597358d085"
COPIER_OUTPUT_SUBDIR_NAME = "output-subdir"
COPIER_OUTPUT_SUBDIR_DIR = COPIERS_DIR / COPIER_OUTPUT_SUBDIR_NAME
COPIER_OUTPUT_SUBDIR_VERSION = "783e158aea9852664d497b19f6ba7b8b"
COPIER_OUTPUT_SUBDIR_MODIFIED_VERSION = "does not matter yet for tests"
COPIER_FROM_COOKIECUTTER_ONE_NAME = "from-cookiecutter-one"
COPIER_FROM_COOKIECUTTER_ONE_DIR = COPIERS_DIR / COPIER_FROM_COOKIECUTTER_ONE_NAME
COPIER_FROM_COOKIECUTTER_ONE_VERSION = "5a4e3d4bf1fe026cb6e63dbca154825a"
COPIER_WITH_TASKS_NAME = "with-tasks"
COPIER_WITH_TASKS_DIR = COPIERS_DIR / COPIER_WITH_TASKS_NAME
COPIER_WITH_TASKS_VERSION = "ba749e5c12a24679aa138dfaec88f8ee"
COPIER_WITH_TASKS_MODIFIED_VERSION = "8597833b6069a1ecb114e5d84cee0d09"
COPIER_REMOTE_URL = "https://github.com/nickderobertis/copier-simple-example"
COPIER_REMOTE_NAME = "copier-simple-example"
COPIER_REMOTE_VERSION_1 = "c7e1ba1bfb141e9c577e7c21ee4a5d3ae5dde04d"
COPIER_REMOTE_VERSION_2 = "f3fa2c9526c12b3011e0a26108ce141373539bca"

CONFIGS_DIR = INPUT_FILES_DIR / "configs"
CONFIG_1_PATH = CONFIGS_DIR / "flexlate.json"
CONFIG_SUBDIR_1 = CONFIG_1_PATH / "subdir1"
CONFIG_SUBDIR_2 = CONFIGS_DIR / "subdir2"

PROJECTS_DIR = INPUT_FILES_DIR / "projects"
NESTED_PROJECT_DIR = PROJECTS_DIR / "nested"

PROJECT_CONFIGS_DIR = INPUT_FILES_DIR / "project_configs"
PROJECT_CONFIGS_ROOT_DIR = PROJECT_CONFIGS_DIR / "root"
PROJECT_CONFIGS_ROOT_CONFIG_PATH = PROJECT_CONFIGS_ROOT_DIR / "flexlate-project.json"
PROJECT_CONFIGS_PROJECT_1_PATH = PROJECT_CONFIGS_ROOT_DIR / "1"
PROJECT_CONFIGS_PROJECT_2_PATH = PROJECT_CONFIGS_ROOT_DIR / "2"
PROJECT_CONFIGS_PROJECT_1_SUBDIR = PROJECT_CONFIGS_PROJECT_1_PATH / "subdir"
PROJECT_CONFIGS_PROJECT_2_SUBDIR = PROJECT_CONFIGS_PROJECT_2_PATH / "subdir"
PROJECT_CONFIGS_1_CONFIG_PATH = PROJECT_CONFIGS_PROJECT_1_PATH / "flexlate-project.json"


if not GENERATED_FILES_DIR.exists():
    GENERATED_FILES_DIR.mkdir()
