import * as cloudwatch from 'aws-cdk-lib/aws-cloudwatch';
import * as iam from 'aws-cdk-lib/aws-iam';
import { IRole } from 'aws-cdk-lib/aws-iam';
import * as lambda from 'aws-cdk-lib/aws-lambda';
import { ILogGroup } from 'aws-cdk-lib/aws-logs';
import * as sns from 'aws-cdk-lib/aws-sns';
import * as sfn from 'aws-cdk-lib/aws-stepfunctions';
import { Construct } from 'constructs';
export { TextractGenericSyncSfnTask, TextractGenericSyncSfnTaskProps } from './textractSync';
export { TextractPOCDecider, TextractDPPOCDeciderProps } from './textractDecider';
export { TextractClassificationConfigurator, TextractClassificationConfiguratorProps } from './textractClassificationConfigurator';
export { TextractAsyncToJSON, TextractAsyncToJSONProps } from './textractOutputConfigToJSON';
export { TextractGenerateCSV, TextractGenerateCSVProps } from './textractGenerateCSV';
export { TextractA2ISfnTask, TextractA2ISfnTaskProps } from './textractA2I';
export { CSVToAuroraTask, CSVToAuroraTaskProps } from './rdsCSVToAurora';
export { ComprehendGenericSyncSfnTask, ComprehendGenericSyncSfnTaskProps } from './comprehendClassification';
export { SpacySfnTask, SpacySfnTaskProps } from './spacyClassification';
export { DocumentSplitter, DocumentSplitterProps } from './documentSplitter';
export { RDSAuroraServerless, RDSAuroraServerlessProps } from './rdsAuroraServerless';
export declare function validatePatternSupported(integrationPattern: sfn.IntegrationPattern, supportedPatterns: sfn.IntegrationPattern[]): void;
export declare function integrationResourceArn(service: string, api: string, integrationPattern?: sfn.IntegrationPattern): string;
export interface TextractGenericAsyncSfnTaskProps extends sfn.TaskStateBaseProps {
    /** Bucketname to output data to */
    readonly s3OutputBucket: string;
    /** The prefix to use for the temporary output files (e. g. output from async process before stiching together) */
    readonly s3TempOutputPrefix: string;
    /** Which Textract API to call
     * GENERIC and EXPENSE are supported.
     *
     * For GENERIC, when called without features (e. g. FORMS, TABLES, QUERIES), StartDetectText is called.
     * For GENERIC, when called with a feature (e. g. FORMS, TABLES, QUERIES),  StartAnalyzeDocument is called.
     * @default - GENERIC */
    readonly textractAPI?: 'GENERIC' | 'EXPENSE';
    /** number of retries in Step Function flow
     * @default is 100 */
    readonly textractAsyncCallMaxRetries?: number;
    /**retyr backoff rate
     * @default is 1.1 */
    readonly textractAsyncCallBackoffRate?: number;
    /** log level for Lambda function, supports DEBUG|INFO|WARNING|ERROR|FATAL
     * @default = DEBUG
    */
    readonly lambdaLogLevel?: 'DEBUG' | 'INFO' | 'WARNING' | 'ERROR' | 'FATAL';
    /**time in seconds to wait before next retry
     * @default is 1 */
    readonly textractAsyncCallInterval?: number;
    /** how long can we wait for the process
     * @default - 2880 (48 hours (60 min * 48 hours = 2880)) */
    readonly textractStateMachineTimeoutMinutes?: number;
    /** enable CloudWatch Metrics and Dashboard
     * @default - false
     */
    readonly enableCloudWatchMetricsAndDashboard?: boolean;
    /**
         * The JSON input for the execution, same as that of StartExecution.
         *
         * @see https://docs.aws.amazon.com/step-functions/latest/apireference/API_StartExecution.html
         *
         * @default - The state input (JSON path '$')
         */
    readonly input?: sfn.TaskInput;
    /**
            * The name of the execution, same as that of StartExecution.
            *
            * @see https://docs.aws.amazon.com/step-functions/latest/apireference/API_StartExecution.html
            *
            * @default - None
            */
    readonly name?: string;
    /**
            * Pass the execution ID from the context object to the execution input.
            * This allows the Step Functions UI to link child executions from parent executions, making it easier to trace execution flow across state machines.
            *
            * If you set this property to `true`, the `input` property must be an object (provided by `sfn.TaskInput.fromObject`) or omitted entirely.
            *
            * @see https://docs.aws.amazon.com/step-functions/latest/dg/concepts-nested-workflows.html#nested-execution-startid
            *
            * @default - false
            */
    readonly associateWithParent?: boolean;
}
/**
 * This Task calls the Textract through the asynchronous API.
 *
 * Which API to call is defined in
 *
 * When GENERIC is called with features in the manifest definition, will call the AnalzyeDocument API.
 *
 * Takes the configuration from "Payload"."manifest"
 *
 * Will retry on recoverable errors based on textractAsyncCallMaxRetries
 * errors for retry: ['ThrottlingException', 'LimitExceededException', 'InternalServerError', 'ProvisionedThroughputExceededException'],
 *
 * Internally calls Start* calls with OutputConfig and SNSNotification.
 * Another Lambda functions waits for SNS Notification event and notifies the Step Function flow with the task token.
 *
 * Step Function JSON input requirements
 *
 * **Input**: "Payload"."manifest"
 *
 * **Output**: "TextractTempOutputJsonPath" points to potentially paginated Textract JSON Schema output at "TextractTempOutputJsonPath" (using the example code it will be at: "textract_result"."TextractTempOutputJsonPath")
 *
 * Works together with TextractAsyncToJSON, which takes the s3_output_bucket/s3_temp_output_prefix location as input
 *
 * Example (Python)
 * ```python
    textract_async_task = tcdk.TextractGenericAsyncSfnTask(
        self,
        "TextractAsync",
        s3_output_bucket=s3_output_bucket,
        s3_temp_output_prefix=s3_temp_output_prefix,
        integration_pattern=sfn.IntegrationPattern.WAIT_FOR_TASK_TOKEN,
        lambda_log_level="DEBUG",
        timeout=Duration.hours(24),
        input=sfn.TaskInput.from_object({
            "Token":
            sfn.JsonPath.task_token,
            "ExecutionId":
            sfn.JsonPath.string_at('$$.Execution.Id'),
            "Payload":
            sfn.JsonPath.entire_payload,
        }),
        result_path="$.textract_result")
    ```

 */
export declare class TextractGenericAsyncSfnTask extends sfn.TaskStateBase {
    private readonly props;
    private static readonly SUPPORTED_INTEGRATION_PATTERNS;
    protected readonly taskMetrics?: sfn.TaskMetricsConfig;
    protected readonly taskPolicies?: iam.PolicyStatement[];
    private readonly integrationPattern;
    stateMachine: sfn.IStateMachine;
    startTextractLambdaLogGroup: ILogGroup;
    receiveStartSNSLambdaLogGroup: ILogGroup;
    taskTokenTableName: string;
    textractAsyncSNSRole: IRole;
    textractAsyncSNS: sns.ITopic;
    textractAsyncCallFunction: lambda.IFunction;
    textractAsyncReceiveSNSFunction: lambda.IFunction;
    asyncDurationMetric?: cloudwatch.IMetric;
    asyncNumberPagesMetric?: cloudwatch.IMetric;
    asyncJobFinshedMetric?: cloudwatch.IMetric;
    asyncJobStartedMetric?: cloudwatch.IMetric;
    asyncNumberPagesSendMetric?: cloudwatch.IMetric;
    constructor(scope: Construct, id: string, props: TextractGenericAsyncSfnTaskProps);
    /**
         * @internal
         */
    protected _renderTask(): any;
    /**
         * As StateMachineArn is extracted automatically from the state machine object included in the constructor,
         *
         * the scoped access policy should be generated accordingly.
         *
         * This means the action of StartExecution should be restricted on the given state machine, instead of being granted to all the resources (*).
         */
    private createScopedAccessPolicy;
}
