# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['steamsync', 'steamsync.launchers']

package_data = \
{'': ['*'], 'steamsync.launchers': ['static/*']}

install_requires = \
['appdirs>=1.4.4,<2.0.0',
 'requests>=2.28.2,<3.0.0',
 'toml>=0.10.2,<0.11.0',
 'vdf>=3.3,<4.0']

entry_points = \
{'console_scripts': ['steamsync = steamsync.steamsync:main']}

setup_kwargs = {
    'name': 'steamsync',
    'version': '0.4.1',
    'description': 'Tool to automatically add games from the Epic Games Launcher to Steam',
    'long_description': '## steamsync cli\n[![PyPI version](https://badge.fury.io/py/steamsync.svg)](https://badge.fury.io/py/steamsync)\n\nSimple command line tool (and poorly documented library!) to automatically add\ngames from the Epic Games Launcher to Steam.\n\nMakes playing all of those free EGS games in Big Picture Mode a lot easier. In my experience,\nwhen launching from Big Picture Mode, Steam Input works as expected (even in Fortnite!).\n\nsteamsync will scan all of the Epic Games Store games installed on your computer and\nadd them to your Steam Library. If a shortcut with the same path already exists, it will\nskip it, so it\'s safe to import all of your games over and over.\n\nsteamsync attempts to be simple. It does not attempt to fetch any banner art, it\n simply uses the executable\'s icon as the icon in steam.\n\n### Installation (brief)\nRequires > Python 3.8\n\n```console\n$ pip install steamsync\n$ steamsync\n```\n\n## Installation and Usage (for beginners)\n\n1. [Download Python 3.8](https://www.python.org/downloads/)\n2. Choose the latest version of Python 3.8, and get the "Windows x86-64 executable installer" option\n3. When installing Python, make sure to install pip and to *add Python to your PATH*\n4. Open Commmand Prompt (search Start Menu for cmd.exe)\n5. Type `pip install steamsync`, press enter.\n6. Make sure Steam is not running!\n7. Type `steamsync.py`, press enter. The tool will walk you through everything else.\n   Press ctrl+c if you get scared and want to abort.\n\n## Usage\n```\n(steamsync-py3.10) PS C:\\Users\\jayde\\Documents\\GitHub\\steamsync> steamsync -h  \nusage: steamsync [-h] [--source {legendary,epicstore,itchio,xbox}] \n                      [--egs-manifests EGS_MANIFESTS] \n                      [--legendary-command LEGENDARY_COMMAND] \n                      [--itch-library ITCH_LIBRARY] \n                      [--steam-path STEAM_PATH] \n                      [--all] \n                      [--replace-existing] \n                      [--remove-missing] \n                      [--live-dangerously] \n                      [--steamid STEAMID] \n                      [--use-uri]\n                      [--download-art] \n                      [--download-art-all-shortcuts] \n                      [--init-shortcuts-file]\n\nUtility to import games from the Epic Games Store, Microsoft Store (Xbox for \nWindows), and itch.io to your Steam library\n\noptions:\n  -h, --help            show this help message and exit\n  --source {legendary,epicstore,itchio,xbox}\n                        Storefronts with games to add to Steam. If unspecified, \n                        uses all sources. Use argument multiple times to select \n                        multiple sources (--source itchio --source xbox). \n                        (default: None)\n  --egs-manifests EGS_MANIFESTS\n                        Path to search for Epic Games Store manifest files \n                        (default: C:\\ProgramData\\Epic\\EpicGamesLauncher\\Data\\Manifests)\n  --legendary-command LEGENDARY_COMMAND\n                        Command/Path to run \'legendary\' executable \n                        (default: legendary)\n  --itch-library ITCH_LIBRARY\n                        Path where the itch.io app installs games \n                        (default: C:\\Users\\jayde\\AppData\\Roaming\\itch\\itch\\apps)\n  --steam-path STEAM_PATH\n                        Path to Steam installation (default: C:\\Program Files (x86)\\Steam)\n  --all                 \n                        Install all games found, do not prompt user to select which \n                        (default: False)\n  --replace-existing    \n                        Instead of skipping existing shortcuts (ones with the \n                        same path), overwrite them with new data. Useful to \n                        repair broken shortcuts. \n                        (default: False)\n  --remove-missing      \n                        Remove shortcuts to games that no longer exist. Uses \n                        selected sources to determine if games without executables \n                        (uri or Xbox) still exist. i.e., if you don\'t include \n                        xbox source all xbox games will appear to be missing. \n                        (default: False)\n  --live-dangerously    \n                        Don\'t backup Steam\'s shortcuts.vdf file to shortcuts.vdf-{time}.bak \n                        (default: False)\n  --steamid STEAMID     SteamID or username to install the shortcuts to, only \n                        needed if >1 accounts on this machine \n                        (default: )\n  --use-uri             \n                        Use a launcher URI (`com.epicgames.launcher://apps/fortnite?action=launch&silent=true`) \n                        instead of the path to the executable (eg `C:\\Fortnite\\Fortnite.exe`). \n                        Some games with online functionality (eg GTAV) require \n                        being launched through the EGS. Other games work better with Steam      \n                        game streaming (eg Steam Link or Big Picture) using the path to the executable. \n                        (default: False)\n  --download-art        \n                        Download Steam grid and Big Picture art from steam\'s \n                        servers for games we\'re adding. Only downloads art that \n                        we haven\'t already downloaded. \n                        (default: False)\n  --download-art-all-shortcuts\n                        Download Steam grid and Big Picture art for all non-steam \n                        game shortcuts. Only downloads art that we haven\'t already \n                        downloaded. Implies --download-art \n                        (default: False)\n  --init-shortcuts-file\n                        Initialize Steam shortcuts.vdf file if it doesn\'t exist.\n                        EXPERIMENTAL!! \n                        (default: False)\n```\n\n### FAQ\n#### Does this work on OSX?\nProbably not. You may have luck with `--egs-manifests` and `--steam-path`, maybe\nMRs are welcome\n\n#### What about Linux?\nWhen using [Legendary](https://github.com/derrod/legendary) or [Heroic](https://github.com/Heroic-Games-Launcher/HeroicGamesLauncher) steamsync should work.\nUse `--legendary-command` option to path to correct binary if not already in `PATH`.\nNot tested with [Rare](https://github.com/Dummerle/Rare)\nNot tested with EGS running through Wine.\n\n#### It doesn\'t work!\nOpen an issue on GitHub.\n\n#### Steam crashed after opening my library the first time, but worked after that\nWeird, right? Mine did that too ¯\\\\_(ツ)_/¯. Maybe loading 52 shortcuts at once\nwas too much for it.\n\n#### I want to go back to the way it was\nsteamsync will backup your `shortcuts.vdf` file by default every time you run it.\n\nGo to `C:\\Program Files (x86)\\Steam\\userdata\\{your steam userid}\\config`. You will see some\n`shortcuts.vdf-DATE.bak` files. Delete `shortcuts.vdf` (this is the one steamsync modified),\nand rename the `.bak` file you want to use to `shortcuts.vdf`, restart steam.\n\n#### I got a `could not find shortcuts file at ...` error\nTry making a shortcut in Steam (Library ➡ ➕ Add Game ➡ Add a Non-Steam Game...) first.\nBy default steamsync will not make a `shortcuts.vdf` file for you if it isn\'t already there.\nYou can enable the experimental functionality for automatically initializing the\n`shortcuts.vdf` file with the `--init-shortcuts-file` option.\n\n#### Can this run automagically?\nYes, yes it can! (you may need to adjust paths below)\n\n1. Open Task Scheduler (start + type "task...")\n2. Action Menu ➡ Create Basic Task\n3. Fill in a name and description\n4. Set the trigger you want to use (daily, log in, etc), Next\n5. Action = Start a Program\n6. Program/Script is `pythonw`\n7. Add arguments `C:\\Users\\{username}\\AppData\\Local\\Programs\\Python\\Python38\\Scripts\\steamsync.py --all --steamid={steam id}`, Next\n8. Make sure to restart Steam once in a while\n\nTADA!\n',
    'author': 'Jayden Milne',
    'author_email': 'jaydenmilne@users.noreply.github.com',
    'maintainer': 'None',
    'maintainer_email': 'None',
    'url': 'https://github.com/jaydenmilne/steamsync',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.10,<4.0',
}


setup(**setup_kwargs)
