# DO NOT EDIT! This file is automatically generated
import typing

from commercetools.helpers import RemoveEmptyValuesMixin
from commercetools.platform.models.cart import CartPagedQueryResponse
from commercetools.platform.models.customer import CustomerSignInResult
from commercetools.platform.models.me import (
    MyCart,
    MyCartDraft,
    MyCartUpdate,
    MyCartUpdateAction,
    MyCustomer,
    MyCustomerDraft,
    MyOrder,
    MyOrderFromCartDraft,
    MyPayment,
    MyPaymentDraft,
    MyPaymentPagedQueryResponse,
    MyPaymentUpdate,
    MyPaymentUpdateAction,
    MyShoppingListDraft,
    MyShoppingListUpdate,
    MyShoppingListUpdateAction,
)
from commercetools.platform.models.order import OrderPagedQueryResponse
from commercetools.platform.models.shopping_list import (
    MyShoppingList,
    ShoppingListPagedQueryResponse,
)
from commercetools.typing import OptionalListStr

from . import abstract, traits


class _MeQuerySchema(
    traits.SortableSchema,
    traits.PagingSchema,
    traits.ExpandableSchema,
    traits.QuerySchema,
):
    pass


class _MeUpdateSchema(traits.ExpandableSchema, traits.VersionedSchema):
    pass


class _MeDeleteSchema(traits.VersionedSchema, traits.ExpandableSchema):
    pass


class MeService(abstract.AbstractService):
    def my_cart_get_by_id(self, id: str, *, expand: OptionalListStr = None) -> MyCart:
        params = self._serialize_params({"expand": expand}, traits.ExpandableSchema)
        return self._client._get(
            endpoint=f"me/carts/{id}", params=params, response_class=MyCart
        )

    def my_order_get_by_id(self, id: str, *, expand: OptionalListStr = None) -> MyOrder:
        params = self._serialize_params({"expand": expand}, traits.ExpandableSchema)
        return self._client._get(
            endpoint=f"me/orders/{id}", params=params, response_class=MyOrder
        )

    def my_payment_get_by_id(
        self, id: str, *, expand: OptionalListStr = None
    ) -> MyPayment:
        params = self._serialize_params({"expand": expand}, traits.ExpandableSchema)
        return self._client._get(
            endpoint=f"me/payments/{id}", params=params, response_class=MyPayment
        )

    def my_payment_get_by_key(
        self, key: str, *, expand: OptionalListStr = None
    ) -> MyPayment:
        params = self._serialize_params({"expand": expand}, traits.ExpandableSchema)
        return self._client._get(
            endpoint=f"me/payments/key={key}", params=params, response_class=MyPayment
        )

    def my_shopping_list_get_by_id(
        self, id: str, *, expand: OptionalListStr = None
    ) -> MyShoppingList:
        params = self._serialize_params({"expand": expand}, traits.ExpandableSchema)
        return self._client._get(
            endpoint=f"me/shopping-lists/{id}",
            params=params,
            response_class=MyShoppingList,
        )

    def my_shopping_list_get_by_key(
        self, key: str, *, expand: OptionalListStr = None
    ) -> MyShoppingList:
        params = self._serialize_params({"expand": expand}, traits.ExpandableSchema)
        return self._client._get(
            endpoint=f"me/shopping-lists/key={key}",
            params=params,
            response_class=MyShoppingList,
        )

    def my_cart_query(
        self,
        *,
        expand: OptionalListStr = None,
        sort: OptionalListStr = None,
        limit: int = None,
        offset: int = None,
        with_total: bool = None,
        where: OptionalListStr = None,
        predicate_var: typing.Dict[str, str] = None,
    ) -> CartPagedQueryResponse:
        """A shopping cart holds product variants and can be ordered."""
        params = self._serialize_params(
            {
                "expand": expand,
                "sort": sort,
                "limit": limit,
                "offset": offset,
                "with_total": with_total,
                "where": where,
                "predicate_var": predicate_var,
            },
            _MeQuerySchema,
        )
        return self._client._get(
            endpoint="me/carts", params=params, response_class=CartPagedQueryResponse
        )

    def my_order_query(
        self,
        *,
        expand: OptionalListStr = None,
        sort: OptionalListStr = None,
        limit: int = None,
        offset: int = None,
        with_total: bool = None,
        where: OptionalListStr = None,
        predicate_var: typing.Dict[str, str] = None,
    ) -> OrderPagedQueryResponse:
        """An order can be created from a cart, usually after a checkout process has
        been completed.
        """
        params = self._serialize_params(
            {
                "expand": expand,
                "sort": sort,
                "limit": limit,
                "offset": offset,
                "with_total": with_total,
                "where": where,
                "predicate_var": predicate_var,
            },
            _MeQuerySchema,
        )
        return self._client._get(
            endpoint="me/orders", params=params, response_class=OrderPagedQueryResponse
        )

    def my_payment_query(
        self,
        *,
        expand: OptionalListStr = None,
        sort: OptionalListStr = None,
        limit: int = None,
        offset: int = None,
        with_total: bool = None,
        where: OptionalListStr = None,
        predicate_var: typing.Dict[str, str] = None,
    ) -> MyPaymentPagedQueryResponse:
        """The My Payments endpoint creates and provides access to payments scoped
        to a specific user.
        """
        params = self._serialize_params(
            {
                "expand": expand,
                "sort": sort,
                "limit": limit,
                "offset": offset,
                "with_total": with_total,
                "where": where,
                "predicate_var": predicate_var,
            },
            _MeQuerySchema,
        )
        return self._client._get(
            endpoint="me/payments",
            params=params,
            response_class=MyPaymentPagedQueryResponse,
        )

    def my_shopping_list_query(
        self,
        *,
        expand: OptionalListStr = None,
        sort: OptionalListStr = None,
        limit: int = None,
        offset: int = None,
        with_total: bool = None,
        where: OptionalListStr = None,
        predicate_var: typing.Dict[str, str] = None,
    ) -> ShoppingListPagedQueryResponse:
        """The My Shopping Lists endpoint creates and provides access to shopping
        lists scoped to a specific user.
        """
        params = self._serialize_params(
            {
                "expand": expand,
                "sort": sort,
                "limit": limit,
                "offset": offset,
                "with_total": with_total,
                "where": where,
                "predicate_var": predicate_var,
            },
            _MeQuerySchema,
        )
        return self._client._get(
            endpoint="me/shopping-lists",
            params=params,
            response_class=ShoppingListPagedQueryResponse,
        )

    def query(
        self,
        *,
        sort: OptionalListStr = None,
        limit: int = None,
        offset: int = None,
        with_total: bool = None,
        expand: OptionalListStr = None,
        where: OptionalListStr = None,
        predicate_var: typing.Dict[str, str] = None,
    ) -> MyCustomer:
        params = self._serialize_params(
            {
                "sort": sort,
                "limit": limit,
                "offset": offset,
                "with_total": with_total,
                "expand": expand,
                "where": where,
                "predicate_var": predicate_var,
            },
            _MeQuerySchema,
        )
        return self._client._get(
            endpoint="me", params=params, response_class=MyCustomer
        )

    def create(self) -> MyCustomer:
        """Update my customer"""
        params: typing.Dict[str, str] = {}
        return self._client._post(
            endpoint="me", params=params, data_object=None, response_class=MyCustomer
        )

    def my_cart_create(
        self, draft: MyCartDraft, *, expand: OptionalListStr = None
    ) -> MyCart:
        """A shopping cart holds product variants and can be ordered."""
        params = self._serialize_params({"expand": expand}, traits.ExpandableSchema)
        return self._client._post(
            endpoint="me/carts", params=params, data_object=draft, response_class=MyCart
        )

    def my_order_create(
        self, draft: MyOrderFromCartDraft, *, expand: OptionalListStr = None
    ) -> MyOrder:
        """An order can be created from a cart, usually after a checkout process has
        been completed.
        """
        params = self._serialize_params({"expand": expand}, traits.ExpandableSchema)
        return self._client._post(
            endpoint="me/orders",
            params=params,
            data_object=draft,
            response_class=MyOrder,
        )

    def my_payment_create(
        self, draft: MyPaymentDraft, *, expand: OptionalListStr = None
    ) -> MyPayment:
        """The My Payments endpoint creates and provides access to payments scoped
        to a specific user.
        """
        params = self._serialize_params({"expand": expand}, traits.ExpandableSchema)
        return self._client._post(
            endpoint="me/payments",
            params=params,
            data_object=draft,
            response_class=MyPayment,
        )

    def my_shopping_list_create(
        self, draft: MyShoppingListDraft, *, expand: OptionalListStr = None
    ) -> MyShoppingList:
        """The My Shopping Lists endpoint creates and provides access to shopping
        lists scoped to a specific user.
        """
        params = self._serialize_params({"expand": expand}, traits.ExpandableSchema)
        return self._client._post(
            endpoint="me/shopping-lists",
            params=params,
            data_object=draft,
            response_class=MyShoppingList,
        )

    def my_cart_update_by_id(
        self,
        id: str,
        version: int,
        actions: typing.List[MyCartUpdateAction],
        *,
        expand: OptionalListStr = None,
        force_update: bool = False,
    ) -> MyCart:
        params = self._serialize_params({"expand": expand}, _MeUpdateSchema)
        update_action = MyCartUpdate(version=version, actions=actions)
        return self._client._post(
            endpoint=f"me/carts/{id}",
            params=params,
            data_object=update_action,
            response_class=MyCart,
            force_update=force_update,
        )

    def my_payment_update_by_id(
        self,
        id: str,
        version: int,
        actions: typing.List[MyPaymentUpdateAction],
        *,
        expand: OptionalListStr = None,
        force_update: bool = False,
    ) -> MyPayment:
        params = self._serialize_params({"expand": expand}, _MeUpdateSchema)
        update_action = MyPaymentUpdate(version=version, actions=actions)
        return self._client._post(
            endpoint=f"me/payments/{id}",
            params=params,
            data_object=update_action,
            response_class=MyPayment,
            force_update=force_update,
        )

    def my_payment_update_by_key(
        self,
        key: str,
        version: int,
        actions: typing.List[MyPaymentUpdateAction],
        *,
        expand: OptionalListStr = None,
        force_update: bool = False,
    ) -> MyPayment:
        params = self._serialize_params({"expand": expand}, _MeUpdateSchema)
        update_action = MyPaymentUpdate(version=version, actions=actions)
        return self._client._post(
            endpoint=f"me/payments/key={key}",
            params=params,
            data_object=update_action,
            response_class=MyPayment,
            force_update=force_update,
        )

    def my_shopping_list_update_by_id(
        self,
        id: str,
        version: int,
        actions: typing.List[MyShoppingListUpdateAction],
        *,
        expand: OptionalListStr = None,
        force_update: bool = False,
    ) -> MyShoppingList:
        params = self._serialize_params({"expand": expand}, _MeUpdateSchema)
        update_action = MyShoppingListUpdate(version=version, actions=actions)
        return self._client._post(
            endpoint=f"me/shopping-lists/{id}",
            params=params,
            data_object=update_action,
            response_class=MyShoppingList,
            force_update=force_update,
        )

    def my_shopping_list_update_by_key(
        self,
        key: str,
        version: int,
        actions: typing.List[MyShoppingListUpdateAction],
        *,
        expand: OptionalListStr = None,
        force_update: bool = False,
    ) -> MyShoppingList:
        params = self._serialize_params({"expand": expand}, _MeUpdateSchema)
        update_action = MyShoppingListUpdate(version=version, actions=actions)
        return self._client._post(
            endpoint=f"me/shopping-lists/key={key}",
            params=params,
            data_object=update_action,
            response_class=MyShoppingList,
            force_update=force_update,
        )

    def my_cart_delete_by_id(
        self,
        id: str,
        version: int,
        *,
        expand: OptionalListStr = None,
        force_delete: bool = False,
    ) -> MyCart:
        params = self._serialize_params(
            {"version": version, "expand": expand}, _MeDeleteSchema
        )
        return self._client._delete(
            endpoint=f"me/carts/{id}",
            params=params,
            response_class=MyCart,
            force_delete=force_delete,
        )

    def my_payment_delete_by_id(
        self,
        id: str,
        version: int,
        *,
        expand: OptionalListStr = None,
        force_delete: bool = False,
    ) -> MyPayment:
        params = self._serialize_params(
            {"version": version, "expand": expand}, _MeDeleteSchema
        )
        return self._client._delete(
            endpoint=f"me/payments/{id}",
            params=params,
            response_class=MyPayment,
            force_delete=force_delete,
        )

    def my_payment_delete_by_key(
        self,
        key: str,
        version: int,
        *,
        expand: OptionalListStr = None,
        force_delete: bool = False,
    ) -> MyPayment:
        params = self._serialize_params(
            {"version": version, "expand": expand}, _MeDeleteSchema
        )
        return self._client._delete(
            endpoint=f"me/payments/key={key}",
            params=params,
            response_class=MyPayment,
            force_delete=force_delete,
        )

    def my_shopping_list_delete_by_id(
        self,
        id: str,
        version: int,
        *,
        expand: OptionalListStr = None,
        force_delete: bool = False,
    ) -> MyShoppingList:
        params = self._serialize_params(
            {"version": version, "expand": expand}, _MeDeleteSchema
        )
        return self._client._delete(
            endpoint=f"me/shopping-lists/{id}",
            params=params,
            response_class=MyShoppingList,
            force_delete=force_delete,
        )

    def my_shopping_list_delete_by_key(
        self,
        key: str,
        version: int,
        *,
        expand: OptionalListStr = None,
        force_delete: bool = False,
    ) -> MyShoppingList:
        params = self._serialize_params(
            {"version": version, "expand": expand}, _MeDeleteSchema
        )
        return self._client._delete(
            endpoint=f"me/shopping-lists/key={key}",
            params=params,
            response_class=MyShoppingList,
            force_delete=force_delete,
        )

    def active_cart(self) -> MyCart:
        params: typing.Dict[str, str] = {}
        return self._client._get(
            endpoint="me/active-cart", params=params, response_class=MyCart
        )

    def email_confirm(self):
        params: typing.Dict[str, str] = {}
        return self._client._post(
            endpoint="me/email/confirm", params=params, data_object=None
        )

    def login(self) -> CustomerSignInResult:
        params: typing.Dict[str, str] = {}
        return self._client._post(
            endpoint="me/login",
            params=params,
            data_object=None,
            response_class=CustomerSignInResult,
        )

    def password(self) -> MyCustomer:
        params: typing.Dict[str, str] = {}
        return self._client._post(
            endpoint="me/password",
            params=params,
            data_object=None,
            response_class=MyCustomer,
        )

    def signup(self, draft: MyCustomerDraft) -> CustomerSignInResult:
        params: typing.Dict[str, str] = {}
        return self._client._post(
            endpoint="me/signup",
            params=params,
            data_object=draft,
            response_class=CustomerSignInResult,
        )
