#!/usr/bin/env python

"""The setup script."""

from setuptools import setup, find_packages

with open('README.rst') as readme_file:
    readme = readme_file.read()

with open('HISTORY.rst') as history_file:
    history = history_file.read()

requirements = ['Click>=7.0', 'spacy>=3.0', 'numpy>1.0', 'matplotlib>3.0','pandas>1.0','seaborn>0.11']

test_requirements = [ ]

setup(
    author="Jonathan St-Onge",
    author_email='jonathanstonge7@gmail.com',
    python_requires='>=3.6',
    classifiers=[
        'Development Status :: 2 - Pre-Alpha',
        'Intended Audience :: Developers',
        'License :: OSI Approved :: MIT License',
        'Natural Language :: English',
        'Programming Language :: Python :: 3',
        'Programming Language :: Python :: 3.6',
        'Programming Language :: Python :: 3.7',
        'Programming Language :: Python :: 3.8',
    ],
    description="A python package for tidytext analysis.",
    entry_points={
        'console_scripts': [
            'tidytxt=tidytxt.cli:main',
        ],
    },
    install_requires=requirements,
    license="MIT license",
    long_description=readme + '\n\n' + history,
    include_package_data=True,
    keywords='tidytxt',
    name='tidytxt',
    packages=find_packages(include=['tidytxt', 'tidytxt.*']),
    test_suite='tests',
    tests_require=test_requirements,
    url='https://github.com/jstonge/tidytxt',
    version='0.1.0',
    zip_safe=False,
)
