import * as lambda from '@aws-cdk/aws-lambda';
import { Duration, NestedStack } from '@aws-cdk/core';
import * as cr from '@aws-cdk/custom-resources';
import { Construct } from 'constructs';
/**
 * Properties for a ReplicaProvider
 */
export interface ReplicaProviderProps {
    /**
     * The timeout for the replication operation.
     *
     * @default Duration.minutes(30)
     */
    readonly timeout?: Duration;
}
export declare class ReplicaProvider extends NestedStack {
    /**
     * Creates a stack-singleton resource provider nested stack.
     */
    static getOrCreate(scope: Construct, props?: ReplicaProviderProps): ReplicaProvider;
    private static getOrCreateCalls;
    private static checkManagedPoliciesLimit;
    /**
     * The custom resource provider.
     */
    readonly provider: cr.Provider;
    /**
     * The onEvent handler
     */
    readonly onEventHandler: lambda.Function;
    /**
     * The isComplete handler
     */
    readonly isCompleteHandler: lambda.Function;
    private constructor();
}
