import logging
import time
from timeit import default_timer as timer
import cv2

import sys

from gspeerconnection.gspeerconnectionwatcher import FrameBufferThread


class GSHLSPlayer:

    def __init__(self, gsdbs, onframe, ondestruct):
        self.gsdbs = gsdbs
        self.target = "hls_playlist"
        self.onframe = onframe
        self.ondestruct = ondestruct
        self.logger = logging.getLogger(__name__)
        self.broadcastthread = FrameBufferThread(self.gsdbs, self.target, self.onframe)
        self.broadcastthread.start()

    @classmethod
    async def create(cls, gshlsplayer, url):
        self = gshlsplayer
        self.url = url
        self._logger = logging.getLogger(__name__)
        self.url += f"&vision=true&session={self.gsdbs.cookiejar.get('session')}&signature={self.gsdbs.cookiejar.get('signature')}"
        cap = cv2.VideoCapture(self.url)

        if cap.isOpened() == False:
            self._logger.error("unable to open playlist")
            return
        fps = cap.get(cv2.CAP_PROP_FPS)
        # fps = 1000
        wait_ms = (1000 / fps)
        self._logger.info(f"playing back HLS-Playlist with {fps} fps")
        framecount = 0
        while True:
            ret, frame = cap.read()
            if not ret:
                break

            start_time = time.time()

            self.broadcastthread.write(frame)

            end_time = time.time()

            execution_time_ms = (end_time - start_time) * 1000

            calculatedwait = wait_ms - execution_time_ms / 1000
            # self.logger.info(f"frame written with id {framecount}")
            framecount = framecount + 1
            if calculatedwait > 0:
                time.sleep(calculatedwait / 1000)

        self.ondestruct(self.gsdbs)

        cap.release()
