# Generated by Django 4.1.8 on 2023-04-07 10:05

import re

import django.core.validators
import django.db.models.deletion
import django_countries.fields
import django_tools.file_storage.file_system_storage
from django.db import migrations, models

import reversion_compare_project.models


class Migration(migrations.Migration):
    initial = True

    dependencies = []

    operations = [
        migrations.CreateModel(
            name='Building',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('address', models.CharField(max_length=128)),
            ],
        ),
        migrations.CreateModel(
            name='CountryFieldTestModel',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('one_country', django_countries.fields.CountryField(max_length=2)),
                ('multiple_countries', django_countries.fields.CountryField(max_length=746, multiple=True)),
            ],
        ),
        migrations.CreateModel(
            name='CustomModel',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('text', models.TextField()),
            ],
        ),
        migrations.CreateModel(
            name='MigrationModel',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                (
                    'info',
                    models.CharField(
                        help_text='This field never changed and contains info about migration/version', max_length=255
                    ),
                ),
                (
                    'number_then_text',
                    models.IntegerField(help_text='migrate between CharField -> IntegerField -> CharField'),
                ),
                (
                    'text',
                    models.CharField(
                        help_text='TextField -> CharField(max_length=128) -> CharField(max_length=64)', max_length=128
                    ),
                ),
            ],
        ),
        migrations.CreateModel(
            name='Person',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=100)),
            ],
        ),
        migrations.CreateModel(
            name='Pet',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=100)),
            ],
        ),
        migrations.CreateModel(
            name='SimpleModel',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('text', models.CharField(max_length=255)),
            ],
        ),
        migrations.CreateModel(
            name='VariantModel',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('boolean', models.BooleanField(default=True)),
                ('null_boolean', models.BooleanField(null=True)),
                ('char', models.CharField(blank=True, max_length=1, null=True)),
                (
                    'choices_char',
                    models.CharField(blank=True, choices=[('a', 'alpha'), ('b', 'bravo')], max_length=1, null=True),
                ),
                ('text', models.TextField(blank=True, null=True)),
                ('integer', models.IntegerField(blank=True, null=True)),
                (
                    'integers',
                    models.CharField(
                        blank=True,
                        max_length=64,
                        null=True,
                        validators=[
                            django.core.validators.RegexValidator(
                                re.compile('^\\d+(?:,\\d+)*\\Z'),
                                code='invalid',
                                message='Enter only digits separated by commas.',
                            )
                        ],
                    ),
                ),
                ('positive_integer', models.PositiveIntegerField(blank=True, null=True)),
                ('big_integer', models.BigIntegerField(blank=True, null=True)),
                ('time', models.TimeField(blank=True, null=True)),
                ('date', models.DateField(blank=True, null=True)),
                ('datetime', models.DateTimeField(blank=True, null=True)),
                ('decimal', models.DecimalField(blank=True, decimal_places=3, max_digits=5, null=True)),
                ('float', models.FloatField(blank=True, null=True)),
                ('email', models.EmailField(blank=True, max_length=254, null=True)),
                ('url', models.URLField(blank=True, null=True)),
                (
                    'file_field',
                    models.FileField(
                        blank=True,
                        null=True,
                        storage=django_tools.file_storage.file_system_storage.OverwriteFileSystemStorage(
                            create_backups=False
                        ),
                        upload_to='',
                    ),
                ),
                (
                    'filepath',
                    models.FilePathField(blank=True, null=True, path=reversion_compare_project.models.get_filepath),
                ),
                ('ip_address', models.GenericIPAddressField(blank=True, null=True)),
            ],
        ),
        migrations.CreateModel(
            name='Factory',
            fields=[
                (
                    'building_ptr',
                    models.OneToOneField(
                        auto_created=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        parent_link=True,
                        primary_key=True,
                        serialize=False,
                        to='reversion_compare_project.building',
                    ),
                ),
                ('name', models.CharField(max_length=128)),
            ],
            bases=('reversion_compare_project.building',),
        ),
        migrations.CreateModel(
            name='TemplateField',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('text', models.CharField(max_length=20)),
                (
                    'template',
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        to='reversion_compare_project.person',
                    ),
                ),
            ],
        ),
        migrations.AddField(
            model_name='person',
            name='pets',
            field=models.ManyToManyField(blank=True, to='reversion_compare_project.pet'),
        ),
        migrations.AddField(
            model_name='person',
            name='workplace',
            field=models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.CASCADE,
                related_name='workers',
                to='reversion_compare_project.building',
            ),
        ),
        migrations.CreateModel(
            name='Identity',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('id_numer', models.CharField(max_length=100)),
                (
                    'person',
                    models.OneToOneField(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name='_identity',
                        to='reversion_compare_project.person',
                    ),
                ),
            ],
        ),
        migrations.CreateModel(
            name='Car',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=128)),
                (
                    'manufacturer',
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name='cars',
                        to='reversion_compare_project.factory',
                    ),
                ),
                (
                    'supplier',
                    models.ManyToManyField(
                        blank=True, related_name='suppliers', to='reversion_compare_project.factory'
                    ),
                ),
            ],
        ),
    ]
