"use strict";
const assert_1 = require("@aws-cdk/assert");
const core_1 = require("@aws-cdk/core");
const lib_1 = require("../lib");
module.exports = {
    'can create a receipt rule set'(test) {
        // GIVEN
        const stack = new core_1.Stack();
        // WHEN
        new lib_1.ReceiptRuleSet(stack, 'RuleSet', {
            receiptRuleSetName: 'MyRuleSet',
        });
        // THEN
        assert_1.expect(stack).to(assert_1.haveResource('AWS::SES::ReceiptRuleSet', {
            RuleSetName: 'MyRuleSet',
        }));
        test.done();
    },
    'can create a receipt rule set with drop spam'(test) {
        // GIVEN
        const stack = new core_1.Stack();
        // WHEN
        new lib_1.ReceiptRuleSet(stack, 'RuleSet', {
            dropSpam: true,
        });
        // THEN
        assert_1.expect(stack).to(assert_1.haveResource('AWS::SES::ReceiptRule', {
            Rule: {
                Actions: [
                    {
                        LambdaAction: {
                            FunctionArn: {
                                'Fn::GetAtt': [
                                    'SingletonLambda224e77f9a32e4b4dac32983477abba164533EA15',
                                    'Arn',
                                ],
                            },
                            InvocationType: 'RequestResponse',
                        },
                    },
                ],
                Enabled: true,
                ScanEnabled: true,
            },
        }));
        assert_1.expect(stack).to(assert_1.haveResource('AWS::Lambda::Function'));
        test.done();
    },
    'import receipt rule set'(test) {
        // GIVEN
        const stack = new core_1.Stack();
        // WHEN
        const receiptRuleSet = lib_1.ReceiptRuleSet.fromReceiptRuleSetName(stack, 'ImportedRuleSet', 'MyRuleSet');
        receiptRuleSet.addRule('MyRule');
        // THEN
        assert_1.expect(stack).toMatch({
            'Resources': {
                'ImportedRuleSetMyRule53EE2F7F': {
                    'Type': 'AWS::SES::ReceiptRule',
                    'Properties': {
                        'Rule': {
                            'Enabled': true,
                        },
                        'RuleSetName': 'MyRuleSet',
                    },
                },
            },
        });
        test.done();
    },
};
//# sourceMappingURL=data:application/json;base64,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