"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.WaitForResourceSimulation = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const non_retriable_exception_1 = require("../../domain/non-retriable-exception");
const assert_aws_resource_simulation_1 = require("./assert-aws-resource-simulation");
const automation_simulation_base_1 = require("./automation-simulation-base");
/**
 * AutomationStep impl for aws:waitForAwsResourceProperty
 * https://docs.aws.amazon.com/systems-manager/latest/userguide/automation-action-waitForAwsResourceProperty.html
 */
class WaitForResourceSimulation extends automation_simulation_base_1.AutomationSimulationBase {
    constructor(step, props) {
        super(step);
        this.action = 'aws:waitForAwsResourceProperty';
        this.waitForResourceStep = step;
        this.props = props;
    }
    /**
     * As is the case in an SSM Automation execution, this will continue to sleep/execute until desired value is found.
     * This function will throw if the timeoutSeconds is exceeded and the desired value is still not received from AWS.
     */
    executeStep(inputs) {
        var lastError = undefined;
        for (var endTime = Date.now() + this.waitForResourceStep.timeoutSeconds * 1000; endTime > Date.now();) {
            try {
                return new assert_aws_resource_simulation_1.AssertAwsResourceSimulation(this.waitForResourceStep, this.props).executeStep(inputs);
            }
            catch (error) {
                if (error instanceof non_retriable_exception_1.NonRetriableException) {
                    throw error;
                }
                console.log(`Received exception when hitting AWS API ${this.waitForResourceStep.service}.${this.waitForResourceStep.pascalCaseApi}. ` +
                    `Will try again in ${this.waitForResourceStep.sleepIntervalMillis} millis: ${JSON.stringify(error.message)}`);
                lastError = error;
                if (endTime > Date.now()) {
                    this.props.sleepHook.sleep(this.waitForResourceStep.sleepIntervalMillis);
                }
            }
        }
        if (lastError != undefined) {
            throw new Error(lastError.message);
        }
        throw new Error('Execution time exceeded timeout: timeout set to '
            + this.waitForResourceStep.timeoutSeconds + ' but did not get desired response in that time.');
    }
}
exports.WaitForResourceSimulation = WaitForResourceSimulation;
_a = JSII_RTTI_SYMBOL_1;
WaitForResourceSimulation[_a] = { fqn: "@cdklabs/cdk-ssm-documents.WaitForResourceSimulation", version: "0.0.25" };
//# sourceMappingURL=data:application/json;base64,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