"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.HelloWorld = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const automation_document_1 = require("../document/automation-document");
const data_type_1 = require("../domain/data-type");
const input_1 = require("../domain/input");
const string_variable_1 = require("../interface/variables/string-variable");
const aws_api_step_1 = require("../parent-steps/automation/aws-api-step");
const execute_script_step_1 = require("../parent-steps/automation/execute-script-step");
class HelloWorld extends aws_cdk_lib_1.Stack {
    constructor(app, id) {
        super(app, id);
        const doc = new automation_document_1.AutomationDocument(this, 'HelloWorld', {
            docInputs: [
                input_1.Input.ofTypeString('Someone', { allowedPattern: '[a-zA-Z]+' }),
                input_1.Input.ofTypeString('SnsTopic'),
            ],
        });
        const greeting = new execute_script_step_1.ExecuteScriptStep(this, 'PrependWithGreeting', {
            language: execute_script_step_1.ScriptLanguage.python(execute_script_step_1.PythonVersion.VERSION_3_6, 'my_func'),
            code: execute_script_step_1.ScriptCode.inline('def my_func(args, context):\n' +
                '    return {"Greeting": "Hello " + args["someone"]}\n' +
                '\n'),
            inputPayload: { someone: string_variable_1.StringVariable.of('Someone') },
            outputs: [{
                    outputType: data_type_1.DataTypeEnum.STRING,
                    name: 'Greeting',
                    selector: '$.Payload.Greeting',
                }],
        });
        doc.addStep(greeting);
        doc.addStep(new aws_api_step_1.AwsApiStep(this, 'PublishToSns', {
            outputs: [],
            service: 'SNS',
            pascalCaseApi: 'publish',
            apiParams: {
                TargetArn: new string_variable_1.StringVariable('SnsTopic'),
                Message: greeting.variables().Greeting,
            },
        }));
    }
}
exports.HelloWorld = HelloWorld;
_a = JSII_RTTI_SYMBOL_1;
HelloWorld[_a] = { fqn: "@cdklabs/cdk-ssm-documents.HelloWorld", version: "0.0.25" };
//# sourceMappingURL=data:application/json;base64,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