import { Construct } from 'constructs';
import { Platform } from '../../domain/platform';
import { IStringVariable } from '../../interface/variables/string-variable';
import { CommandStep, CommandStepProps } from '../command-step';
/**
 * Properties for sleep step.
 */
export interface RunShellScriptStepProps extends CommandStepProps {
    /**
       * Specify the commands to run or the path to an existing script on the instance.
       */
    readonly runCommand: IStringVariable[];
    /**
       * (Optional) The time in seconds for a command to be completed before it's considered to have failed.
       * When the timeout is reached, Systems Manager stops the command execution.
       */
    readonly timeoutSeconds?: number;
    /**
       * (Optional) The path to the working directory on your instance.
       */
    readonly workingDirectory?: IStringVariable;
}
/**
 * AutomationStep implemenation for aws:sleep
 * https://docs.aws.amazon.com/systems-manager/latest/userguide/automation-action-sleep.html
 */
export declare class RunShellScriptStep extends CommandStep {
    readonly runCommand: IStringVariable[];
    readonly timeoutSeconds?: number;
    readonly workingDirectory?: IStringVariable;
    readonly platforms: Platform[];
    readonly action = "aws:runShellScript";
    constructor(scope: Construct, id: string, props: RunShellScriptStepProps);
    /**
       * Inputs required for this command includes both the runCommand variables and workingDirectory if provided.
       */
    listInputs(): string[];
    toSsmEntry(): {
        [name: string]: any;
    };
}
