"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.RunDockerActionStep = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const platform_1 = require("../../domain/platform");
const command_step_1 = require("../command-step");
/**
 * CommandStep implementation for aws:runDockerAction
 * https://docs.aws.amazon.com/systems-manager/latest/userguide/ssm-plugins.html#aws-rundockeraction
 */
class RunDockerActionStep extends command_step_1.CommandStep {
    constructor(scope, id, props) {
        super(scope, id, props);
        this.platforms = [platform_1.Platform.WINDOWS, platform_1.Platform.LINUX];
        this.action = 'aws:runDockerAction';
        this.dockerAction = props.action;
        this.container = props.container;
        this.image = props.image;
        this.cmd = props.cmd;
        this.memory = props.memory;
        this.cpuShares = props.cpuShares;
        this.volume = props.volume;
        this.env = props.env;
        this.user = props.user;
        this.publish = props.publish;
    }
    listInputs() {
        const inputs = [
            this.dockerAction,
            this.container,
            this.image,
            this.cmd,
            this.memory,
            this.cpuShares,
            this.volume,
            this.env,
            this.user,
            this.publish,
        ];
        return inputs.flatMap(i => i?.requiredInputs() ?? []);
    }
    toSsmEntry() {
        const inputs = {
            action: this.dockerAction,
        };
        if (this.container != undefined) {
            inputs.container = this.container;
        }
        if (this.image != undefined) {
            inputs.image = this.image;
        }
        if (this.cmd != undefined) {
            inputs.cmd = this.cmd;
        }
        if (this.memory != undefined) {
            inputs.memory = this.memory;
        }
        if (this.cpuShares != undefined) {
            inputs.cpuShares = this.cpuShares;
        }
        if (this.volume != undefined) {
            inputs.volume = this.volume;
        }
        if (this.env != undefined) {
            inputs.env = this.env;
        }
        if (this.user != undefined) {
            inputs.user = this.user;
        }
        if (this.publish != undefined) {
            inputs.publish = this.publish;
        }
        return super.prepareSsmEntry(inputs);
    }
}
exports.RunDockerActionStep = RunDockerActionStep;
_a = JSII_RTTI_SYMBOL_1;
RunDockerActionStep[_a] = { fqn: "@cdklabs/cdk-ssm-documents.RunDockerActionStep", version: "0.0.25" };
//# sourceMappingURL=data:application/json;base64,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