"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ConfigureDockerStep = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const platform_1 = require("../../domain/platform");
const command_step_1 = require("../command-step");
/**
 * AutomationStep implemenation for aws:UpdateAgent
 * https://docs.aws.amazon.com/systems-manager/latest/userguide/ssm-plugins.html#aws-configuredocker
 */
class ConfigureDockerStep extends command_step_1.CommandStep {
    constructor(scope, id, props) {
        super(scope, id, props);
        this.platforms = [platform_1.Platform.WINDOWS, platform_1.Platform.LINUX];
        this.action = 'aws:configureDocker';
        this.installAction = props.action;
    }
    /**
     * Inputs required for this command include agentName allowDowngrade source and targetVersion if version other than latest is desired
     */
    listInputs() {
        const inputs = [
            this.installAction,
        ];
        return inputs.flatMap(i => i.requiredInputs() ?? []);
    }
    toSsmEntry() {
        const inputs = { action: this.installAction };
        return super.prepareSsmEntry(inputs);
    }
}
exports.ConfigureDockerStep = ConfigureDockerStep;
_a = JSII_RTTI_SYMBOL_1;
ConfigureDockerStep[_a] = { fqn: "@cdklabs/cdk-ssm-documents.ConfigureDockerStep", version: "0.0.25" };
//# sourceMappingURL=data:application/json;base64,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