import { Construct } from 'constructs';
import { IBooleanVariable, IMapListVariable, INumberVariable, IStringListVariable, IStringMapVariable, IStringVariable } from '../..';
import { Output } from '../../domain/output';
import { AutomationStep, AutomationStepProps } from '../automation-step';
/**
 * Properties for RunInstanceStep
 */
export interface RunInstanceStepProps extends AutomationStepProps {
    /**
     * The ID of the Amazon Machine Image (AMI).
     */
    readonly imageId: IStringVariable;
    /**
     * (Optional) The instance type.
     */
    readonly instanceType?: IStringVariable;
    /**
     * (Optional) The minimum number of instances to be launched.
     */
    readonly minInstanceCount?: INumberVariable;
    /**
     * (Optional) The maximum number of instances to be launched.
     */
    readonly maxInstanceCount?: INumberVariable;
    /**
     * (Optional) Reserved.
     */
    readonly additionalInfo?: IStringVariable;
    /**
     * (Optional) The block devices for the instance.
     */
    readonly blockDeviceMappings?: IMapListVariable;
    /**
     * (Optional) The identifier to ensure idempotency of the request.
     */
    readonly clientToken?: IStringVariable;
    /**
     * (Optional) Turns on or turns off instance API termination.
     */
    readonly disableApiTermination?: IBooleanVariable;
    /**
     * (Optional) Turns on or turns off Amazon Elastic Block Store (Amazon EBS) optimization.
     */
    readonly ebsOptimized?: IBooleanVariable;
    /**
     * (Optional) The Amazon Resource Name (ARN) of the AWS Identity and Access Management (IAM) instance profile for the instance.
     */
    readonly iamInstanceProfileArn?: IStringVariable;
    /**
     * (Optional) The name of the IAM instance profile for the instance.
     */
    readonly iamInstanceProfileName?: IStringVariable;
    /**
     * (Optional) Indicates whether the instance stops or terminates on system shutdown.
     */
    readonly instanceInitiatedShutdownBehavior?: IStringVariable;
    /**
     * (Optional) The ID of the kernel.
     */
    readonly kernelId?: IStringVariable;
    /**
     * (Optional) The name of the key pair.
     */
    readonly keyName?: IStringVariable;
    /**
     * (Optional) Turns on or turns off detailed monitoring.
     */
    readonly monitoring?: IBooleanVariable;
    /**
     * (Optional) The network interfaces.
     */
    readonly networkInterfaces?: IMapListVariable;
    /**
     * (Optional) The placement for the instance.
     */
    readonly placement?: IStringMapVariable;
    /**
     * (Optional) The primary IPv4 address.
     */
    readonly privateIpAddress?: IStringVariable;
    /**
     * (Optional) The ID of the RAM disk.
     */
    readonly ramdiskId?: IStringVariable;
    /**
     * (Optional) The IDs of the security groups for the instance.
     */
    readonly securityGroupIds?: IStringListVariable;
    /**
     * (Optional) The names of the security groups for the instance.
     */
    readonly securityGroups?: IStringListVariable;
    /**
     * (Optional) The subnet ID.
     */
    readonly subnetId?: IStringVariable;
    /**
     * (Optional) The tags to apply to the resources during launch. You can only tag instances and volumes at launch. The specified tags are applied to all instances or volumes that are created during launch.
     * To tag an instance after it has been launched, use the aws:createTags – Create tags for AWS resources action.
     */
    readonly tagSpecifications?: IMapListVariable;
    /**
     * (Optional) A script provided as a string literal value. If a literal value is entered, then it must be Base64-encoded.
     */
    readonly userData?: IStringVariable;
}
/**
 * AutomationStep implemenation for aws:runInstance
 * https://docs.aws.amazon.com/systems-manager/latest/userguide/automation-action-runinstance.html
 */
export declare class RunInstanceStep extends AutomationStep {
    readonly imageId: IStringVariable;
    readonly instanceType?: IStringVariable;
    readonly minInstanceCount?: INumberVariable;
    readonly maxInstanceCount?: INumberVariable;
    readonly additionalInfo?: IStringVariable;
    readonly blockDeviceMappings?: IMapListVariable;
    readonly clientToken?: IStringVariable;
    readonly disableApiTermination?: IBooleanVariable;
    readonly ebsOptimized?: IBooleanVariable;
    readonly iamInstanceProfileArn?: IStringVariable;
    readonly iamInstanceProfileName?: IStringVariable;
    readonly instanceInitiatedShutdownBehavior?: IStringVariable;
    readonly kernelId?: IStringVariable;
    readonly keyName?: IStringVariable;
    readonly monitoring?: IBooleanVariable;
    readonly networkInterfaces?: IMapListVariable;
    readonly placement?: IStringMapVariable;
    readonly privateIpAddress?: IStringVariable;
    readonly ramdiskId?: IStringVariable;
    readonly securityGroupIds?: IStringListVariable;
    readonly securityGroups?: IStringListVariable;
    readonly subnetId?: IStringVariable;
    readonly tagSpecifications?: IMapListVariable;
    readonly userData?: IStringVariable;
    readonly action: string;
    constructor(scope: Construct, id: string, props: RunInstanceStepProps);
    /**
       * @returns IDs and states of the new instances
       */
    listOutputs(): Output[];
    /**
       * Derives the inputs based on given variables
       * @returns list of required inputs.
       */
    listInputs(): string[];
    toSsmEntry(): {
        [name: string]: any;
    };
}
