"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ApproveStep = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const data_type_1 = require("../../domain/data-type");
const prune_and_transform_record_1 = require("../../utils/prune-and-transform-record");
const automation_step_1 = require("../automation-step");
/**
 * AutomationStep implementation for aws:approve
 * https://docs.aws.amazon.com/systems-manager/latest/userguide/automation-action-approve.html
 */
class ApproveStep extends automation_step_1.AutomationStep {
    constructor(scope, id, props) {
        super(scope, id, props);
        this.action = 'aws:approve';
        this.approvers = props.approvers;
        this.notificationArn = props.notificationArn;
        this.message = props.message;
        this.minRequiredApprovals = props.minRequiredApprovals;
    }
    listOutputs() {
        return [{
                outputType: data_type_1.DataTypeEnum.STRING,
                selector: '$.ApprovalStatus',
                name: 'ApprovalStatus',
            }, {
                outputType: data_type_1.DataTypeEnum.MAP_LIST,
                selector: '$.ApproverDecisions',
                name: 'ApproverDecisions',
            }];
    }
    listInputs() {
        const inputs = [
            this.approvers,
            this.notificationArn,
            this.message,
            this.minRequiredApprovals,
        ];
        return inputs.flatMap(i => i?.requiredInputs() ?? []);
    }
    toSsmEntry() {
        const entireEntry = super.prepareSsmEntry(prune_and_transform_record_1.pruneAndTransformRecord({
            Approvers: this.approvers,
            NotificationArn: this.notificationArn,
            Message: this.message,
            MinRequiredApprovals: this.minRequiredApprovals,
        }, x => x.print()));
        const { outputs, ...newObj } = entireEntry;
        return newObj;
    }
    /**
     * Override to mock the date the reviewer approved
     */
    provideDate() {
        return new Date();
    }
}
exports.ApproveStep = ApproveStep;
_a = JSII_RTTI_SYMBOL_1;
ApproveStep[_a] = { fqn: "@cdklabs/cdk-ssm-documents.ApproveStep", version: "0.0.25" };
//# sourceMappingURL=data:application/json;base64,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