"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.MockPause = exports.PauseImpl = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
// eslint-disable-next-line
const readline = require('readline');
// eslint-disable-next-line
const sp = require('synchronized-promise');
/**
 * This IPauseHook implementation provides a real pause and wait for user input of Enter.
 * This implementation does not work well on all exported JSII languages.
 * Users can provide their own impl using the IPauseHook interface.
 */
class PauseImpl {
    pause() {
        const rl = readline.createInterface({
            input: process.stdin,
            output: process.stdout,
        });
        let asyncFunction = () => {
            return new Promise(resolve => rl.question("'pauseRuntime' flag enabled. Press Enter to continue...\n", (ans) => {
                rl.close();
                resolve(ans);
            })).then(function () {
                console.log('Proceeding with runtime after pause');
            }, function () {
                console.log('error');
            });
        };
        return sp(asyncFunction)();
    }
}
exports.PauseImpl = PauseImpl;
_a = JSII_RTTI_SYMBOL_1;
PauseImpl[_a] = { fqn: "@cdklabs/cdk-ssm-documents.PauseImpl", version: "0.0.25" };
class MockPause {
    constructor() {
        this.timesInvoked = 0;
    }
    pause() {
        console.log('Mocked implementation! Not performing real pause');
        this.timesInvoked++;
    }
}
exports.MockPause = MockPause;
_b = JSII_RTTI_SYMBOL_1;
MockPause[_b] = { fqn: "@cdklabs/cdk-ssm-documents.MockPause", version: "0.0.25" };
//# sourceMappingURL=data:application/json;base64,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