# THIS FILE IS AUTOGENERATED. DO NOT EDIT.
import struct
import logging
from dataclasses import dataclass
from enum import Enum, IntFlag
from .raw_event import RawEvent

logger = logging.getLogger(__name__)

EVENT_LEN = 26

@dataclass
class BaseEvent:
    @staticmethod
    def build(raw):
        raise NotImplemented

UINT8 = '>B'
INT8 = '>b'
UINT16 = '>H'
INT16 = '>h'
UINT32 = '>I'
FLOAT32 = '>f'

@dataclass
class LidBasalRateChange(BaseEvent):
    """3: LID_BASAL_RATE_CHANGE"""
    ID = 3
    NAME = "LID_BASAL_RATE_CHANGE"

    raw: RawEvent
    commandedbasalrate: float # units/hour
    basebasalrate: float # units/hour
    maxbasalrate: float # units/hour
    IDP: int
    changetypeRaw: int

    ChangetypeMap = {
        "0": "\"timed segment\" - change by timed segment (because either the segment advanced based on time, the user changed the pump time, the user changed the active segment or changed by an AID algorithm.)",
        "1": "\"new profile\" - change by activation of new profile",
        "2": "\"temp rate start\"",
        "3": "\"temp rate end\"",
        "4": "\"pump suspended\"",
        "5": "\"pump resumed\"",
        "6": "\u201cpump shut down\u201d",
        "7": "\u201cbasal limit\u201d"
    }

    class ChangetypeBitmask(IntFlag):
        TimedSegment = 2**0
        NewProfile = 2**1
        TempRateStart = 2**2
        TempRateEnd = 2**3
        PumpSuspended = 2**4
        PumpResumed = 2**5
        PumpShutDown = 2**6
        BasalLimit = 2**7

    @property
    def changetype(self):
        try:
            return self.ChangetypeBitmask(self.changetypeRaw)
        except ValueError as e:
            logger.error("Invalid changetypeRaw in ChangetypeBitmask for "+str(self))
            logger.error(e)
            return None

    @staticmethod
    def build(raw):
        commandedbasalrate, = struct.unpack_from(FLOAT32, raw[:EVENT_LEN], 10)
        basebasalrate, = struct.unpack_from(FLOAT32, raw[:EVENT_LEN], 14)
        maxbasalrate, = struct.unpack_from(FLOAT32, raw[:EVENT_LEN], 18)
        IDP, = struct.unpack_from(UINT16, raw[:EVENT_LEN], 24)
        changetype, = struct.unpack_from(UINT8, raw[:EVENT_LEN], 23)

        return LidBasalRateChange(
            raw = RawEvent.build(raw),
            commandedbasalrate = commandedbasalrate,
            basebasalrate = basebasalrate,
            maxbasalrate = maxbasalrate,
            IDP = IDP,
            changetypeRaw = changetype,
        )

    @property
    def eventTimestamp(self):
        return self.raw.timestamp

    @property
    def eventId(self):
        return self.raw.seqNum


@dataclass
class LidAlertActivated(BaseEvent):
    """4: LID_ALERT_ACTIVATED"""
    ID = 4
    NAME = "LID_ALERT_ACTIVATED"

    raw: RawEvent
    alertidRaw: int
    faultlocatordata: int
    param1: int
    param2: float

    AlertidMap = {
        "0": "LOW_INSULIN_ALERT",
        "1": "USB_CONNECTION_ALERT",
        "2": "LOW_POWER_ALERT",
        "3": "LOW_POWER_ALERT2",
        "4": "DATA_ERROR_ALERT",
        "5": "AUTO_OFF_ALERT",
        "6": "MAX_BASAL_RATE_ALERT",
        "7": "POWER_SOURCE_ALERT",
        "8": "MIN_BASAL_ALERT",
        "9": "CONNECTION_ERROR_ALERT",
        "10": "CONNECTION_ERROR_ALERT2",
        "11": "INCOMPLETE_BOLUS_ALERT",
        "12": "INCOMPLETE_TEMP_RATE_ALERT",
        "13": "INCOMPLETE_CARTRIDGE_CHANGE_ALERT",
        "14": "INCOMPLETE_FILL_TUBING_ALERT",
        "15": "INCOMPLETE_FILL_CANNULA_ALERT",
        "16": "INCOMPLETE_SETTING_ALERT",
        "17": "LOW_INSULIN_ALERT2",
        "18": "MAX_BASAL_ALERT",
        "19": "LOW_TRANSMITTER_ALERT",
        "20": "TRANSMITTER_ALERT",
        "21": "DEFAULT_ALERT_21",
        "22": "SENSOR_EXPIRING_ALERT",
        "23": "PUMP_REBOOTING_ALERT",
        "24": "DEVICE_CONNECTION_ERROR",
        "25": "CGM_GRAPH_REMOVED",
        "26": "MIN_BASAL_ALERT2",
        "27": "INCOMPLETE_CALIBRATION",
        "28": "CALIBRATION_TIMEOUT",
        "29": "INVALID_TRANSMITTER_ID",
        "30": "DEFAULT_ALERT_30",
        "32": "DEFAULT_ALERT_32",
        "33": "BUTTON_ALERT",
        "34": "QUICK_BOLUS_ALERT",
        "35": "BASAL_IQ_ALERT",
        "36": "DEFAULT_ALERT_36",
        "37": "DEFAULT_ALERT_37",
        "38": "DEFAULT_ALERT_38",
        "39": "TRANSMITTER_END_OF_LIFE",
        "40": "CGM_ERROR",
        "41": "CGM_ERROR2",
        "42": "CGM_ERROR3",
        "43": "DEFAULT_ALERT_43",
        "44": "TRANSMITTER_EXPIRING_ALERT",
        "45": "TRANSMITTER_EXPIRING_ALERT2",
        "46": "TRANSMITTER_EXPIRING_ALERT3",
        "47": "DEFAULT_ALERT_47",
        "48": "CGM_UNAVAILABLE",
        "49": "DEFAULT_ALERT_49",
        "50": "DEFAULT_ALERT_50",
        "51": "DEFAULT_ALERT_51",
        "52": "DEFAULT_ALERT_52",
        "53": "DEFAULT_ALERT_53",
        "54": "DEVICE_PAIRED",
        "55": "DEFAULT_ALERT_55",
        "56": "DEFAULT_ALERT_56",
        "57": "DEFAULT_ALERT_57",
        "58": "DEFAULT_ALERT_58",
        "59": "DEFAULT_ALERT_59",
        "60": "DEFAULT_ALERT_60",
        "61": "DEFAULT_ALERT_61",
        "62": "DEFAULT_ALERT_62",
        "63": "DEFAULT_ALERT_63"
    }

    class AlertidEnum(Enum):
        LowInsulinAlert = 0
        UsbConnectionAlert = 1
        LowPowerAlert = 2
        LowPowerAlert2 = 3
        DataErrorAlert = 4
        AutoOffAlert = 5
        MaxBasalRateAlert = 6
        PowerSourceAlert = 7
        MinBasalAlert = 8
        ConnectionErrorAlert = 9
        ConnectionErrorAlert2 = 10
        IncompleteBolusAlert = 11
        IncompleteTempRateAlert = 12
        IncompleteCartridgeChangeAlert = 13
        IncompleteFillTubingAlert = 14
        IncompleteFillCannulaAlert = 15
        IncompleteSettingAlert = 16
        LowInsulinAlert2 = 17
        MaxBasalAlert = 18
        LowTransmitterAlert = 19
        TransmitterAlert = 20
        DefaultAlert21 = 21
        SensorExpiringAlert = 22
        PumpRebootingAlert = 23
        DeviceConnectionError = 24
        CgmGraphRemoved = 25
        MinBasalAlert2 = 26
        IncompleteCalibration = 27
        CalibrationTimeout = 28
        InvalidTransmitterId = 29
        DefaultAlert30 = 30
        DefaultAlert32 = 32
        ButtonAlert = 33
        QuickBolusAlert = 34
        BasalIqAlert = 35
        DefaultAlert36 = 36
        DefaultAlert37 = 37
        DefaultAlert38 = 38
        TransmitterEndOfLife = 39
        CgmError = 40
        CgmError2 = 41
        CgmError3 = 42
        DefaultAlert43 = 43
        TransmitterExpiringAlert = 44
        TransmitterExpiringAlert2 = 45
        TransmitterExpiringAlert3 = 46
        DefaultAlert47 = 47
        CgmUnavailable = 48
        DefaultAlert49 = 49
        DefaultAlert50 = 50
        DefaultAlert51 = 51
        DefaultAlert52 = 52
        DefaultAlert53 = 53
        DevicePaired = 54
        DefaultAlert55 = 55
        DefaultAlert56 = 56
        DefaultAlert57 = 57
        DefaultAlert58 = 58
        DefaultAlert59 = 59
        DefaultAlert60 = 60
        DefaultAlert61 = 61
        DefaultAlert62 = 62
        DefaultAlert63 = 63

    @property
    def alertid(self):
        try:
            return self.AlertidEnum(self.alertidRaw)
        except ValueError as e:
            logger.error("Invalid alertidRaw in Alertid for "+str(self))
            logger.error(e)
            return None

    @staticmethod
    def build(raw):
        alertid, = struct.unpack_from(UINT32, raw[:EVENT_LEN], 10)
        faultlocatordata, = struct.unpack_from(UINT32, raw[:EVENT_LEN], 14)
        param1, = struct.unpack_from(UINT32, raw[:EVENT_LEN], 18)
        param2, = struct.unpack_from(FLOAT32, raw[:EVENT_LEN], 22)

        return LidAlertActivated(
            raw = RawEvent.build(raw),
            alertidRaw = alertid,
            faultlocatordata = faultlocatordata,
            param1 = param1,
            param2 = param2,
        )

    @property
    def eventTimestamp(self):
        return self.raw.timestamp

    @property
    def eventId(self):
        return self.raw.seqNum


@dataclass
class LidAlarmActivated(BaseEvent):
    """5: LID_ALARM_ACTIVATED"""
    ID = 5
    NAME = "LID_ALARM_ACTIVATED"

    raw: RawEvent
    alarmidRaw: int
    faultlocatordata: int
    param1: int
    param2: float

    AlarmidMap = {
        "0": "CARTRIDGE_ALARM",
        "1": "CARTRIDGE_ALARM2",
        "2": "OCCLUSION_ALARM",
        "3": "PUMP_RESET_ALARM",
        "4": "DEFAULT_ALARM_4",
        "5": "CARTRIDGE_ALARM3",
        "6": "CARTRIDGE_ALARM4",
        "7": "AUTO_OFF_ALARM",
        "8": "EMPTY_CARTRIDGE_ALARM",
        "9": "CARTRIDGE_ALARM5",
        "10": "TEMPERATURE_ALARM",
        "11": "TEMPERATURE_ALARM2",
        "12": "BATTERY_SHUTDOWN_ALARM",
        "13": "DEFAULT_ALARM_13",
        "14": "INVALID_DATE_ALARM",
        "15": "TEMPERATURE_ALARM3",
        "16": "CARTRIDGE_ALARM6",
        "17": "DEFAULT_ALARM_17",
        "18": "RESUME_PUMP_ALARM",
        "19": "DEFAULT_ALARM_19",
        "20": "CARTRIDGE_ALARM7",
        "21": "ALTITUDE_ALARM",
        "22": "STUCK_BUTTON_ALARM",
        "23": "RESUME_PUMP_ALARM2",
        "24": "ATMOSPHERIC_PRESSURE_OUT_OF_RANGE_ALARM",
        "25": "CARTRIDGE_REMOVED_ALARM",
        "26": "OCCLUSION_ALARM2",
        "27": "DEFAULT_ALARM_27",
        "28": "DEFAULT_ALARM_28",
        "29": "CARTRIDGE_ALARM10",
        "30": "CARTRIDGE_ALARM11",
        "31": "CARTRIDGE_ALARM12",
        "32": "DEFAULT_ALARM_32",
        "33": "DEFAULT_ALARM_33",
        "34": "DEFAULT_ALARM_34",
        "35": "DEFAULT_ALARM_35",
        "36": "DEFAULT_ALARM_36",
        "37": "DEFAULT_ALARM_37",
        "38": "DEFAULT_ALARM_38",
        "39": "DEFAULT_ALARM_39",
        "40": "DEFAULT_ALARM_40",
        "41": "DEFAULT_ALARM_41",
        "42": "DEFAULT_ALARM_42",
        "43": "DEFAULT_ALARM_43",
        "44": "DEFAULT_ALARM_44",
        "45": "DEFAULT_ALARM_45",
        "46": "DEFAULT_ALARM_46",
        "47": "DEFAULT_ALARM_47",
        "48": "DEFAULT_ALARM_48",
        "49": "DEFAULT_ALARM_49",
        "50": "DEFAULT_ALARM_50",
        "51": "DEFAULT_ALARM_51",
        "52": "DEFAULT_ALARM_52",
        "53": "DEFAULT_ALARM_53",
        "54": "DEFAULT_ALARM_54",
        "55": "DEFAULT_ALARM_55",
        "56": "DEFAULT_ALARM_56",
        "57": "DEFAULT_ALARM_57",
        "58": "DEFAULT_ALARM_58",
        "59": "DEFAULT_ALARM_59",
        "60": "DEFAULT_ALARM_60",
        "61": "DEFAULT_ALARM_61",
        "62": "DEFAULT_ALARM_62",
        "63": "DEFAULT_ALARM_63"
    }

    class AlarmidEnum(Enum):
        CartridgeAlarm = 0
        CartridgeAlarm2 = 1
        OcclusionAlarm = 2
        PumpResetAlarm = 3
        DefaultAlarm4 = 4
        CartridgeAlarm3 = 5
        CartridgeAlarm4 = 6
        AutoOffAlarm = 7
        EmptyCartridgeAlarm = 8
        CartridgeAlarm5 = 9
        TemperatureAlarm = 10
        TemperatureAlarm2 = 11
        BatteryShutdownAlarm = 12
        DefaultAlarm13 = 13
        InvalidDateAlarm = 14
        TemperatureAlarm3 = 15
        CartridgeAlarm6 = 16
        DefaultAlarm17 = 17
        ResumePumpAlarm = 18
        DefaultAlarm19 = 19
        CartridgeAlarm7 = 20
        AltitudeAlarm = 21
        StuckButtonAlarm = 22
        ResumePumpAlarm2 = 23
        AtmosphericPressureOutOfRangeAlarm = 24
        CartridgeRemovedAlarm = 25
        OcclusionAlarm2 = 26
        DefaultAlarm27 = 27
        DefaultAlarm28 = 28
        CartridgeAlarm10 = 29
        CartridgeAlarm11 = 30
        CartridgeAlarm12 = 31
        DefaultAlarm32 = 32
        DefaultAlarm33 = 33
        DefaultAlarm34 = 34
        DefaultAlarm35 = 35
        DefaultAlarm36 = 36
        DefaultAlarm37 = 37
        DefaultAlarm38 = 38
        DefaultAlarm39 = 39
        DefaultAlarm40 = 40
        DefaultAlarm41 = 41
        DefaultAlarm42 = 42
        DefaultAlarm43 = 43
        DefaultAlarm44 = 44
        DefaultAlarm45 = 45
        DefaultAlarm46 = 46
        DefaultAlarm47 = 47
        DefaultAlarm48 = 48
        DefaultAlarm49 = 49
        DefaultAlarm50 = 50
        DefaultAlarm51 = 51
        DefaultAlarm52 = 52
        DefaultAlarm53 = 53
        DefaultAlarm54 = 54
        DefaultAlarm55 = 55
        DefaultAlarm56 = 56
        DefaultAlarm57 = 57
        DefaultAlarm58 = 58
        DefaultAlarm59 = 59
        DefaultAlarm60 = 60
        DefaultAlarm61 = 61
        DefaultAlarm62 = 62
        DefaultAlarm63 = 63

    @property
    def alarmid(self):
        try:
            return self.AlarmidEnum(self.alarmidRaw)
        except ValueError as e:
            logger.error("Invalid alarmidRaw in Alarmid for "+str(self))
            logger.error(e)
            return None

    @staticmethod
    def build(raw):
        alarmid, = struct.unpack_from(UINT32, raw[:EVENT_LEN], 10)
        faultlocatordata, = struct.unpack_from(UINT32, raw[:EVENT_LEN], 14)
        param1, = struct.unpack_from(UINT32, raw[:EVENT_LEN], 18)
        param2, = struct.unpack_from(FLOAT32, raw[:EVENT_LEN], 22)

        return LidAlarmActivated(
            raw = RawEvent.build(raw),
            alarmidRaw = alarmid,
            faultlocatordata = faultlocatordata,
            param1 = param1,
            param2 = param2,
        )

    @property
    def eventTimestamp(self):
        return self.raw.timestamp

    @property
    def eventId(self):
        return self.raw.seqNum


@dataclass
class LidMalfunctionActivated(BaseEvent):
    """6: LID_MALFUNCTION_ACTIVATED"""
    ID = 6
    NAME = "LID_MALFUNCTION_ACTIVATED"

    raw: RawEvent
    malfidRaw: int
    faultlocatordata: int
    param1: int
    param2: float

    # Dictionary unknown: malfs
    @staticmethod
    def build(raw):
        malfid, = struct.unpack_from(UINT32, raw[:EVENT_LEN], 10)
        faultlocatordata, = struct.unpack_from(UINT32, raw[:EVENT_LEN], 14)
        param1, = struct.unpack_from(UINT32, raw[:EVENT_LEN], 18)
        param2, = struct.unpack_from(FLOAT32, raw[:EVENT_LEN], 22)

        return LidMalfunctionActivated(
            raw = RawEvent.build(raw),
            malfidRaw = malfid,
            faultlocatordata = faultlocatordata,
            param1 = param1,
            param2 = param2,
        )

    @property
    def eventTimestamp(self):
        return self.raw.timestamp

    @property
    def eventId(self):
        return self.raw.seqNum


@dataclass
class LidPumpingSuspended(BaseEvent):
    """11: LID_PUMPING_SUSPENDED"""
    ID = 11
    NAME = "LID_PUMPING_SUSPENDED"

    raw: RawEvent
    presuspendstate: int
    insulinamount: int # units
    suspendreasonRaw: int
    rpatimeout: int # minutes

    SuspendreasonMap = {
        "0": "User Aborted",
        "1": "Terminated by Alarm",
        "2": "Terminated by Malfunction",
        "6": "Auto Suspend by PLGS"
    }

    class SuspendreasonEnum(Enum):
        UserAborted = 0
        TerminatedByAlarm = 1
        TerminatedByMalfunction = 2
        AutoSuspendByPlgs = 6

    @property
    def suspendreason(self):
        try:
            return self.SuspendreasonEnum(self.suspendreasonRaw)
        except ValueError as e:
            logger.error("Invalid suspendreasonRaw in Suspendreason for "+str(self))
            logger.error(e)
            return None

    @staticmethod
    def build(raw):
        presuspendstate, = struct.unpack_from(UINT32, raw[:EVENT_LEN], 10)
        insulinamount, = struct.unpack_from(UINT16, raw[:EVENT_LEN], 16)
        suspendreason, = struct.unpack_from(UINT8, raw[:EVENT_LEN], 15)
        rpatimeout, = struct.unpack_from(UINT8, raw[:EVENT_LEN], 14)

        return LidPumpingSuspended(
            raw = RawEvent.build(raw),
            presuspendstate = presuspendstate,
            insulinamount = insulinamount,
            suspendreasonRaw = suspendreason,
            rpatimeout = rpatimeout,
        )

    @property
    def eventTimestamp(self):
        return self.raw.timestamp

    @property
    def eventId(self):
        return self.raw.seqNum


@dataclass
class LidPumpingResumed(BaseEvent):
    """12: LID_PUMPING_RESUMED"""
    ID = 12
    NAME = "LID_PUMPING_RESUMED"

    raw: RawEvent
    preresumestate: int
    insulinamount: int # units


    @staticmethod
    def build(raw):
        preresumestate, = struct.unpack_from(UINT32, raw[:EVENT_LEN], 10)
        insulinamount, = struct.unpack_from(UINT16, raw[:EVENT_LEN], 16)

        return LidPumpingResumed(
            raw = RawEvent.build(raw),
            preresumestate = preresumestate,
            insulinamount = insulinamount,
        )

    @property
    def eventTimestamp(self):
        return self.raw.timestamp

    @property
    def eventId(self):
        return self.raw.seqNum


@dataclass
class LidTimeChanged(BaseEvent):
    """13: LID_TIME_CHANGED"""
    ID = 13
    NAME = "LID_TIME_CHANGED"

    raw: RawEvent
    timeprior: int # ms
    timeafter: int # ms
    rawrtctime: int # ms


    @staticmethod
    def build(raw):
        timeprior, = struct.unpack_from(UINT32, raw[:EVENT_LEN], 10)
        timeafter, = struct.unpack_from(UINT32, raw[:EVENT_LEN], 14)
        rawrtctime, = struct.unpack_from(UINT32, raw[:EVENT_LEN], 18)

        return LidTimeChanged(
            raw = RawEvent.build(raw),
            timeprior = timeprior,
            timeafter = timeafter,
            rawrtctime = rawrtctime,
        )

    @property
    def eventTimestamp(self):
        return self.raw.timestamp

    @property
    def eventId(self):
        return self.raw.seqNum


@dataclass
class LidDateChanged(BaseEvent):
    """14: LID_DATE_CHANGED"""
    ID = 14
    NAME = "LID_DATE_CHANGED"

    raw: RawEvent
    dateprior: int # day
    dateafter: int # day
    rawrtctime: int # ms


    @staticmethod
    def build(raw):
        dateprior, = struct.unpack_from(UINT32, raw[:EVENT_LEN], 10)
        dateafter, = struct.unpack_from(UINT32, raw[:EVENT_LEN], 14)
        rawrtctime, = struct.unpack_from(UINT32, raw[:EVENT_LEN], 18)

        return LidDateChanged(
            raw = RawEvent.build(raw),
            dateprior = dateprior,
            dateafter = dateafter,
            rawrtctime = rawrtctime,
        )

    @property
    def eventTimestamp(self):
        return self.raw.timestamp

    @property
    def eventId(self):
        return self.raw.seqNum


@dataclass
class LidBgReadingTaken(BaseEvent):
    """16: LID_BG_READING_TAKEN"""
    ID = 16
    NAME = "LID_BG_READING_TAKEN"

    raw: RawEvent
    selectediobRaw: int
    BG: int # mg/dL
    bgentrytypeRaw: int
    IOB: float # units
    targetbg: int # mg/dL
    ISF: int # (mg/dL)/unit
    bgsourcetypeRaw: int
    cgmcalibrationRaw: int

    SelectediobMap = {
        "0": "Mudaliar IOB",
        "1": "Swan IOB Meal"
    }

    class SelectediobEnum(Enum):
        MudaliarIob = 0
        SwanIobMeal = 1

    @property
    def selectediob(self):
        try:
            return self.SelectediobEnum(self.selectediobRaw)
        except ValueError as e:
            logger.error("Invalid selectediobRaw in Selectediob for "+str(self))
            logger.error(e)
            return None

    BgentrytypeMap = {
        "0": "Manual Entry by the User via Numpad",
        "1": "Auto Populated BG using Dexcom EGV"
    }

    class BgentrytypeEnum(Enum):
        ManualEntryByTheUserViaNumpad = 0
        AutoPopulatedBgUsingDexcomEgv = 1

    @property
    def bgentrytype(self):
        try:
            return self.BgentrytypeEnum(self.bgentrytypeRaw)
        except ValueError as e:
            logger.error("Invalid bgentrytypeRaw in Bgentrytype for "+str(self))
            logger.error(e)
            return None

    BgsourcetypeMap = {
        "0": "Local Pump entry",
        "1": "Remote entry"
    }

    class BgsourcetypeEnum(Enum):
        LocalPumpEntry = 0
        RemoteEntry = 1

    @property
    def bgsourcetype(self):
        try:
            return self.BgsourcetypeEnum(self.bgsourcetypeRaw)
        except ValueError as e:
            logger.error("Invalid bgsourcetypeRaw in Bgsourcetype for "+str(self))
            logger.error(e)
            return None

    CgmcalibrationMap = {
        "0": "No, it was not used to Calibrate.",
        "1": "Yes, it was used to calibrate."
    }

    class CgmcalibrationEnum(Enum):
        No = 0
        Yes = 1

    @property
    def cgmcalibration(self):
        try:
            return self.CgmcalibrationEnum(self.cgmcalibrationRaw)
        except ValueError as e:
            logger.error("Invalid cgmcalibrationRaw in Cgmcalibration for "+str(self))
            logger.error(e)
            return None

    @staticmethod
    def build(raw):
        selectediob, = struct.unpack_from(UINT8, raw[:EVENT_LEN], 25)
        BG, = struct.unpack_from(UINT16, raw[:EVENT_LEN], 12)
        bgentrytype, = struct.unpack_from(UINT8, raw[:EVENT_LEN], 10)
        IOB, = struct.unpack_from(FLOAT32, raw[:EVENT_LEN], 14)
        targetbg, = struct.unpack_from(UINT16, raw[:EVENT_LEN], 20)
        ISF, = struct.unpack_from(UINT16, raw[:EVENT_LEN], 18)
        bgsourcetype, = struct.unpack_from(UINT8, raw[:EVENT_LEN], 24)
        cgmcalibration, = struct.unpack_from(UINT8, raw[:EVENT_LEN], 11)

        return LidBgReadingTaken(
            raw = RawEvent.build(raw),
            selectediobRaw = selectediob,
            BG = BG,
            bgentrytypeRaw = bgentrytype,
            IOB = IOB,
            targetbg = targetbg,
            ISF = ISF,
            bgsourcetypeRaw = bgsourcetype,
            cgmcalibrationRaw = cgmcalibration,
        )

    @property
    def eventTimestamp(self):
        return self.raw.timestamp

    @property
    def eventId(self):
        return self.raw.seqNum


@dataclass
class LidBolusCompleted(BaseEvent):
    """20: LID_BOLUS_COMPLETED"""
    ID = 20
    NAME = "LID_BOLUS_COMPLETED"

    raw: RawEvent
    completionstatusRaw: int
    bolusid: int
    insulindelivered: float # units
    insulinrequested: float # units
    IOB: float # units

    CompletionstatusMap = {
        "0": "User Aborted",
        "1": "Terminated by Alarm",
        "2": "Terminated by Malfunction",
        "3": "Completed",
        "4": "Reserved - Used in non-commercial software",
        "5": "Bolus rejected",
        "6": "Aborted by PLGS",
        "7": "Reserved",
        "8": "Reserved - For future use"
    }

    class CompletionstatusEnum(Enum):
        UserAborted = 0
        TerminatedByAlarm = 1
        TerminatedByMalfunction = 2
        Completed = 3
        BolusRejected = 5
        AbortedByPlgs = 6

    @property
    def completionstatus(self):
        try:
            return self.CompletionstatusEnum(self.completionstatusRaw)
        except ValueError as e:
            logger.error("Invalid completionstatusRaw in Completionstatus for "+str(self))
            logger.error(e)
            return None

    @staticmethod
    def build(raw):
        completionstatus, = struct.unpack_from(UINT16, raw[:EVENT_LEN], 12)
        bolusid, = struct.unpack_from(UINT16, raw[:EVENT_LEN], 10)
        insulindelivered, = struct.unpack_from(FLOAT32, raw[:EVENT_LEN], 18)
        insulinrequested, = struct.unpack_from(FLOAT32, raw[:EVENT_LEN], 22)
        IOB, = struct.unpack_from(FLOAT32, raw[:EVENT_LEN], 14)

        return LidBolusCompleted(
            raw = RawEvent.build(raw),
            completionstatusRaw = completionstatus,
            bolusid = bolusid,
            insulindelivered = insulindelivered,
            insulinrequested = insulinrequested,
            IOB = IOB,
        )

    @property
    def eventTimestamp(self):
        return self.raw.timestamp

    @property
    def eventId(self):
        return self.raw.seqNum


@dataclass
class LidBolexCompleted(BaseEvent):
    """21: LID_BOLEX_COMPLETED"""
    ID = 21
    NAME = "LID_BOLEX_COMPLETED"

    raw: RawEvent
    completionstatusRaw: int
    bolusid: int
    insulindelivered: float # units
    insulinrequested: float # units
    IOB: float # units

    CompletionstatusMap = {
        "0": "User Aborted",
        "1": "Terminated by Alarm",
        "2": "Terminated by Malfunction",
        "3": "Completed",
        "4": "Reserved - Used in non-commercial software",
        "5": "Bolus rejected",
        "6": "Aborted by PLGS",
        "7": "Reserved",
        "8": "Reserved - For future use"
    }

    class CompletionstatusEnum(Enum):
        UserAborted = 0
        TerminatedByAlarm = 1
        TerminatedByMalfunction = 2
        Completed = 3
        BolusRejected = 5
        AbortedByPlgs = 6

    @property
    def completionstatus(self):
        try:
            return self.CompletionstatusEnum(self.completionstatusRaw)
        except ValueError as e:
            logger.error("Invalid completionstatusRaw in Completionstatus for "+str(self))
            logger.error(e)
            return None

    @staticmethod
    def build(raw):
        completionstatus, = struct.unpack_from(UINT16, raw[:EVENT_LEN], 12)
        bolusid, = struct.unpack_from(UINT16, raw[:EVENT_LEN], 10)
        insulindelivered, = struct.unpack_from(FLOAT32, raw[:EVENT_LEN], 18)
        insulinrequested, = struct.unpack_from(FLOAT32, raw[:EVENT_LEN], 22)
        IOB, = struct.unpack_from(FLOAT32, raw[:EVENT_LEN], 14)

        return LidBolexCompleted(
            raw = RawEvent.build(raw),
            completionstatusRaw = completionstatus,
            bolusid = bolusid,
            insulindelivered = insulindelivered,
            insulinrequested = insulinrequested,
            IOB = IOB,
        )

    @property
    def eventTimestamp(self):
        return self.raw.timestamp

    @property
    def eventId(self):
        return self.raw.seqNum


@dataclass
class LidAlertCleared(BaseEvent):
    """26: LID_ALERT_CLEARED"""
    ID = 26
    NAME = "LID_ALERT_CLEARED"

    raw: RawEvent
    alertidRaw: int
    faultlocatordata: int

    AlertidMap = {
        "0": "LOW_INSULIN_ALERT",
        "1": "USB_CONNECTION_ALERT",
        "2": "LOW_POWER_ALERT",
        "3": "LOW_POWER_ALERT2",
        "4": "DATA_ERROR_ALERT",
        "5": "AUTO_OFF_ALERT",
        "6": "MAX_BASAL_RATE_ALERT",
        "7": "POWER_SOURCE_ALERT",
        "8": "MIN_BASAL_ALERT",
        "9": "CONNECTION_ERROR_ALERT",
        "10": "CONNECTION_ERROR_ALERT2",
        "11": "INCOMPLETE_BOLUS_ALERT",
        "12": "INCOMPLETE_TEMP_RATE_ALERT",
        "13": "INCOMPLETE_CARTRIDGE_CHANGE_ALERT",
        "14": "INCOMPLETE_FILL_TUBING_ALERT",
        "15": "INCOMPLETE_FILL_CANNULA_ALERT",
        "16": "INCOMPLETE_SETTING_ALERT",
        "17": "LOW_INSULIN_ALERT2",
        "18": "MAX_BASAL_ALERT",
        "19": "LOW_TRANSMITTER_ALERT",
        "20": "TRANSMITTER_ALERT",
        "21": "DEFAULT_ALERT_21",
        "22": "SENSOR_EXPIRING_ALERT",
        "23": "PUMP_REBOOTING_ALERT",
        "24": "DEVICE_CONNECTION_ERROR",
        "25": "CGM_GRAPH_REMOVED",
        "26": "MIN_BASAL_ALERT2",
        "27": "INCOMPLETE_CALIBRATION",
        "28": "CALIBRATION_TIMEOUT",
        "29": "INVALID_TRANSMITTER_ID",
        "30": "DEFAULT_ALERT_30",
        "32": "DEFAULT_ALERT_32",
        "33": "BUTTON_ALERT",
        "34": "QUICK_BOLUS_ALERT",
        "35": "BASAL_IQ_ALERT",
        "36": "DEFAULT_ALERT_36",
        "37": "DEFAULT_ALERT_37",
        "38": "DEFAULT_ALERT_38",
        "39": "TRANSMITTER_END_OF_LIFE",
        "40": "CGM_ERROR",
        "41": "CGM_ERROR2",
        "42": "CGM_ERROR3",
        "43": "DEFAULT_ALERT_43",
        "44": "TRANSMITTER_EXPIRING_ALERT",
        "45": "TRANSMITTER_EXPIRING_ALERT2",
        "46": "TRANSMITTER_EXPIRING_ALERT3",
        "47": "DEFAULT_ALERT_47",
        "48": "CGM_UNAVAILABLE",
        "49": "DEFAULT_ALERT_49",
        "50": "DEFAULT_ALERT_50",
        "51": "DEFAULT_ALERT_51",
        "52": "DEFAULT_ALERT_52",
        "53": "DEFAULT_ALERT_53",
        "54": "DEVICE_PAIRED",
        "55": "DEFAULT_ALERT_55",
        "56": "DEFAULT_ALERT_56",
        "57": "DEFAULT_ALERT_57",
        "58": "DEFAULT_ALERT_58",
        "59": "DEFAULT_ALERT_59",
        "60": "DEFAULT_ALERT_60",
        "61": "DEFAULT_ALERT_61",
        "62": "DEFAULT_ALERT_62",
        "63": "DEFAULT_ALERT_63"
    }

    class AlertidEnum(Enum):
        LowInsulinAlert = 0
        UsbConnectionAlert = 1
        LowPowerAlert = 2
        LowPowerAlert2 = 3
        DataErrorAlert = 4
        AutoOffAlert = 5
        MaxBasalRateAlert = 6
        PowerSourceAlert = 7
        MinBasalAlert = 8
        ConnectionErrorAlert = 9
        ConnectionErrorAlert2 = 10
        IncompleteBolusAlert = 11
        IncompleteTempRateAlert = 12
        IncompleteCartridgeChangeAlert = 13
        IncompleteFillTubingAlert = 14
        IncompleteFillCannulaAlert = 15
        IncompleteSettingAlert = 16
        LowInsulinAlert2 = 17
        MaxBasalAlert = 18
        LowTransmitterAlert = 19
        TransmitterAlert = 20
        DefaultAlert21 = 21
        SensorExpiringAlert = 22
        PumpRebootingAlert = 23
        DeviceConnectionError = 24
        CgmGraphRemoved = 25
        MinBasalAlert2 = 26
        IncompleteCalibration = 27
        CalibrationTimeout = 28
        InvalidTransmitterId = 29
        DefaultAlert30 = 30
        DefaultAlert32 = 32
        ButtonAlert = 33
        QuickBolusAlert = 34
        BasalIqAlert = 35
        DefaultAlert36 = 36
        DefaultAlert37 = 37
        DefaultAlert38 = 38
        TransmitterEndOfLife = 39
        CgmError = 40
        CgmError2 = 41
        CgmError3 = 42
        DefaultAlert43 = 43
        TransmitterExpiringAlert = 44
        TransmitterExpiringAlert2 = 45
        TransmitterExpiringAlert3 = 46
        DefaultAlert47 = 47
        CgmUnavailable = 48
        DefaultAlert49 = 49
        DefaultAlert50 = 50
        DefaultAlert51 = 51
        DefaultAlert52 = 52
        DefaultAlert53 = 53
        DevicePaired = 54
        DefaultAlert55 = 55
        DefaultAlert56 = 56
        DefaultAlert57 = 57
        DefaultAlert58 = 58
        DefaultAlert59 = 59
        DefaultAlert60 = 60
        DefaultAlert61 = 61
        DefaultAlert62 = 62
        DefaultAlert63 = 63

    @property
    def alertid(self):
        try:
            return self.AlertidEnum(self.alertidRaw)
        except ValueError as e:
            logger.error("Invalid alertidRaw in Alertid for "+str(self))
            logger.error(e)
            return None

    @staticmethod
    def build(raw):
        alertid, = struct.unpack_from(UINT32, raw[:EVENT_LEN], 10)
        faultlocatordata, = struct.unpack_from(UINT32, raw[:EVENT_LEN], 14)

        return LidAlertCleared(
            raw = RawEvent.build(raw),
            alertidRaw = alertid,
            faultlocatordata = faultlocatordata,
        )

    @property
    def eventTimestamp(self):
        return self.raw.timestamp

    @property
    def eventId(self):
        return self.raw.seqNum


@dataclass
class LidAlarmCleared(BaseEvent):
    """28: LID_ALARM_CLEARED"""
    ID = 28
    NAME = "LID_ALARM_CLEARED"

    raw: RawEvent
    alarmidRaw: int

    AlarmidMap = {
        "0": "CARTRIDGE_ALARM",
        "1": "CARTRIDGE_ALARM2",
        "2": "OCCLUSION_ALARM",
        "3": "PUMP_RESET_ALARM",
        "4": "DEFAULT_ALARM_4",
        "5": "CARTRIDGE_ALARM3",
        "6": "CARTRIDGE_ALARM4",
        "7": "AUTO_OFF_ALARM",
        "8": "EMPTY_CARTRIDGE_ALARM",
        "9": "CARTRIDGE_ALARM5",
        "10": "TEMPERATURE_ALARM",
        "11": "TEMPERATURE_ALARM2",
        "12": "BATTERY_SHUTDOWN_ALARM",
        "13": "DEFAULT_ALARM_13",
        "14": "INVALID_DATE_ALARM",
        "15": "TEMPERATURE_ALARM3",
        "16": "CARTRIDGE_ALARM6",
        "17": "DEFAULT_ALARM_17",
        "18": "RESUME_PUMP_ALARM",
        "19": "DEFAULT_ALARM_19",
        "20": "CARTRIDGE_ALARM7",
        "21": "ALTITUDE_ALARM",
        "22": "STUCK_BUTTON_ALARM",
        "23": "RESUME_PUMP_ALARM2",
        "24": "ATMOSPHERIC_PRESSURE_OUT_OF_RANGE_ALARM",
        "25": "CARTRIDGE_REMOVED_ALARM",
        "26": "OCCLUSION_ALARM2",
        "27": "DEFAULT_ALARM_27",
        "28": "DEFAULT_ALARM_28",
        "29": "CARTRIDGE_ALARM10",
        "30": "CARTRIDGE_ALARM11",
        "31": "CARTRIDGE_ALARM12",
        "32": "DEFAULT_ALARM_32",
        "33": "DEFAULT_ALARM_33",
        "34": "DEFAULT_ALARM_34",
        "35": "DEFAULT_ALARM_35",
        "36": "DEFAULT_ALARM_36",
        "37": "DEFAULT_ALARM_37",
        "38": "DEFAULT_ALARM_38",
        "39": "DEFAULT_ALARM_39",
        "40": "DEFAULT_ALARM_40",
        "41": "DEFAULT_ALARM_41",
        "42": "DEFAULT_ALARM_42",
        "43": "DEFAULT_ALARM_43",
        "44": "DEFAULT_ALARM_44",
        "45": "DEFAULT_ALARM_45",
        "46": "DEFAULT_ALARM_46",
        "47": "DEFAULT_ALARM_47",
        "48": "DEFAULT_ALARM_48",
        "49": "DEFAULT_ALARM_49",
        "50": "DEFAULT_ALARM_50",
        "51": "DEFAULT_ALARM_51",
        "52": "DEFAULT_ALARM_52",
        "53": "DEFAULT_ALARM_53",
        "54": "DEFAULT_ALARM_54",
        "55": "DEFAULT_ALARM_55",
        "56": "DEFAULT_ALARM_56",
        "57": "DEFAULT_ALARM_57",
        "58": "DEFAULT_ALARM_58",
        "59": "DEFAULT_ALARM_59",
        "60": "DEFAULT_ALARM_60",
        "61": "DEFAULT_ALARM_61",
        "62": "DEFAULT_ALARM_62",
        "63": "DEFAULT_ALARM_63"
    }

    class AlarmidEnum(Enum):
        CartridgeAlarm = 0
        CartridgeAlarm2 = 1
        OcclusionAlarm = 2
        PumpResetAlarm = 3
        DefaultAlarm4 = 4
        CartridgeAlarm3 = 5
        CartridgeAlarm4 = 6
        AutoOffAlarm = 7
        EmptyCartridgeAlarm = 8
        CartridgeAlarm5 = 9
        TemperatureAlarm = 10
        TemperatureAlarm2 = 11
        BatteryShutdownAlarm = 12
        DefaultAlarm13 = 13
        InvalidDateAlarm = 14
        TemperatureAlarm3 = 15
        CartridgeAlarm6 = 16
        DefaultAlarm17 = 17
        ResumePumpAlarm = 18
        DefaultAlarm19 = 19
        CartridgeAlarm7 = 20
        AltitudeAlarm = 21
        StuckButtonAlarm = 22
        ResumePumpAlarm2 = 23
        AtmosphericPressureOutOfRangeAlarm = 24
        CartridgeRemovedAlarm = 25
        OcclusionAlarm2 = 26
        DefaultAlarm27 = 27
        DefaultAlarm28 = 28
        CartridgeAlarm10 = 29
        CartridgeAlarm11 = 30
        CartridgeAlarm12 = 31
        DefaultAlarm32 = 32
        DefaultAlarm33 = 33
        DefaultAlarm34 = 34
        DefaultAlarm35 = 35
        DefaultAlarm36 = 36
        DefaultAlarm37 = 37
        DefaultAlarm38 = 38
        DefaultAlarm39 = 39
        DefaultAlarm40 = 40
        DefaultAlarm41 = 41
        DefaultAlarm42 = 42
        DefaultAlarm43 = 43
        DefaultAlarm44 = 44
        DefaultAlarm45 = 45
        DefaultAlarm46 = 46
        DefaultAlarm47 = 47
        DefaultAlarm48 = 48
        DefaultAlarm49 = 49
        DefaultAlarm50 = 50
        DefaultAlarm51 = 51
        DefaultAlarm52 = 52
        DefaultAlarm53 = 53
        DefaultAlarm54 = 54
        DefaultAlarm55 = 55
        DefaultAlarm56 = 56
        DefaultAlarm57 = 57
        DefaultAlarm58 = 58
        DefaultAlarm59 = 59
        DefaultAlarm60 = 60
        DefaultAlarm61 = 61
        DefaultAlarm62 = 62
        DefaultAlarm63 = 63

    @property
    def alarmid(self):
        try:
            return self.AlarmidEnum(self.alarmidRaw)
        except ValueError as e:
            logger.error("Invalid alarmidRaw in Alarmid for "+str(self))
            logger.error(e)
            return None

    @staticmethod
    def build(raw):
        alarmid, = struct.unpack_from(UINT32, raw[:EVENT_LEN], 10)

        return LidAlarmCleared(
            raw = RawEvent.build(raw),
            alarmidRaw = alarmid,
        )

    @property
    def eventTimestamp(self):
        return self.raw.timestamp

    @property
    def eventId(self):
        return self.raw.seqNum


@dataclass
class LidCartridgeFilled(BaseEvent):
    """33: LID_CARTRIDGE_FILLED"""
    ID = 33
    NAME = "LID_CARTRIDGE_FILLED"

    raw: RawEvent
    insulinvolume: int # units
    v2Volume: float # units


    @staticmethod
    def build(raw):
        insulinvolume, = struct.unpack_from(UINT32, raw[:EVENT_LEN], 10)
        v2Volume, = struct.unpack_from(FLOAT32, raw[:EVENT_LEN], 14)

        return LidCartridgeFilled(
            raw = RawEvent.build(raw),
            insulinvolume = insulinvolume,
            v2Volume = v2Volume,
        )

    @property
    def eventTimestamp(self):
        return self.raw.timestamp

    @property
    def eventId(self):
        return self.raw.seqNum


@dataclass
class LidShelfMode(BaseEvent):
    """53: LID_SHELF_MODE"""
    ID = 53
    NAME = "LID_SHELF_MODE"

    raw: RawEvent
    msecsincereset: int # ms
    lipocurrent: int # mA
    lipoAbc: int # %
    lipoIbc: int # %
    lipoRemcap: int # mAh
    lipoMv: int # mV


    @staticmethod
    def build(raw):
        msecsincereset, = struct.unpack_from(UINT32, raw[:EVENT_LEN], 10)
        lipocurrent, = struct.unpack_from(INT16, raw[:EVENT_LEN], 16)
        lipoAbc, = struct.unpack_from(UINT8, raw[:EVENT_LEN], 15)
        lipoIbc, = struct.unpack_from(UINT8, raw[:EVENT_LEN], 14)
        lipoRemcap, = struct.unpack_from(UINT32, raw[:EVENT_LEN], 18)
        lipoMv, = struct.unpack_from(UINT32, raw[:EVENT_LEN], 22)

        return LidShelfMode(
            raw = RawEvent.build(raw),
            msecsincereset = msecsincereset,
            lipocurrent = lipocurrent,
            lipoAbc = lipoAbc,
            lipoIbc = lipoIbc,
            lipoRemcap = lipoRemcap,
            lipoMv = lipoMv,
        )

    @property
    def eventTimestamp(self):
        return self.raw.timestamp

    @property
    def eventId(self):
        return self.raw.seqNum


@dataclass
class LidBolusActivated(BaseEvent):
    """55: LID_BOLUS_ACTIVATED"""
    ID = 55
    NAME = "LID_BOLUS_ACTIVATED"

    raw: RawEvent
    selectediobRaw: int
    bolusid: int
    IOB: float # units
    bolussize: float # units

    SelectediobMap = {
        "0": "Mudaliar IOB",
        "1": "Swan IOB Meal"
    }

    class SelectediobEnum(Enum):
        MudaliarIob = 0
        SwanIobMeal = 1

    @property
    def selectediob(self):
        try:
            return self.SelectediobEnum(self.selectediobRaw)
        except ValueError as e:
            logger.error("Invalid selectediobRaw in Selectediob for "+str(self))
            logger.error(e)
            return None

    @staticmethod
    def build(raw):
        selectediob, = struct.unpack_from(UINT8, raw[:EVENT_LEN], 11)
        bolusid, = struct.unpack_from(UINT16, raw[:EVENT_LEN], 12)
        IOB, = struct.unpack_from(FLOAT32, raw[:EVENT_LEN], 14)
        bolussize, = struct.unpack_from(FLOAT32, raw[:EVENT_LEN], 18)

        return LidBolusActivated(
            raw = RawEvent.build(raw),
            selectediobRaw = selectediob,
            bolusid = bolusid,
            IOB = IOB,
            bolussize = bolussize,
        )

    @property
    def eventTimestamp(self):
        return self.raw.timestamp

    @property
    def eventId(self):
        return self.raw.seqNum


@dataclass
class LidBolexActivated(BaseEvent):
    """59: LID_BOLEX_ACTIVATED"""
    ID = 59
    NAME = "LID_BOLEX_ACTIVATED"

    raw: RawEvent
    selectediobRaw: int
    bolusid: int
    IOB: float # units
    bolexsize: float # units

    SelectediobMap = {
        "0": "Mudaliar IOB",
        "1": "Swan IOB Meal"
    }

    class SelectediobEnum(Enum):
        MudaliarIob = 0
        SwanIobMeal = 1

    @property
    def selectediob(self):
        try:
            return self.SelectediobEnum(self.selectediobRaw)
        except ValueError as e:
            logger.error("Invalid selectediobRaw in Selectediob for "+str(self))
            logger.error(e)
            return None

    @staticmethod
    def build(raw):
        selectediob, = struct.unpack_from(UINT8, raw[:EVENT_LEN], 11)
        bolusid, = struct.unpack_from(UINT16, raw[:EVENT_LEN], 12)
        IOB, = struct.unpack_from(FLOAT32, raw[:EVENT_LEN], 14)
        bolexsize, = struct.unpack_from(FLOAT32, raw[:EVENT_LEN], 18)

        return LidBolexActivated(
            raw = RawEvent.build(raw),
            selectediobRaw = selectediob,
            bolusid = bolusid,
            IOB = IOB,
            bolexsize = bolexsize,
        )

    @property
    def eventTimestamp(self):
        return self.raw.timestamp

    @property
    def eventId(self):
        return self.raw.seqNum


@dataclass
class LidDataLogCorruption(BaseEvent):
    """60: LID_DATA_LOG_CORRUPTION"""
    ID = 60
    NAME = "LID_DATA_LOG_CORRUPTION"

    raw: RawEvent
    block: int
    reason: int


    @staticmethod
    def build(raw):
        block, = struct.unpack_from(UINT32, raw[:EVENT_LEN], 10)
        reason, = struct.unpack_from(UINT8, raw[:EVENT_LEN], 17)

        return LidDataLogCorruption(
            raw = RawEvent.build(raw),
            block = block,
            reason = reason,
        )

    @property
    def eventTimestamp(self):
        return self.raw.timestamp

    @property
    def eventId(self):
        return self.raw.seqNum


@dataclass
class LidCannulaFilled(BaseEvent):
    """61: LID_CANNULA_FILLED"""
    ID = 61
    NAME = "LID_CANNULA_FILLED"

    raw: RawEvent
    primesize: float # units
    completionstatusRaw: int

    CompletionstatusMap = {
        "0": "User Aborted",
        "1": "Terminated by Alarm",
        "2": "Terminated by Malfunction",
        "3": "Completed"
    }

    class CompletionstatusEnum(Enum):
        UserAborted = 0
        TerminatedByAlarm = 1
        TerminatedByMalfunction = 2
        Completed = 3

    @property
    def completionstatus(self):
        try:
            return self.CompletionstatusEnum(self.completionstatusRaw)
        except ValueError as e:
            logger.error("Invalid completionstatusRaw in Completionstatus for "+str(self))
            logger.error(e)
            return None

    @staticmethod
    def build(raw):
        primesize, = struct.unpack_from(FLOAT32, raw[:EVENT_LEN], 10)
        completionstatus, = struct.unpack_from(UINT32, raw[:EVENT_LEN], 14)

        return LidCannulaFilled(
            raw = RawEvent.build(raw),
            primesize = primesize,
            completionstatusRaw = completionstatus,
        )

    @property
    def eventTimestamp(self):
        return self.raw.timestamp

    @property
    def eventId(self):
        return self.raw.seqNum


@dataclass
class LidTubingFilled(BaseEvent):
    """63: LID_TUBING_FILLED"""
    ID = 63
    NAME = "LID_TUBING_FILLED"

    raw: RawEvent
    primesize: float # units
    completionstatusRaw: int
    position: int # counts

    CompletionstatusMap = {
        "0": "User Aborted",
        "1": "Terminated by Alarm",
        "2": "Terminated by Malfunction",
        "3": "Completed"
    }

    class CompletionstatusEnum(Enum):
        UserAborted = 0
        TerminatedByAlarm = 1
        TerminatedByMalfunction = 2
        Completed = 3

    @property
    def completionstatus(self):
        try:
            return self.CompletionstatusEnum(self.completionstatusRaw)
        except ValueError as e:
            logger.error("Invalid completionstatusRaw in Completionstatus for "+str(self))
            logger.error(e)
            return None

    @staticmethod
    def build(raw):
        primesize, = struct.unpack_from(FLOAT32, raw[:EVENT_LEN], 10)
        completionstatus, = struct.unpack_from(UINT32, raw[:EVENT_LEN], 14)
        position, = struct.unpack_from(UINT32, raw[:EVENT_LEN], 18)

        return LidTubingFilled(
            raw = RawEvent.build(raw),
            primesize = primesize,
            completionstatusRaw = completionstatus,
            position = position,
        )

    @property
    def eventTimestamp(self):
        return self.raw.timestamp

    @property
    def eventId(self):
        return self.raw.seqNum


@dataclass
class LidBolusRequestedMsg1(BaseEvent):
    """64: LID_BOLUS_REQUESTED_MSG1"""
    ID = 64
    NAME = "LID_BOLUS_REQUESTED_MSG1"

    raw: RawEvent
    bolusid: int
    bolustypeRaw: int
    correctionbolusincludedRaw: int
    carbamount: int # grams
    BG: int # mg/dL
    carbratioRaw: int # g/u
    IOB: float # units

    BolustypeMap = {
        "0": "Insulin",
        "1": "Carb",
        "2": "Automatic Correction",
        "3": "Remote"
    }

    class BolustypeEnum(Enum):
        Insulin = 0
        Carb = 1
        AutomaticCorrection = 2
        Remote = 3

    @property
    def bolustype(self):
        try:
            return self.BolustypeEnum(self.bolustypeRaw)
        except ValueError as e:
            logger.error("Invalid bolustypeRaw in Bolustype for "+str(self))
            logger.error(e)
            return None

    CorrectionbolusincludedMap = {
        "0": "No",
        "1": "Yes"
    }

    class CorrectionbolusincludedEnum(Enum):
        No = 0
        Yes = 1

    @property
    def correctionbolusincluded(self):
        try:
            return self.CorrectionbolusincludedEnum(self.correctionbolusincludedRaw)
        except ValueError as e:
            logger.error("Invalid correctionbolusincludedRaw in Correctionbolusincluded for "+str(self))
            logger.error(e)
            return None

    @property
    def carbratio(self):
        return self.carbratioRaw * 0.001

    @staticmethod
    def build(raw):
        bolusid, = struct.unpack_from(UINT16, raw[:EVENT_LEN], 12)
        bolustype, = struct.unpack_from(UINT8, raw[:EVENT_LEN], 11)
        correctionbolusincluded, = struct.unpack_from(UINT8, raw[:EVENT_LEN], 10)
        carbamount, = struct.unpack_from(UINT16, raw[:EVENT_LEN], 16)
        BG, = struct.unpack_from(UINT16, raw[:EVENT_LEN], 14)
        carbratio, = struct.unpack_from(UINT32, raw[:EVENT_LEN], 22)
        IOB, = struct.unpack_from(FLOAT32, raw[:EVENT_LEN], 18)

        return LidBolusRequestedMsg1(
            raw = RawEvent.build(raw),
            bolusid = bolusid,
            bolustypeRaw = bolustype,
            correctionbolusincludedRaw = correctionbolusincluded,
            carbamount = carbamount,
            BG = BG,
            carbratioRaw = carbratio,
            IOB = IOB,
        )

    @property
    def eventTimestamp(self):
        return self.raw.timestamp

    @property
    def eventId(self):
        return self.raw.seqNum


@dataclass
class LidBolusRequestedMsg2(BaseEvent):
    """65: LID_BOLUS_REQUESTED_MSG2"""
    ID = 65
    NAME = "LID_BOLUS_REQUESTED_MSG2"

    raw: RawEvent
    selectediobRaw: int
    bolusid: int
    optionsRaw: int
    standardpercent: int # %
    duration: int # minutes
    ISF: int # (mg/dL)/unit
    targetbg: int # mg/dL
    useroverrideRaw: int
    declinedcorrectionRaw: int

    SelectediobMap = {
        "0": "Mudaliar IOB",
        "1": "Swan IOB Meal"
    }

    class SelectediobEnum(Enum):
        MudaliarIob = 0
        SwanIobMeal = 1

    @property
    def selectediob(self):
        try:
            return self.SelectediobEnum(self.selectediobRaw)
        except ValueError as e:
            logger.error("Invalid selectediobRaw in Selectediob for "+str(self))
            logger.error(e)
            return None

    OptionsMap = {
        "0": "Standard Bolus",
        "1": "Extended Bolus",
        "2": "Quick Bolus",
        "3": "Automatic Bolus",
        "4": "BLE Standard Bolus",
        "5": "BLE Extended Bolus",
        "6": "Eating Soon Automatic Bolus",
        "7": "Late Bolus"
    }

    class OptionsEnum(Enum):
        StandardBolus = 0
        ExtendedBolus = 1
        QuickBolus = 2
        AutomaticBolus = 3
        BleStandardBolus = 4
        BleExtendedBolus = 5
        EatingSoonAutomaticBolus = 6
        LateBolus = 7

    @property
    def options(self):
        try:
            return self.OptionsEnum(self.optionsRaw)
        except ValueError as e:
            logger.error("Invalid optionsRaw in Options for "+str(self))
            logger.error(e)
            return None

    UseroverrideMap = {
        "0": "\"No\", user did not override the bolus size",
        "1": "\"Yes\", user did override the bolus size"
    }

    class UseroverrideEnum(Enum):
        No = 0
        Yes = 1

    @property
    def useroverride(self):
        try:
            return self.UseroverrideEnum(self.useroverrideRaw)
        except ValueError as e:
            logger.error("Invalid useroverrideRaw in Useroverride for "+str(self))
            logger.error(e)
            return None

    DeclinedcorrectionMap = {
        "0": "\"No\", user did not decline the recommended correction",
        "1": "\"Yes\", user declined the recommended correction"
    }

    class DeclinedcorrectionEnum(Enum):
        No = 0
        Yes = 1

    @property
    def declinedcorrection(self):
        try:
            return self.DeclinedcorrectionEnum(self.declinedcorrectionRaw)
        except ValueError as e:
            logger.error("Invalid declinedcorrectionRaw in Declinedcorrection for "+str(self))
            logger.error(e)
            return None

    @staticmethod
    def build(raw):
        selectediob, = struct.unpack_from(UINT8, raw[:EVENT_LEN], 23)
        bolusid, = struct.unpack_from(UINT16, raw[:EVENT_LEN], 12)
        options, = struct.unpack_from(UINT8, raw[:EVENT_LEN], 11)
        standardpercent, = struct.unpack_from(UINT8, raw[:EVENT_LEN], 10)
        duration, = struct.unpack_from(UINT16, raw[:EVENT_LEN], 16)
        ISF, = struct.unpack_from(UINT16, raw[:EVENT_LEN], 20)
        targetbg, = struct.unpack_from(UINT16, raw[:EVENT_LEN], 18)
        useroverride, = struct.unpack_from(UINT8, raw[:EVENT_LEN], 25)
        declinedcorrection, = struct.unpack_from(UINT8, raw[:EVENT_LEN], 24)

        return LidBolusRequestedMsg2(
            raw = RawEvent.build(raw),
            selectediobRaw = selectediob,
            bolusid = bolusid,
            optionsRaw = options,
            standardpercent = standardpercent,
            duration = duration,
            ISF = ISF,
            targetbg = targetbg,
            useroverrideRaw = useroverride,
            declinedcorrectionRaw = declinedcorrection,
        )

    @property
    def eventTimestamp(self):
        return self.raw.timestamp

    @property
    def eventId(self):
        return self.raw.seqNum


@dataclass
class LidBolusRequestedMsg3(BaseEvent):
    """66: LID_BOLUS_REQUESTED_MSG3"""
    ID = 66
    NAME = "LID_BOLUS_REQUESTED_MSG3"

    raw: RawEvent
    bolusid: int
    foodbolussize: float # units
    correctionbolussize: float # units
    totalbolussize: float # units


    @staticmethod
    def build(raw):
        bolusid, = struct.unpack_from(UINT16, raw[:EVENT_LEN], 12)
        foodbolussize, = struct.unpack_from(FLOAT32, raw[:EVENT_LEN], 14)
        correctionbolussize, = struct.unpack_from(FLOAT32, raw[:EVENT_LEN], 18)
        totalbolussize, = struct.unpack_from(FLOAT32, raw[:EVENT_LEN], 22)

        return LidBolusRequestedMsg3(
            raw = RawEvent.build(raw),
            bolusid = bolusid,
            foodbolussize = foodbolussize,
            correctionbolussize = correctionbolussize,
            totalbolussize = totalbolussize,
        )

    @property
    def eventTimestamp(self):
        return self.raw.timestamp

    @property
    def eventId(self):
        return self.raw.seqNum


@dataclass
class LidNewDay(BaseEvent):
    """90: LID_NEW_DAY"""
    ID = 90
    NAME = "LID_NEW_DAY"

    raw: RawEvent
    commandedbasalrate: float # units/hour
    featuresbitmask: int
    featurebitmaskindex: int


    @staticmethod
    def build(raw):
        commandedbasalrate, = struct.unpack_from(FLOAT32, raw[:EVENT_LEN], 10)
        featuresbitmask, = struct.unpack_from(UINT32, raw[:EVENT_LEN], 14)
        featurebitmaskindex, = struct.unpack_from(UINT32, raw[:EVENT_LEN], 18)

        return LidNewDay(
            raw = RawEvent.build(raw),
            commandedbasalrate = commandedbasalrate,
            featuresbitmask = featuresbitmask,
            featurebitmaskindex = featurebitmaskindex,
        )

    @property
    def eventTimestamp(self):
        return self.raw.timestamp

    @property
    def eventId(self):
        return self.raw.seqNum


@dataclass
class LidArmInit(BaseEvent):
    """99: LID_ARM_INIT"""
    ID = 99
    NAME = "LID_ARM_INIT"

    raw: RawEvent
    version: int
    configabits: int
    configbbits: int
    numlogentries: int


    @staticmethod
    def build(raw):
        version, = struct.unpack_from(UINT32, raw[:EVENT_LEN], 10)
        configabits, = struct.unpack_from(UINT32, raw[:EVENT_LEN], 14)
        configbbits, = struct.unpack_from(UINT32, raw[:EVENT_LEN], 18)
        numlogentries, = struct.unpack_from(UINT32, raw[:EVENT_LEN], 22)

        return LidArmInit(
            raw = RawEvent.build(raw),
            version = version,
            configabits = configabits,
            configbbits = configbbits,
            numlogentries = numlogentries,
        )

    @property
    def eventTimestamp(self):
        return self.raw.timestamp

    @property
    def eventId(self):
        return self.raw.seqNum


@dataclass
class LidPlgsPeriodic(BaseEvent):
    """140: LID_PLGS_PERIODIC"""
    ID = 140
    NAME = "LID_PLGS_PERIODIC"

    raw: RawEvent
    timestamp: int # sec
    FMR: int # mg/dL
    PGV: int # mg/dL
    fmrstatusRaw: int
    pgvvalidRaw: int
    rulestateRaw: int
    hominstateRaw: int
    statusRaw: int

    FmrstatusMap = {
        "0": "No FMR",
        "1": "Periodic glucose reading",
        "2": "Calibration response glucose reading",
        "3": "Sensor session stopped (no FMR)",
        "4": "Sensor session started (no FMR)",
        "5": "Calibration entered (no FMR)",
        "6": "Pumping event (no FMR)"
    }

    class FmrstatusEnum(Enum):
        NoFmr = 0
        PeriodicGlucoseReading = 1
        CalibrationResponseGlucoseReading = 2
        SensorSessionStoppedNoFmr = 3
        SensorSessionStartedNoFmr = 4
        CalibrationEnteredNoFmr = 5
        PumpingEventNoFmr = 6

    @property
    def fmrstatus(self):
        try:
            return self.FmrstatusEnum(self.fmrstatusRaw)
        except ValueError as e:
            logger.error("Invalid fmrstatusRaw in Fmrstatus for "+str(self))
            logger.error(e)
            return None

    PgvvalidMap = {
        "0": "FALSE",
        "1": "TRUE"
    }

    class PgvvalidEnum(Enum):
        FalseVal = 0
        TrueVal = 1

    @property
    def pgvvalid(self):
        try:
            return self.PgvvalidEnum(self.pgvvalidRaw)
        except ValueError as e:
            logger.error("Invalid pgvvalidRaw in Pgvvalid for "+str(self))
            logger.error(e)
            return None

    RulestateMap = {
        "0": "HO_SUSPEND_RULE",
        "1": "HO_RECOVERY_RULE",
        "2": "HO_UNAVAILABLE_RULE"
    }

    class RulestateBitmask(IntFlag):
        HoSuspendRule = 2**0
        HoRecoveryRule = 2**1
        HoUnavailableRule = 2**2

    @property
    def rulestate(self):
        try:
            return self.RulestateBitmask(self.rulestateRaw)
        except ValueError as e:
            logger.error("Invalid rulestateRaw in RulestateBitmask for "+str(self))
            logger.error(e)
            return None

    HominstateMap = {
        "0": "On and available",
        "1": "On and suspended",
        "2": "Off",
        "3": "On and not available"
    }

    class HominstateEnum(Enum):
        OnAndAvailable = 0
        OnAndSuspended = 1
        Off = 2
        OnAndNotAvailable = 3

    @property
    def hominstate(self):
        try:
            return self.HominstateEnum(self.hominstateRaw)
        except ValueError as e:
            logger.error("Invalid hominstateRaw in Hominstate for "+str(self))
            logger.error(e)
            return None

    StatusMap = {
        "0": "Suspend Predicted",
        "1": "Suspend Current",
        "2": "Unused",
        "3": "Unused",
        "4": "Resume EGV Rise",
        "5": "Unused",
        "6": "Resume Nadir Lock",
        "7": "Unavailable - Time Small",
        "8": "Unavailable - Suspend Override",
        "9": "Unavailable - CGM Off",
        "10": "Unavailable - High EGV",
        "11": "Unavailable - Not Therapy",
        "12": "Unavailable - Bolus Active",
        "13": "Unavailable - No Current"
    }

    class StatusBitmask(IntFlag):
        SuspendPredicted = 2**0
        SuspendCurrent = 2**1
        ResumeEgvRise = 2**4
        ResumeNadirLock = 2**6
        Unavailabletimesmall = 2**7
        Unavailablesuspendoverride = 2**8
        Unavailablecgmoff = 2**9
        Unavailablehighegv = 2**10
        Unavailablenottherapy = 2**11
        Unavailablebolusactive = 2**12
        Unavailablenocurrent = 2**13

    @property
    def status(self):
        try:
            return self.StatusBitmask(self.statusRaw)
        except ValueError as e:
            logger.error("Invalid statusRaw in StatusBitmask for "+str(self))
            logger.error(e)
            return None

    @staticmethod
    def build(raw):
        timestamp, = struct.unpack_from(UINT32, raw[:EVENT_LEN], 10)
        FMR, = struct.unpack_from(UINT16, raw[:EVENT_LEN], 16)
        PGV, = struct.unpack_from(UINT16, raw[:EVENT_LEN], 14)
        fmrstatus, = struct.unpack_from(UINT8, raw[:EVENT_LEN], 21)
        pgvvalid, = struct.unpack_from(UINT8, raw[:EVENT_LEN], 20)
        rulestate, = struct.unpack_from(UINT8, raw[:EVENT_LEN], 19)
        hominstate, = struct.unpack_from(UINT8, raw[:EVENT_LEN], 18)
        status, = struct.unpack_from(UINT32, raw[:EVENT_LEN], 22)

        return LidPlgsPeriodic(
            raw = RawEvent.build(raw),
            timestamp = timestamp,
            FMR = FMR,
            PGV = PGV,
            fmrstatusRaw = fmrstatus,
            pgvvalidRaw = pgvvalid,
            rulestateRaw = rulestate,
            hominstateRaw = hominstate,
            statusRaw = status,
        )

    @property
    def eventTimestamp(self):
        return self.raw.timestamp

    @property
    def eventId(self):
        return self.raw.seqNum


@dataclass
class LidCgmAlertActivated(BaseEvent):
    """171: LID_CGM_ALERT_ACTIVATED"""
    ID = 171
    NAME = "LID_CGM_ALERT_ACTIVATED"

    raw: RawEvent
    dalertidRaw: int
    faultlocatordata: int
    param1: int
    param2: float

    DalertidMap = {
        "11": "CGM Sensor Fail",
        "13": "CGM Sensor Expired",
        "14": "CGM Out Of Range",
        "20": "CGM Transmitter Error",
        "26": "CGM Temperature",
        "27": "CGM Failed Connection",
        "39": "CGM Transmitter Expired",
        "40": "Pump Bluetooth Error"
    }

    class DalertidEnum(Enum):
        CgmSensorFail = 11
        CgmSensorExpired = 13
        CgmOutOfRange = 14
        CgmTransmitterError = 20
        CgmTemperature = 26
        CgmFailedConnection = 27
        CgmTransmitterExpired = 39
        PumpBluetoothError = 40

    @property
    def dalertid(self):
        try:
            return self.DalertidEnum(self.dalertidRaw)
        except ValueError as e:
            logger.error("Invalid dalertidRaw in Dalertid for "+str(self))
            logger.error(e)
            return None

    @staticmethod
    def build(raw):
        dalertid, = struct.unpack_from(UINT32, raw[:EVENT_LEN], 10)
        faultlocatordata, = struct.unpack_from(UINT32, raw[:EVENT_LEN], 14)
        param1, = struct.unpack_from(UINT32, raw[:EVENT_LEN], 18)
        param2, = struct.unpack_from(FLOAT32, raw[:EVENT_LEN], 22)

        return LidCgmAlertActivated(
            raw = RawEvent.build(raw),
            dalertidRaw = dalertid,
            faultlocatordata = faultlocatordata,
            param1 = param1,
            param2 = param2,
        )

    @property
    def eventTimestamp(self):
        return self.raw.timestamp

    @property
    def eventId(self):
        return self.raw.seqNum


@dataclass
class LidCgmAlertCleared(BaseEvent):
    """172: LID_CGM_ALERT_CLEARED"""
    ID = 172
    NAME = "LID_CGM_ALERT_CLEARED"

    raw: RawEvent
    dalertidRaw: int

    DalertidMap = {
        "11": "CGM Sensor Fail",
        "13": "CGM Sensor Expired",
        "14": "CGM Out Of Range",
        "20": "CGM Transmitter Error",
        "26": "CGM Temperature",
        "27": "CGM Failed Connection",
        "39": "CGM Transmitter Expired",
        "40": "Pump Bluetooth Error"
    }

    class DalertidEnum(Enum):
        CgmSensorFail = 11
        CgmSensorExpired = 13
        CgmOutOfRange = 14
        CgmTransmitterError = 20
        CgmTemperature = 26
        CgmFailedConnection = 27
        CgmTransmitterExpired = 39
        PumpBluetoothError = 40

    @property
    def dalertid(self):
        try:
            return self.DalertidEnum(self.dalertidRaw)
        except ValueError as e:
            logger.error("Invalid dalertidRaw in Dalertid for "+str(self))
            logger.error(e)
            return None

    @staticmethod
    def build(raw):
        dalertid, = struct.unpack_from(UINT32, raw[:EVENT_LEN], 10)

        return LidCgmAlertCleared(
            raw = RawEvent.build(raw),
            dalertidRaw = dalertid,
        )

    @property
    def eventTimestamp(self):
        return self.raw.timestamp

    @property
    def eventId(self):
        return self.raw.seqNum


@dataclass
class LidVersionInfo(BaseEvent):
    """191: LID_VERSION_INFO"""
    ID = 191
    NAME = "LID_VERSION_INFO"

    raw: RawEvent
    version: int
    configabits: int
    configbbits: int
    armcrc: int


    @staticmethod
    def build(raw):
        version, = struct.unpack_from(UINT32, raw[:EVENT_LEN], 10)
        configabits, = struct.unpack_from(UINT32, raw[:EVENT_LEN], 14)
        configbbits, = struct.unpack_from(UINT32, raw[:EVENT_LEN], 18)
        armcrc, = struct.unpack_from(UINT16, raw[:EVENT_LEN], 24)

        return LidVersionInfo(
            raw = RawEvent.build(raw),
            version = version,
            configabits = configabits,
            configbbits = configbbits,
            armcrc = armcrc,
        )

    @property
    def eventTimestamp(self):
        return self.raw.timestamp

    @property
    def eventId(self):
        return self.raw.seqNum


@dataclass
class LidUpdateStatus(BaseEvent):
    """203: LID_UPDATE_STATUS"""
    ID = 203
    NAME = "LID_UPDATE_STATUS"

    raw: RawEvent
    swupdatestatus: int
    metadataandversionstatus: int
    fulldlandcrcstatus: int
    filedlandsideloadstatus: int
    externalflashstatus: int
    updatesuccessfulRaw: int
    swpartnum: int

    UpdatesuccessfulMap = {
        "0": "Update Not Successful",
        "1": "Update Successful"
    }

    class UpdatesuccessfulEnum(Enum):
        UpdateNotSuccessful = 0
        UpdateSuccessful = 1

    @property
    def updatesuccessful(self):
        try:
            return self.UpdatesuccessfulEnum(self.updatesuccessfulRaw)
        except ValueError as e:
            logger.error("Invalid updatesuccessfulRaw in Updatesuccessful for "+str(self))
            logger.error(e)
            return None

    @staticmethod
    def build(raw):
        swupdatestatus, = struct.unpack_from(UINT16, raw[:EVENT_LEN], 12)
        metadataandversionstatus, = struct.unpack_from(UINT16, raw[:EVENT_LEN], 10)
        fulldlandcrcstatus, = struct.unpack_from(UINT16, raw[:EVENT_LEN], 16)
        filedlandsideloadstatus, = struct.unpack_from(UINT16, raw[:EVENT_LEN], 14)
        externalflashstatus, = struct.unpack_from(UINT16, raw[:EVENT_LEN], 20)
        updatesuccessful, = struct.unpack_from(UINT8, raw[:EVENT_LEN], 19)
        swpartnum, = struct.unpack_from(UINT32, raw[:EVENT_LEN], 22)

        return LidUpdateStatus(
            raw = RawEvent.build(raw),
            swupdatestatus = swupdatestatus,
            metadataandversionstatus = metadataandversionstatus,
            fulldlandcrcstatus = fulldlandcrcstatus,
            filedlandsideloadstatus = filedlandsideloadstatus,
            externalflashstatus = externalflashstatus,
            updatesuccessfulRaw = updatesuccessful,
            swpartnum = swpartnum,
        )

    @property
    def eventTimestamp(self):
        return self.raw.timestamp

    @property
    def eventId(self):
        return self.raw.seqNum


@dataclass
class LidCgmStartSessionGx(BaseEvent):
    """212: LID_CGM_START_SESSION_GX"""
    ID = 212
    NAME = "LID_CGM_START_SESSION_GX"

    raw: RawEvent
    currenttransmittertime: int # sec
    sessionstarttime: int # sec
    sessionduration: int # days


    @staticmethod
    def build(raw):
        currenttransmittertime, = struct.unpack_from(UINT32, raw[:EVENT_LEN], 10)
        sessionstarttime, = struct.unpack_from(UINT32, raw[:EVENT_LEN], 14)
        sessionduration, = struct.unpack_from(UINT8, raw[:EVENT_LEN], 25)

        return LidCgmStartSessionGx(
            raw = RawEvent.build(raw),
            currenttransmittertime = currenttransmittertime,
            sessionstarttime = sessionstarttime,
            sessionduration = sessionduration,
        )

    @property
    def eventTimestamp(self):
        return self.raw.timestamp

    @property
    def eventId(self):
        return self.raw.seqNum


@dataclass
class LidCgmJoinSessionGx(BaseEvent):
    """213: LID_CGM_JOIN_SESSION_GX"""
    ID = 213
    NAME = "LID_CGM_JOIN_SESSION_GX"

    raw: RawEvent
    currenttransmittertime: int # sec
    sessionstarttime: int # sec
    sessionduration: int # days
    sessionjoinreasonRaw: int

    SessionjoinreasonMap = {
        "0": "DEXBLES_REASON_USER,",
        "1": "DEXBLES_REASON_UNKNOWN,",
        "2": "Reserved,",
        "3": "DEXBLES_REASON_TX_END_OF_LIFE,",
        "4": "DEXBLES_REASON_TRANSMITTER_ERROR,",
        "5": "DEXBLES_REASON_SESSION_STOP_SUCCESS,",
        "6": "DEXBLES_REASON_TRANSMITTER_NOT_IN_SESSION,",
        "7": "Reserved",
        "8": "DEXBLES_REASON_NEW_SESSION_STARTED_SUCCESS,",
        "9": "DEXBLES_REASON_SESSION_STARTED_IN_PROGRESS,",
        "10": "DEXBLES_REASON_TRANSMITTER_IN_SESSION,",
        "11": "DEXBLES_REASON_BLESTACK_INVALID,",
        "12": "DEXBLES_REASON_NEW_AUTOCAL_SESSION_STARTED_SUCCESS,",
        "13": "DEXBLES_REASON_NO_AUTOCAL_SESSION_IN_PROGRESS"
    }

    class SessionjoinreasonEnum(Enum):
        DexblesReasonUser = 0
        DexblesReasonUnknown = 1
        DexblesReasonTxEndOfLife = 3
        DexblesReasonTransmitterError = 4
        DexblesReasonSessionStopSuccess = 5
        DexblesReasonTransmitterNotInSession = 6
        DexblesReasonNewSessionStartedSuccess = 8
        DexblesReasonSessionStartedInProgress = 9
        DexblesReasonTransmitterInSession = 10
        DexblesReasonBlestackInvalid = 11
        DexblesReasonNewAutocalSessionStartedSuccess = 12
        DexblesReasonNoAutocalSessionInProgress = 13

    @property
    def sessionjoinreason(self):
        try:
            return self.SessionjoinreasonEnum(self.sessionjoinreasonRaw)
        except ValueError as e:
            logger.error("Invalid sessionjoinreasonRaw in Sessionjoinreason for "+str(self))
            logger.error(e)
            return None

    @staticmethod
    def build(raw):
        currenttransmittertime, = struct.unpack_from(UINT32, raw[:EVENT_LEN], 10)
        sessionstarttime, = struct.unpack_from(UINT32, raw[:EVENT_LEN], 14)
        sessionduration, = struct.unpack_from(UINT8, raw[:EVENT_LEN], 25)
        sessionjoinreason, = struct.unpack_from(UINT8, raw[:EVENT_LEN], 24)

        return LidCgmJoinSessionGx(
            raw = RawEvent.build(raw),
            currenttransmittertime = currenttransmittertime,
            sessionstarttime = sessionstarttime,
            sessionduration = sessionduration,
            sessionjoinreasonRaw = sessionjoinreason,
        )

    @property
    def eventTimestamp(self):
        return self.raw.timestamp

    @property
    def eventId(self):
        return self.raw.seqNum


@dataclass
class LidCgmStopSessionGx(BaseEvent):
    """214: LID_CGM_STOP_SESSION_GX"""
    ID = 214
    NAME = "LID_CGM_STOP_SESSION_GX"

    raw: RawEvent
    currenttransmittertime: int # sec
    sessionstarttime: int # sec
    sessionstoptime: int # sec
    sessionduration: int # days
    sessionstopreasonRaw: int

    SessionstopreasonMap = {
        "0": "DEXBLES_REASON_USER,",
        "1": "DEXBLES_REASON_UNKNOWN,",
        "2": "Reserved,",
        "3": "DEXBLES_REASON_TX_END_OF_LIFE,",
        "4": "DEXBLES_REASON_TRANSMITTER_ERROR,",
        "5": "DEXBLES_REASON_SESSION_STOP_SUCCESS,",
        "6": "DEXBLES_REASON_TRANSMITTER_NOT_IN_SESSION,",
        "7": "Reserved",
        "8": "DEXBLES_REASON_NEW_SESSION_STARTED_SUCCESS,",
        "9": "DEXBLES_REASON_SESSION_STARTED_IN_PROGRESS,",
        "10": "DEXBLES_REASON_TRANSMITTER_IN_SESSION,",
        "11": "DEXBLES_REASON_BLESTACK_INVALID,",
        "12": "DEXBLES_REASON_NEW_AUTOCAL_SESSION_STARTED_SUCCESS,",
        "13": "DEXBLES_REASON_NO_AUTOCAL_SESSION_IN_PROGRESS"
    }

    class SessionstopreasonEnum(Enum):
        DexblesReasonUser = 0
        DexblesReasonUnknown = 1
        DexblesReasonTxEndOfLife = 3
        DexblesReasonTransmitterError = 4
        DexblesReasonSessionStopSuccess = 5
        DexblesReasonTransmitterNotInSession = 6
        DexblesReasonNewSessionStartedSuccess = 8
        DexblesReasonSessionStartedInProgress = 9
        DexblesReasonTransmitterInSession = 10
        DexblesReasonBlestackInvalid = 11
        DexblesReasonNewAutocalSessionStartedSuccess = 12
        DexblesReasonNoAutocalSessionInProgress = 13

    @property
    def sessionstopreason(self):
        try:
            return self.SessionstopreasonEnum(self.sessionstopreasonRaw)
        except ValueError as e:
            logger.error("Invalid sessionstopreasonRaw in Sessionstopreason for "+str(self))
            logger.error(e)
            return None

    @staticmethod
    def build(raw):
        currenttransmittertime, = struct.unpack_from(UINT32, raw[:EVENT_LEN], 10)
        sessionstarttime, = struct.unpack_from(UINT32, raw[:EVENT_LEN], 14)
        sessionstoptime, = struct.unpack_from(UINT32, raw[:EVENT_LEN], 18)
        sessionduration, = struct.unpack_from(UINT8, raw[:EVENT_LEN], 25)
        sessionstopreason, = struct.unpack_from(UINT8, raw[:EVENT_LEN], 24)

        return LidCgmStopSessionGx(
            raw = RawEvent.build(raw),
            currenttransmittertime = currenttransmittertime,
            sessionstarttime = sessionstarttime,
            sessionstoptime = sessionstoptime,
            sessionduration = sessionduration,
            sessionstopreasonRaw = sessionstopreason,
        )

    @property
    def eventTimestamp(self):
        return self.raw.timestamp

    @property
    def eventId(self):
        return self.raw.seqNum


@dataclass
class LidAaUserModeChange(BaseEvent):
    """229: LID_AA_USER_MODE_CHANGE"""
    ID = 229
    NAME = "LID_AA_USER_MODE_CHANGE"

    raw: RawEvent
    exercisechoiceRaw: int
    exercisetime: int # minutes
    currentusermodeRaw: int
    previoususermodeRaw: int
    requestedactionRaw: int
    sleepstartedbyguiRaw: int
    exercisestoppedbytimerRaw: int
    activesleepscheduleRaw: int
    eatingsoonstoppedbytimerRaw: int

    ExercisechoiceMap = {
        "0": "Continuous",
        "1": "Timed"
    }

    class ExercisechoiceEnum(Enum):
        Continuous = 0
        Timed = 1

    @property
    def exercisechoice(self):
        try:
            return self.ExercisechoiceEnum(self.exercisechoiceRaw)
        except ValueError as e:
            logger.error("Invalid exercisechoiceRaw in Exercisechoice for "+str(self))
            logger.error(e)
            return None

    CurrentusermodeMap = {
        "0": "Normal",
        "1": "Sleeping",
        "2": "Exercising",
        "3": "Eating Soon"
    }

    class CurrentusermodeEnum(Enum):
        Normal = 0
        Sleeping = 1
        Exercising = 2
        EatingSoon = 3

    @property
    def currentusermode(self):
        try:
            return self.CurrentusermodeEnum(self.currentusermodeRaw)
        except ValueError as e:
            logger.error("Invalid currentusermodeRaw in Currentusermode for "+str(self))
            logger.error(e)
            return None

    PrevioususermodeMap = {
        "0": "Normal",
        "1": "Sleeping",
        "2": "Exercising",
        "3": "Eating Soon"
    }

    class PrevioususermodeEnum(Enum):
        Normal = 0
        Sleeping = 1
        Exercising = 2
        EatingSoon = 3

    @property
    def previoususermode(self):
        try:
            return self.PrevioususermodeEnum(self.previoususermodeRaw)
        except ValueError as e:
            logger.error("Invalid previoususermodeRaw in Previoususermode for "+str(self))
            logger.error(e)
            return None

    RequestedactionMap = {
        "0": "No User Request",
        "1": "Start Sleep",
        "2": "Stop Sleep",
        "3": "Start Exercise",
        "4": "Stop Exercise",
        "5": "Stop All",
        "6": "Start Eating Soon",
        "7": "Stop Eating Soon"
    }

    class RequestedactionEnum(Enum):
        NoUserRequest = 0
        StartSleep = 1
        StopSleep = 2
        StartExercise = 3
        StopExercise = 4
        StopAll = 5
        StartEatingSoon = 6
        StopEatingSoon = 7

    @property
    def requestedaction(self):
        try:
            return self.RequestedactionEnum(self.requestedactionRaw)
        except ValueError as e:
            logger.error("Invalid requestedactionRaw in Requestedaction for "+str(self))
            logger.error(e)
            return None

    SleepstartedbyguiMap = {
        "0": "FALSE",
        "1": "TRUE"
    }

    class SleepstartedbyguiEnum(Enum):
        FalseVal = 0
        TrueVal = 1

    @property
    def sleepstartedbygui(self):
        try:
            return self.SleepstartedbyguiEnum(self.sleepstartedbyguiRaw)
        except ValueError as e:
            logger.error("Invalid sleepstartedbyguiRaw in Sleepstartedbygui for "+str(self))
            logger.error(e)
            return None

    ExercisestoppedbytimerMap = {
        "0": "False",
        "1": "True"
    }

    class ExercisestoppedbytimerEnum(Enum):
        FalseVal = 0
        TrueVal = 1

    @property
    def exercisestoppedbytimer(self):
        try:
            return self.ExercisestoppedbytimerEnum(self.exercisestoppedbytimerRaw)
        except ValueError as e:
            logger.error("Invalid exercisestoppedbytimerRaw in Exercisestoppedbytimer for "+str(self))
            logger.error(e)
            return None

    ActivesleepscheduleMap = {
        "0": "Sleep Schedule 1 is Active",
        "1": "Sleep Schedule 2 is Active",
        "2": "Sleep Schedule 3 is Active",
        "3": "Sleep Schedule 4 is Active"
    }

    class ActivesleepscheduleBitmask(IntFlag):
        SleepSchedule1IsActive = 2**0
        SleepSchedule2IsActive = 2**1
        SleepSchedule3IsActive = 2**2
        SleepSchedule4IsActive = 2**3

    @property
    def activesleepschedule(self):
        try:
            return self.ActivesleepscheduleBitmask(self.activesleepscheduleRaw)
        except ValueError as e:
            logger.error("Invalid activesleepscheduleRaw in ActivesleepscheduleBitmask for "+str(self))
            logger.error(e)
            return None

    EatingsoonstoppedbytimerMap = {
        "0": "False",
        "1": "True"
    }

    class EatingsoonstoppedbytimerEnum(Enum):
        FalseVal = 0
        TrueVal = 1

    @property
    def eatingsoonstoppedbytimer(self):
        try:
            return self.EatingsoonstoppedbytimerEnum(self.eatingsoonstoppedbytimerRaw)
        except ValueError as e:
            logger.error("Invalid eatingsoonstoppedbytimerRaw in Eatingsoonstoppedbytimer for "+str(self))
            logger.error(e)
            return None

    @staticmethod
    def build(raw):
        exercisechoice, = struct.unpack_from(UINT8, raw[:EVENT_LEN], 20)
        exercisetime, = struct.unpack_from(UINT16, raw[:EVENT_LEN], 18)
        currentusermode, = struct.unpack_from(UINT8, raw[:EVENT_LEN], 13)
        previoususermode, = struct.unpack_from(UINT8, raw[:EVENT_LEN], 12)
        requestedaction, = struct.unpack_from(UINT8, raw[:EVENT_LEN], 11)
        sleepstartedbygui, = struct.unpack_from(UINT8, raw[:EVENT_LEN], 17)
        exercisestoppedbytimer, = struct.unpack_from(UINT8, raw[:EVENT_LEN], 21)
        activesleepschedule, = struct.unpack_from(UINT8, raw[:EVENT_LEN], 16)
        eatingsoonstoppedbytimer, = struct.unpack_from(UINT8, raw[:EVENT_LEN], 25)

        return LidAaUserModeChange(
            raw = RawEvent.build(raw),
            exercisechoiceRaw = exercisechoice,
            exercisetime = exercisetime,
            currentusermodeRaw = currentusermode,
            previoususermodeRaw = previoususermode,
            requestedactionRaw = requestedaction,
            sleepstartedbyguiRaw = sleepstartedbygui,
            exercisestoppedbytimerRaw = exercisestoppedbytimer,
            activesleepscheduleRaw = activesleepschedule,
            eatingsoonstoppedbytimerRaw = eatingsoonstoppedbytimer,
        )

    @property
    def eventTimestamp(self):
        return self.raw.timestamp

    @property
    def eventId(self):
        return self.raw.seqNum


@dataclass
class LidAaPcmChange(BaseEvent):
    """230: LID_AA_PCM_CHANGE"""
    ID = 230
    NAME = "LID_AA_PCM_CHANGE"

    raw: RawEvent
    currentpcmRaw: int
    previouspcmRaw: int
    pumpsuspendedRaw: int
    calculationavailableRaw: int
    cgmavailableRaw: int
    closedlooppreferredRaw: int
    sufficientclosedloopparamsRaw: int

    CurrentpcmMap = {
        "0": "No Control",
        "1": "Open Loop",
        "2": "Pining",
        "3": "Closed Loop"
    }

    class CurrentpcmEnum(Enum):
        NoControl = 0
        OpenLoop = 1
        Pining = 2
        ClosedLoop = 3

    @property
    def currentpcm(self):
        try:
            return self.CurrentpcmEnum(self.currentpcmRaw)
        except ValueError as e:
            logger.error("Invalid currentpcmRaw in Currentpcm for "+str(self))
            logger.error(e)
            return None

    PreviouspcmMap = {
        "0": "No Control",
        "1": "Open Loop",
        "2": "Pining",
        "3": "Closed Loop"
    }

    class PreviouspcmEnum(Enum):
        NoControl = 0
        OpenLoop = 1
        Pining = 2
        ClosedLoop = 3

    @property
    def previouspcm(self):
        try:
            return self.PreviouspcmEnum(self.previouspcmRaw)
        except ValueError as e:
            logger.error("Invalid previouspcmRaw in Previouspcm for "+str(self))
            logger.error(e)
            return None

    PumpsuspendedMap = {
        "0": "FALSE",
        "1": "TRUE"
    }

    class PumpsuspendedEnum(Enum):
        FalseVal = 0
        TrueVal = 1

    @property
    def pumpsuspended(self):
        try:
            return self.PumpsuspendedEnum(self.pumpsuspendedRaw)
        except ValueError as e:
            logger.error("Invalid pumpsuspendedRaw in Pumpsuspended for "+str(self))
            logger.error(e)
            return None

    CalculationavailableMap = {
        "0": "FALSE",
        "1": "TRUE"
    }

    class CalculationavailableEnum(Enum):
        FalseVal = 0
        TrueVal = 1

    @property
    def calculationavailable(self):
        try:
            return self.CalculationavailableEnum(self.calculationavailableRaw)
        except ValueError as e:
            logger.error("Invalid calculationavailableRaw in Calculationavailable for "+str(self))
            logger.error(e)
            return None

    CgmavailableMap = {
        "0": "FALSE",
        "1": "TRUE"
    }

    class CgmavailableEnum(Enum):
        FalseVal = 0
        TrueVal = 1

    @property
    def cgmavailable(self):
        try:
            return self.CgmavailableEnum(self.cgmavailableRaw)
        except ValueError as e:
            logger.error("Invalid cgmavailableRaw in Cgmavailable for "+str(self))
            logger.error(e)
            return None

    ClosedlooppreferredMap = {
        "0": "FALSE",
        "1": "TRUE"
    }

    class ClosedlooppreferredEnum(Enum):
        FalseVal = 0
        TrueVal = 1

    @property
    def closedlooppreferred(self):
        try:
            return self.ClosedlooppreferredEnum(self.closedlooppreferredRaw)
        except ValueError as e:
            logger.error("Invalid closedlooppreferredRaw in Closedlooppreferred for "+str(self))
            logger.error(e)
            return None

    SufficientclosedloopparamsMap = {
        "0": "FALSE",
        "1": "TRUE"
    }

    class SufficientclosedloopparamsEnum(Enum):
        FalseVal = 0
        TrueVal = 1

    @property
    def sufficientclosedloopparams(self):
        try:
            return self.SufficientclosedloopparamsEnum(self.sufficientclosedloopparamsRaw)
        except ValueError as e:
            logger.error("Invalid sufficientclosedloopparamsRaw in Sufficientclosedloopparams for "+str(self))
            logger.error(e)
            return None

    @staticmethod
    def build(raw):
        currentpcm, = struct.unpack_from(UINT8, raw[:EVENT_LEN], 13)
        previouspcm, = struct.unpack_from(UINT8, raw[:EVENT_LEN], 12)
        pumpsuspended, = struct.unpack_from(UINT8, raw[:EVENT_LEN], 11)
        calculationavailable, = struct.unpack_from(UINT8, raw[:EVENT_LEN], 10)
        cgmavailable, = struct.unpack_from(UINT8, raw[:EVENT_LEN], 17)
        closedlooppreferred, = struct.unpack_from(UINT8, raw[:EVENT_LEN], 16)
        sufficientclosedloopparams, = struct.unpack_from(UINT8, raw[:EVENT_LEN], 15)

        return LidAaPcmChange(
            raw = RawEvent.build(raw),
            currentpcmRaw = currentpcm,
            previouspcmRaw = previouspcm,
            pumpsuspendedRaw = pumpsuspended,
            calculationavailableRaw = calculationavailable,
            cgmavailableRaw = cgmavailable,
            closedlooppreferredRaw = closedlooppreferred,
            sufficientclosedloopparamsRaw = sufficientclosedloopparams,
        )

    @property
    def eventTimestamp(self):
        return self.raw.timestamp

    @property
    def eventId(self):
        return self.raw.seqNum


@dataclass
class LidCgmDataGxb(BaseEvent):
    """256: LID_CGM_DATA_GXB"""
    ID = 256
    NAME = "LID_CGM_DATA_GXB"

    raw: RawEvent
    glucosevaluestatusRaw: int
    cgmDataTypeRaw: int
    rateRaw: int # mg/dL/min
    algorithmstate: int
    RSSI: int # dBm
    currentglucosedisplayvalue: int # mg/dL
    egvTimestamp: int # sec
    egvInfoBitmaskRaw: int
    interval: int

    GlucosevaluestatusMap = {
        "0": "\"currentGlucoseDisplayValue\" contains the glucose reading",
        "1": "The glucose reading is \"high\", \"currentGlucoseDisplayValue\" set to 0",
        "2": "The glucose reading is \"low\", \"currentGlucoseDisplayValue\" set to 0"
    }

    class GlucosevaluestatusEnum(Enum):
        CurrentglucosedisplayvalueContainsTheGlucoseReading = 0
        TheGlucoseReadingIsHigh = 1
        TheGlucoseReadingIsLow = 2

    @property
    def glucosevaluestatus(self):
        try:
            return self.GlucosevaluestatusEnum(self.glucosevaluestatusRaw)
        except ValueError as e:
            logger.error("Invalid glucosevaluestatusRaw in Glucosevaluestatus for "+str(self))
            logger.error(e)
            return None

    CgmdatatypeMap = {
        "0": "Five Minute Reading (FMR)",
        "1": "BackFill",
        "2": "Immediate Match Value",
        "3": "Calibration",
        "4": "None"
    }

    class CgmdatatypeBitmask(IntFlag):
        FiveMinuteReadingFmr = 2**0
        Backfill = 2**1
        ImmediateMatchValue = 2**2
        Calibration = 2**3
        NoneVal = 2**4

    @property
    def cgmDataType(self):
        try:
            return self.CgmdatatypeBitmask(self.cgmDataTypeRaw)
        except ValueError as e:
            logger.error("Invalid cgmDataTypeRaw in CgmdatatypeBitmask for "+str(self))
            logger.error(e)
            return None

    @property
    def rate(self):
        return self.rateRaw * 0.1

    EgvinfobitmaskMap = {
        "0": "Five Minute Reading (FMR)",
        "1": "Backfill",
        "2": "Immediate match value",
        "3": "CRR (EGV is result of calibration, bit:14 was set to 1)",
        "4": "NO_EGV message",
        "5": "Valid timestamp",
        "6": "Valid EGV (valid range)",
        "7": "Valid algState (algState is 6, 7, or 14)",
        "8": "EGV was successfully added to CGM subsystem array (e.g.,"
    }

    class EgvinfobitmaskBitmask(IntFlag):
        FiveMinuteReadingFmr = 2**0
        Backfill = 2**1
        ImmediateMatchValue = 2**2
        CrrEgvIsResultOfCalibration = 2**3
        NoEgvMessage = 2**4
        ValidTimestamp = 2**5
        ValidEgvValidRange = 2**6
        ValidAlgstateAlgstateIs6 = 2**7
        EgvWasSuccessfullyAddedToCgmSubsystemArrayE = 2**8

    @property
    def egvInfoBitmask(self):
        try:
            return self.EgvinfobitmaskBitmask(self.egvInfoBitmaskRaw)
        except ValueError as e:
            logger.error("Invalid egvInfoBitmaskRaw in EgvinfobitmaskBitmask for "+str(self))
            logger.error(e)
            return None

    @staticmethod
    def build(raw):
        glucosevaluestatus, = struct.unpack_from(UINT16, raw[:EVENT_LEN], 12)
        cgmDataType, = struct.unpack_from(UINT8, raw[:EVENT_LEN], 11)
        rate, = struct.unpack_from(INT8, raw[:EVENT_LEN], 10)
        algorithmstate, = struct.unpack_from(UINT8, raw[:EVENT_LEN], 17)
        RSSI, = struct.unpack_from(INT8, raw[:EVENT_LEN], 16)
        currentglucosedisplayvalue, = struct.unpack_from(UINT16, raw[:EVENT_LEN], 14)
        egvTimestamp, = struct.unpack_from(UINT32, raw[:EVENT_LEN], 18)
        egvInfoBitmask, = struct.unpack_from(UINT16, raw[:EVENT_LEN], 24)
        interval, = struct.unpack_from(UINT8, raw[:EVENT_LEN], 23)

        return LidCgmDataGxb(
            raw = RawEvent.build(raw),
            glucosevaluestatusRaw = glucosevaluestatus,
            cgmDataTypeRaw = cgmDataType,
            rateRaw = rate,
            algorithmstate = algorithmstate,
            RSSI = RSSI,
            currentglucosedisplayvalue = currentglucosedisplayvalue,
            egvTimestamp = egvTimestamp,
            egvInfoBitmaskRaw = egvInfoBitmask,
            interval = interval,
        )

    @property
    def eventTimestamp(self):
        return self.raw.timestamp

    @property
    def eventId(self):
        return self.raw.seqNum


@dataclass
class LidBasalDelivery(BaseEvent):
    """279: LID_BASAL_DELIVERY"""
    ID = 279
    NAME = "LID_BASAL_DELIVERY"

    raw: RawEvent
    commandedRateSourceRaw: int
    commandedRate: int # milliunits/hr
    profileBasalRate: int # milliunits/hr
    algorithmRate: int # milliunits/hr
    tempRate: int # milliunits/hr

    CommandedratesourceMap = {
        "0": "Suspended",
        "1": "Profile",
        "2": "Temp Rate",
        "3": "Algorithm",
        "4": "Temp Rate and Algorithm"
    }

    class CommandedratesourceEnum(Enum):
        Suspended = 0
        Profile = 1
        TempRate = 2
        Algorithm = 3
        TempRateAndAlgorithm = 4

    @property
    def commandedRateSource(self):
        try:
            return self.CommandedratesourceEnum(self.commandedRateSourceRaw)
        except ValueError as e:
            logger.error("Invalid commandedRateSourceRaw in Commandedratesource for "+str(self))
            logger.error(e)
            return None

    @staticmethod
    def build(raw):
        commandedRateSource, = struct.unpack_from(UINT16, raw[:EVENT_LEN], 12)
        commandedRate, = struct.unpack_from(UINT16, raw[:EVENT_LEN], 16)
        profileBasalRate, = struct.unpack_from(UINT16, raw[:EVENT_LEN], 14)
        algorithmRate, = struct.unpack_from(UINT16, raw[:EVENT_LEN], 20)
        tempRate, = struct.unpack_from(UINT16, raw[:EVENT_LEN], 18)

        return LidBasalDelivery(
            raw = RawEvent.build(raw),
            commandedRateSourceRaw = commandedRateSource,
            commandedRate = commandedRate,
            profileBasalRate = profileBasalRate,
            algorithmRate = algorithmRate,
            tempRate = tempRate,
        )

    @property
    def eventTimestamp(self):
        return self.raw.timestamp

    @property
    def eventId(self):
        return self.raw.seqNum


@dataclass
class LidBolusDelivery(BaseEvent):
    """280: LID_BOLUS_DELIVERY"""
    ID = 280
    NAME = "LID_BOLUS_DELIVERY"

    raw: RawEvent
    bolusid: int
    bolusDeliveryStatusRaw: int
    bolusTypeRaw: int
    bolusSourceRaw: int
    remoteId: int
    requestedNow: int # milliunits
    requestedLater: int # milliunits
    extendedDurationRequested: int # minutes
    deliveredTotal: int # milliunits
    correction: int # milliunits

    BolusdeliverystatusMap = {
        "0": "Bolus Completed",
        "1": "Bolus Started"
    }

    class BolusdeliverystatusEnum(Enum):
        BolusCompleted = 0
        BolusStarted = 1

    @property
    def bolusDeliveryStatus(self):
        try:
            return self.BolusdeliverystatusEnum(self.bolusDeliveryStatusRaw)
        except ValueError as e:
            logger.error("Invalid bolusDeliveryStatusRaw in Bolusdeliverystatus for "+str(self))
            logger.error(e)
            return None

    BolustypeMap = {
        "0": "Now",
        "1": "Later",
        "2": "Override",
        "3": "Correction",
        "4": "Carb",
        "5": "Eating Soon Mode"
    }

    class BolustypeBitmask(IntFlag):
        Now = 2**0
        Later = 2**1
        Override = 2**2
        Correction = 2**3
        Carb = 2**4
        EatingSoonMode = 2**5

    @property
    def bolusType(self):
        try:
            return self.BolustypeBitmask(self.bolusTypeRaw)
        except ValueError as e:
            logger.error("Invalid bolusTypeRaw in BolustypeBitmask for "+str(self))
            logger.error(e)
            return None

    BolussourceMap = {
        "0": "Pump Button",
        "1": "Pump GUI",
        "2": "Reserved",
        "3": "Reserved",
        "4": "Reserved",
        "5": "Remote",
        "6": "Reserved",
        "7": "Algorithm",
        "8": "BLE",
        "9": "Eating Soon Bolus"
    }

    class BolussourceEnum(Enum):
        PumpButton = 0
        PumpGui = 1
        Remote = 5
        Algorithm = 7
        Ble = 8
        EatingSoonBolus = 9

    @property
    def bolusSource(self):
        try:
            return self.BolussourceEnum(self.bolusSourceRaw)
        except ValueError as e:
            logger.error("Invalid bolusSourceRaw in Bolussource for "+str(self))
            logger.error(e)
            return None

    @staticmethod
    def build(raw):
        bolusid, = struct.unpack_from(UINT16, raw[:EVENT_LEN], 12)
        bolusDeliveryStatus, = struct.unpack_from(UINT8, raw[:EVENT_LEN], 11)
        bolusType, = struct.unpack_from(UINT8, raw[:EVENT_LEN], 10)
        bolusSource, = struct.unpack_from(UINT8, raw[:EVENT_LEN], 17)
        remoteId, = struct.unpack_from(UINT8, raw[:EVENT_LEN], 16)
        requestedNow, = struct.unpack_from(UINT16, raw[:EVENT_LEN], 14)
        requestedLater, = struct.unpack_from(UINT16, raw[:EVENT_LEN], 20)
        extendedDurationRequested, = struct.unpack_from(UINT16, raw[:EVENT_LEN], 24)
        deliveredTotal, = struct.unpack_from(UINT16, raw[:EVENT_LEN], 22)
        correction, = struct.unpack_from(UINT16, raw[:EVENT_LEN], 18)

        return LidBolusDelivery(
            raw = RawEvent.build(raw),
            bolusid = bolusid,
            bolusDeliveryStatusRaw = bolusDeliveryStatus,
            bolusTypeRaw = bolusType,
            bolusSourceRaw = bolusSource,
            remoteId = remoteId,
            requestedNow = requestedNow,
            requestedLater = requestedLater,
            extendedDurationRequested = extendedDurationRequested,
            deliveredTotal = deliveredTotal,
            correction = correction,
        )

    @property
    def eventTimestamp(self):
        return self.raw.timestamp

    @property
    def eventId(self):
        return self.raw.seqNum


@dataclass
class LidVersionsA(BaseEvent):
    """307: LID_VERSIONS_A"""
    ID = 307
    NAME = "LID_VERSIONS_A"

    raw: RawEvent
    armpartnumber: int
    armswversion: int
    blepartnumber: int
    bleswversion: int


    @staticmethod
    def build(raw):
        armpartnumber, = struct.unpack_from(UINT32, raw[:EVENT_LEN], 10)
        armswversion, = struct.unpack_from(UINT32, raw[:EVENT_LEN], 14)
        blepartnumber, = struct.unpack_from(UINT32, raw[:EVENT_LEN], 18)
        bleswversion, = struct.unpack_from(UINT32, raw[:EVENT_LEN], 22)

        return LidVersionsA(
            raw = RawEvent.build(raw),
            armpartnumber = armpartnumber,
            armswversion = armswversion,
            blepartnumber = blepartnumber,
            bleswversion = bleswversion,
        )

    @property
    def eventTimestamp(self):
        return self.raw.timestamp

    @property
    def eventId(self):
        return self.raw.seqNum


@dataclass
class LidAaDailyStatus(BaseEvent):
    """313: LID_AA_DAILY_STATUS"""
    ID = 313
    NAME = "LID_AA_DAILY_STATUS"

    raw: RawEvent
    pumpcontrolstateRaw: int
    usermodeRaw: int
    sensortypeRaw: int

    PumpcontrolstateMap = {
        "0": "PCM No Control (No cartridge installed)",
        "1": "PCM Open Loop",
        "2": "PCM Pining",
        "3": "PCM Closed Loop"
    }

    class PumpcontrolstateEnum(Enum):
        PcmNoControlNoCartridgeInstalled = 0
        PcmOpenLoop = 1
        PcmPining = 2
        PcmClosedLoop = 3

    @property
    def pumpcontrolstate(self):
        try:
            return self.PumpcontrolstateEnum(self.pumpcontrolstateRaw)
        except ValueError as e:
            logger.error("Invalid pumpcontrolstateRaw in Pumpcontrolstate for "+str(self))
            logger.error(e)
            return None

    UsermodeMap = {
        "0": "Normal",
        "1": "Sleeping",
        "2": "Exercising"
    }

    class UsermodeEnum(Enum):
        Normal = 0
        Sleeping = 1
        Exercising = 2

    @property
    def usermode(self):
        try:
            return self.UsermodeEnum(self.usermodeRaw)
        except ValueError as e:
            logger.error("Invalid usermodeRaw in Usermode for "+str(self))
            logger.error(e)
            return None

    SensortypeMap = {
        "0": "CGM_TYPE_NONE",
        "1": "CGM_TYPE_DEXCOM_G6",
        "2": "CGM_TYPE_LIBRE2",
        "3": "CGM_TYPE_DEXCOM_G7"
    }

    class SensortypeEnum(Enum):
        CgmTypeNone = 0
        CgmTypeDexcomG6 = 1
        CgmTypeLibre2 = 2
        CgmTypeDexcomG7 = 3

    @property
    def sensortype(self):
        try:
            return self.SensortypeEnum(self.sensortypeRaw)
        except ValueError as e:
            logger.error("Invalid sensortypeRaw in Sensortype for "+str(self))
            logger.error(e)
            return None

    @staticmethod
    def build(raw):
        pumpcontrolstate, = struct.unpack_from(UINT8, raw[:EVENT_LEN], 13)
        usermode, = struct.unpack_from(UINT8, raw[:EVENT_LEN], 12)
        sensortype, = struct.unpack_from(UINT8, raw[:EVENT_LEN], 11)

        return LidAaDailyStatus(
            raw = RawEvent.build(raw),
            pumpcontrolstateRaw = pumpcontrolstate,
            usermodeRaw = usermode,
            sensortypeRaw = sensortype,
        )

    @property
    def eventTimestamp(self):
        return self.raw.timestamp

    @property
    def eventId(self):
        return self.raw.seqNum


@dataclass
class LidCgmAlertActivatedDex(BaseEvent):
    """369: LID_CGM_ALERT_ACTIVATED_DEX"""
    ID = 369
    NAME = "LID_CGM_ALERT_ACTIVATED_DEX"

    raw: RawEvent
    dalertidRaw: int
    sensortypeRaw: int
    faultlocatordata: int
    param1: int
    param2: float

    DalertidMap = {
        "11": "CGM Sensor Fail",
        "13": "CGM Sensor Expired",
        "14": "CGM Out Of Range",
        "20": "CGM Transmitter Error",
        "26": "CGM Temperature",
        "27": "CGM Failed Connection",
        "39": "CGM Transmitter Expired",
        "40": "Pump Bluetooth Error"
    }

    class DalertidEnum(Enum):
        CgmSensorFail = 11
        CgmSensorExpired = 13
        CgmOutOfRange = 14
        CgmTransmitterError = 20
        CgmTemperature = 26
        CgmFailedConnection = 27
        CgmTransmitterExpired = 39
        PumpBluetoothError = 40

    @property
    def dalertid(self):
        try:
            return self.DalertidEnum(self.dalertidRaw)
        except ValueError as e:
            logger.error("Invalid dalertidRaw in Dalertid for "+str(self))
            logger.error(e)
            return None

    SensortypeMap = {
        "0": "Invalid",
        "1": "CGM_TYPE_DEXCOM_G6",
        "3": "CGM_TYPE_DEXCOM_G7"
    }

    class SensortypeEnum(Enum):
        Invalid = 0
        CgmTypeDexcomG6 = 1
        CgmTypeDexcomG7 = 3

    @property
    def sensortype(self):
        try:
            return self.SensortypeEnum(self.sensortypeRaw)
        except ValueError as e:
            logger.error("Invalid sensortypeRaw in Sensortype for "+str(self))
            logger.error(e)
            return None

    @staticmethod
    def build(raw):
        dalertid, = struct.unpack_from(UINT8, raw[:EVENT_LEN], 13)
        sensortype, = struct.unpack_from(UINT8, raw[:EVENT_LEN], 12)
        faultlocatordata, = struct.unpack_from(UINT32, raw[:EVENT_LEN], 14)
        param1, = struct.unpack_from(UINT32, raw[:EVENT_LEN], 18)
        param2, = struct.unpack_from(FLOAT32, raw[:EVENT_LEN], 22)

        return LidCgmAlertActivatedDex(
            raw = RawEvent.build(raw),
            dalertidRaw = dalertid,
            sensortypeRaw = sensortype,
            faultlocatordata = faultlocatordata,
            param1 = param1,
            param2 = param2,
        )

    @property
    def eventTimestamp(self):
        return self.raw.timestamp

    @property
    def eventId(self):
        return self.raw.seqNum


@dataclass
class LidCgmAlertClearedDex(BaseEvent):
    """370: LID_CGM_ALERT_CLEARED_DEX"""
    ID = 370
    NAME = "LID_CGM_ALERT_CLEARED_DEX"

    raw: RawEvent
    dalertidRaw: int
    sensortypeRaw: int

    DalertidMap = {
        "11": "CGM Sensor Fail",
        "13": "CGM Sensor Expired",
        "14": "CGM Out Of Range",
        "20": "CGM Transmitter Error",
        "26": "CGM Temperature",
        "27": "CGM Failed Connection",
        "39": "CGM Transmitter Expired",
        "40": "Pump Bluetooth Error"
    }

    class DalertidEnum(Enum):
        CgmSensorFail = 11
        CgmSensorExpired = 13
        CgmOutOfRange = 14
        CgmTransmitterError = 20
        CgmTemperature = 26
        CgmFailedConnection = 27
        CgmTransmitterExpired = 39
        PumpBluetoothError = 40

    @property
    def dalertid(self):
        try:
            return self.DalertidEnum(self.dalertidRaw)
        except ValueError as e:
            logger.error("Invalid dalertidRaw in Dalertid for "+str(self))
            logger.error(e)
            return None

    SensortypeMap = {
        "0": "Invalid",
        "1": "CGM_TYPE_DEXCOM_G6",
        "3": "CGM_TYPE_DEXCOM_G7"
    }

    class SensortypeEnum(Enum):
        Invalid = 0
        CgmTypeDexcomG6 = 1
        CgmTypeDexcomG7 = 3

    @property
    def sensortype(self):
        try:
            return self.SensortypeEnum(self.sensortypeRaw)
        except ValueError as e:
            logger.error("Invalid sensortypeRaw in Sensortype for "+str(self))
            logger.error(e)
            return None

    @staticmethod
    def build(raw):
        dalertid, = struct.unpack_from(UINT8, raw[:EVENT_LEN], 13)
        sensortype, = struct.unpack_from(UINT8, raw[:EVENT_LEN], 12)

        return LidCgmAlertClearedDex(
            raw = RawEvent.build(raw),
            dalertidRaw = dalertid,
            sensortypeRaw = sensortype,
        )

    @property
    def eventTimestamp(self):
        return self.raw.timestamp

    @property
    def eventId(self):
        return self.raw.seqNum


@dataclass
class LidCgmAlertAckDex(BaseEvent):
    """371: LID_CGM_ALERT_ACK_DEX"""
    ID = 371
    NAME = "LID_CGM_ALERT_ACK_DEX"

    raw: RawEvent
    dalertidRaw: int
    sensortypeRaw: int
    acksourceRaw: int

    DalertidMap = {
        "11": "CGM Sensor Fail",
        "13": "CGM Sensor Expired",
        "14": "CGM Out Of Range",
        "20": "CGM Transmitter Error",
        "26": "CGM Temperature",
        "27": "CGM Failed Connection",
        "39": "CGM Transmitter Expired",
        "40": "Pump Bluetooth Error"
    }

    class DalertidEnum(Enum):
        CgmSensorFail = 11
        CgmSensorExpired = 13
        CgmOutOfRange = 14
        CgmTransmitterError = 20
        CgmTemperature = 26
        CgmFailedConnection = 27
        CgmTransmitterExpired = 39
        PumpBluetoothError = 40

    @property
    def dalertid(self):
        try:
            return self.DalertidEnum(self.dalertidRaw)
        except ValueError as e:
            logger.error("Invalid dalertidRaw in Dalertid for "+str(self))
            logger.error(e)
            return None

    SensortypeMap = {
        "0": "Invalid",
        "1": "CGM_TYPE_DEXCOM_G6",
        "3": "CGM_TYPE_DEXCOM_G7"
    }

    class SensortypeEnum(Enum):
        Invalid = 0
        CgmTypeDexcomG6 = 1
        CgmTypeDexcomG7 = 3

    @property
    def sensortype(self):
        try:
            return self.SensortypeEnum(self.sensortypeRaw)
        except ValueError as e:
            logger.error("Invalid sensortypeRaw in Sensortype for "+str(self))
            logger.error(e)
            return None

    AcksourceMap = {
        "0": "Alert Acknowledged by User",
        "1": "Alert Acknowledged by Software"
    }

    class AcksourceEnum(Enum):
        AlertAcknowledgedByUser = 0
        AlertAcknowledgedBySoftware = 1

    @property
    def acksource(self):
        try:
            return self.AcksourceEnum(self.acksourceRaw)
        except ValueError as e:
            logger.error("Invalid acksourceRaw in Acksource for "+str(self))
            logger.error(e)
            return None

    @staticmethod
    def build(raw):
        dalertid, = struct.unpack_from(UINT8, raw[:EVENT_LEN], 13)
        sensortype, = struct.unpack_from(UINT8, raw[:EVENT_LEN], 12)
        acksource, = struct.unpack_from(UINT32, raw[:EVENT_LEN], 14)

        return LidCgmAlertAckDex(
            raw = RawEvent.build(raw),
            dalertidRaw = dalertid,
            sensortypeRaw = sensortype,
            acksourceRaw = acksource,
        )

    @property
    def eventTimestamp(self):
        return self.raw.timestamp

    @property
    def eventId(self):
        return self.raw.seqNum


@dataclass
class LidCgmDataFsl2(BaseEvent):
    """372: LID_CGM_DATA_FSL2"""
    ID = 372
    NAME = "LID_CGM_DATA_FSL2"

    raw: RawEvent
    glucosevaluestatusRaw: int
    cgmDataTypeRaw: int
    rateRaw: int # mg/dL/min
    algorithmstateRaw: int
    RSSI: int # dBm
    currentglucosedisplayvalue: int # mg/dL
    egvTimestamp: int # Seconds
    egvInfoBitmaskRaw: int
    interval: int

    GlucosevaluestatusMap = {
        "0": "Precise Value",
        "1": "Special High",
        "2": "Special Low"
    }

    class GlucosevaluestatusEnum(Enum):
        PreciseValue = 0
        SpecialHigh = 1
        SpecialLow = 2

    @property
    def glucosevaluestatus(self):
        try:
            return self.GlucosevaluestatusEnum(self.glucosevaluestatusRaw)
        except ValueError as e:
            logger.error("Invalid glucosevaluestatusRaw in Glucosevaluestatus for "+str(self))
            logger.error(e)
            return None

    CgmdatatypeMap = {
        "0": "Five Minute Reading (FMR)",
        "1": "Backfill",
        "4": "None",
        "5": "One Minute Reading (OMR)",
        "6": "Real Time Reading"
    }

    class CgmdatatypeBitmask(IntFlag):
        FiveMinuteReadingFmr = 2**0
        Backfill = 2**1
        NoneVal = 2**4
        OneMinuteReadingOmr = 2**5
        RealTimeReading = 2**6

    @property
    def cgmDataType(self):
        try:
            return self.CgmdatatypeBitmask(self.cgmDataTypeRaw)
        except ValueError as e:
            logger.error("Invalid cgmDataTypeRaw in CgmdatatypeBitmask for "+str(self))
            logger.error(e)
            return None

    @property
    def rate(self):
        return self.rateRaw * 0.1

    AlgorithmstateMap = {
        "2": "Warmup",
        "100": "OK State",
        "101": "RF Error State",
        "102": "Sensor Signal Low State",
        "103": "Temp High State",
        "104": "Temp Low State",
        "105": "Invalid Data State",
        "106": "Other State"
    }

    class AlgorithmstateEnum(Enum):
        Warmup = 2
        OkState = 100
        RfErrorState = 101
        SensorSignalLowState = 102
        TempHighState = 103
        TempLowState = 104
        InvalidDataState = 105
        OtherState = 106

    @property
    def algorithmstate(self):
        try:
            return self.AlgorithmstateEnum(self.algorithmstateRaw)
        except ValueError as e:
            logger.error("Invalid algorithmstateRaw in Algorithmstate for "+str(self))
            logger.error(e)
            return None

    EgvinfobitmaskMap = {
        "0": "Five Minute Reading (FMR)",
        "1": "Backfill",
        "2": "Immediate match value",
        "3": "CRR (EGV is result of calibration, bit:14 was set to 1)",
        "4": "NO_EGV message",
        "5": "Valid timestamp",
        "6": "Valid EGV (valid range)",
        "7": "Valid algState (algState is 100)",
        "8": "EGV was successfully added to CGM subsystem array (e.g., not a duplicate)",
        "9": "OMR reading type",
        "10": "Real Time Reading from NFC scan"
    }

    class EgvinfobitmaskBitmask(IntFlag):
        FiveMinuteReadingFmr = 2**0
        Backfill = 2**1
        ImmediateMatchValue = 2**2
        CrrEgvIsResultOfCalibration = 2**3
        NoEgvMessage = 2**4
        ValidTimestamp = 2**5
        ValidEgvValidRange = 2**6
        ValidAlgstateAlgstateIs100 = 2**7
        EgvWasSuccessfullyAddedToCgmSubsystemArrayE = 2**8
        OmrReadingType = 2**9
        RealTimeReadingFromNfcScan = 2**10

    @property
    def egvInfoBitmask(self):
        try:
            return self.EgvinfobitmaskBitmask(self.egvInfoBitmaskRaw)
        except ValueError as e:
            logger.error("Invalid egvInfoBitmaskRaw in EgvinfobitmaskBitmask for "+str(self))
            logger.error(e)
            return None

    @staticmethod
    def build(raw):
        glucosevaluestatus, = struct.unpack_from(UINT8, raw[:EVENT_LEN], 13)
        cgmDataType, = struct.unpack_from(UINT8, raw[:EVENT_LEN], 12)
        rate, = struct.unpack_from(INT16, raw[:EVENT_LEN], 10)
        algorithmstate, = struct.unpack_from(UINT8, raw[:EVENT_LEN], 17)
        RSSI, = struct.unpack_from(INT8, raw[:EVENT_LEN], 16)
        currentglucosedisplayvalue, = struct.unpack_from(UINT16, raw[:EVENT_LEN], 14)
        egvTimestamp, = struct.unpack_from(UINT32, raw[:EVENT_LEN], 18)
        egvInfoBitmask, = struct.unpack_from(UINT16, raw[:EVENT_LEN], 24)
        interval, = struct.unpack_from(UINT8, raw[:EVENT_LEN], 23)

        return LidCgmDataFsl2(
            raw = RawEvent.build(raw),
            glucosevaluestatusRaw = glucosevaluestatus,
            cgmDataTypeRaw = cgmDataType,
            rateRaw = rate,
            algorithmstateRaw = algorithmstate,
            RSSI = RSSI,
            currentglucosedisplayvalue = currentglucosedisplayvalue,
            egvTimestamp = egvTimestamp,
            egvInfoBitmaskRaw = egvInfoBitmask,
            interval = interval,
        )

    @property
    def eventTimestamp(self):
        return self.raw.timestamp

    @property
    def eventId(self):
        return self.raw.seqNum


@dataclass
class LidCgmJoinSessionG7(BaseEvent):
    """394: LID_CGM_JOIN_SESSION_G7"""
    ID = 394
    NAME = "LID_CGM_JOIN_SESSION_G7"

    raw: RawEvent
    cgmtimestamp: int # Seconds
    sessionsignature: int # Seconds


    @staticmethod
    def build(raw):
        cgmtimestamp, = struct.unpack_from(UINT32, raw[:EVENT_LEN], 10)
        sessionsignature, = struct.unpack_from(UINT32, raw[:EVENT_LEN], 14)

        return LidCgmJoinSessionG7(
            raw = RawEvent.build(raw),
            cgmtimestamp = cgmtimestamp,
            sessionsignature = sessionsignature,
        )

    @property
    def eventTimestamp(self):
        return self.raw.timestamp

    @property
    def eventId(self):
        return self.raw.seqNum


@dataclass
class LidCgmDataG7(BaseEvent):
    """399: LID_CGM_DATA_G7"""
    ID = 399
    NAME = "LID_CGM_DATA_G7"

    raw: RawEvent
    glucosevaluestatusRaw: int
    cgmDataTypeRaw: int
    rateRaw: int # mg/dL/min/10
    algorithmstateRaw: int
    RSSI: int # dBm
    currentglucosedisplayvalue: int # mg/dL
    egvTimestamp: int # sec
    egvInfoBitmaskRaw: int
    interval: int

    GlucosevaluestatusMap = {
        "0": "Precise Value",
        "1": "Special High",
        "2": "Special Low",
        "6": "Do Not Show"
    }

    class GlucosevaluestatusEnum(Enum):
        PreciseValue = 0
        SpecialHigh = 1
        SpecialLow = 2
        DoNotShow = 6

    @property
    def glucosevaluestatus(self):
        try:
            return self.GlucosevaluestatusEnum(self.glucosevaluestatusRaw)
        except ValueError as e:
            logger.error("Invalid glucosevaluestatusRaw in Glucosevaluestatus for "+str(self))
            logger.error(e)
            return None

    CgmdatatypeMap = {
        "0": "FMR",
        "1": "Backfill",
        "2": "IMM No longer applies",
        "3": "Calibration",
        "4": "None"
    }

    class CgmdatatypeBitmask(IntFlag):
        Fmr = 2**0
        Backfill = 2**1
        ImmNoLongerApplies = 2**2
        Calibration = 2**3
        NoneVal = 2**4

    @property
    def cgmDataType(self):
        try:
            return self.CgmdatatypeBitmask(self.cgmDataTypeRaw)
        except ValueError as e:
            logger.error("Invalid cgmDataTypeRaw in CgmdatatypeBitmask for "+str(self))
            logger.error(e)
            return None

    @property
    def rate(self):
        return self.rateRaw * 0.1

    AlgorithmstateMap = {
        "2": "Warmup",
        "30": "Default Electronics Wakeup",
        "31": "Detecting Deployment",
        "32": "Reportable Period Valid EGV",
        "33": "Reportable Period Invalid EGV",
        "34": "Session Stopped (End of Session)",
        "35": "Session Stopped (Algorithm Detected Failure)",
        "36": "Session Stopped (Manual Stop)",
        "37": "Session Stopped (Transmitter Failure)",
        "38": "Session Stopped (SIV Failure)",
        "39": "Session Stopped (Out of Range / Environmental Conditions Detected)"
    }

    class AlgorithmstateEnum(Enum):
        Warmup = 2
        DefaultElectronicsWakeup = 30
        DetectingDeployment = 31
        ReportablePeriodValidEgv = 32
        ReportablePeriodInvalidEgv = 33
        SessionStoppedEndOfSession = 34
        SessionStoppedAlgorithmDetectedFailure = 35
        SessionStoppedManualStop = 36
        SessionStoppedTransmitterFailure = 37
        SessionStoppedSivFailure = 38
        SessionStoppedOutOfRangeEnvironmentalConditionsDetected = 39

    @property
    def algorithmstate(self):
        try:
            return self.AlgorithmstateEnum(self.algorithmstateRaw)
        except ValueError as e:
            logger.error("Invalid algorithmstateRaw in Algorithmstate for "+str(self))
            logger.error(e)
            return None

    EgvinfobitmaskMap = {
        "0": "Five Minute Reading (FMR)",
        "1": "Backfill",
        "2": "Immediate match value",
        "3": "CRR (EGV is result of calibration, bit:14 was set to 1)",
        "4": "NO_EGV message",
        "5": "Valid timestamp",
        "6": "Valid EGV (valid range)",
        "7": "Valid algState (algState is 32)",
        "8": "EGV was successfully added to CGM subsystem array (e.g.,",
        "9": "Reserved",
        "10": "Reserved"
    }

    class EgvinfobitmaskBitmask(IntFlag):
        FiveMinuteReadingFmr = 2**0
        Backfill = 2**1
        ImmediateMatchValue = 2**2
        CrrEgvIsResultOfCalibration = 2**3
        NoEgvMessage = 2**4
        ValidTimestamp = 2**5
        ValidEgvValidRange = 2**6
        ValidAlgstateAlgstateIs32 = 2**7
        EgvWasSuccessfullyAddedToCgmSubsystemArrayE = 2**8

    @property
    def egvInfoBitmask(self):
        try:
            return self.EgvinfobitmaskBitmask(self.egvInfoBitmaskRaw)
        except ValueError as e:
            logger.error("Invalid egvInfoBitmaskRaw in EgvinfobitmaskBitmask for "+str(self))
            logger.error(e)
            return None

    @staticmethod
    def build(raw):
        glucosevaluestatus, = struct.unpack_from(UINT16, raw[:EVENT_LEN], 12)
        cgmDataType, = struct.unpack_from(UINT8, raw[:EVENT_LEN], 11)
        rate, = struct.unpack_from(INT8, raw[:EVENT_LEN], 10)
        algorithmstate, = struct.unpack_from(UINT8, raw[:EVENT_LEN], 17)
        RSSI, = struct.unpack_from(INT8, raw[:EVENT_LEN], 16)
        currentglucosedisplayvalue, = struct.unpack_from(UINT16, raw[:EVENT_LEN], 14)
        egvTimestamp, = struct.unpack_from(UINT32, raw[:EVENT_LEN], 18)
        egvInfoBitmask, = struct.unpack_from(UINT16, raw[:EVENT_LEN], 24)
        interval, = struct.unpack_from(UINT8, raw[:EVENT_LEN], 23)

        return LidCgmDataG7(
            raw = RawEvent.build(raw),
            glucosevaluestatusRaw = glucosevaluestatus,
            cgmDataTypeRaw = cgmDataType,
            rateRaw = rate,
            algorithmstateRaw = algorithmstate,
            RSSI = RSSI,
            currentglucosedisplayvalue = currentglucosedisplayvalue,
            egvTimestamp = egvTimestamp,
            egvInfoBitmaskRaw = egvInfoBitmask,
            interval = interval,
        )

    @property
    def eventTimestamp(self):
        return self.raw.timestamp

    @property
    def eventId(self):
        return self.raw.seqNum


@dataclass
class LidCgmStartSessionFsl2(BaseEvent):
    """404: LID_CGM_START_SESSION_FSL2"""
    ID = 404
    NAME = "LID_CGM_START_SESSION_FSL2"

    raw: RawEvent
    sessionstarttime: int # sec
    sessionduration: int # days


    @staticmethod
    def build(raw):
        sessionstarttime, = struct.unpack_from(UINT32, raw[:EVENT_LEN], 10)
        sessionduration, = struct.unpack_from(UINT8, raw[:EVENT_LEN], 17)

        return LidCgmStartSessionFsl2(
            raw = RawEvent.build(raw),
            sessionstarttime = sessionstarttime,
            sessionduration = sessionduration,
        )

    @property
    def eventTimestamp(self):
        return self.raw.timestamp

    @property
    def eventId(self):
        return self.raw.seqNum


@dataclass
class LidCgmStopSessionFsl2(BaseEvent):
    """405: LID_CGM_STOP_SESSION_FSL2"""
    ID = 405
    NAME = "LID_CGM_STOP_SESSION_FSL2"

    raw: RawEvent
    sessionstarttime: int # sec
    sessionstoptime: int # sec
    sessionduration: int # days
    sessionstopreason: int


    @staticmethod
    def build(raw):
        sessionstarttime, = struct.unpack_from(UINT32, raw[:EVENT_LEN], 10)
        sessionstoptime, = struct.unpack_from(UINT32, raw[:EVENT_LEN], 14)
        sessionduration, = struct.unpack_from(UINT8, raw[:EVENT_LEN], 21)
        sessionstopreason, = struct.unpack_from(UINT8, raw[:EVENT_LEN], 20)

        return LidCgmStopSessionFsl2(
            raw = RawEvent.build(raw),
            sessionstarttime = sessionstarttime,
            sessionstoptime = sessionstoptime,
            sessionduration = sessionduration,
            sessionstopreason = sessionstopreason,
        )

    @property
    def eventTimestamp(self):
        return self.raw.timestamp

    @property
    def eventId(self):
        return self.raw.seqNum


@dataclass
class LidCgmJoinSessionFsl2(BaseEvent):
    """406: LID_CGM_JOIN_SESSION_FSL2"""
    ID = 406
    NAME = "LID_CGM_JOIN_SESSION_FSL2"

    raw: RawEvent
    sessionstarttime: int # sec
    sessionjointime: int # sec
    sessionduration: int # days
    sessionjoinreason: int


    @staticmethod
    def build(raw):
        sessionstarttime, = struct.unpack_from(UINT32, raw[:EVENT_LEN], 10)
        sessionjointime, = struct.unpack_from(UINT32, raw[:EVENT_LEN], 14)
        sessionduration, = struct.unpack_from(UINT8, raw[:EVENT_LEN], 21)
        sessionjoinreason, = struct.unpack_from(UINT8, raw[:EVENT_LEN], 20)

        return LidCgmJoinSessionFsl2(
            raw = RawEvent.build(raw),
            sessionstarttime = sessionstarttime,
            sessionjointime = sessionjointime,
            sessionduration = sessionduration,
            sessionjoinreason = sessionjoinreason,
        )

    @property
    def eventTimestamp(self):
        return self.raw.timestamp

    @property
    def eventId(self):
        return self.raw.seqNum


@dataclass
class LidCgmStopSessionG7(BaseEvent):
    """447: LID_CGM_STOP_SESSION_G7"""
    ID = 447
    NAME = "LID_CGM_STOP_SESSION_G7"

    raw: RawEvent
    currenttransmittertime: int # sec
    sessionstarttime: int # sec
    sessionstoptime: int # sec
    sessionduration: int # days
    sessionstopreason: int
    stopsessioncode: int


    @staticmethod
    def build(raw):
        currenttransmittertime, = struct.unpack_from(UINT32, raw[:EVENT_LEN], 10)
        sessionstarttime, = struct.unpack_from(UINT32, raw[:EVENT_LEN], 14)
        sessionstoptime, = struct.unpack_from(UINT32, raw[:EVENT_LEN], 18)
        sessionduration, = struct.unpack_from(UINT8, raw[:EVENT_LEN], 25)
        sessionstopreason, = struct.unpack_from(UINT8, raw[:EVENT_LEN], 24)
        stopsessioncode, = struct.unpack_from(UINT8, raw[:EVENT_LEN], 23)

        return LidCgmStopSessionG7(
            raw = RawEvent.build(raw),
            currenttransmittertime = currenttransmittertime,
            sessionstarttime = sessionstarttime,
            sessionstoptime = sessionstoptime,
            sessionduration = sessionduration,
            sessionstopreason = sessionstopreason,
            stopsessioncode = stopsessioncode,
        )

    @property
    def eventTimestamp(self):
        return self.raw.timestamp

    @property
    def eventId(self):
        return self.raw.seqNum


@dataclass
class LidCgmAlertActivatedFsl2(BaseEvent):
    """460: LID_CGM_ALERT_ACTIVATED_FSL2"""
    ID = 460
    NAME = "LID_CGM_ALERT_ACTIVATED_FSL2"

    raw: RawEvent
    dalertidRaw: int
    sensortypeRaw: int
    faultlocatordata: int
    param1: int
    param2: float

    DalertidMap = {
        "11": "CGM Sensor Fail",
        "13": "CGM Sensor Expired",
        "14": "CGM Out Of Range",
        "20": "CGM Transmitter Error",
        "26": "CGM Temperature",
        "27": "CGM Failed Connection",
        "39": "CGM Transmitter Expired",
        "40": "Pump Bluetooth Error"
    }

    class DalertidEnum(Enum):
        CgmSensorFail = 11
        CgmSensorExpired = 13
        CgmOutOfRange = 14
        CgmTransmitterError = 20
        CgmTemperature = 26
        CgmFailedConnection = 27
        CgmTransmitterExpired = 39
        PumpBluetoothError = 40

    @property
    def dalertid(self):
        try:
            return self.DalertidEnum(self.dalertidRaw)
        except ValueError as e:
            logger.error("Invalid dalertidRaw in Dalertid for "+str(self))
            logger.error(e)
            return None

    SensortypeMap = {
        "0": "Invalid",
        "2": "CGM_TYPE_LIBRE2"
    }

    class SensortypeEnum(Enum):
        Invalid = 0
        CgmTypeLibre2 = 2

    @property
    def sensortype(self):
        try:
            return self.SensortypeEnum(self.sensortypeRaw)
        except ValueError as e:
            logger.error("Invalid sensortypeRaw in Sensortype for "+str(self))
            logger.error(e)
            return None

    @staticmethod
    def build(raw):
        dalertid, = struct.unpack_from(UINT8, raw[:EVENT_LEN], 13)
        sensortype, = struct.unpack_from(UINT8, raw[:EVENT_LEN], 12)
        faultlocatordata, = struct.unpack_from(UINT32, raw[:EVENT_LEN], 14)
        param1, = struct.unpack_from(UINT32, raw[:EVENT_LEN], 18)
        param2, = struct.unpack_from(FLOAT32, raw[:EVENT_LEN], 22)

        return LidCgmAlertActivatedFsl2(
            raw = RawEvent.build(raw),
            dalertidRaw = dalertid,
            sensortypeRaw = sensortype,
            faultlocatordata = faultlocatordata,
            param1 = param1,
            param2 = param2,
        )

    @property
    def eventTimestamp(self):
        return self.raw.timestamp

    @property
    def eventId(self):
        return self.raw.seqNum


@dataclass
class LidCgmAlertClearedFsl2(BaseEvent):
    """461: LID_CGM_ALERT_CLEARED_FSL2"""
    ID = 461
    NAME = "LID_CGM_ALERT_CLEARED_FSL2"

    raw: RawEvent
    dalertidRaw: int
    sensortypeRaw: int

    DalertidMap = {
        "11": "CGM Sensor Fail",
        "13": "CGM Sensor Expired",
        "14": "CGM Out Of Range",
        "20": "CGM Transmitter Error",
        "26": "CGM Temperature",
        "27": "CGM Failed Connection",
        "39": "CGM Transmitter Expired",
        "40": "Pump Bluetooth Error"
    }

    class DalertidEnum(Enum):
        CgmSensorFail = 11
        CgmSensorExpired = 13
        CgmOutOfRange = 14
        CgmTransmitterError = 20
        CgmTemperature = 26
        CgmFailedConnection = 27
        CgmTransmitterExpired = 39
        PumpBluetoothError = 40

    @property
    def dalertid(self):
        try:
            return self.DalertidEnum(self.dalertidRaw)
        except ValueError as e:
            logger.error("Invalid dalertidRaw in Dalertid for "+str(self))
            logger.error(e)
            return None

    SensortypeMap = {
        "0": "Invalid",
        "2": "CGM_TYPE_LIBRE2"
    }

    class SensortypeEnum(Enum):
        Invalid = 0
        CgmTypeLibre2 = 2

    @property
    def sensortype(self):
        try:
            return self.SensortypeEnum(self.sensortypeRaw)
        except ValueError as e:
            logger.error("Invalid sensortypeRaw in Sensortype for "+str(self))
            logger.error(e)
            return None

    @staticmethod
    def build(raw):
        dalertid, = struct.unpack_from(UINT8, raw[:EVENT_LEN], 13)
        sensortype, = struct.unpack_from(UINT8, raw[:EVENT_LEN], 12)

        return LidCgmAlertClearedFsl2(
            raw = RawEvent.build(raw),
            dalertidRaw = dalertid,
            sensortypeRaw = sensortype,
        )

    @property
    def eventTimestamp(self):
        return self.raw.timestamp

    @property
    def eventId(self):
        return self.raw.seqNum

EVENT_IDS = {
    3: LidBasalRateChange,
    4: LidAlertActivated,
    5: LidAlarmActivated,
    6: LidMalfunctionActivated,
    11: LidPumpingSuspended,
    12: LidPumpingResumed,
    13: LidTimeChanged,
    14: LidDateChanged,
    16: LidBgReadingTaken,
    20: LidBolusCompleted,
    21: LidBolexCompleted,
    26: LidAlertCleared,
    28: LidAlarmCleared,
    33: LidCartridgeFilled,
    53: LidShelfMode,
    55: LidBolusActivated,
    59: LidBolexActivated,
    60: LidDataLogCorruption,
    61: LidCannulaFilled,
    63: LidTubingFilled,
    64: LidBolusRequestedMsg1,
    65: LidBolusRequestedMsg2,
    66: LidBolusRequestedMsg3,
    90: LidNewDay,
    99: LidArmInit,
    140: LidPlgsPeriodic,
    171: LidCgmAlertActivated,
    172: LidCgmAlertCleared,
    191: LidVersionInfo,
    203: LidUpdateStatus,
    212: LidCgmStartSessionGx,
    213: LidCgmJoinSessionGx,
    214: LidCgmStopSessionGx,
    229: LidAaUserModeChange,
    230: LidAaPcmChange,
    256: LidCgmDataGxb,
    279: LidBasalDelivery,
    280: LidBolusDelivery,
    307: LidVersionsA,
    313: LidAaDailyStatus,
    369: LidCgmAlertActivatedDex,
    370: LidCgmAlertClearedDex,
    371: LidCgmAlertAckDex,
    372: LidCgmDataFsl2,
    394: LidCgmJoinSessionG7,
    399: LidCgmDataG7,
    404: LidCgmStartSessionFsl2,
    405: LidCgmStopSessionFsl2,
    406: LidCgmJoinSessionFsl2,
    447: LidCgmStopSessionG7,
    460: LidCgmAlertActivatedFsl2,
    461: LidCgmAlertClearedFsl2,
}

EVENT_NAMES = {
    "LID_BASAL_RATE_CHANGE": LidBasalRateChange,
    "LID_ALERT_ACTIVATED": LidAlertActivated,
    "LID_ALARM_ACTIVATED": LidAlarmActivated,
    "LID_MALFUNCTION_ACTIVATED": LidMalfunctionActivated,
    "LID_PUMPING_SUSPENDED": LidPumpingSuspended,
    "LID_PUMPING_RESUMED": LidPumpingResumed,
    "LID_TIME_CHANGED": LidTimeChanged,
    "LID_DATE_CHANGED": LidDateChanged,
    "LID_BG_READING_TAKEN": LidBgReadingTaken,
    "LID_BOLUS_COMPLETED": LidBolusCompleted,
    "LID_BOLEX_COMPLETED": LidBolexCompleted,
    "LID_ALERT_CLEARED": LidAlertCleared,
    "LID_ALARM_CLEARED": LidAlarmCleared,
    "LID_CARTRIDGE_FILLED": LidCartridgeFilled,
    "LID_SHELF_MODE": LidShelfMode,
    "LID_BOLUS_ACTIVATED": LidBolusActivated,
    "LID_BOLEX_ACTIVATED": LidBolexActivated,
    "LID_DATA_LOG_CORRUPTION": LidDataLogCorruption,
    "LID_CANNULA_FILLED": LidCannulaFilled,
    "LID_TUBING_FILLED": LidTubingFilled,
    "LID_BOLUS_REQUESTED_MSG1": LidBolusRequestedMsg1,
    "LID_BOLUS_REQUESTED_MSG2": LidBolusRequestedMsg2,
    "LID_BOLUS_REQUESTED_MSG3": LidBolusRequestedMsg3,
    "LID_NEW_DAY": LidNewDay,
    "LID_ARM_INIT": LidArmInit,
    "LID_PLGS_PERIODIC": LidPlgsPeriodic,
    "LID_CGM_ALERT_ACTIVATED": LidCgmAlertActivated,
    "LID_CGM_ALERT_CLEARED": LidCgmAlertCleared,
    "LID_VERSION_INFO": LidVersionInfo,
    "LID_UPDATE_STATUS": LidUpdateStatus,
    "LID_CGM_START_SESSION_GX": LidCgmStartSessionGx,
    "LID_CGM_JOIN_SESSION_GX": LidCgmJoinSessionGx,
    "LID_CGM_STOP_SESSION_GX": LidCgmStopSessionGx,
    "LID_AA_USER_MODE_CHANGE": LidAaUserModeChange,
    "LID_AA_PCM_CHANGE": LidAaPcmChange,
    "LID_CGM_DATA_GXB": LidCgmDataGxb,
    "LID_BASAL_DELIVERY": LidBasalDelivery,
    "LID_BOLUS_DELIVERY": LidBolusDelivery,
    "LID_VERSIONS_A": LidVersionsA,
    "LID_AA_DAILY_STATUS": LidAaDailyStatus,
    "LID_CGM_ALERT_ACTIVATED_DEX": LidCgmAlertActivatedDex,
    "LID_CGM_ALERT_CLEARED_DEX": LidCgmAlertClearedDex,
    "LID_CGM_ALERT_ACK_DEX": LidCgmAlertAckDex,
    "LID_CGM_DATA_FSL2": LidCgmDataFsl2,
    "LID_CGM_JOIN_SESSION_G7": LidCgmJoinSessionG7,
    "LID_CGM_DATA_G7": LidCgmDataG7,
    "LID_CGM_START_SESSION_FSL2": LidCgmStartSessionFsl2,
    "LID_CGM_STOP_SESSION_FSL2": LidCgmStopSessionFsl2,
    "LID_CGM_JOIN_SESSION_FSL2": LidCgmJoinSessionFsl2,
    "LID_CGM_STOP_SESSION_G7": LidCgmStopSessionG7,
    "LID_CGM_ALERT_ACTIVATED_FSL2": LidCgmAlertActivatedFsl2,
    "LID_CGM_ALERT_CLEARED_FSL2": LidCgmAlertClearedFsl2,
}

