"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const aws_cdk_lib_1 = require("aws-cdk-lib");
const aws_ec2_1 = require("aws-cdk-lib/aws-ec2");
const aws_iam_1 = require("aws-cdk-lib/aws-iam");
const index_1 = require("./index");
const env = {
    region: process.env.CDK_DEFAULT_REGION,
    account: process.env.CDK_DEFAULT_ACCOUNT,
};
const mockApp = new aws_cdk_lib_1.App();
const stack = new aws_cdk_lib_1.Stack(mockApp, 'testing-stack', { env });
const role = new aws_iam_1.Role(stack, 'runner-role', {
    assumedBy: new aws_iam_1.ServicePrincipal('ec2.amazonaws.com'),
    description: 'For Gitlab EC2 Runner Test Role',
    roleName: 'TestRole',
});
const vpc = aws_ec2_1.Vpc.fromLookup(stack, 'defaultVpc', {
    isDefault: true,
});
const runner = new index_1.GitlabContainerRunner(stack, 'testing', {
    gitlabtoken: stack.node.tryGetContext('GITLAB_TOKEN') ?? 'glrt-GITLAB_TOKEN',
    ec2type: 't3.large',
    ec2iamrole: role,
    onDemandEbsConfig: aws_ec2_1.BlockDeviceVolume.ebs(100),
    selfvpc: vpc,
    // spotFleet: true,
    dockerVolumes: [
        {
            hostPath: '/tmp/cahce',
            containerPath: '/tmp/cahce',
        },
    ],
    gitlabRunnerVersion: '15.10',
    enabledIMDSv2: true,
});
//runner.expireAfter(Duration.hours(1));
runner.runnerRole.addManagedPolicy(aws_iam_1.ManagedPolicy.fromAwsManagedPolicyName('AmazonS3ReadOnlyAccess'));
runner.defaultRunnerSG.connections.allowFromAnyIpv4(aws_ec2_1.Port.tcp(80));
runner.defaultRunnerSG.connections.allowFromAnyIpv4(aws_ec2_1.Port.tcp(443));
//runner.runnerEc2.connections.allowFrom(Peer.ipv4('0.0.0.0/0'), Port.tcp(8080));
new aws_cdk_lib_1.CfnOutput(stack, 'role', { value: runner.runnerRole.roleArn });
//new CfnOutput(stack, 'InstanceID', { value: runner.runnerEc2.instanceId });
//# sourceMappingURL=data:application/json;base64,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