"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.PgStacDatabase = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const constructs_1 = require("constructs");
const bootstrap_pgstac_1 = require("./bootstrap-pgstac");
/**
 * An RDS instance with pgSTAC installed.
 *
 * Will default to installing a `t3.small` Postgres instance.
 */
class PgStacDatabase extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        const parameterGroup = new aws_cdk_lib_1.aws_rds.ParameterGroup(this, "parameterGroup", {
            engine: props.engine,
            parameters: {
                max_locks_per_transaction: "1024",
                work_mem: "64000",
                temp_buffers: "32000",
            },
        });
        this.db = new aws_cdk_lib_1.aws_rds.DatabaseInstance(this, "db", {
            instanceIdentifier: aws_cdk_lib_1.Stack.of(this).stackName,
            instanceType: aws_cdk_lib_1.aws_ec2.InstanceType.of(aws_cdk_lib_1.aws_ec2.InstanceClass.BURSTABLE3, aws_cdk_lib_1.aws_ec2.InstanceSize.SMALL),
            parameterGroup,
            vpcSubnets: {
                subnetType: aws_cdk_lib_1.aws_ec2.SubnetType.PRIVATE_ISOLATED,
            },
            ...props,
        });
        const bootstrap = new bootstrap_pgstac_1.BootstrapPgStac(this, "bootstrap-pgstac-instance", {
            vpc: props.vpc,
            database: this.db,
            dbSecret: this.db.secret,
            pgstacDbName: "pgstac",
            pgstacVersion: "0.6.8",
            pgstacUsername: "pgstac_user",
            secretsPrefix: "pgstac",
        });
        this.pgstacSecret = bootstrap.secret;
    }
}
exports.PgStacDatabase = PgStacDatabase;
_a = JSII_RTTI_SYMBOL_1;
PgStacDatabase[_a] = { fqn: "cdk-pgstac-dev.PgStacDatabase", version: "1.15.0" };
//# sourceMappingURL=data:application/json;base64,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