import { aws_rds as rds, aws_secretsmanager as secretsmanager } from "aws-cdk-lib";
import { Construct } from "constructs";
/**
 * An RDS instance with pgSTAC installed.
 *
 * Will default to installing a `t3.small` Postgres instance.
 */
export declare class PgStacDatabase extends Construct {
    db: rds.DatabaseInstance;
    pgstacSecret: secretsmanager.ISecret;
    constructor(scope: Construct, id: string, props: Props);
}
export interface Props extends rds.DatabaseInstanceProps {
}
