"""
Django settings for core_user_registration_app project.

Generated by 'django-admin startproject' using Django 1.11.

For more information on this file, see
https://docs.djangoproject.com/en/4.2/topics/settings/

For the full list of settings and their values, see
https://docs.djangoproject.com/en/4.2/ref/settings/
"""

from os.path import join

from django.conf import settings

if not settings.configured:
    settings.configure()

REGISTRY_XSD_FILENAME = getattr(settings, "REGISTRY_XSD_FILENAME", "")
""" str: Registry xsd filename used for the initialisation.
"""

XSL_FOLDER_PATH = getattr(
    settings, "XSL_FOLDER_PATH", "core_main_registry_app/xsl"
)
""" str: Xsl folder path used for the initialisation.
"""

LIST_XSL_FILENAME = getattr(settings, "LIST_XSL_FILENAME", "registry-list.xsl")
"""" str : List xsl filename used for the initialisation.
"""

DETAIL_XSL_FILENAME = getattr(
    settings, "DETAIL_XSL_FILENAME", "registry-detail.xsl"
)
"""  str : Detail xsl filename used for the initialisation.
"""

REGISTRY_XSD_USER_FILEPATH = getattr(
    settings,
    "REGISTRY_USER_XSD_FILEPATH",
    join("core_user_registration_app", "user", "xsd", "user.xsd"),
)
""" str: Registry xsd path used for the initialisation.
"""

REGISTRY_XSD_USER_FILENAME = getattr(
    settings, "REGISTRY_XSD_USER_FILENAME", "user.xsd"
)
""" str: Registry xsd filename used for the initialisation.
"""


DELETE_USER_DATA_STRUCTURE_RATE = 10
""" int: Task rate in seconds.
"""

USER_DATA_STRUCTURE_HOURS_THRESHOLD = 1
""" int: Number of hours before deleting a User Data Structure
"""
