"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const base_1 = require("@jupyter-widgets/base");
const ExplanationDashboard_1 = require("../../../../../visualization/dashboard/rel/MLIDashboard/ExplanationDashboard");
const react_1 = __importDefault(require("react"));
const react_dom_1 = __importDefault(require("react-dom"));
// Custom Model. Custom widgets models must at least provide default values
// for model attributes, including
//
//  - `_view_name`
//  - `_view_module`
//  - `_view_module_version`
//
//  - `_model_name`
//  - `_model_module`
//  - `_model_module_version`
//
//  when different from the base class.
// When serialiazing the entire widget state for embedding, only values that
// differ from the defaults will be specified.
class ExplanationModel extends base_1.DOMWidgetModel {
    defaults() {
        return {
            _model_name: 'ExplanationModel',
            _view_name: 'ExplanationView',
            _model_module: 'interpret-text-widget',
            _view_module: 'interpret-text-widget',
            _model_module_version: '0.1.0',
            _view_module_version: '0.1.1',
            value: {}
        };
    }
}
exports.ExplanationModel = ExplanationModel;
;
// Custom View. Renders the widget model.
class ExplanationView extends base_1.DOMWidgetView {
    render() {
        this.el.style.cssText = 'width: 100%';
        let root_element = document.createElement('div');
        root_element.style.cssText = 'width: 100%;';
        const data = this.model.get('value');
        react_dom_1.default.render(react_1.default.createElement(ExplanationDashboard_1.ExplanationDashboard, { modelInformation: { modelClass: 'msra' }, dataSummary: {
                text: data.text,
                classNames: data.classNames,
                localExplanations: data.localExplanations,
                prediction: data.prediction,
            } }), root_element);
        this.el.appendChild(root_element);
    }
}
exports.ExplanationView = ExplanationView;
;
//# sourceMappingURL=explanationDashboard.js.map